/* $Header: /cvs/gnome/gIDE/src/gI_window.h,v 1.10 2000/04/14 04:34:00 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_WINDOW_H
#define GI_WINDOW_H

#include "gI_document.h"

#define GIDE_WINDOW(o)          (GTK_CHECK_CAST ((o), gI_window_get_type(), GideWindow))
#define GIDE_WINDOW_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), gI_window_get_type(), GideWindowClass))
#define IS_GIDE_WINDOW(o)       (GTK_CHECK_TYPE ((o), gI_window_get_type()))

typedef struct _GideWindowClass {
	GnomeAppClass   parent_class;
} GideWindowClass;

typedef struct _GideWindow {
	GnomeApp app;

	GtkWidget *notebook;
	GtkWidget *statusbar;

	GtkWidget *popup;

	GList *menu_items;	
	GList *documents;

	GtkWidget *hpane;
	GtkWidget *tree_box;
	GtkWidget *tree_frame;
	GtkWidget *tree_scrolled_window;
	GtkWidget *tree_viewport;
	GtkWidget *toolbar;

	gint timeout_id;
	gint switch_page_id;

	gI_debug_window *debug_window;
	gint debug_id;
} GideWindow;

/*
 * Prototypes for 'gI_window.c'
 */
guint gI_window_get_type (void);
GtkWidget *gI_window_new( void );

/* Functions to do with documents */
void gI_window_add_doc ( GideWindow *window, GideDocument *document );

gint gI_window_num_docs( GideWindow *window );
glong gI_window_num_changed_docs( GideWindow *window );
gboolean gI_window_is_open_doc( GideWindow *window, const gchar *filename );

void gI_window_goto_doc_by_index( GideWindow *window, gint index );
void gI_window_goto_doc_by_file( GideWindow *window, const gchar *filename );

GideDocument *gI_window_get_nth_doc( GideWindow *window, guint index );
GideDocument *gI_window_get_current_doc( GideWindow *window );
gchar *gI_window_get_doc_label( GideWindow *window, GideDocument *document );
void gI_window_set_doc_label( GideWindow *window,
			      GideDocument *document,
			      gchar *str );
void gI_window_set_doc_label_style( GideWindow *window,
				    GideDocument *document,
				    GtkStyle *style );

/* Title functions */
void gI_window_update_title( GideWindow *window );
	
/* Status bar functions */
void gI_window_set_statusbar( GideWindow *window );
void gI_window_clear_statusbar( GideWindow *window );

/* Project tree */
void gI_window_create_prjftree( GideWindow *window );

void gI_window_set_visible_read_only( gint sensitive );
void gI_window_create_popupmenu(GideWindow *window);

#define STATUSBAR_CONTEXT_CURSOR_POSITION 100

#endif

