<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>libglom Reference Manual</title>
    <filename>index</filename>
    <docanchor file="index">basics</docanchor>
    <docanchor file="index">warning</docanchor>
    <docanchor file="index">description</docanchor>
  </compound>
  <compound kind="class">
    <name>sigc::trackable</name>
    <filename>classsigc_1_1trackable.html</filename>
  </compound>
  <compound kind="class">
    <name>std::exception</name>
    <filename>classstd_1_1exception.html</filename>
  </compound>
  <compound kind="namespace">
    <name>Glom</name>
    <filename>namespaceGlom.html</filename>
    <namespace>Glom::ConnectionPoolBackends</namespace>
    <namespace>Glom::Conversions</namespace>
    <namespace>Glom::Spawn</namespace>
    <namespace>Glom::Utils</namespace>
    <class kind="class">Glom::AppState</class>
    <class kind="class">Glom::CalcInProgress</class>
    <class kind="class">Glom::SharedConnection</class>
    <class kind="class">Glom::ConnectionPool</class>
    <class kind="class">Glom::ExceptionConnection</class>
    <class kind="class">Glom::predicate_FieldHasName</class>
    <class kind="class">Glom::Field</class>
    <class kind="class">Glom::FieldTypes</class>
    <class kind="class">Glom::FoundSet</class>
    <class kind="class">Glom::GroupInfo</class>
    <class kind="class">Glom::HasTitleSingular</class>
    <class kind="class">Glom::CustomTitle</class>
    <class kind="class">Glom::FieldFormatting</class>
    <class kind="class">Glom::LayoutGroup</class>
    <class kind="class">Glom::LayoutItem</class>
    <class kind="class">Glom::LayoutItem_Button</class>
    <class kind="class">Glom::LayoutItem_CalendarPortal</class>
    <class kind="class">Glom::predicate_LayoutItem_Field_IsSameField</class>
    <class kind="class">Glom::LayoutItem_Field</class>
    <class kind="class">Glom::LayoutItem_Image</class>
    <class kind="class">Glom::LayoutItem_Line</class>
    <class kind="class">Glom::LayoutItem_Notebook</class>
    <class kind="class">Glom::LayoutItem_Placeholder</class>
    <class kind="class">Glom::LayoutItem_Portal</class>
    <class kind="class">Glom::LayoutItem_Text</class>
    <class kind="class">Glom::LayoutItem_WithFormatting</class>
    <class kind="class">Glom::LayoutItem_FieldSummary</class>
    <class kind="class">Glom::LayoutItem_Footer</class>
    <class kind="class">Glom::LayoutItem_GroupBy</class>
    <class kind="class">Glom::LayoutItem_Header</class>
    <class kind="class">Glom::LayoutItem_Summary</class>
    <class kind="class">Glom::LayoutItem_VerticalGroup</class>
    <class kind="class">Glom::UsesRelationship</class>
    <class kind="class">Glom::NumericFormat</class>
    <class kind="class">Glom::ParameterNameGenerator</class>
    <class kind="class">Glom::PrintLayout</class>
    <class kind="class">Glom::Privileges</class>
    <class kind="class">Glom::Relationship</class>
    <class kind="class">Glom::Report</class>
    <class kind="class">Glom::SystemPrefs</class>
    <class kind="class">Glom::TableInfo</class>
    <class kind="class">Glom::TranslatableItem</class>
    <class kind="class">Glom::Document</class>
    <class kind="class">Glom::PyGlomRecord</class>
    <class kind="class">Glom::PyGlomRelated</class>
    <class kind="class">Glom::PyGlomRelatedRecord</class>
    <class kind="class">Glom::PyGlomUI</class>
    <class kind="class">Glom::PythonUICallbacks</class>
    <class kind="class">Glom::sharedptr</class>
    <member kind="typedef">
      <type>GlomBakery::View&lt; Document &gt;</type>
      <name>View_Glom</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a3a03874268c9995ac1f9431c4748850b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GlomBakery::View_Composite&lt; Document &gt;</type>
      <name>View_Composite_Glom</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a0d2b1800bbebf8ac2892789b8da66d58</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; sharedptr&lt; const UsesRelationship &gt; &gt;</type>
      <name>type_list_relationships</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>af8a4acd8a4843c8140e3a59232677c5d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::pair&lt; sharedptr&lt; const LayoutItem_Field &gt;, bool &gt;</type>
      <name>type_pair_sort_field</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a4d496233c15b7b68fbf1430ca004b457</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; type_pair_sort_field &gt;</type>
      <name>type_sort_clause</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>aac29514f502dbc3afd655f88a1a75124</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>glom_get_sharedptr_name</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>ae0d2db905f710560385acdc58553fa3d</anchor>
      <arglist>(const sharedptr&lt; T_object &gt; &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>glom_get_sharedptr_title_or_name</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a616c258fc4689ebd8eb3adbcbdd264c4</anchor>
      <arglist>(const sharedptr&lt; T_object &gt; &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>libglom_init</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>af89e82bb7f67620b685dc0a0d4714b44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>libglom_deinit</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a665a5a3e65ac061131c030aa677e6834</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; T_obj &gt;</type>
      <name>glom_sharedptr_clone</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a1902f03a9bb43a378976e86808043e4a</anchor>
      <arglist>(const sharedptr&lt; T_obj &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; T_obj &gt;</type>
      <name>glom_sharedptr_clone</name>
      <anchorfile>namespaceGlom.html</anchorfile>
      <anchor>a6d5378b67c1a63a1c74e333dbd3d10e6</anchor>
      <arglist>(const sharedptr&lt; const T_obj &gt; &amp;src)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::AppState</name>
    <filename>classGlom_1_1AppState.html</filename>
    <member kind="enumeration">
      <name>userlevels</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a2f279293e922b57b080096c2b75815d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USERLEVEL_OPERATOR</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a2f279293e922b57b080096c2b75815d7add9130b87161b0f30eead81d5605f07b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USERLEVEL_DEVELOPER</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a2f279293e922b57b080096c2b75815d7a0cd11138a9ca84a6a80d2f7a8a89e3d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::signal&lt; void, userlevels &gt;</type>
      <name>type_signal_userlevel_changed</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a884b9a86115c0e570aca5682f515d463</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AppState</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a649b630319deb65a77de938692e8bec8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppState</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a909147e25269bab9b73db861319b5c24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual userlevels</type>
      <name>get_userlevel</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a68df7b21c9f7612441a761bd67d32c05</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_userlevel</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a81c6b701e5eaac1bf49eb4db2a5eaad5</anchor>
      <arglist>(userlevels value)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>emit_userlevel_changed</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>ac140f55de12b96a6b684509b95c4efbd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>type_signal_userlevel_changed</type>
      <name>signal_userlevel_changed</name>
      <anchorfile>classGlom_1_1AppState.html</anchorfile>
      <anchor>a3c99b8fbedc6dd1f6e7314063df13c43</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::CalcInProgress</name>
    <filename>classGlom_1_1CalcInProgress.html</filename>
    <member kind="function">
      <type></type>
      <name>CalcInProgress</name>
      <anchorfile>classGlom_1_1CalcInProgress.html</anchorfile>
      <anchor>a5c4313b883e51feb85ea5a9914e4b3c9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; const Field &gt;</type>
      <name>m_field</name>
      <anchorfile>classGlom_1_1CalcInProgress.html</anchorfile>
      <anchor>ae5496df1d7d3ad0f382606655acb7505</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Gnome::Gda::Value</type>
      <name>m_value</name>
      <anchorfile>classGlom_1_1CalcInProgress.html</anchorfile>
      <anchor>a60aca46f1f09386b18944da134b1ca32</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_calc_in_progress</name>
      <anchorfile>classGlom_1_1CalcInProgress.html</anchorfile>
      <anchor>a2bed8df2f52e6ad25309b3443e4f6319</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_calc_finished</name>
      <anchorfile>classGlom_1_1CalcInProgress.html</anchorfile>
      <anchor>a4958f73fd004cdb6e7a3d41e78c8c88e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::SharedConnection</name>
    <filename>classGlom_1_1SharedConnection.html</filename>
    <base>sigc::trackable</base>
    <member kind="typedef">
      <type>sigc::signal&lt; void &gt;</type>
      <name>type_signal_finished</name>
      <anchorfile>classGlom_1_1SharedConnection.html</anchorfile>
      <anchor>ad28e4e92cc1ebb1d9defae5c1c25119c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SharedConnection</name>
      <anchorfile>classGlom_1_1SharedConnection.html</anchorfile>
      <anchor>a5bcaf1dd03a78448a12d27c67159dfd9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SharedConnection</name>
      <anchorfile>classGlom_1_1SharedConnection.html</anchorfile>
      <anchor>aa1a2cf989fb09f60ee7768f2b2b49180</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;gda_connection)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SharedConnection</name>
      <anchorfile>classGlom_1_1SharedConnection.html</anchorfile>
      <anchor>a6ac99397edf7dfe46966905de5b4a78f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gnome::Gda::Connection &gt;</type>
      <name>get_gda_connection</name>
      <anchorfile>classGlom_1_1SharedConnection.html</anchorfile>
      <anchor>a864985710e0c22a33f02e761b181cd6f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Gnome::Gda::Connection &gt;</type>
      <name>get_gda_connection</name>
      <anchorfile>classGlom_1_1SharedConnection.html</anchorfile>
      <anchor>a86bee1b44670ddd27baf88ad354822c6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGlom_1_1SharedConnection.html</anchorfile>
      <anchor>a16a51bdef46683a49d93df744a4f039e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>type_signal_finished</type>
      <name>signal_finished</name>
      <anchorfile>classGlom_1_1SharedConnection.html</anchorfile>
      <anchor>a0c93c133888fce5185dadbbd36c21e8c</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::ConnectionPool</name>
    <filename>classGlom_1_1ConnectionPool.html</filename>
    <base>sigc::trackable</base>
    <member kind="typedef">
      <type>ConnectionPoolBackends::Backend</type>
      <name>Backend</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a160549e801a2c37cede9d54319c4204a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Backend::type_vec_const_fields</type>
      <name>type_vec_const_fields</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>aa75799e1da92281449b86a45bb846ca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void &gt;</type>
      <name>type_void_slot</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>af230e274a0eec07c3cb527409215b947</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Backend::SlotProgress</type>
      <name>SlotProgress</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>ad229e2dd6261e56a39a1d988331fa7e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Backend::InitErrors</type>
      <name>InitErrors</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>af3172b04cc00dce6d21aff454fa14b71</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; Document * &gt;</type>
      <name>SlotGetDocument</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a434e30829cfccbbb3547295dc20f7416</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setup_from_document</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a24ed3e3f733a1beed86151890e315c94</anchor>
      <arglist>(const Document *document)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_avahi_publish_callbacks</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a5efa81eba56165a069295b86fa3dcdea</anchor>
      <arglist>(const type_void_slot &amp;slot_begin, const type_void_slot &amp;slot_progress, const type_void_slot &amp;slot_done)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_ready_to_connect</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a418886c87757bb9e26ffe5e97b387dfe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_ready_to_connect</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>aba70257245fe0d1afc3d70a220f90a2f</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_backend</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>ae6301e29f51e4b754aea39f89130a96e</anchor>
      <arglist>(std::auto_ptr&lt; Backend &gt; backend)</arglist>
    </member>
    <member kind="function">
      <type>Backend *</type>
      <name>get_backend</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a1765ba7246e7d315c76caffa0a281890</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Backend *</type>
      <name>get_backend</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>af31e8f95e9fadf9c1dff84b2eb99da9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; SharedConnection &gt;</type>
      <name>connect</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a8c48fd0996fb8caaded723f153ba9868</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_database</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a6fbf128f895688295daaded702ea8e1b</anchor>
      <arglist>(const Glib::ustring &amp;database_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_user</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a3191219fb0d1ceee51cb74e3843264f2</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_password</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a73aaef4b64bff9f317d2fcdd257f33ae</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_database</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a474021161d154ec70c456a5cde4680fe</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_user</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>ae3ac6b2dc26a36e0de8bae193ea06155</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_password</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a10fc8e88cf9d6d49690bfa7aaf2c5dfe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_database</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>aa95edac62d411976c512b3de6519f308</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Field::sql_format</type>
      <name>get_sql_format</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>ad4cb2ab65160e5e2e12710dc9395a59e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const FieldTypes *</type>
      <name>get_field_types</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a65cb7e9cc757c401a1dd145a78aca266</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_string_find_operator</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a0a9ad2db7c737b8b4cca09d7cfc113eb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>InitErrors</type>
      <name>initialize</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a2e86bf5d8b1da375baeffbf937545894</anchor>
      <arglist>(const SlotProgress &amp;slot_progress, bool network_shared=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>startup</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a45736c70d0c909ff252e2ca1c1ecf40a</anchor>
      <arglist>(const SlotProgress &amp;slot_progress, bool network_shared=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>cleanup</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>ac15ae928139bde93e9111ad9f5b8c890</anchor>
      <arglist>(const SlotProgress &amp;slot_progress)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>set_network_shared</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a23e03b02b63e740a1a53f273481fe13c</anchor>
      <arglist>(const SlotProgress &amp;slot_progress, bool network_shared=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_column</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a785fb823a07a6a209eb7296a81daf641</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; const Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>drop_column</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a04e794e9a9e74925cb60ec6426c5b302</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>change_column</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>af0a40bff62ca1809c42507d41a855490</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; const Field &gt; &amp;field_old, const sharedptr&lt; const Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>change_columns</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a34e462119db08eb832b6bccccbdcd4fa</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vec_const_fields &amp;old_fields, const type_vec_const_fields &amp;fields)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_get_document_func</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a19ab1613aa77c9af8dba49d7cfa178ae</anchor>
      <arglist>(const SlotGetDocument &amp;slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ConnectionPool *</type>
      <name>get_instance</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a0fe955876aa802cdf98480905abc9626</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>delete_instance</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a462d4f655b9f5862e15882668bcb1f28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; SharedConnection &gt;</type>
      <name>get_and_connect</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a988d7beaca93db54f850aa9454988307</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static EpcContents *</type>
      <name>on_publisher_document_requested</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>acf054de5d9aee7e0ef26a777b8a34910</anchor>
      <arglist>(EpcPublisher *publisher, const gchar *key, gpointer user_data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static gboolean</type>
      <name>on_publisher_document_authentication</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a96683eca4b03bdd2ee938033b9f90b53</anchor>
      <arglist>(EpcAuthContext *context, const gchar *user_name, gpointer user_data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>on_epc_progress_begin</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a032bf2f89eafd7aaf02be78ba033939a</anchor>
      <arglist>(const gchar *title, gpointer user_data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>on_epc_progress_update</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a28f6896dc7d0030ae82285f4d4daa046</anchor>
      <arglist>(gdouble progress, const gchar *message, gpointer user_data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>on_epc_progress_end</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a5825b122dafa29a3769f8c1578193bd5</anchor>
      <arglist>(gpointer user_data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>handle_error_cerr_only</name>
      <anchorfile>classGlom_1_1ConnectionPool.html</anchorfile>
      <anchor>a36f1a14526afeee574fdba54caf2a942</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::ExceptionConnection</name>
    <filename>classGlom_1_1ExceptionConnection.html</filename>
    <base>std::exception</base>
    <member kind="enumeration">
      <name>failure_type</name>
      <anchorfile>classGlom_1_1ExceptionConnection.html</anchorfile>
      <anchor>a39b8438e269dae30304b8e0c3f216015</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILURE_NO_SERVER</name>
      <anchorfile>classGlom_1_1ExceptionConnection.html</anchorfile>
      <anchor>a39b8438e269dae30304b8e0c3f216015ae911b0c3f595cd98750013cd4c14752f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILURE_NO_DATABASE</name>
      <anchorfile>classGlom_1_1ExceptionConnection.html</anchorfile>
      <anchor>a39b8438e269dae30304b8e0c3f216015a4f9e2bc191be0b1e881ea13ee189fe88</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILURE_NO_BACKEND</name>
      <anchorfile>classGlom_1_1ExceptionConnection.html</anchorfile>
      <anchor>a39b8438e269dae30304b8e0c3f216015aab80e1d04120151e92c28d5cef9e1b9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExceptionConnection</name>
      <anchorfile>classGlom_1_1ExceptionConnection.html</anchorfile>
      <anchor>a4a5018295940c965d46bf26a5026ffd0</anchor>
      <arglist>(failure_type failure)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ExceptionConnection</name>
      <anchorfile>classGlom_1_1ExceptionConnection.html</anchorfile>
      <anchor>a31de63d8a4042683517465e911b223e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const char *</type>
      <name>what</name>
      <anchorfile>classGlom_1_1ExceptionConnection.html</anchorfile>
      <anchor>af2f930ce25cf849555b59bb5867a8ecc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual failure_type</type>
      <name>get_failure_type</name>
      <anchorfile>classGlom_1_1ExceptionConnection.html</anchorfile>
      <anchor>a9abfcd6918cca5581d194bef0a51132b</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::predicate_FieldHasName</name>
    <filename>classGlom_1_1predicate__FieldHasName.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>predicate_FieldHasName</name>
      <anchorfile>classGlom_1_1predicate__FieldHasName.html</anchorfile>
      <anchor>a7b14ca1de37ade9e22301fd3a71584d8</anchor>
      <arglist>(const Glib::ustring &amp;strName)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~predicate_FieldHasName</name>
      <anchorfile>classGlom_1_1predicate__FieldHasName.html</anchorfile>
      <anchor>a1ed9865d798553335f7f8a69bef1ff7f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>classGlom_1_1predicate__FieldHasName.html</anchorfile>
      <anchor>ac772ed0984769f6a73dc919f26f137b1</anchor>
      <arglist>(const T_Element &amp;element)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>classGlom_1_1predicate__FieldHasName.html</anchorfile>
      <anchor>a0ba37cd302871723594b17229f3fa0aa</anchor>
      <arglist>(const sharedptr&lt; T_Element &gt; &amp;element)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>classGlom_1_1predicate__FieldHasName.html</anchorfile>
      <anchor>a2238be40ba9eb848a4378287d53dc7dd</anchor>
      <arglist>(const sharedptr&lt; const T_Element &gt; &amp;element)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::Field</name>
    <filename>classGlom_1_1Field.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="enumeration">
      <name>sql_format</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ada8c5d83c1e0937fd60888ce7dc0f6d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SQL_FORMAT_POSTGRES</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ada8c5d83c1e0937fd60888ce7dc0f6d5a3cf3686d521e0d67add2da215a7dba6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SQL_FORMAT_SQLITE</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ada8c5d83c1e0937fd60888ce7dc0f6d5ab56283c9f73d17dd0c0725e061512367</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>glom_field_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_INVALID</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12ca00cf52d1858c9fa384818e30e6361e7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_NUMERIC</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12cad950dc2be538deaf32d1d8a0c3b2ae1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_TEXT</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12ca1c7d059c2af6e8d926faeda822032db6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_DATE</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12ca9022b56a7ca173c9d0bb7d80c68b4995</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_TIME</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12cac9a5b1fff349153aaae3cd82e3cdb69f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_BOOLEAN</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12ca627e8e7391477bfc55396801a93eb483</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_IMAGE</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add1ab8498c593222460a6ed3b100b12ca83e2891317bc48d680d35398ad3e017d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; Glib::ustring &gt;</type>
      <name>type_list_strings</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aafd981325587760ef8d7ba154ef11fb2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; glom_field_type, Glib::ustring &gt;</type>
      <name>type_map_type_names</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a56155f103e46e51360cdd2993590f13f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Field</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ab16773ddcb24e1abf06698394ddeddea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Field</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a47d5af89431e1a0aa03c9d2e0920a1a8</anchor>
      <arglist>(const Field &amp;src)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Field</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aa0cd80c44dcdc16eb9df80a76a807333</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Field &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a0f98eca42bfb07dc69e862fe4449a37a</anchor>
      <arglist>(const Field &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a0404d92688dcc5ab74f9455b27d73f5e</anchor>
      <arglist>(const Field &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ae656efcd871323cbdc33f19f91c83397</anchor>
      <arglist>(const Field &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>Field *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a95e1b838f61b6dd53737ea1ce3327b72</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>glom_field_type</type>
      <name>get_glom_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a22ce84aef87ed48acf62de8df2e0eb6c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_glom_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a3406391c25e522224ea2ad8027bea3aa</anchor>
      <arglist>(glom_field_type fieldtype)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a3065857fc3d2d4e82d39281107e90727</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_name</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a77fba7e18187f600e0b2aea98607deb1</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_auto_increment</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a194e7066edf0c068c92789cdf798d2fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_auto_increment</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a85f425795b1e92440fac67a0252f1995</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_primary_key</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a4347150af91b26fe0b44691c77b1b483</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_primary_key</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a512e83cec34d698e69e86d7698b5b79a</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_unique_key</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a7ec1971af5993f1ef6cddd8091486d41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_unique_key</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a30976018811becd64286979eb5d7d9fb</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_default_value</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ae0a95c5473b7938c605b08596ab4917b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_default_value</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ab47c1ab9feeb66914091319fb42bcfeb</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gnome::Gda::Column &gt;</type>
      <name>get_field_info</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a6c1849e044183041601a98ecd31acc14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Gnome::Gda::Column &gt;</type>
      <name>get_field_info</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>add9efecf5c51b1ec91084ef49d047c19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_field_info</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a0225380341f4687252524cfa181d537b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Column &gt; &amp;fieldInfo)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>field_info_from_database_is_equal</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>acfa5b26f62bc28c446ef606f7520afc6</anchor>
      <arglist>(const Glib::RefPtr&lt; const Gnome::Gda::Column &gt; &amp;field)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_lookup</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ad753285064bd881597dc7daa09caf18f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Relationship &gt;</type>
      <name>get_lookup_relationship</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aa73bc9e605a934751c4dc38e0fc2d28a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_lookup_relationship</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a06e99b24090775e710146f1609078d3f</anchor>
      <arglist>(const sharedptr&lt; Relationship &gt; &amp;strRelationship)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_lookup_field</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a71eeb4dccbdfb37004a7d509301285e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_lookup_field</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a8950d7de8111a4222c5ab73d131d4ce3</anchor>
      <arglist>(const Glib::ustring &amp;strField)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sql_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a90925cd40a7309423b5f7df9c2b7b5b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_gda_type_name</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a3dbb72491db5f94a100b7d805ef9077f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gnome::Gda::Holder &gt;</type>
      <name>get_holder</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ade361ce3869857afbd338a1206637b6d</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value, const Glib::ustring &amp;name=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_gda_holder_string</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>acc66ee95a44701872b6e280d228d3459</anchor>
      <arglist>(const Glib::ustring &amp;name=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>sql</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a1f08a2e6f26f7adea81fc5ff846cf664</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value, const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>sql</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a7eba101ea773462b56919ce084ba4749</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_file_format</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aac63bd78c81d3d818e5dba334fbd46bd</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>from_file_format</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a1fc51c5610d4084bfcbb77926fa8d75a</anchor>
      <arglist>(const Glib::ustring &amp;str, bool &amp;success) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>sql_find</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a7f6af900d048b288d806d694b982fcec</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>sql_find_operator</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a1803d6eb7c143bf94e1a62eca1bb597e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_calculation</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a1978cfe72f5e20a01c90779f720eddce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_calculation</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a941efb1d13243d663adfeff41a7f3888</anchor>
      <arglist>(const Glib::ustring &amp;calculation)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_calculation</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a40bfeff3fcd237db92d887f15ac2dc47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>type_list_strings</type>
      <name>get_calculation_relationships</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a68a5a86e2b064a19310ae31507540bda</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_visible</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aa6d99f2ec74aaa32bdf47cddae28f4cc</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_visible</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a428a1225bd43e4d2f7050564739e0765</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>to_file_format</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a9553ecae1752e7cfbc0c5f757b0f284b</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value, glom_field_type glom_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Gnome::Gda::Value</type>
      <name>from_file_format</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ab95fa968c4ed01d3b4fb1330eddfa4c9</anchor>
      <arglist>(const Glib::ustring &amp;str, glom_field_type glom_type, bool &amp;success)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static type_map_type_names</type>
      <name>get_type_names</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>aee40f3156237b0fb184c2e09ecb9a6b8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static type_map_type_names</type>
      <name>get_type_names_ui</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a0692486b01175fa565c331307721f48d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static type_map_type_names</type>
      <name>get_usable_type_names</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a8a2a65e96ee089b75a6b8e7c7699b4f6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_type_name_ui</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a0157822c3ca247c26c60f67e8ffec13a</anchor>
      <arglist>(glom_field_type glom_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static glom_field_type</type>
      <name>get_type_for_ui_name</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ab17da7077c3c7a11440d2ee382dde260</anchor>
      <arglist>(const Glib::ustring &amp;glom_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static glom_field_type</type>
      <name>get_glom_type_for_gda_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a09839d595f630a15160d91a8c7eb6fd7</anchor>
      <arglist>(GType gda_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_gda_type_for_glom_type</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>ad15d03dfdc48f6054f9b8aa9bd2868c4</anchor>
      <arglist>(Field::glom_field_type glom_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>get_conversion_possible</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a8224d9469546f2da5455f83386ff5a96</anchor>
      <arglist>(glom_field_type field_type_src, glom_field_type field_type_dest)</arglist>
    </member>
    <member kind="variable">
      <type>FieldFormatting</type>
      <name>m_default_formatting</name>
      <anchorfile>classGlom_1_1Field.html</anchorfile>
      <anchor>a86858b09350d0a64e5c8f8a68e130750</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::FieldTypes</name>
    <filename>classGlom_1_1FieldTypes.html</filename>
    <member kind="function">
      <type></type>
      <name>FieldTypes</name>
      <anchorfile>classGlom_1_1FieldTypes.html</anchorfile>
      <anchor>ac9cc840694ac1ff2017f61846690d34b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;gda_connection)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FieldTypes</name>
      <anchorfile>classGlom_1_1FieldTypes.html</anchorfile>
      <anchor>ae46359100dc137ef98de246eac811005</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GType</type>
      <name>get_gdavalue_for_schema_type_string</name>
      <anchorfile>classGlom_1_1FieldTypes.html</anchorfile>
      <anchor>aa445eb6b3ba80f59478d04498c08ad36</anchor>
      <arglist>(const Glib::ustring &amp;schema_type_string) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_string_name_for_gdavaluetype</name>
      <anchorfile>classGlom_1_1FieldTypes.html</anchorfile>
      <anchor>a31372ed25860df9ac7612087f9c4ac8f</anchor>
      <arglist>(GType field_type) const </arglist>
    </member>
    <member kind="function">
      <type>GType</type>
      <name>get_fallback_type_for_gdavaluetype</name>
      <anchorfile>classGlom_1_1FieldTypes.html</anchorfile>
      <anchor>a085a318379cbd6bd7bf260abb899a9a7</anchor>
      <arglist>(GType field_type) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::FoundSet</name>
    <filename>classGlom_1_1FoundSet.html</filename>
    <member kind="typedef">
      <type>std::pair&lt; sharedptr&lt; const LayoutItem_Field &gt;, bool &gt;</type>
      <name>type_pair_sort_field</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a4bfb5c943cef4b5a5b571b2aba979dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; type_pair_sort_field &gt;</type>
      <name>type_sort_clause</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>af4a3fcea8b710f06dbcbc7ed6148fd9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FoundSet</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a4c287194a475ab7d4f9b22521564d11a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FoundSet</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>abd97863cdbbffcef50f4e3cc23718707</anchor>
      <arglist>(const FoundSet &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>FoundSet &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>ac626068577467d44ba1164fe609e9fb6</anchor>
      <arglist>(const FoundSet &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a408114590c6006b5e73d8764903ece4a</anchor>
      <arglist>(const FoundSet &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_no_criteria</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a061a06644ff31e77d6ca5e0e32805023</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_table_name</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>af21405a9e9b748acf2704e3886e4b67f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_extra_join</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a32d9cfc32c93052d9b4d0a11624b9db9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_where_clause</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a6da5298dd7e5b6cfecc1ffdf13c84420</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_extra_group_by</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>a96f774432206d060d0924680258033d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>type_sort_clause</type>
      <name>m_sort_clause</name>
      <anchorfile>classGlom_1_1FoundSet.html</anchorfile>
      <anchor>adbb2fd3155dfaa83e44b7cc4dc085ca7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::GroupInfo</name>
    <filename>classGlom_1_1GroupInfo.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="typedef">
      <type>std::map&lt; Glib::ustring, Privileges &gt;</type>
      <name>type_map_table_privileges</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>ac0c0a9cf3ce4d33656a8691d55e564f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GroupInfo</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>aab4134bcd0e0f328ee2167dd524ba785</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GroupInfo</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>a75ca49042cc16c8fd832fc3946debdc9</anchor>
      <arglist>(const GroupInfo &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~GroupInfo</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>a5cc9eb66efebb908b9d334a10d42db5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GroupInfo &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>acf4e5fb45ba3cd614ed24fd6aca4723c</anchor>
      <arglist>(const GroupInfo &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>aba1272fb72097e814696404bc49efb55</anchor>
      <arglist>(const GroupInfo &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>a8837141e8516889ba9ba0efd098e3847</anchor>
      <arglist>(const GroupInfo &amp;src) const </arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_developer</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>a38d0afd82991f1e0d82132a68ddd8c07</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>type_map_table_privileges</type>
      <name>m_map_privileges</name>
      <anchorfile>classGlom_1_1GroupInfo.html</anchorfile>
      <anchor>aae8d6c3c5e6a544d49a80a0500de260a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::HasTitleSingular</name>
    <filename>classGlom_1_1HasTitleSingular.html</filename>
    <member kind="function">
      <type></type>
      <name>HasTitleSingular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>aa0c39ce866aeb19abc259c1a2837a421</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HasTitleSingular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a5fdc3e299b428451ca61c33ddfb9dd49</anchor>
      <arglist>(const HasTitleSingular &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~HasTitleSingular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a0452de5ab8f5508fa722b9e84965e5d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HasTitleSingular &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a6df15f75d3b776e52a7fdc720230786a</anchor>
      <arglist>(const HasTitleSingular &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a17759330bd64796d6da3f26061c25610</anchor>
      <arglist>(const HasTitleSingular &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a605244ae6c172dcad52db98cad6af476</anchor>
      <arglist>(const HasTitleSingular &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_singular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>acebe8a67348aacd5e735d5f88987d3e1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_singular_with_fallback</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a786b76189efc83864adb4fbcd62abe3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title_singular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a7b20c72d40b18f355ba673f4d99e0b7a</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; TranslatableItem &gt;</type>
      <name>m_title_singular</name>
      <anchorfile>classGlom_1_1HasTitleSingular.html</anchorfile>
      <anchor>a2a6b14f5898388830e09b071092b53cf</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::CustomTitle</name>
    <filename>classGlom_1_1CustomTitle.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="function">
      <type></type>
      <name>CustomTitle</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>a83b387ddcc97c0e6305fd01ecf024c1a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CustomTitle</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>ac372dc9e7e50789eafd5e9e339e29706</anchor>
      <arglist>(const CustomTitle &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>CustomTitle &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>a61e03c1620920c5277f835febeee4fb9</anchor>
      <arglist>(const CustomTitle &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~CustomTitle</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>a15677da69861a6aac67ef3592a13af48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>ae9de8d727f7891656d4de1df2df5dca4</anchor>
      <arglist>(const CustomTitle &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_use_custom_title</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>aa88c42fa7f233511bc8cd96bd34347b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_use_custom_title</name>
      <anchorfile>classGlom_1_1CustomTitle.html</anchorfile>
      <anchor>a0b700c95ca30481b7e029df969dcde53</anchor>
      <arglist>(bool use_custom_title=true)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::FieldFormatting</name>
    <filename>classGlom_1_1FieldFormatting.html</filename>
    <base>Glom::UsesRelationship</base>
    <member kind="enumeration">
      <name>HorizontalAlignment</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a9e0dd58899dc50f6128742a2f531f709</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HORIZONTAL_ALIGNMENT_AUTO</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a9e0dd58899dc50f6128742a2f531f709ab2f4faba7018584860cbe42142c0b324</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HORIZONTAL_ALIGNMENT_LEFT</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a9e0dd58899dc50f6128742a2f531f709aa28648b7b0ea81073dbc6ca26d246847</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HORIZONTAL_ALIGNMENT_RIGHT</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a9e0dd58899dc50f6128742a2f531f709ace7cebab10575d11aa5dfe93e874f11f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; Gnome::Gda::Value &gt;</type>
      <name>type_list_values</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>af2fd1be87ba4d56bd91a15d14fdf655b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FieldFormatting</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a324953d7d2a70acf6a0d09526aa49693</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FieldFormatting</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a60281263b2a706ba7b77044c5244686f</anchor>
      <arglist>(const FieldFormatting &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>FieldFormatting &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a4f8b90cb40ce1f192afaba316f97ed19</anchor>
      <arglist>(const FieldFormatting &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FieldFormatting</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a2ca209a9ee59cb4219206b8aea18b901</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a07b919f21a55568c4de9431f4b27ac41</anchor>
      <arglist>(const FieldFormatting &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a936095f1607a70e1ea3f9524318a87c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_related_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>aec1be05e6f8283f84c0dcf6a713a011b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_has_related_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a8dd266633e776f32309785aeb0120a8c</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_custom_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>abf5a7d3bd42d0faf269db5d9ddcf818d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_has_custom_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>aecadbbe6a9446f4a1624252d0400c514</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual type_list_values</type>
      <name>get_choices_custom</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a95ac3e69f7eb1142d166a3b197f2e326</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_choices_custom</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a899f281c6ff9f078584e7cfe83b690a5</anchor>
      <arglist>(const type_list_values &amp;choices)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_choices_restricted</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a0e2ea102b0fb0d814e958e19932557ab</anchor>
      <arglist>(bool &amp;as_radio_buttons) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_choices_restricted</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a913266eb2bed0e334454dad2e3acbd25</anchor>
      <arglist>(bool val=true, bool as_radio_buttons=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a3e2cc5f9d7e0a17437fc24fcaaffb510</anchor>
      <arglist>(sharedptr&lt; Relationship &gt; &amp;relationship_name, Glib::ustring &amp;field, Glib::ustring &amp;field_second) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_choices</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a67a1cc30d37ae5fe8666aad2624eae3f</anchor>
      <arglist>(const sharedptr&lt; Relationship &gt; &amp;relationship_name, const Glib::ustring &amp;field, const Glib::ustring &amp;field_second)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_text_format_multiline</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a87b8fc92401ae238e9c13dce88afeb35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_format_multiline</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a32651adde2e28c69c441bb0a2e4019d8</anchor>
      <arglist>(bool value=true)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_text_format_multiline_height_lines</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a84d92c8621b279feaa403d97c94e7035</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_format_multiline_height_lines</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a0ac2bb0727ac828cedce15f2333be63e</anchor>
      <arglist>(guint value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_format_font</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a9feafa8a602bd7501fe5cf5d94daeb4a</anchor>
      <arglist>(const Glib::ustring &amp;font_desc)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_format_font</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a1e346ff2d265a1d328d1986d1ffa5b47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_format_color_foreground</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>adeebfc014989cbc9e1799b91fd6e1a46</anchor>
      <arglist>(const Glib::ustring &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_format_color_foreground_to_use</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a68fe9ba2e9c5732852b2944c4b2236a1</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_format_color_foreground</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>abfa7355dfef0fd2a179d3b2b094ce1a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_format_color_background</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a6ded5f1a442d1227cc29747a8b545b5a</anchor>
      <arglist>(const Glib::ustring &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_format_color_background</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>ae368aa78ca42de29060df3abed4cbb8e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_horizontal_alignment</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>ae78d7d92b21db21d69ac414b4f59926c</anchor>
      <arglist>(HorizontalAlignment alignment)</arglist>
    </member>
    <member kind="function">
      <type>HorizontalAlignment</type>
      <name>get_horizontal_alignment</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>a8f1a99d65c37e694fc1b869fd02dbbd8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_field_name</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>ad2e21e247409fa349bf49a0663abdc70</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="variable">
      <type>NumericFormat</type>
      <name>m_numeric_format</name>
      <anchorfile>classGlom_1_1FieldFormatting.html</anchorfile>
      <anchor>ae1e666e03916c892cd44f3cd16255d55</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutGroup</name>
    <filename>classGlom_1_1LayoutGroup.html</filename>
    <base>Glom::LayoutItem</base>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; LayoutItem &gt; &gt;</type>
      <name>type_list_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a5444b6f4cd0a9f227dc4ee06fe3b3cf0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; const LayoutItem &gt; &gt;</type>
      <name>type_list_const_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>af8b21f87bf200e1eb5362f2ce60e8e4a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutGroup</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>ab6f26b67e8f5ac3d1663435efc517950</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutGroup</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>ad28231f56022d8e89693d72136b9ea8c</anchor>
      <arglist>(const LayoutGroup &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutGroup &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>aadfb92b8f732482ca4516ce75b657f94</anchor>
      <arglist>(const LayoutGroup &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutGroup</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a146ecb20f385e2102bc1c503ad415a65</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a2a170110b849c2d2a181d03184b2febf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_field</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>acf1fe5c384be59079712a45b1ee62f83</anchor>
      <arglist>(const Glib::ustring &amp;field_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_any_fields</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>affc3a68341d7ffff6fc3df720a677fda</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_item</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a2f600f375268eda33a8f87affe1e2940</anchor>
      <arglist>(const sharedptr&lt; LayoutItem &gt; &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_item</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>acf3a338ec10048565183f5f42e71f6f5</anchor>
      <arglist>(const sharedptr&lt; LayoutItem &gt; &amp;item, const sharedptr&lt; const LayoutItem &gt; &amp;position)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_item</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a948a966cd9828181f58247d74cedcc0b</anchor>
      <arglist>(const sharedptr&lt; LayoutItem &gt; &amp;item)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_field</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>aba8c9227e08f7359e13ad8d198a0fe71</anchor>
      <arglist>(const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_field</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>aa95e603acad8c8f377fa94ebd4209f13</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a7dfcf2731abaf35bb3c2c066b21541a4</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_related_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a125464463ee24fd8875ea3769934d0ae</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_relationship</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>acf68c4a533d7a263e428c7a3c9a132b9</anchor>
      <arglist>(const sharedptr&lt; const Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_all_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>ab59d9816e75104f40f00ccdbcbdab22e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_border_width</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>ae18431459e3d9ebfddcb1f70611f9b7b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_border_width</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a5e8081f3580ce4a9ee15c58a6215c4a3</anchor>
      <arglist>(double border_width)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_items_count</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>afd4f75d0f44bd3271763973853133a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_columns_count</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a1fa9afce617b16ccedeb39e74a8cc1ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_columns_count</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a6e72f4a42d7332dfe32429d5036f39ce</anchor>
      <arglist>(guint columns_count)</arglist>
    </member>
    <member kind="function">
      <type>type_list_items</type>
      <name>get_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>ae65f81d84160e9b4801033720f02f3c8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>type_list_const_items</type>
      <name>get_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a8fd146f2bc964bc337df079d4ef996ea</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a269f1f17fa87d137872b0bdb13c6c8c9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>af7a64cbb30879e91e59bfb00c7b1476e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>type_list_items</type>
      <name>m_list_items</name>
      <anchorfile>classGlom_1_1LayoutGroup.html</anchorfile>
      <anchor>a39cb33d72ffed3ddaad8930c773e385a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem</name>
    <filename>classGlom_1_1LayoutItem.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a370b521941530a78789bca5628b7dd5f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a193bc6da7f754929c242fdcc58a5862a</anchor>
      <arglist>(const LayoutItem &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a052ca83bdc6278d4c6aebd3d8f4617f1</anchor>
      <arglist>(const LayoutItem &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a97e640c8c542b8a62d1589aede2b626e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>aec14051b9835ffc6b370847bbba39234</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>ad07e79bf80a127b9581039b504bda49f</anchor>
      <arglist>(const LayoutItem &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>get_editable</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>ab71164993a204287dd7f8e3881f35b03</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_editable</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>ac520a491bba906afc0ee42797af4ef56</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_layout_display_name</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a79253c726a048b45b809cf1775c0cf72</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a294c70c200ae58a60b1764419fd962f9</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a34aaaf4af1425200e2554c6a51edf6fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_display_width</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>ab893b325d963cad72ae557d9e55fb028</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_width</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a45c16168ebc8e42034c4be660f85ea97</anchor>
      <arglist>(guint value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_print_layout_position</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>ae4f9461068589f667c4076bfae665211</anchor>
      <arglist>(double &amp;x, double &amp;y, double &amp;width, double &amp;height) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout_position</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a0772df4266c5ef33161ba9e61b3f0c4a</anchor>
      <arglist>(double x, double y, double width, double height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout_split_across_pages</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>afec222cdd038e9c8821aa19209911d26</anchor>
      <arglist>(bool split=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_print_layout_split_across_pages</name>
      <anchorfile>classGlom_1_1LayoutItem.html</anchorfile>
      <anchor>a4ec5a36401301273708a2578a5ad2066</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Button</name>
    <filename>classGlom_1_1LayoutItem__Button.html</filename>
    <base>Glom::LayoutItem_WithFormatting</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Button</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a00b3f32c5de0f54a75b7c3b43ea67df7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Button</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a2a4ff9550af019cae8483f91e8480f57</anchor>
      <arglist>(const LayoutItem_Button &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Button &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a57d70482c1a847f6a10928658e755844</anchor>
      <arglist>(const LayoutItem_Button &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Button</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a4940b9bb3a879fd87c1dabc11125dd79</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a99c6fba14a2db4aea19ffb455439b1de</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>acd7d494fd05a26c1a54911fcff348ffa</anchor>
      <arglist>(const LayoutItem_Button &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a88da86692084369c8fcfc28d69a63a0f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_script</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a17a9f7f4a29eef0d493067d567f09663</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_script</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>aedd2bb0ab0a11abc2a0ae72c06c676fd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_script</name>
      <anchorfile>classGlom_1_1LayoutItem__Button.html</anchorfile>
      <anchor>a81253a97704133bc0a4a12cebdab6764</anchor>
      <arglist>(const Glib::ustring &amp;script)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_CalendarPortal</name>
    <filename>classGlom_1_1LayoutItem__CalendarPortal.html</filename>
    <base>Glom::LayoutItem_Portal</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_CalendarPortal</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>af51129ed35a198ff4af45f19302a82d9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_CalendarPortal</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a160ecf721711fd7245a18b6c5cdd6d20</anchor>
      <arglist>(const LayoutItem_CalendarPortal &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_CalendarPortal &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a39ed64c5fcd0757ff201246ae21c2328</anchor>
      <arglist>(const LayoutItem_CalendarPortal &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_CalendarPortal</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>aa1c4f497db97230ac5ea23b66c3519c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a8202f1d2cc282b86d08545e263abb2ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a225b02b8699e57f1273b9e2efaad9265</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Field &gt;</type>
      <name>get_date_field</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a2f4989d49e06e9c5976d099112cdcead</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const Field &gt;</type>
      <name>get_date_field</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>af153d20375cb0f1bcb13bd32df3a4fe0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_date_field</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>a9c6fd10f1b7f9a4ceb521fb9a461f301</anchor>
      <arglist>(const sharedptr&lt; Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>ae30e67ab0d8975a8881f6bbbfe515dbe</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_related_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutItem__CalendarPortal.html</anchorfile>
      <anchor>ad901709c6ab318dd9c44f74af5b3fe82</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::predicate_LayoutItem_Field_IsSameField</name>
    <filename>classGlom_1_1predicate__LayoutItem__Field__IsSameField.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>predicate_LayoutItem_Field_IsSameField</name>
      <anchorfile>classGlom_1_1predicate__LayoutItem__Field__IsSameField.html</anchorfile>
      <anchor>a0caaf532f226ff5044634b5c3bc3cd0f</anchor>
      <arglist>(const sharedptr&lt; const T_Element &gt; &amp;layout_item)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>classGlom_1_1predicate__LayoutItem__Field__IsSameField.html</anchorfile>
      <anchor>a93aaee3a50d1f53001c0660ae194d3b5</anchor>
      <arglist>(const sharedptr&lt; const T_Element &gt; &amp;element)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Field</name>
    <filename>classGlom_1_1LayoutItem__Field.html</filename>
    <base>Glom::LayoutItem_WithFormatting</base>
    <base>Glom::UsesRelationship</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Field</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a312279764f2e2b122e72175e7c784491</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Field</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a83995649de46f3b46768f79022e93b07</anchor>
      <arglist>(const LayoutItem_Field &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Field &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a57663eda1f090490ed1ef41c5537170b</anchor>
      <arglist>(const LayoutItem_Field &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Field</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>abafc1fe5896d91ffbca3f7ce96ab5a5e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>ac15859ad17b97ad91e79c1783a6a422b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a3a2ac0bc68570560609f8226aef49ff9</anchor>
      <arglist>(const LayoutItem_Field &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>af9ec40be97d9eab11410ffbfb9f378ab</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>ab88461ab173ad6ec97a29e0f4560a750</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title_or_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a855bc23516400de12d3ebcd96abba591</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_or_name_no_custom</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a268a810908b775c13e782b801bac55ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const CustomTitle &gt;</type>
      <name>get_title_custom</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>af92df10057ec47a38634227daff92a5e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; CustomTitle &gt;</type>
      <name>get_title_custom</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a97e45913892669b2f246e0ac84920758</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title_custom</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a92e701f44e8b59cad3235cac4a301cd2</anchor>
      <arglist>(const sharedptr&lt; CustomTitle &gt; &amp;title)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_layout_display_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a8313d189bd94e43c73962c1258209ede</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a14d4d6ea3d832fdd79a6148987afffa4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>ad84386077b77a358d4082588fdcb9334</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_full_field_details</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a9ab952dfe0242c0eca45a6fc3fb5d8df</anchor>
      <arglist>(const sharedptr&lt; const Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const Field &gt;</type>
      <name>get_full_field_details</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>ad40e4d98f80f76bd844d76d4b6a932c1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Field::glom_field_type</type>
      <name>get_glom_type</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a4f988b415db9bd4aa4e5c8488d4e2998</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_editable_and_allowed</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a90d532d50123f0094940cf0b7dc9a91a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_hidden</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>af2eb4539b3550bc75d0adff0e364b82d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_hidden</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a9a1015d10fc93c8810c8d460313f25d6</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_formatting_use_default</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a118b982f10589e3f0306c62aa84d2695</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_formatting_use_default</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a2e3083a50fe5c26e63f496e3a46a3268</anchor>
      <arglist>(bool use_default=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const FieldFormatting &amp;</type>
      <name>get_formatting_used</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a162956266a5e9a12c497bc42475fe576</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual FieldFormatting::HorizontalAlignment</type>
      <name>get_formatting_used_horizontal_alignment</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>aa1378ca2750662ac6813c9f79a6fb684</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_same_field</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a56d81dae9c69e16ae9742c59150f1c0e</anchor>
      <arglist>(const sharedptr&lt; const LayoutItem_Field &gt; &amp;field) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sql_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a16adaf17dacddf94a9e21a18204b8266</anchor>
      <arglist>(const Glib::ustring &amp;parent_table) const </arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_priv_view</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a89c7f17a6fe692c7e2388032cd1cec96</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_priv_edit</name>
      <anchorfile>classGlom_1_1LayoutItem__Field.html</anchorfile>
      <anchor>a2bf327f386eaf382447e1f7dc8f57d97</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Image</name>
    <filename>classGlom_1_1LayoutItem__Image.html</filename>
    <base>Glom::LayoutItem</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>aad409f1b3b0248e49f78e9b18263bbbb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a1167f8d69a599aa2954bd3f6777aa55b</anchor>
      <arglist>(const LayoutItem_Image &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Image &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a734c4f09c69980569269ba5450071a74</anchor>
      <arglist>(const LayoutItem_Image &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a7b2813864cab857715e82c771eaf8de7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a77976dc636cc90082dd0041910246cef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a1361251a5f1a68473f8cd0e734e210fd</anchor>
      <arglist>(const LayoutItem_Image &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>aa624525c16024ababd618db684bba3a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>af9cd667416731699481af074b89894ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a71112b07fca1b96c24b657a1530857e5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a6d85bae161efeafc6be7a25bc950e7a2</anchor>
      <arglist>(const Gnome::Gda::Value &amp;image)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>create_local_image_uri</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>a995973b3bc0a34e784b03857ddf05b8b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>Gnome::Gda::Value</type>
      <name>m_image</name>
      <anchorfile>classGlom_1_1LayoutItem__Image.html</anchorfile>
      <anchor>ad73ae1d7a678f8b3395b9301905422a0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Line</name>
    <filename>classGlom_1_1LayoutItem__Line.html</filename>
    <base>Glom::LayoutItem</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Line</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a56566dcba44ad36603724e1aeaa00e9b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Line</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a09512d126a5e21f038025a01027ed8a6</anchor>
      <arglist>(const LayoutItem_Line &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Line &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>ac41565bba990d3a8533e72ae05ef02ec</anchor>
      <arglist>(const LayoutItem_Line &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Line</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>ab43729619fc4534cd07167dc4fd822f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a1c61947d87b94e7bf66324a18765d10d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a1d4a3a10824a01d06550e75bc70903cb</anchor>
      <arglist>(const LayoutItem_Line &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>acae250d9195d00315b5287f508263032</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a7c4520c934b49339489b31896c7ca963</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_coordinates</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>afefd4f89604aaa0cf28ac8b9e89f9ea8</anchor>
      <arglist>(double &amp;start_x, double &amp;start_y, double &amp;end_x, double &amp;end_y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_coordinates</name>
      <anchorfile>classGlom_1_1LayoutItem__Line.html</anchorfile>
      <anchor>a296b6a81745f8bfd80c9d4d9a2356f1e</anchor>
      <arglist>(double start_x, double start_y, double end_x, double end_y)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Notebook</name>
    <filename>classGlom_1_1LayoutItem__Notebook.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Notebook</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>a1db785b35a8a27e0168e07040e06ada0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Notebook</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>a5a88eac42b2ce249535524bd1f605fe9</anchor>
      <arglist>(const LayoutItem_Notebook &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Notebook &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>ad8e292ea18216ef5614ebfb075930064</anchor>
      <arglist>(const LayoutItem_Notebook &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Notebook</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>a435b85462e405ed2a782ba738342a56b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>a9298c72481477916d63ad69516c34d79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Notebook.html</anchorfile>
      <anchor>ae1fb18edd134afc423668ed8d730604f</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Placeholder</name>
    <filename>classGlom_1_1LayoutItem__Placeholder.html</filename>
    <base>Glom::LayoutItem</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Placeholder</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>a5e2da34b8731604cc7147f4c736f74c9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~LayoutItem_Placeholder</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>aa9eb7caa697c5df480c5557075d626f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Placeholder</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>aafc3689d681ea80b8ed88bbbe205fb1e</anchor>
      <arglist>(const LayoutItem_Placeholder &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>a1b9acb01ecc0a3ec475008f35fcc0b62</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>ad3f6ea4e233c7fd7b44825b8b6d5e820</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>a43e73f29efeb0e429a1d68bdc12e0d6f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Placeholder.html</anchorfile>
      <anchor>aa4712068ad68656f2ece7f5ff6a68990</anchor>
      <arglist>(const LayoutItem_Placeholder *src) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Portal</name>
    <filename>classGlom_1_1LayoutItem__Portal.html</filename>
    <base>Glom::LayoutGroup</base>
    <base>Glom::UsesRelationship</base>
    <member kind="enumeration">
      <name>navigation_type</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aee2aed2ac459d4f6a0e32b6b6c9f0f75</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NAVIGATION_NONE</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aee2aed2ac459d4f6a0e32b6b6c9f0f75a329b6c6510b5d604146a8b20aad5af9b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NAVIGATION_AUTOMATIC</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aee2aed2ac459d4f6a0e32b6b6c9f0f75a1bd463cd69729f739cbd493b27a2cdcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NAVIGATION_SPECIFIC</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aee2aed2ac459d4f6a0e32b6b6c9f0f75a0db576ac945533ba968c47c548ed79fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Portal</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ac3f6ee86b16bf685a1865ca4af56ffcf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Portal</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a954b4241b93c441733d4efccfc273551</anchor>
      <arglist>(const LayoutItem_Portal &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Portal &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a04299ad631eacfe14794327eddb038e1</anchor>
      <arglist>(const LayoutItem_Portal &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Portal</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a64d3404239a138736f2a9846bafbdc14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a2fddedd477c636ba57419f86ce8424f3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>aba296ce8dcedc2fd740c989d3cf6288f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a6000d49e89d8c2ff9c3fc5211e034dd8</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_related_field_item_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a95c3126e9ec18334752d0c307e8bf0e5</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, const Glib::ustring &amp;field_name_new)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_from_table</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>acdb03d31a8822f900c7baf42b2dbe026</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; UsesRelationship &gt;</type>
      <name>get_navigation_relationship_specific</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ad2822b8d12c24ab20577b6a4450d4067</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const UsesRelationship &gt;</type>
      <name>get_navigation_relationship_specific</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a4dab7539e8768c41622fd9b5e7268e33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_navigation_relationship_specific</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a0f8420d7b9f54e5a42e6f98fea43ced7</anchor>
      <arglist>(const sharedptr&lt; UsesRelationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset_navigation_relationship</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ae115a916fb3cc3e510d9cdeba2be20da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>navigation_type</type>
      <name>get_navigation_type</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a58f1cd6bc23b3fe36895d744a81c8e82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_navigation_type</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a4b6e005d2800eb04995b9c641872bb65</anchor>
      <arglist>(navigation_type type)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_print_layout_row_height</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>a0fc8ea5d4186768c8d029cd585a94823</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout_row_height</name>
      <anchorfile>classGlom_1_1LayoutItem__Portal.html</anchorfile>
      <anchor>ad30c7ab27c5af843f2aba81f31e7bc48</anchor>
      <arglist>(double row_height)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Text</name>
    <filename>classGlom_1_1LayoutItem__Text.html</filename>
    <base>Glom::LayoutItem_WithFormatting</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a5cf0aa60dacdba7f3294bb34e777b0d1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>afe3b7b46f6690b54d9e5f0dadb3a7cd1</anchor>
      <arglist>(const LayoutItem_Text &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Text &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>aee65dd876b9bf536a724828d79bf7979</anchor>
      <arglist>(const LayoutItem_Text &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a70ade4318ed6c5ac116fa077bd3e7a49</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a003b9ec5015861add4ea651a3c539ee8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a1a27554f574c0489086afc6b8962c0c5</anchor>
      <arglist>(const LayoutItem_Text &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a8bd29c496096d365a6d8decd398bad7b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a2e560e593e2c136b74b605880a8e92af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>ae67f458a315a2ee7bed6f75bd70bd65a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>a61a075fb2a7c20a18c65a668a29dce8e</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; TranslatableItem &gt;</type>
      <name>m_text</name>
      <anchorfile>classGlom_1_1LayoutItem__Text.html</anchorfile>
      <anchor>ac28edbfeef06c5bc6f9ad122994d9933</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_WithFormatting</name>
    <filename>classGlom_1_1LayoutItem__WithFormatting.html</filename>
    <base>Glom::LayoutItem</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_WithFormatting</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>a3af7021b565392474390d225bcf6840e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_WithFormatting</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>ab362e44a2c211cd24a8372871a85a6db</anchor>
      <arglist>(const LayoutItem_WithFormatting &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_WithFormatting &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>a26b17c244e26b63ed3d29e668615de31</anchor>
      <arglist>(const LayoutItem_WithFormatting &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_WithFormatting</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>ae81dddf81fbf66fad3595873a3558df5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>abc75b88f0302d9faf23a010dde2c52ef</anchor>
      <arglist>(const LayoutItem_WithFormatting &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const FieldFormatting &amp;</type>
      <name>get_formatting_used</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>a93678510d5d1baa41529859ba21a2a1f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual FieldFormatting::HorizontalAlignment</type>
      <name>get_formatting_used_horizontal_alignment</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>aaca92f08595091b541bb8c6d983a83a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>FieldFormatting</type>
      <name>m_formatting</name>
      <anchorfile>classGlom_1_1LayoutItem__WithFormatting.html</anchorfile>
      <anchor>a649bca5ff5f9e2f1a14d897b80d59c7a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_FieldSummary</name>
    <filename>classGlom_1_1LayoutItem__FieldSummary.html</filename>
    <base>Glom::LayoutItem_Field</base>
    <member kind="enumeration">
      <name>summaryType</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac7a444ba46f7e39d99f404f0732470a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_INVALID</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac7a444ba46f7e39d99f404f0732470a8a93cc3a5462b74dcefc32c7cbd7f86e95</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_SUM</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac7a444ba46f7e39d99f404f0732470a8aaf4eed59bf396496c2aa7a19bd30ac64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_AVERAGE</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac7a444ba46f7e39d99f404f0732470a8a00e4f4aaa38f0cd0e129b66294f63fde</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TYPE_COUNT</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac7a444ba46f7e39d99f404f0732470a8a31f89bf6388e3abff94f08dfdc5e68b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_FieldSummary</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a1a383a4360f51784799b0231494a9c65</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_FieldSummary</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>aa3bf4352da0411e0e5800a1295d69213</anchor>
      <arglist>(const LayoutItem_FieldSummary &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_FieldSummary &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a5fc982f5c3ae2b17e8749bb2aca19f97</anchor>
      <arglist>(const LayoutItem_FieldSummary &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_FieldSummary</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ad1f6ea2a2bfb29de675b2797e71cf8b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a0a4fbef0e230354ae7773a5730ab5412</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a543e2195dd01dfd706ee9974c51cee13</anchor>
      <arglist>(const LayoutItem_FieldSummary &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a83f70a3dc1baeb9ba4b21b010f0f933b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a9ffea5659a50dbd8e134feaa4051b941</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>summaryType</type>
      <name>get_summary_type</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>aad763535db9c3585881dc89a153f0fb3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_summary_type</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ac8f5d02ec14cd7ef0632a7553a70982a</anchor>
      <arglist>(summaryType summary_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_summary_type_sql</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a0939ff5eb6ae75dbb9699fd611a3227b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_summary_type_from_sql</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a40e8f2829757218074199758c33d298a</anchor>
      <arglist>(const Glib::ustring &amp;summary_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_field</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ad5efd580794a4a82845dda895f0c641c</anchor>
      <arglist>(const sharedptr&lt; LayoutItem_Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title_or_name</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>a8f0735ed3a0d5a256dd43bb9c7176c4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_layout_display_name</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>ad027f1c1530e3fdfbd1635de49284352</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_layout_display_name_field</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>af8e643306d8317bc1515cde40e50a0fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_summary_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__FieldSummary.html</anchorfile>
      <anchor>af7ad9ac2ce90a729a03afb6dff235186</anchor>
      <arglist>(summaryType summary_type)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Footer</name>
    <filename>classGlom_1_1LayoutItem__Footer.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Footer</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>af42d7a6df5f3f6bce10160cf4d480a3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Footer</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>ab29ec6bf51dba1da570443eed0022247</anchor>
      <arglist>(const LayoutItem_Footer &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Footer &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>a1fa67fd99e9695b9bf68bbf89ed682f7</anchor>
      <arglist>(const LayoutItem_Footer &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Footer</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>aac35ae62849d54ba0e11760bef3f2b17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>a21019aea5d9d43a90a66ec64879e9be1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>ad7465409e0783dec61b5332a7aa2c5c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Footer.html</anchorfile>
      <anchor>af920bcec2b20f020cad1f1b51e70c1a1</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_GroupBy</name>
    <filename>classGlom_1_1LayoutItem__GroupBy.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="typedef">
      <type>std::pair&lt; sharedptr&lt; const LayoutItem_Field &gt;, bool &gt;</type>
      <name>type_pair_sort_field</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a86f86a567ec6f540decf10565e952046</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; type_pair_sort_field &gt;</type>
      <name>type_list_sort_fields</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a67c7de91a9dd24988a4e34779274b3d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_GroupBy</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>aef2d5076b2bcd6ea87fc6f6fb778bd77</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_GroupBy</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a177a17665f678a1b8c07069ab0a343a6</anchor>
      <arglist>(const LayoutItem_GroupBy &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_GroupBy &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>af15da217f9d86a32c445ed7560d7f263</anchor>
      <arglist>(const LayoutItem_GroupBy &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_GroupBy</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a62eb046c8adf474916e23130662ea3ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a5c174413daf97cfb1c58a32b4823a7e1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; LayoutItem_Field &gt;</type>
      <name>get_field_group_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a7dad483e736446bbd0302a0844c5326d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; const LayoutItem_Field &gt;</type>
      <name>get_field_group_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>aa30d7572cb2bcb9bf953523ce4b8d27e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_field_group_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>ad72cab568a4f32840cfba438ac97da1e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_field_group_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>ac27d718e2d915c0e3c196f5c44d1b8ad</anchor>
      <arglist>(const sharedptr&lt; LayoutItem_Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function">
      <type>type_list_sort_fields</type>
      <name>get_fields_sort_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>ab5698f2a030b02334adab603f501083a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>type_list_sort_fields</type>
      <name>get_fields_sort_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a6f48520d5cd92fb7ccf0017aeed0675e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_fields_sort_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a5d6486b3ea63b5a833d0fcea310a084e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fields_sort_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>af6233ebe91f08a75108a5252e8653657</anchor>
      <arglist>(const type_list_sort_fields &amp;field)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_layout_display_name</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>ac56364bb84714004b3fa8496bd4762c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>ab2a7adc6952f9b18194e1415a6e05fb6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>abc6c120dfd1b706625c4d25d8005808d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; LayoutGroup &gt;</type>
      <name>m_group_secondary_fields</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>ac46b432524b317165679c5e3fdf1cf33</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>type_list_sort_fields</type>
      <name>m_fields_sort_by</name>
      <anchorfile>classGlom_1_1LayoutItem__GroupBy.html</anchorfile>
      <anchor>a04906696db25ea8d6ec2c47538e2278f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Header</name>
    <filename>classGlom_1_1LayoutItem__Header.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Header</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a298fce41d5a9e990b8180a34fa89c7a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Header</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a882f33e654234866417d2aa94fd9bc78</anchor>
      <arglist>(const LayoutItem_Header &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Header &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>ab756e0f2b4c641b967b8c5b2e209fc0f</anchor>
      <arglist>(const LayoutItem_Header &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Header</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a10e0fe931d484a70abe1f0a097ffc9a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a06c57ce643f854e4b1e4bc1806073a09</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a1485994082a11b3883d910ce3021af35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Header.html</anchorfile>
      <anchor>a882bbefd81e1ac95fc38e281936e12d9</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_Summary</name>
    <filename>classGlom_1_1LayoutItem__Summary.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Summary</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>a18f140ac144c7b8e4be2e9b792a9e006</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_Summary</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>aac13147739481f2874215e83244a7b5d</anchor>
      <arglist>(const LayoutItem_Summary &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_Summary &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>af3fed655e6fedbc6a3fe761240565143</anchor>
      <arglist>(const LayoutItem_Summary &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_Summary</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>a5840bb7ff9ad63e15510f27bd466e421</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>a442b59bc2ee57bf392448838d4dbcaab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>ac45d68f2eab4b4d9140f09c710cd4022</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__Summary.html</anchorfile>
      <anchor>af8532048d396b86823911e1acb0e40c2</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::LayoutItem_VerticalGroup</name>
    <filename>classGlom_1_1LayoutItem__VerticalGroup.html</filename>
    <base>Glom::LayoutGroup</base>
    <member kind="function">
      <type></type>
      <name>LayoutItem_VerticalGroup</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a0565284ac341dd56b2969fdc1125bb36</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LayoutItem_VerticalGroup</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a75020c234aeda70afa11e81005c6c932</anchor>
      <arglist>(const LayoutItem_VerticalGroup &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>LayoutItem_VerticalGroup &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a4c73c104ccec60d1fed002df0e483703</anchor>
      <arglist>(const LayoutItem_VerticalGroup &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutItem_VerticalGroup</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>ac7012e56ad149baea68717393f304344</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual LayoutItem *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a72765425daaccf99715fdf485d347fbe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_part_type_name</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a714ad4ee082316204b31659cdc6207f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_report_part_id</name>
      <anchorfile>classGlom_1_1LayoutItem__VerticalGroup.html</anchorfile>
      <anchor>a28f8d26e1de55d70e33658fbcce5b51d</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::UsesRelationship</name>
    <filename>classGlom_1_1UsesRelationship.html</filename>
    <member kind="function">
      <type></type>
      <name>UsesRelationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a08d9232e304a6be1929f826c07be8401</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UsesRelationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>ad1c70e67858276fa99873c02ff8a792b</anchor>
      <arglist>(const UsesRelationship &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>UsesRelationship &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>af0600689d4285c9239ef849a74905a7c</anchor>
      <arglist>(const UsesRelationship &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UsesRelationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>aaafdd414fee5e64515b0f5e57fa0c331</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a854b7d9573391af22ffd58a315e27f24</anchor>
      <arglist>(const UsesRelationship &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_relationship_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a8de43ba6a30c8f6d0b59dfe7dd1d070b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_related_relationship_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a77c12cb5a554e4364992394492e64178</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_relationship_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>ab6ea484067457f54de8895d34fe6c2dc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_related_relationship_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a7d15ed810c92859fb53a82e26b5face0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Relationship &gt;</type>
      <name>get_relationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a0b630aca05898dec008128e4144bfe1a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_relationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a4f149d45d325a0986b0d128b72ff88ef</anchor>
      <arglist>(const sharedptr&lt; Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Relationship &gt;</type>
      <name>get_related_relationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a5425c44419992a26e822709dfa8103b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_related_relationship</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a55036468e2aec6fe4f85604e0f2d11ea</anchor>
      <arglist>(const sharedptr&lt; Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_table_used</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a9c318b7b53b289b2cce4b7a2837c6ac3</anchor>
      <arglist>(const Glib::ustring &amp;parent_table) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_used</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>ad2a0d15ff3f128efbea3a7dcd4822cd9</anchor>
      <arglist>(const Glib::ustring &amp;parent_table_title) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_singular_used</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a72680483b5f7805860a4b7d96e43f1fb</anchor>
      <arglist>(const Glib::ustring &amp;parent_table_title) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_to_field_used</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>ad617dbc1dac6a36622e1df4d19460820</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_relationship_name_used</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>aba1275ef9104195d0295ededca4baa87</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_relationship_used_allows_edit</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a5f62a279a3b92f332a281908e7373cc1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sql_join_alias_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a848a62d4a236699d2b72eeb07336e118</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sql_join_alias_definition</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>aec24ad37c4bcac59bbb58ffd279215b7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sql_table_or_join_alias_name</name>
      <anchorfile>classGlom_1_1UsesRelationship.html</anchorfile>
      <anchor>a4e11c0d9f8ce41071d029a577c2d1bb4</anchor>
      <arglist>(const Glib::ustring &amp;parent_table) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::NumericFormat</name>
    <filename>classGlom_1_1NumericFormat.html</filename>
    <member kind="function">
      <type></type>
      <name>NumericFormat</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>aaf955d13fa451e126e504d3dc2c87de1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>NumericFormat</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a32243f98e403d8eba8be283a7911162f</anchor>
      <arglist>(const NumericFormat &amp;src)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~NumericFormat</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>af3e680cf6d09f07af1b76ba6c349dfea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>NumericFormat &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a145cc9f3a59351e912ad2279989fc003</anchor>
      <arglist>(const NumericFormat &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a9b87f17b841f81b3149c1117155c0088</anchor>
      <arglist>(const NumericFormat &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>ae54a335f1c28a4440b8ee5f6d1f8468b</anchor>
      <arglist>(const NumericFormat &amp;src) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_alternative_color_for_negatives</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a74e8ae9e3ed8551a3d6924473fa30720</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static guint</type>
      <name>get_default_precision</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a51c367cdb65b3da1f16aa18025c99330</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_currency_symbol</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a2138c60199b12fbb39e206c8b7a0be3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_use_thousands_separator</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a0cc3f7af432d63a9ed58f0b1352a9d1d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_decimal_places_restricted</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a00fa7436dfe76375b60a20efa3371bfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>guint</type>
      <name>m_decimal_places</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a551be2f91ec8b1bbd08342b16447950d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_alt_foreground_color_for_negatives</name>
      <anchorfile>classGlom_1_1NumericFormat.html</anchorfile>
      <anchor>a687d90667e6d6f4e7ea782e88488347c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::ParameterNameGenerator</name>
    <filename>classGlom_1_1ParameterNameGenerator.html</filename>
    <member kind="function">
      <type></type>
      <name>ParameterNameGenerator</name>
      <anchorfile>classGlom_1_1ParameterNameGenerator.html</anchorfile>
      <anchor>ae46a47e145dd2b1c271326dba042627f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ParameterNameGenerator</name>
      <anchorfile>classGlom_1_1ParameterNameGenerator.html</anchorfile>
      <anchor>a5b511f44628ce35b3bef554b9a9cbf53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_next_name</name>
      <anchorfile>classGlom_1_1ParameterNameGenerator.html</anchorfile>
      <anchor>a4a01b4660eb8af5aa05cba331a3acf19</anchor>
      <arglist>(unsigned int &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name_from_id</name>
      <anchorfile>classGlom_1_1ParameterNameGenerator.html</anchorfile>
      <anchor>a9d71b392911800dc1afbb054987a64da</anchor>
      <arglist>(unsigned int id)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::PrintLayout</name>
    <filename>classGlom_1_1PrintLayout.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="function">
      <type></type>
      <name>PrintLayout</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>aa24618bcdf93f211321336657b8ce440</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PrintLayout</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a5b1c2ddc046b18cf2c3a06a35cca1300</anchor>
      <arglist>(const PrintLayout &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>PrintLayout &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>aa799d9dcc69bee8f81959f40fac90af3</anchor>
      <arglist>(const PrintLayout &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_show_table_title</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a262eb060afda4aae28206387e3bf56c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_show_table_title</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>ad8dbb34ebb40ca05367938cb811ec5b7</anchor>
      <arglist>(bool show_table_title=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_page_setup</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>a2bacab030c749af331df465c13ba9d15</anchor>
      <arglist>(const std::string &amp;page_setup)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_page_setup</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>ac1272d3458acb8005a955fc1f4d270df</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; LayoutGroup &gt;</type>
      <name>m_layout_group</name>
      <anchorfile>classGlom_1_1PrintLayout.html</anchorfile>
      <anchor>aebaeba846e1c45cb86803ebbef33e390</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::Privileges</name>
    <filename>classGlom_1_1Privileges.html</filename>
    <member kind="function">
      <type></type>
      <name>Privileges</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>aa44942247f9f5cd37c0158ea3135253f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Privileges</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>aff22fb4d93c74fb5533903930c0ee02e</anchor>
      <arglist>(const Privileges &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Privileges</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>ac791d94856700fdec59c72f5d23acf65</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Privileges &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a5595c77a4c93e0e92c5c66dc3cf81626</anchor>
      <arglist>(const Privileges &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a7264e33cc541dd98b27ce1180312a8f8</anchor>
      <arglist>(const Privileges &amp;src) const </arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_view</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a1f8f0726dc4b89fdd9d909df18ba1dd6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_edit</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a83b1171087ab5947209e14b82cd93cc4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_create</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>a57d83d9f39bd03c21cdf1e41c24c7590</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_delete</name>
      <anchorfile>classGlom_1_1Privileges.html</anchorfile>
      <anchor>ab52ae304f6508b669d766682b21d43b7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::Relationship</name>
    <filename>classGlom_1_1Relationship.html</filename>
    <base>Glom::TranslatableItem</base>
    <base>Glom::HasTitleSingular</base>
    <member kind="function">
      <type></type>
      <name>Relationship</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a94cde292c4af02b28692980f82ef19ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Relationship</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a330ffdd12dc99aae589364a432b19c2f</anchor>
      <arglist>(const Relationship &amp;src)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Relationship</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a94560e4f063db28593bdc56bcbd30877</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Relationship &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a7d73d9da8f86d88ec50bd2e878535e71</anchor>
      <arglist>(const Relationship &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a2e2ba2b426295ebe9dbed54850ef447a</anchor>
      <arglist>(const Relationship &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>Relationship *</type>
      <name>clone</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>aa9a2b748a2a4ef193103cf8a70cf8e47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_from_table</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a3b3e458ca899746fc175f8731ea4ff49</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_from_field</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a08462b33b37d76c0c3a221f4f7ccf528</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_to_table</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a04fc32785f3eea359abfed6831c79ba8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_to_field</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a990a22e48d31b32b738dcc3bdfdbd051</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_from_table</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a41b604bd24c681045dc8ee3fa23c3573</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_from_field</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>acfe2d31f53f95630165be62a173121c4</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_to_table</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a0fcdbf621390747042fea5363f80bf74</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_to_field</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a80c36f036e5d5ec265635b574cd42e18</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_auto_create</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>ae656e6249a01e944f5f7307a9536ee64</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_auto_create</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>ac93cbceb752c10780babe3a9631e22e7</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_allow_edit</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a20b38d5f5a4ded2aa137c3b9fc0fc9ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_allow_edit</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a7cdacd3004b9be677b6d2e480d443753</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_fields</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>a6512b2b14220b946b2679ddda4456f88</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_to_table</name>
      <anchorfile>classGlom_1_1Relationship.html</anchorfile>
      <anchor>ac93aa928e7eb80165bc8c9b1d2183bdb</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::Report</name>
    <filename>classGlom_1_1Report.html</filename>
    <base>Glom::TranslatableItem</base>
    <member kind="function">
      <type></type>
      <name>Report</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>ac16b046a107dcb425a9c063be5c76662</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Report</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>a9c08e09fb6722138ca649668d6f85c2f</anchor>
      <arglist>(const Report &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>Report &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>a764b65b8756e75c2441680a27768996c</anchor>
      <arglist>(const Report &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_show_table_title</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>ad2ce809d2f6c3dee2bae42584f942327</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_show_table_title</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>a169be4aa13172643ecb93377638846e8</anchor>
      <arglist>(bool show_table_title=true)</arglist>
    </member>
    <member kind="variable">
      <type>sharedptr&lt; LayoutGroup &gt;</type>
      <name>m_layout_group</name>
      <anchorfile>classGlom_1_1Report.html</anchorfile>
      <anchor>aa06fd1de0f21e02409524f9c3402c68c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::SystemPrefs</name>
    <filename>classGlom_1_1SystemPrefs.html</filename>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_name</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>aaa6b3baae3c6c36d70fad0bfb0aa5932</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_name</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>a4c77401a02d4d8d916b7549d01abcf7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_street</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>a49def901c0c857f7114b2659bd621c6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_street2</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>aa8d9cfd0ca0673c07ad95b454e2990bd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_town</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>a64ab452bd2ba2dbd00c6ad4b185a9772</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_county</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>a0ed741d895302266d54f1c4c319b89e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_country</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>ab4528856d49e81dd0720c81f4699a1b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_org_address_postcode</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>ab5e758740c2f6defa091f98307d77cba</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Gnome::Gda::Value</type>
      <name>m_org_logo</name>
      <anchorfile>classGlom_1_1SystemPrefs.html</anchorfile>
      <anchor>ab3d3a3730e198564e4702ec3e2bee844</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::TableInfo</name>
    <filename>classGlom_1_1TableInfo.html</filename>
    <base>Glom::TranslatableItem</base>
    <base>Glom::HasTitleSingular</base>
    <member kind="function">
      <type></type>
      <name>TableInfo</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>aad05b7307836a9b7548e5161ba6cd8f2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TableInfo</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>a9557bc606d9bb73c58544ed90c962b55</anchor>
      <arglist>(const TableInfo &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>TableInfo &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>ad9a4603eb92524a3e40d2d4e96bc9ba9</anchor>
      <arglist>(const TableInfo &amp;src)</arglist>
    </member>
    <member kind="variable">
      <type>guint</type>
      <name>m_sequence</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>a19e6003776b7826467dddf1c99cfe5e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_hidden</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>aa532f7a43eeda83a050df796ca6ac4fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>m_default</name>
      <anchorfile>classGlom_1_1TableInfo.html</anchorfile>
      <anchor>a216ce24bbbe21dfc1fca9ee90c5b3b24</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::TranslatableItem</name>
    <filename>classGlom_1_1TranslatableItem.html</filename>
    <member kind="enumeration">
      <name>enumTranslatableItemType</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_INVALID</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09aa0e068f4c925e126640b5713d30df90d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_FIELD</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a0d44075d1d61db1c44573ee2fc1d7085</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_RELATIONSHIP</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a351c7ac2e55e769d65eb352ab56d259d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_LAYOUT_ITEM</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a5b6a542b337cf60fdfeeb14fc81df55e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_CUSTOM_TITLE</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a9ac77fa3c1931a962640283b55f6be2a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_PRINT_LAYOUT</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a4d90339e4e1360096b7b3e2cce3b6694</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_REPORT</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09acc95af040162973a318d31805618bceb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_TABLE</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09ae7222449dfa5a27b485267d70a587fcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_BUTTON</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09abb8fada243c986dc43e4795155bf1e07</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_TEXTOBJECT</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a6174f2152734f488adfe3d572f746a66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRANSLATABLE_TYPE_IMAGEOBJECT</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a42caf941e237ef5c654c2a232a272f09a4a84bd31da6cda2d3bb4a1d522d794b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; Glib::ustring, Glib::ustring &gt;</type>
      <name>type_map_locale_to_translations</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a1c9755f8567b4247f4a37bb46435f4c5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TranslatableItem</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a59d9f54952fb3953c70c3cf79e5b0397</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TranslatableItem</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a6d86fb79fc616db7ba0ac5005d0e74c1</anchor>
      <arglist>(const TranslatableItem &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~TranslatableItem</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>abebc7ddec9b4f63f9f1a1754c02f4105</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>TranslatableItem &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>aacbf1093c62e04361c022387053ca760</anchor>
      <arglist>(const TranslatableItem &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ae33a145dda75b7322e7a5f2a5635f8d8</anchor>
      <arglist>(const TranslatableItem &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a1c80c03608eedd719b36f9e917d92bbe</anchor>
      <arglist>(const TranslatableItem &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_name</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>af313c8b7add99dd1ceb1adf71981de5a</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ab3c4f398be8064fc0ed7a3244cb75ac2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_name_not_empty</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>aa1c2999c30fc5878b9c55eeaafa1d04d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_title_or_name</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a3f000bee9e52693cafd2a4473c3fae1f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a1b04ab4b62f235e116ab8a854f7e2142</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a8f13a76fb5816066c85343626eba0057</anchor>
      <arglist>(const Glib::ustring &amp;locale) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title_original</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ac06d29f1097153cd6bd47eb97739869f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a9252d016031a8a553e54844b085f1ee1</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a18e23a932295d1969d27e02b20d17986</anchor>
      <arglist>(const Glib::ustring &amp;locale, const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title_original</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a9a6619911111f34afbb378e477366048</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_translation</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a679816b224ce7c2a6bcf18dcb82394b7</anchor>
      <arglist>(const Glib::ustring &amp;locale, const Glib::ustring &amp;translation)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_translation</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ac9dc3a4c56155779a561fe56fc1f7c26</anchor>
      <arglist>(const Glib::ustring &amp;locale) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_title_in_all_locales</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ad972e58a60f9d2a7458e2abd1253b75f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_translations</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a627b76316a98caa6e84f4f12eb2e8e65</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>enumTranslatableItemType</type>
      <name>get_translatable_item_type</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a486a93ad28528009a9174abbaabe55fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_translatable_type_name</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>acc45224a4c529024aef7d90c94a9e4ab</anchor>
      <arglist>(enumTranslatableItemType item_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_translatable_type_name_nontranslated</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a1e9fa1e6662844076ef63aff1d9376ee</anchor>
      <arglist>(enumTranslatableItemType item_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_current_locale</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a68f15b75132052daf87b5f7c927fbee6</anchor>
      <arglist>(const Glib::ustring &amp;locale)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>get_current_locale</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>a18b46404b9b4793d65f426678d61f256</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_original_locale</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ad4058a1b134417a052406357b70e6b06</anchor>
      <arglist>(const Glib::ustring &amp;locale)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>get_current_locale_not_original</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ab575866dea0998537a3b6ffc6865ac93</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>enumTranslatableItemType</type>
      <name>m_translatable_item_type</name>
      <anchorfile>classGlom_1_1TranslatableItem.html</anchorfile>
      <anchor>ab4ef5af7ccfc36bbf2f5feb23918b9f6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::Document</name>
    <filename>classGlom_1_1Document.html</filename>
    <base>GlomBakery::Document_XML</base>
    <member kind="enumeration">
      <name>HostingMode</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a54256dad3f42641da3434bf687d5da49</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOSTING_MODE_POSTGRES_CENTRAL</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a54256dad3f42641da3434bf687d5da49ab86dcd950027408ed28e171902e769aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOSTING_MODE_POSTGRES_SELF</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a54256dad3f42641da3434bf687d5da49af6a98f13e469bdd6bfcd933b25fea68b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOSTING_MODE_SQLITE</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a54256dad3f42641da3434bf687d5da49abf9c730e96318c88df8766514cfdfa9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOSTING_MODE_DEFAULT</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a54256dad3f42641da3434bf687d5da49a901e9051108e8e556ba4f260d5adb2f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>userLevelReason</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc26e179ab1bb3fc08dbfbe06fbaf410</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USER_LEVEL_REASON_UNKNOWN</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc26e179ab1bb3fc08dbfbe06fbaf410a8d7d9bacad5ba54589f1b5a412bb3dd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USER_LEVEL_REASON_FILE_READ_ONLY</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc26e179ab1bb3fc08dbfbe06fbaf410a8c5889c747c97b125f96d0d720598315</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USER_LEVEL_REASON_DATABASE_ACCESS_LEVEL</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc26e179ab1bb3fc08dbfbe06fbaf410a4e77ef46784db3ff58ff34686c45cc7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>USER_LEVEL_REASON_OPENED_FROM_BROWSE</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abc26e179ab1bb3fc08dbfbe06fbaf410a014d8667d572ce4617e504183bdf7462</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>load_failure_codes</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a66a6e7180bd2e8ed4b0cd3c98e04bb77</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LOAD_FAILURE_CODE_FILE_VERSION_TOO_NEW</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a66a6e7180bd2e8ed4b0cd3c98e04bb77aaa943ae3fc9f302196739a7da25e2f4a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; Relationship &gt; &gt;</type>
      <name>type_vec_relationships</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a5f5a0cd04d7505fc767d8c3fa3619721</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; Field &gt; &gt;</type>
      <name>type_vec_fields</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9cae49d450ede55a856575682eab53dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; LayoutGroup &gt; &gt;</type>
      <name>type_list_layout_groups</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9d8a77d03f244bc189e08e133eb475fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; sharedptr&lt; TranslatableItem &gt; &gt;</type>
      <name>type_list_translatables</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a84c669bb6dc95ce7ffa16b61b4056f1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; sharedptr&lt; TableInfo &gt; &gt;</type>
      <name>type_listTableInfo</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae42cb0d25dbdcd3a09cf704f238f9f9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; Gnome::Gda::Value &gt;</type>
      <name>type_row_data</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aca8431de4908b829ce8024e798b4ff8c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; type_row_data &gt;</type>
      <name>type_example_rows</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab5905a45fa16a88d745959b620a038bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; GroupInfo &gt;</type>
      <name>type_list_groups</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abfa5f5dfb05a1f4396022a30d202d051</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; Glib::ustring &gt;</type>
      <name>type_listReports</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>acf8dcf5aa53edb41903a089e8887a754</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; Glib::ustring &gt;</type>
      <name>type_listPrintLayouts</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab7532d847364e062dfb1ca8bfa512552</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::signal&lt; void, AppState::userlevels &gt;</type>
      <name>type_signal_userlevel_changed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7a0abb07acbcae993250c2108c650184</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Document</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a90ff6b08dcaf5ddcae4f3499c2578bf3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Document</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a344c8ae601cc9256224368977a1fd8b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_modified</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab73f48890e1764529433095dd974d105</anchor>
      <arglist>(bool value=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_file_uri</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ac9819606d7c905271fe873dddb62f53e</anchor>
      <arglist>(const Glib::ustring &amp;file_uri, bool bEnforceFileExtension=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a1ede7d94348089309c46b7b01229e79e</anchor>
      <arglist>(int &amp;failure_code)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_opened_from_browse</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0e008dfbf0d238b5a77c0f45298edf29</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_opened_from_browse</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a18bb5479ce943ef28278558960920766</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_allow_autosave</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae203d2b063dac5287da64fa63ae50c5e</anchor>
      <arglist>(bool value=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_example_file</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a2ecc05580205e89f46aa90c5230ac6a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_example_file</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a8d4d81de8c825f1f68d1821c05d1023e</anchor>
      <arglist>(bool value=true)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_document_format_version</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ac3976a7656969455e9c4e1c3c7567972</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_hosting_mode</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ace5a3278c813d2110776852899c22944</anchor>
      <arglist>(HostingMode mode)</arglist>
    </member>
    <member kind="function">
      <type>HostingMode</type>
      <name>get_hosting_mode</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a6a9ac061b46ecbadd61cf64f294c5930</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_network_shared</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3e15ba717ea6589c46c5082564e700e7</anchor>
      <arglist>(bool shared=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_network_shared</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a07e3a92de7638d028f8b66f69f588466</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_connection_server</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a044d90398f59d87e55a6bb7b79bbdc1e</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_connection_database</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0c9cd11c69ff2d32661a9c6d9473b660</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_connection_port</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a853716283bf8064f0d1fe0bf359cfec7</anchor>
      <arglist>(int port_number)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_connection_try_other_ports</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a288a93328e6058bb769e74f56ed18791</anchor>
      <arglist>(bool val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_connection_user</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad2d85b9e4840a99197ec327a3f39584b</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_connection_self_hosted_directory_uri</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a6bac0c857baecc5c84731af9d6fa6251</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_connection_server</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a1883d24f1120b747ad064b8d7a73d21f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_connection_database</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a85c082c4808d6fe39c42e4a14f2299a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_connection_port</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab8d4b98905e52c9228f9303fa0865d4c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_connection_try_other_ports</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7a11f7a921bf490a9de6506919fd213d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_connection_user</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a036e47f17250ef6b8af83164cce5c1b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_translation_original_locale</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>abd8e2bc47132dbdf9c5fa98024729b07</anchor>
      <arglist>(const Glib::ustring &amp;locale)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_translation_original_locale</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a8d805cbac982814fec599d010c5236dc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>type_vec_relationships</type>
      <name>get_relationships</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>acd434017c27038ceb773c900d19b5778</anchor>
      <arglist>(const Glib::ustring &amp;table_name, bool plus_system_prefs=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_relationships</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3d8df9373a64f30bc6c9127a69f0a07b</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vec_relationships &amp;vecRelationships)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Relationship &gt;</type>
      <name>get_relationship</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad39d0089cf34047624db0e8c33e9ac8d</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;relationship_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_relationship</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a16f7565b30384dadcd17d3525f628be6</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_relationship</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a15a2ab17697301f2726d080d7baad1f5</anchor>
      <arglist>(const sharedptr&lt; const Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_relationship_is_to_one</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3c98c23ac46b78af711d49111fa5b44d</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;relationship_name) const </arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Relationship &gt;</type>
      <name>get_field_used_in_relationship_to_one</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a063c42c035a83d92990d4b214a3f8f6b</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; const LayoutItem_Field &gt; &amp;layout_field) const </arglist>
    </member>
    <member kind="function">
      <type>type_vec_fields</type>
      <name>get_table_fields</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a89eeee7950330d4000f5cdddb36bf4e9</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_table_fields</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a657108407aaed9a6cca6232a1587f116</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vec_fields &amp;vecFields)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Field &gt;</type>
      <name>get_field</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab9c42a30a3826c3a52f43a0d9c5ba2d0</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;strFieldName) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_field</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a07027365c86499ca1a5d820aabfe0457</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name)</arglist>
    </member>
    <member kind="function">
      <type>type_list_layout_groups</type>
      <name>get_data_layout_groups</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a87bc03c6698865dd8dfd194de66f1618</anchor>
      <arglist>(const Glib::ustring &amp;layout_name, const Glib::ustring &amp;parent_table_name, const Glib::ustring &amp;layout_platform=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_data_layout_groups_have_any_fields</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7e381754fc804dd08b3096ee7522214b</anchor>
      <arglist>(const Glib::ustring &amp;layout_name, const Glib::ustring &amp;parent_table_name, const Glib::ustring &amp;layout_platform=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_data_layout_groups</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab33878ff9cf67dfcfea57a095a0eced4</anchor>
      <arglist>(const Glib::ustring &amp;layout_name, const Glib::ustring &amp;parent_table_name, const Glib::ustring &amp;layout_platform, const type_list_layout_groups &amp;groups)</arglist>
    </member>
    <member kind="function">
      <type>type_list_layout_groups</type>
      <name>get_data_layout_groups_plus_new_fields</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aa1ec054e4ada4da45663ab917352cf2a</anchor>
      <arglist>(const Glib::ustring &amp;layout_name, const Glib::ustring &amp;parent_table_name, const Glib::ustring &amp;layout_platform=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>type_list_layout_groups</type>
      <name>get_data_layout_groups_default</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a99db4a5995cdaac2d13d68cd6ce272c3</anchor>
      <arglist>(const Glib::ustring &amp;layout_name, const Glib::ustring &amp;parent_table_name, const Glib::ustring &amp;layout_platform=Glib::ustring()) const </arglist>
    </member>
    <member kind="function">
      <type>type_list_translatables</type>
      <name>get_translatable_layout_items</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a877f9c48886dad82b344b7cccc84b347</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>type_list_translatables</type>
      <name>get_translatable_report_items</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0f559465fd43ca1f610f21657c164df5</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;report_title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_layout_field_details</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a78d0b24d0b76a960c3229a0df2014d14</anchor>
      <arglist>(const Glib::ustring &amp;parent_table_name, const sharedptr&lt; LayoutGroup &gt; &amp;layout_group) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_layout_field_details</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad600378dbbd8dd695a860b1442f1c4ac</anchor>
      <arglist>(const Glib::ustring &amp;parent_table_name, type_list_layout_groups &amp;groups) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_field_name</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>af5a1f5b0c3da19b7efcda3c930ca47b2</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;strFieldNameOld, const Glib::ustring &amp;strFieldNameNew)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_table_name</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a4cf00bbe1e0e933babbb7232fe18f3e2</anchor>
      <arglist>(const Glib::ustring &amp;table_name_old, const Glib::ustring &amp;table_name_new)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_relationship_name</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a70f3bcd7d6a6b6db063f0b3d99a59f9c</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;name, const Glib::ustring &amp;name_new)</arglist>
    </member>
    <member kind="function">
      <type>type_listTableInfo</type>
      <name>get_tables</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aad2bb4030a215df165c0853340da9683</anchor>
      <arglist>(bool plus_system_prefs=false) const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>get_table_names</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a24489310e5ec3fe42e10c19aa99dbaf5</anchor>
      <arglist>(bool plus_system_prefs=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_tables</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a1793737ae7580ca7eda799182dce95bc</anchor>
      <arglist>(const type_listTableInfo &amp;tables)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; TableInfo &gt;</type>
      <name>get_table</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7b30bb9366b751b49c98f78e3f230e6c</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_table</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aa10ca51126b3584e6b08c252d1b0de94</anchor>
      <arglist>(const sharedptr&lt; TableInfo &gt; &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_table</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>af8a8df4382e37d65864efb6d211f50e2</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_table_is_known</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aef76714a9cbca223eaa407c2eaa0327f</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_table_is_hidden</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a2879c2d8d949bab631e07ff421bc481b</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_table_title</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9a66b0361d754351f2d6d39515414b01</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_table_title</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae716dda0e1fec4f96bc1f1e71a1635af</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_table_title_singular</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a5e16ef68c717ae8ac71e0ca0e1df391b</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_table_example_data</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>afedc945ec10ff9dbab28eddee55fa8d0</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_example_rows &amp;rows)</arglist>
    </member>
    <member kind="function">
      <type>type_example_rows</type>
      <name>get_table_example_data</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a8efb16e60e7bd958571a07517742b128</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a1ead5d0ddaa368c3e01165bbdc9bbdda</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_default_table</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3578eab4e777bdbc552e6d72c4cbcd12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_first_table</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a194af911d3ce865c40b9a0e3cc4a6fba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_database_title</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ac7395b0f421de0a6e4b7ce2d7a071861</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_database_title</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a84b1c7bf8678ab058fb8e741c8496b7d</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>get_library_module_names</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a6801b603aa028c5cb1f592878e3374d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_library_module</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab92ce8dd4687ae3b45257ad007a60511</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::ustring &amp;script)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_library_module</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>af40255606bf9091cbac43fa54c2dd703</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_library_module</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0fdc644b88c714eaf8fb13d3d05f97fe</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_startup_script</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae917d14c0bb3760a3b249e2f82688d24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_startup_script</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7babdeae6c108d1a8fe5ce98b62b1541</anchor>
      <arglist>(const Glib::ustring &amp;script)</arglist>
    </member>
    <member kind="function">
      <type>type_list_groups</type>
      <name>get_groups</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a711160783afe364504fb6b0a32d983b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_group</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3e77240d9e4eb38502951e604d5c4e5c</anchor>
      <arglist>(GroupInfo &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_group</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae49bf6ebfe9961f3b1d4f7cf09ca6dc2</anchor>
      <arglist>(const Glib::ustring &amp;group_name)</arglist>
    </member>
    <member kind="function">
      <type>type_listReports</type>
      <name>get_report_names</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a5e55517f22fd0ee23c7ab26ca1f7acfa</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_all_reports</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a86a93a8e6fa9c0a19c0375d27002ae8e</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_report</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a47faae146fbbc9dea0752f412f2a3595</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; Report &gt; &amp;report)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; Report &gt;</type>
      <name>get_report</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aaa7e2e1160442d0458b876d8e6f8d9b0</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;report_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_report</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a8b231a7d8dbfe07ad8c5074fa2dde323</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;report_name)</arglist>
    </member>
    <member kind="function">
      <type>type_listPrintLayouts</type>
      <name>get_print_layout_names</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0af3dcaffe9f55d9f812a8998efed945</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_all_print_layouts</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a52c72ccc778f50cbb4eead7fcc179a11</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_print_layout</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a2afd8bdf6a5634933c2c819c3e9373a1</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const sharedptr&lt; PrintLayout &gt; &amp;print_layout)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; PrintLayout &gt;</type>
      <name>get_print_layout</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aa017f2517ee0f960c5e4e40731c131fc</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;print_layout_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_print_layout</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a375934cf55b339d500daa64ca8435f05</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;print_layout_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_layout_record_viewed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a11900053dde2eb3cd26e54e5c0f5e53f</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;layout_name, const Gnome::Gda::Value &amp;primary_key_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>forget_layout_record_viewed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a7f4be165d31a3a2a79ac48b949164d74</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_layout_record_viewed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9e5f6ebd2ea216bef094c024540ab179</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;layout_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_layout_current</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a6d2ce3a3100db68f9b901198d308cf90</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const Glib::ustring &amp;layout_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_criteria_current</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ac8fe4bdc200ddc160df1ce8c98b91af5</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const FoundSet &amp;found_set)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_layout_current</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a4c0a2e8c578cd930b67d8995783df6dc</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>FoundSet</type>
      <name>get_criteria_current</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>acd5d4b86efeb529937d481a04153a1c6</anchor>
      <arglist>(const Glib::ustring &amp;table_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_table_overview_position</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3a092c6f1683877c1ac7b488b44d156a</anchor>
      <arglist>(const Glib::ustring &amp;table_name, float &amp;x, float &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_table_overview_position</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a18f56166c46a675e0b3485f1983a6280</anchor>
      <arglist>(const Glib::ustring &amp;utable_name, float x, float y)</arglist>
    </member>
    <member kind="function">
      <type>AppState::userlevels</type>
      <name>get_userlevel</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad3647830784ebc50678b3fef30c6fedf</anchor>
      <arglist>(userLevelReason &amp;reason) const </arglist>
    </member>
    <member kind="function">
      <type>AppState::userlevels</type>
      <name>get_userlevel</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a3beaf21050dd7b8a5be28e5cac4f2690</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_userlevel</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aa6ec845cf0ea70ed218b248aeb554a4c</anchor>
      <arglist>(AppState::userlevels userlevel)</arglist>
    </member>
    <member kind="function">
      <type>type_signal_userlevel_changed</type>
      <name>signal_userlevel_changed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad862fd4a25737f6b62809ffb757909ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emit_userlevel_changed</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9bd93833eb1d8e098c6a6111a5bd2ce0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_active_layout_platform</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ab72b14ad85f8a6764fead1cd8af2bd82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_active_layout_platform</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a0a0a5ce1b3e1456628a6db90b387a5db</anchor>
      <arglist>(const Glib::ustring &amp;layout_platform=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>maemo_restrict_layouts_to_single_column</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ad0cf429bdad6ffc1339d305fc2c458d6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>build_and_get_contents</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aad09e0b498f1071f526ba441183f8a0f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static guint</type>
      <name>get_latest_known_document_format_version</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a2d3befa8dfffc3d7225fb6be4e707a40</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; TableInfo &gt;</type>
      <name>create_table_system_preferences</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a2021f4c868235bc1cc8cff04c632b436</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; TableInfo &gt;</type>
      <name>create_table_system_preferences</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a972cff1b3568d4af4f5880ec235035fa</anchor>
      <arglist>(type_vec_fields &amp;fields)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; Relationship &gt;</type>
      <name>create_relationship_system_preferences</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>ae0986afe876ac15dadb77540342c81a5</anchor>
      <arglist>(const Glib::ustring &amp;table_name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>get_relationship_is_system_properties</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a5a0d21375e7eb339463802633e1091b7</anchor>
      <arglist>(const sharedptr&lt; const Relationship &gt; &amp;relationship)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>set_node_attribute_value_as_decimal</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>a9d41a327ef64abcd6dce185f535848eb</anchor>
      <arglist>(xmlpp::Element *node, const Glib::ustring &amp;strAttributeName, guint value, guint value_default=0)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>set_node_attribute_value_as_decimal_double</name>
      <anchorfile>classGlom_1_1Document.html</anchorfile>
      <anchor>aeb749ad21a7630dc837daf7ea7f74b0d</anchor>
      <arglist>(xmlpp::Element *node, const Glib::ustring &amp;strAttributeName, double value)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::PyGlomRecord</name>
    <filename>classGlom_1_1PyGlomRecord.html</filename>
    <member kind="typedef">
      <type>std::map&lt; Glib::ustring, Gnome::Gda::Value &gt;</type>
      <name>type_map_field_values</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a2f358e49cd33fb41dda3dd7661876468</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PyGlomRecord</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a7882dc923ce7c9dbc2cbe2066ceff731</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~PyGlomRecord</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a287e1dc61b16876e068d337bae34656a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_read_only</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a4a5dc3eeb93d86d53a33d729e6338349</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_table_name</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a6a753641df3500c2925d5a358e1c94c7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>boost::python::object</type>
      <name>get_connection</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a064383e2d38cd4aec68685ec1f9d1eb6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>boost::python::object</type>
      <name>get_related</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a337d1485d6a8e05a04309e94d5f7bd70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>len</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a4391e1b2197824b9ff505bd0068ee48e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>boost::python::object</type>
      <name>getitem</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a5bcac1c2fb997179e793305282346bdd</anchor>
      <arglist>(const boost::python::object &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setitem</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a75b88e16ced471f645a5a3bc235f38c8</anchor>
      <arglist>(const boost::python::object &amp;, const boost::python::object &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fields</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a10a31fc52c2ee8c7de078ecb92ae21a6</anchor>
      <arglist>(const PyGlomRecord::type_map_field_values &amp;field_values, Document *document, const Glib::ustring &amp;table_name, const sharedptr&lt; const Field &gt; &amp;key_field, const Gnome::Gda::Value &amp;key_field_value, const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;opened_connection)</arglist>
    </member>
    <member kind="variable">
      <type>Document *</type>
      <name>m_document</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>ae95a8f22953ea3704b168ea2e39883a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Glib::ustring</type>
      <name>m_table_name</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>a434242222a25a7e91b534de29b0c61d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>type_map_field_values</type>
      <name>m_map_field_values</name>
      <anchorfile>classGlom_1_1PyGlomRecord.html</anchorfile>
      <anchor>abe89bd67e6655ec71aa0d9121ee6ef9c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::PyGlomRelated</name>
    <filename>classGlom_1_1PyGlomRelated.html</filename>
    <member kind="typedef">
      <type>std::map&lt; Glib::ustring, sharedptr&lt; Relationship &gt; &gt;</type>
      <name>type_map_relationships</name>
      <anchorfile>classGlom_1_1PyGlomRelated.html</anchorfile>
      <anchor>a91d33b25c194088802e4e6da64e30885</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PyGlomRelated</name>
      <anchorfile>classGlom_1_1PyGlomRelated.html</anchorfile>
      <anchor>ab3bcd2f87ce245e60c17100f823e2977</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~PyGlomRelated</name>
      <anchorfile>classGlom_1_1PyGlomRelated.html</anchorfile>
      <anchor>a285bbb919721c7582cc8966a3f2676cd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_relationships</name>
      <anchorfile>classGlom_1_1PyGlomRelated.html</anchorfile>
      <anchor>af581d3bac31242a06f24f0b12268d67e</anchor>
      <arglist>(const PyGlomRelated::type_map_relationships &amp;relationships)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>len</name>
      <anchorfile>classGlom_1_1PyGlomRelated.html</anchorfile>
      <anchor>a232a18d9690391c85de021bbdf6baac4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>boost::python::object</type>
      <name>getitem</name>
      <anchorfile>classGlom_1_1PyGlomRelated.html</anchorfile>
      <anchor>aafc1ce239bdd84950de0902c3e5f295d</anchor>
      <arglist>(const boost::python::object &amp;item)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::PyGlomRelatedRecord</name>
    <filename>classGlom_1_1PyGlomRelatedRecord.html</filename>
    <member kind="function">
      <type></type>
      <name>PyGlomRelatedRecord</name>
      <anchorfile>classGlom_1_1PyGlomRelatedRecord.html</anchorfile>
      <anchor>ad6b3df615e2e454c387b19a025efdce8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~PyGlomRelatedRecord</name>
      <anchorfile>classGlom_1_1PyGlomRelatedRecord.html</anchorfile>
      <anchor>a69d96b20e51ae617e05af7f77b9cf7a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_relationship</name>
      <anchorfile>classGlom_1_1PyGlomRelatedRecord.html</anchorfile>
      <anchor>af86b5573d0633f5e773f2924f5256523</anchor>
      <arglist>(const sharedptr&lt; const Relationship &gt; &amp;relationship, const Glib::ustring &amp;from_key_value_sqlized, Document *document)</arglist>
    </member>
    <member kind="function">
      <type>boost::python::object</type>
      <name>sum</name>
      <anchorfile>classGlom_1_1PyGlomRelatedRecord.html</anchorfile>
      <anchor>a2710a3838ed21b4415169d4e1bbfd50f</anchor>
      <arglist>(const std::string &amp;field_name) const </arglist>
    </member>
    <member kind="function">
      <type>boost::python::object</type>
      <name>count</name>
      <anchorfile>classGlom_1_1PyGlomRelatedRecord.html</anchorfile>
      <anchor>ace33d6d699321452ff27b37a4da1eb2f</anchor>
      <arglist>(const std::string &amp;field_name) const </arglist>
    </member>
    <member kind="function">
      <type>boost::python::object</type>
      <name>min</name>
      <anchorfile>classGlom_1_1PyGlomRelatedRecord.html</anchorfile>
      <anchor>aed6666c944e6f9ae577b06e4b639294b</anchor>
      <arglist>(const std::string &amp;field_name) const </arglist>
    </member>
    <member kind="function">
      <type>boost::python::object</type>
      <name>max</name>
      <anchorfile>classGlom_1_1PyGlomRelatedRecord.html</anchorfile>
      <anchor>aff2eebaaa1b3bb41b11894067652922c</anchor>
      <arglist>(const std::string &amp;field_name) const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>len</name>
      <anchorfile>classGlom_1_1PyGlomRelatedRecord.html</anchorfile>
      <anchor>a5208b9b585854a0b11fb2cddc4b2bc2b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>boost::python::object</type>
      <name>getitem</name>
      <anchorfile>classGlom_1_1PyGlomRelatedRecord.html</anchorfile>
      <anchor>ae80ee81f69033e49b3839a23ebf26d43</anchor>
      <arglist>(const boost::python::object &amp;item)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::PyGlomUI</name>
    <filename>classGlom_1_1PyGlomUI.html</filename>
    <member kind="function">
      <type></type>
      <name>PyGlomUI</name>
      <anchorfile>classGlom_1_1PyGlomUI.html</anchorfile>
      <anchor>a8ace20a586c6f38c4267a31c53b480ac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PyGlomUI</name>
      <anchorfile>classGlom_1_1PyGlomUI.html</anchorfile>
      <anchor>ae7d186c3e36570319c566aa37575bbd9</anchor>
      <arglist>(const PythonUICallbacks &amp;callbacks)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~PyGlomUI</name>
      <anchorfile>classGlom_1_1PyGlomUI.html</anchorfile>
      <anchor>a33124c475135bfd7aaf9dba6024a77c7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show_table_details</name>
      <anchorfile>classGlom_1_1PyGlomUI.html</anchorfile>
      <anchor>ad8ba2e467f6d8835030209a1ce28c42f</anchor>
      <arglist>(const std::string &amp;table_name, const boost::python::object &amp;primary_key_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show_table_list</name>
      <anchorfile>classGlom_1_1PyGlomUI.html</anchorfile>
      <anchor>a9f7ff56543c9d508accd0258ef772476</anchor>
      <arglist>(const std::string &amp;table_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print_layout</name>
      <anchorfile>classGlom_1_1PyGlomUI.html</anchorfile>
      <anchor>a0f9dd82adac1655d27bbdc8657583c8e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print_report</name>
      <anchorfile>classGlom_1_1PyGlomUI.html</anchorfile>
      <anchor>aad96e1a2e3c47ec08760da71faf55947</anchor>
      <arglist>(const std::string &amp;report_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start_new_record</name>
      <anchorfile>classGlom_1_1PyGlomUI.html</anchorfile>
      <anchor>aadf25bab76b824b941ad91fe7cdcbf84</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::PythonUICallbacks</name>
    <filename>classGlom_1_1PythonUICallbacks.html</filename>
    <member kind="variable">
      <type>sigc::slot&lt; void, const Glib::ustring &amp;, const Gnome::Gda::Value &amp; &gt;</type>
      <name>m_slot_show_table_details</name>
      <anchorfile>classGlom_1_1PythonUICallbacks.html</anchorfile>
      <anchor>ac0eec8966cac7b551176ae1bde751fa7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>sigc::slot&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>m_slot_show_table_list</name>
      <anchorfile>classGlom_1_1PythonUICallbacks.html</anchorfile>
      <anchor>acabd62860e991e3f495e4b4fef34ab1d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>sigc::slot&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>m_slot_print_report</name>
      <anchorfile>classGlom_1_1PythonUICallbacks.html</anchorfile>
      <anchor>a6d9d2c359a26329be1dbf2e377aad2f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>sigc::slot&lt; void &gt;</type>
      <name>m_slot_print_layout</name>
      <anchorfile>classGlom_1_1PythonUICallbacks.html</anchorfile>
      <anchor>af62fb451715347944b39c1ad5f6dc0fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>sigc::slot&lt; void &gt;</type>
      <name>m_slot_start_new_record</name>
      <anchorfile>classGlom_1_1PythonUICallbacks.html</anchorfile>
      <anchor>a5746d971a6e78f83295d1de3008234e9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::sharedptr</name>
    <filename>classGlom_1_1sharedptr.html</filename>
    <templarg>T_obj</templarg>
    <member kind="typedef">
      <type>size_t</type>
      <name>size_type</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a136c71f35df111e6f6bfa9e03e9917a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T_obj</type>
      <name>object_type</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>acb058473e72cf4f006a7a23ffbbdaf35</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a7749eb805a1a96911d3244bae89611a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a915c7a122a951ec527f04ae985112ef1</anchor>
      <arglist>(T_obj *pobj)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a7e090a36f58b2811717c25cab64cae14</anchor>
      <arglist>(T_obj *pobj, size_type *refcount)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a6102dbc1119f259160e667856633042b</anchor>
      <arglist>(const sharedptr &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a04d5ed27e0cb5ef44d49fadcfeafa928</anchor>
      <arglist>(sharedptr&lt; T_obj &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a203eb1fbaaebde12e9fa2ee7a0f3fd4c</anchor>
      <arglist>(const sharedptr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a1cdd392b3e161e02a16ca205ea54311a</anchor>
      <arglist>(const sharedptr &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>sharedptr&lt; T_obj &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a83c9e34f44f9106bab15ec7469da7809</anchor>
      <arglist>(const sharedptr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~sharedptr</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>ab4de9a1efd217faa77e39a1813c4bd0b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>af93fe9dabf864468837057cb430d6817</anchor>
      <arglist>(const sharedptr&lt; T_obj &gt; &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a107f3107052d1d026b54a7dde628cc13</anchor>
      <arglist>(const sharedptr&lt; T_obj &gt; &amp;src) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a4d421575966613b3eb0862e1d0776419</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>T_obj &amp;</type>
      <name>operator*</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>ace647214b829e740d49a7a760341ee09</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const T_obj &amp;</type>
      <name>operator*</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a249c5d4eef8f2c27c72c4b5c9807cc52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>T_obj *</type>
      <name>operator-&gt;</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a3f3e93d6c6f2f2858f54abcaf3aecdcf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a2a9e0c086b97df95d465d39d29e5467b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>ad854eea3ed6f8bff576b1323d0f458f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>T_obj *</type>
      <name>obj</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a4b254013a623c15f9040b4e26772d399</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const T_obj *</type>
      <name>obj</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a14b85493ef0d6ea82e6305050259ca84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; T_obj &gt;</type>
      <name>cast_dynamic</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>ad5d33b5025ea64781d42ac2dcfb5cf85</anchor>
      <arglist>(const sharedptr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; T_obj &gt;</type>
      <name>cast_static</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>afb08a5066123a92b73c32df6d924b702</anchor>
      <arglist>(const sharedptr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; T_obj &gt;</type>
      <name>cast_const</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>a41155a5e5f5edc47f7a211f8e33deee6</anchor>
      <arglist>(const sharedptr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sharedptr&lt; T_obj &gt;</type>
      <name>create</name>
      <anchorfile>classGlom_1_1sharedptr.html</anchorfile>
      <anchor>aeb06d0326d1404fe72a9eb9eeb8dd981</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Glom::ConnectionPoolBackends</name>
    <filename>namespaceGlom_1_1ConnectionPoolBackends.html</filename>
    <class kind="class">Glom::ConnectionPoolBackends::Backend</class>
    <class kind="class">Glom::ConnectionPoolBackends::Postgres</class>
    <class kind="class">Glom::ConnectionPoolBackends::PostgresCentralHosted</class>
    <class kind="class">Glom::ConnectionPoolBackends::PostgresSelfHosted</class>
    <class kind="class">Glom::ConnectionPoolBackends::Sqlite</class>
  </compound>
  <compound kind="class">
    <name>Glom::ConnectionPoolBackends::Backend</name>
    <filename>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</filename>
    <member kind="enumeration">
      <name>InitErrors</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>aaa0bd364eafdc89bb4a996d16994d6bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INITERROR_NONE</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>aaa0bd364eafdc89bb4a996d16994d6bca9c622203b2160e0e8ba147c397860878</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INITERROR_DIRECTORY_ALREADY_EXISTS</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>aaa0bd364eafdc89bb4a996d16994d6bcab3693634a2f48972f2d75a684a285dcb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INITERROR_COULD_NOT_CREATE_DIRECTORY</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>aaa0bd364eafdc89bb4a996d16994d6bca0b77a57b8c7ba0b6737c73375edef323</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INITERROR_COULD_NOT_START_SERVER</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>aaa0bd364eafdc89bb4a996d16994d6bca2225f96d06eec8d990cd76ad5e66ab06</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INITERROR_OTHER</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>aaa0bd364eafdc89bb4a996d16994d6bca9468337ef0b3b3b35a45d723b0d28050</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; const Field &gt; &gt;</type>
      <name>type_vec_const_fields</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>adf057b628de8af2de2657f1b613b911d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Backend</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>add1593a93ff9135071101b49cbe98ca7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>sigc::slot&lt; void &gt;</type>
      <name>SlotProgress</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>acbbc79a4ae05ec13159ec87abb306a63</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>query_execute</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a721c237a0f684e970e5498fddcc0c19d</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection, const Glib::ustring &amp;sql_query, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>set_server_operation_value</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>ad164ec0494c7ac4f7fdc4cd404e2475f</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::ServerOperation &gt; &amp;operation, const Glib::ustring &amp;path, const Glib::ustring &amp;value, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>Glib::RefPtr&lt; Gnome::Gda::ServerOperation &gt;</type>
      <name>create_server_operation</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a2687da55714cacb0548d2d66f54c3959</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::ServerProvider &gt; &amp;provider, const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection, Gnome::Gda::ServerOperationType type, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>perform_server_operation</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>afe43c77b075352bf805c7a3d969f7ccd</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::ServerProvider &gt; &amp;provider, const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection, const Glib::RefPtr&lt; Gnome::Gda::ServerOperation &gt; &amp;operation, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>begin_transaction</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a34bfcf2fe8891801e6847623454febdc</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection, const Glib::ustring &amp;name, Gnome::Gda::TransactionIsolation level, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>commit_transaction</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a156f65091149e21590762477a5833d67</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection, const Glib::ustring &amp;name, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>rollback_transaction</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a401b5cbdae9c1091fcada6fe5c0a477b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection, const Glib::ustring &amp;name, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual Field::sql_format</type>
      <name>get_sql_format</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>aacb2860e9c652c8e96b9a7acd777f35f</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual bool</type>
      <name>supports_remote_access</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>aa60366811bad363c69687bbbc56531dd</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual Glib::ustring</type>
      <name>get_string_find_operator</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a332bb75da0a86fc98334ebe8fd1ff282</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual const char *</type>
      <name>get_public_schema_name</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>ac7ff9b2e6d91fd0aad650232f120a29c</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual InitErrors</type>
      <name>initialize</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a979cedefd25274b124e7ee99979268d7</anchor>
      <arglist>(const SlotProgress &amp;slot_progress, const Glib::ustring &amp;initial_username, const Glib::ustring &amp;password, bool network_shared=false)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>startup</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a1aae9b197b1a4265ad038291865de84c</anchor>
      <arglist>(const SlotProgress &amp;slot_progress, bool network_shared=false)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>cleanup</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a99ccecf2a2154889cd10be11bbdbc931</anchor>
      <arglist>(const SlotProgress &amp;slot_progress)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>set_network_shared</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a52c86bffff6413a704dfa53ce91d3668</anchor>
      <arglist>(const SlotProgress &amp;slot_progress, bool network_shared=true)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual Glib::RefPtr&lt; Gnome::Gda::Connection &gt;</type>
      <name>connect</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>ad0145c7311661814400221f92da0d112</anchor>
      <arglist>(const Glib::ustring &amp;database, const Glib::ustring &amp;username, const Glib::ustring &amp;password, std::auto_ptr&lt; ExceptionConnection &gt; &amp;error)=0</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>add_column</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a008e5b621788c1a60e832b0fd583a07b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection, const Glib::ustring &amp;table_name, const sharedptr&lt; const Field &gt; &amp;field, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>drop_column</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a331d57ee797886e9142c1fd6ce0c937b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection, const Glib::ustring &amp;table_name, const Glib::ustring &amp;field_name, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>change_columns</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a6112aafe7ffacbd3d5b30f8ba3e79aa4</anchor>
      <arglist>(const Glib::RefPtr&lt; Gnome::Gda::Connection &gt; &amp;connection, const Glib::ustring &amp;table_name, const type_vec_const_fields &amp;old_fields, const type_vec_const_fields &amp;new_fields, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual bool</type>
      <name>create_database</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Backend.html</anchorfile>
      <anchor>a440ad48a014ac0be8d2cde10d307d988</anchor>
      <arglist>(const Glib::ustring &amp;database_name, const Glib::ustring &amp;username, const Glib::ustring &amp;password, std::auto_ptr&lt; Glib::Error &gt; &amp;error)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::ConnectionPoolBackends::Postgres</name>
    <filename>classGlom_1_1ConnectionPoolBackends_1_1Postgres.html</filename>
    <base>Glom::ConnectionPoolBackends::Backend</base>
    <member kind="function">
      <type></type>
      <name>Postgres</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Postgres.html</anchorfile>
      <anchor>a0b8255070eea80818eb74b3cfb775bf1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_postgres_server_version</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Postgres.html</anchorfile>
      <anchor>ab5564c106d2fe4ef77eeb50b4f13ad42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>check_postgres_gda_client_is_available</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Postgres.html</anchorfile>
      <anchor>a97e472b716681154250e9e5812c16cc7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>attempt_create_database</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Postgres.html</anchorfile>
      <anchor>a70802b5f293339de0b6099edfbb7e06b</anchor>
      <arglist>(const Glib::ustring &amp;database_name, const Glib::ustring &amp;host, const Glib::ustring &amp;port, const Glib::ustring &amp;username, const Glib::ustring &amp;password, std::auto_ptr&lt; Glib::Error &gt; &amp;error)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>Glib::RefPtr&lt; Gnome::Gda::Connection &gt;</type>
      <name>attempt_connect</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Postgres.html</anchorfile>
      <anchor>a6832901089ce6929cd23e96569b6838c</anchor>
      <arglist>(const Glib::ustring &amp;host, const Glib::ustring &amp;port, const Glib::ustring &amp;database, const Glib::ustring &amp;username, const Glib::ustring &amp;password, std::auto_ptr&lt; ExceptionConnection &gt; &amp;error)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::ConnectionPoolBackends::PostgresCentralHosted</name>
    <filename>classGlom_1_1ConnectionPoolBackends_1_1PostgresCentralHosted.html</filename>
    <base>Glom::ConnectionPoolBackends::Postgres</base>
    <member kind="function">
      <type></type>
      <name>PostgresCentralHosted</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresCentralHosted.html</anchorfile>
      <anchor>a9ef2b92946d18c064a5096b80eda49c2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_host</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresCentralHosted.html</anchorfile>
      <anchor>a5a0f91b8ac042d661dbf91655c68323e</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_port</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresCentralHosted.html</anchorfile>
      <anchor>a2dadbc3c04720afd5dd48bba737408bc</anchor>
      <arglist>(int port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_try_other_ports</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresCentralHosted.html</anchorfile>
      <anchor>a46f7b860b9a3a33352712e88a52afd46</anchor>
      <arglist>(bool val)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_host</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresCentralHosted.html</anchorfile>
      <anchor>a393ad1411834b06f2aa166f0827ff197</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_port</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresCentralHosted.html</anchorfile>
      <anchor>af76e889b5141ec8ebd60b7e588e2da3f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_try_other_ports</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresCentralHosted.html</anchorfile>
      <anchor>a79037417ec5781e4265d97b66d90ca38</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::ConnectionPoolBackends::PostgresSelfHosted</name>
    <filename>classGlom_1_1ConnectionPoolBackends_1_1PostgresSelfHosted.html</filename>
    <base>Glom::ConnectionPoolBackends::Postgres</base>
    <member kind="function">
      <type></type>
      <name>PostgresSelfHosted</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresSelfHosted.html</anchorfile>
      <anchor>a087515cc62351f02b1f28f97a8a34f1c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_self_hosting_data_uri</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresSelfHosted.html</anchorfile>
      <anchor>a3d59bc3613633189a9ea51c154589d79</anchor>
      <arglist>(const std::string &amp;data_uri)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_self_hosting_active</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresSelfHosted.html</anchorfile>
      <anchor>ae1e3ad621bcc41f1956051a4152371a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_port</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresSelfHosted.html</anchorfile>
      <anchor>a96ba4d924f730d87198f6b14afffd3aa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>install_postgres</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresSelfHosted.html</anchorfile>
      <anchor>a57b5e7dca20493a82c10a30b92f78686</anchor>
      <arglist>(const SlotProgress &amp;slot_progress)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>get_path_to_postgres_executable</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1PostgresSelfHosted.html</anchorfile>
      <anchor>ac4a8311a5d881974de94610be97bd92f</anchor>
      <arglist>(const std::string &amp;program)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glom::ConnectionPoolBackends::Sqlite</name>
    <filename>classGlom_1_1ConnectionPoolBackends_1_1Sqlite.html</filename>
    <base>Glom::ConnectionPoolBackends::Backend</base>
    <member kind="function">
      <type></type>
      <name>Sqlite</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Sqlite.html</anchorfile>
      <anchor>ac1f0f9a45d97805e7f53bc9b7339fcb7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_database_directory_uri</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Sqlite.html</anchorfile>
      <anchor>aa5085715e3634014b8d9831096382390</anchor>
      <arglist>(const std::string &amp;directory_uri)</arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>get_database_directory_uri</name>
      <anchorfile>classGlom_1_1ConnectionPoolBackends_1_1Sqlite.html</anchorfile>
      <anchor>a71d153c06c570d669850903a3a29e500</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Glom::Conversions</name>
    <filename>namespaceGlom_1_1Conversions.html</filename>
    <member kind="function">
      <type>int</type>
      <name>get_stringstream_precision_default</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>af1f02e7ce0812abf81a5b23b2234219a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_for_gda_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a48b6fb46196063a4f2c04a051f9a0107</anchor>
      <arglist>(Field::glom_field_type glom_type, const Gnome::Gda::Value &amp;value, const NumericFormat &amp;numeric_format=NumericFormat())</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text_for_gda_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a01aae2cbc1607de2bb918880494a9f0b</anchor>
      <arglist>(Field::glom_field_type glom_type, const Gnome::Gda::Value &amp;value, const std::locale &amp;locale, const NumericFormat &amp;numeric_format=NumericFormat(), bool iso_format=false)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_double_for_gda_value_numeric</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a033e0bf3a766f7d69b2f818205669e67</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_time</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a051b5314fe433eabf051f3c43a8f7dfc</anchor>
      <arglist>(const tm &amp;tm_data)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_time</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a6714edf75c290bd4de66af771a4b3a56</anchor>
      <arglist>(const tm &amp;tm_data, const std::locale &amp;locale, bool iso_format=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_date</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a764f1ac62953357796ada21349d8a563</anchor>
      <arglist>(const tm &amp;tm_data)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_date</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>ad865bddc0f3454b011f979abd66ee7df</anchor>
      <arglist>(const tm &amp;tm_data, const std::locale &amp;locale, bool iso_format=false)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>parse_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>aeb7a666d6bb259222cf845be878433b3</anchor>
      <arglist>(double number)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>parse_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a242567311d55e2e445389b485354ab1c</anchor>
      <arglist>(Field::glom_field_type glom_type, const Glib::ustring &amp;text, bool &amp;success, bool iso_format=false)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>parse_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a07d9613945623145e881e2037ba4c31b</anchor>
      <arglist>(Field::glom_field_type glom_type, const Glib::ustring &amp;text, const NumericFormat &amp;numeric_format, bool &amp;success, bool iso_format=false)</arglist>
    </member>
    <member kind="function">
      <type>tm</type>
      <name>parse_date</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a2e6cff95cf134f278a10d82fc0088f42</anchor>
      <arglist>(const Glib::ustring &amp;text, bool &amp;success)</arglist>
    </member>
    <member kind="function">
      <type>tm</type>
      <name>parse_date</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a0c39a1f6bd76df296d7dd8a1782c3c00</anchor>
      <arglist>(const Glib::ustring &amp;text, const std::locale &amp;locale, bool &amp;success)</arglist>
    </member>
    <member kind="function">
      <type>tm</type>
      <name>parse_time</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>ab1d9cd8f22d5f3a033f6ecad14676f70</anchor>
      <arglist>(const Glib::ustring &amp;text, bool &amp;success)</arglist>
    </member>
    <member kind="function">
      <type>tm</type>
      <name>parse_time</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a00d777f4efd24b5c43a8fe8d917f965b</anchor>
      <arglist>(const Glib::ustring &amp;text, const std::locale &amp;locale, bool &amp;success)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>sanity_check_date_parsing</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a46a1c1a6c1e5fe998d64835e7788a4b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>sanity_check_date_text_representation_uses_4_digit_years</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a66dd29fe0a9bd12ea1b12b203c95ab4d</anchor>
      <arglist>(bool debug_output=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_tm</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>afa89e12c3c63d94cb14fd2bc5a59c2b0</anchor>
      <arglist>(const tm &amp;tm_data, const std::locale &amp;locale, const char *format)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>value_is_empty</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>a2b8ded4c899f974d4bb995d5aef600b7</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_empty_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>ae75ba006d16abd95bb4fb82920bc5a54</anchor>
      <arglist>(Field::glom_field_type field_type)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>get_example_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>ababe2a34181fa01f8575f34a67184016</anchor>
      <arglist>(Field::glom_field_type field_type)</arglist>
    </member>
    <member kind="function">
      <type>Gnome::Gda::Value</type>
      <name>convert_value</name>
      <anchorfile>namespaceGlom_1_1Conversions.html</anchorfile>
      <anchor>afdb2d3c3d6db46bdd372b69f3009c6e1</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value, Field::glom_field_type target_glom_type)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Glom::Spawn</name>
    <filename>namespaceGlom_1_1Spawn.html</filename>
    <namespace>Glom::Spawn::Impl</namespace>
    <member kind="typedef">
      <type>sigc::slot&lt; void &gt;</type>
      <name>SlotProgress</name>
      <anchorfile>namespaceGlom_1_1Spawn.html</anchorfile>
      <anchor>ae667b73942b403a3806a0a81ab824db5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>execute_command_line_and_wait</name>
      <anchorfile>namespaceGlom_1_1Spawn.html</anchorfile>
      <anchor>a85b7241c8a184a1bd6292a60aee92ac0</anchor>
      <arglist>(const std::string &amp;command, const SlotProgress &amp;slot_progress)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>execute_command_line_and_wait</name>
      <anchorfile>namespaceGlom_1_1Spawn.html</anchorfile>
      <anchor>aeb64cffc10b2668cf1df860322b3c82a</anchor>
      <arglist>(const std::string &amp;command, const SlotProgress &amp;slot_progress, std::string &amp;output)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>execute_command_line_and_wait_until_second_command_returns_success</name>
      <anchorfile>namespaceGlom_1_1Spawn.html</anchorfile>
      <anchor>a7d8303d9e6e131a9d713aea271a566cd</anchor>
      <arglist>(const std::string &amp;command, const std::string &amp;second_command, const SlotProgress &amp;slot_progress, const std::string &amp;success_text=std::string())</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Glom::Spawn::Impl</name>
    <filename>namespaceGlom_1_1Spawn_1_1Impl.html</filename>
  </compound>
  <compound kind="namespace">
    <name>Glom::Utils</name>
    <filename>namespaceGlom_1_1Utils.html</filename>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; LayoutItem_Field &gt; &gt;</type>
      <name>type_vecLayoutFields</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a8f8fbf1c248f46a7142f510b9e76dbae</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; sharedptr&lt; const LayoutItem_Field &gt; &gt;</type>
      <name>type_vecConstLayoutFields</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a62d84be27491c2ba60f84bb54ed7795e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; std::pair&lt; Gnome::Gda::Value, Gnome::Gda::Value &gt; &gt;</type>
      <name>type_list_values_with_second</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ad6bdcc220a5b6d66fa8d7008fb1eedd1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>type_vec_strings</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a52b82841a1690a3a6fe86838470ec1ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>trim_whitespace</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>acc1ef56d72b6a4a34ad1411490c0bba4</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_replace</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a2e783165fbbb305496777daba446d630</anchor>
      <arglist>(const Glib::ustring &amp;src, const Glib::ustring search_for, const Glib::ustring &amp;replace_with)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>build_sql_select_fields_to_get</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ab885f0df9b5cfe317b6b3540e021d7d8</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vecConstLayoutFields &amp;fieldsToGet, const type_sort_clause &amp;sort_clause, Glib::ustring &amp;sql_part_from, Glib::ustring &amp;sql_part_leftouterjoin)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>build_sql_select_with_where_clause</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a1bc65e4aee98c56c6fbec4cd7857902b</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vecLayoutFields &amp;fieldsToGet, const Glib::ustring &amp;where_clause=Glib::ustring(), const Glib::ustring &amp;extra_join=Glib::ustring(), const type_sort_clause &amp;sort_clause=type_sort_clause(), const Glib::ustring &amp;extra_group_by=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>build_sql_select_with_where_clause</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a432ef1b6edda3652a84112c0ac516dfe</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vecConstLayoutFields &amp;fieldsToGet, const Glib::ustring &amp;where_clause=Glib::ustring(), const Glib::ustring &amp;extra_join=Glib::ustring(), const type_sort_clause &amp;sort_clause=type_sort_clause(), const Glib::ustring &amp;extra_group_by=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>build_sql_select_with_key</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a1c748e830b4b62fbff0c50cc408ab22f</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vecLayoutFields &amp;fieldsToGet, const sharedptr&lt; const Field &gt; &amp;key_field, const Gnome::Gda::Value &amp;key_value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>build_sql_select_with_key</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a3a361a37cbadea2b183947dc6bded80a</anchor>
      <arglist>(const Glib::ustring &amp;table_name, const type_vecConstLayoutFields &amp;fieldsToGet, const sharedptr&lt; const Field &gt; &amp;key_field, const Gnome::Gda::Value &amp;key_value)</arglist>
    </member>
    <member kind="function">
      <type>type_list_values_with_second</type>
      <name>get_choice_values</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>aa97ccc4a690d4d66bd7ee68541ccc194</anchor>
      <arglist>(const sharedptr&lt; const LayoutItem_Field &gt; &amp;field)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>create_name_from_title</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ace6b7b73bbbfc9a213e1d7661d83af49</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_escape_underscores</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>adc81f0ad92fcc2ca0c120067d7dfa586</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>locale_simplify</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a1eea3c7eef1c01a97e960a3ec6a6a733</anchor>
      <arglist>(const Glib::ustring &amp;locale_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>locale_language_id</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>aa44a168cd7efec82207c21fe65672e71</anchor>
      <arglist>(const Glib::ustring &amp;locale_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>create_local_image_uri</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a61dcbaa20abb7153e2f873dccfdfff85</anchor>
      <arglist>(const Gnome::Gda::Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_from_decimal</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>ada8087969d3728b1cd1d9c2513d3fc28</anchor>
      <arglist>(guint decimal)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>title_from_string</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>aaa273e5833bc375648851bc23f9bed9f</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>type_vec_strings</type>
      <name>string_separate</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a79061f32223415cbe0b9d02a1f7f9169</anchor>
      <arglist>(const Glib::ustring &amp;str, const Glib::ustring &amp;separator, bool ignore_quoted_separator=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_trim</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a837d3376b91338c742cdcb7eb3c4125c</anchor>
      <arglist>(const Glib::ustring &amp;str, const Glib::ustring &amp;to_remove)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>string_remove_suffix</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a255530113a42f6c853b09605d42b7efb</anchor>
      <arglist>(const Glib::ustring &amp;str, const Glib::ustring &amp;suffix, bool case_sensitive=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>file_exists</name>
      <anchorfile>namespaceGlom_1_1Utils.html</anchorfile>
      <anchor>a3eed787dc0ed308e80d95a8f4819d582</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>GlomBakery</name>
    <filename>namespaceGlomBakery.html</filename>
    <class kind="class">GlomBakery::Document</class>
    <class kind="class">GlomBakery::Document_XML</class>
    <class kind="class">GlomBakery::View</class>
    <class kind="class">GlomBakery::View_Composite</class>
    <class kind="class">GlomBakery::ViewBase</class>
    <member kind="variable">
      <type>const guint</type>
      <name>BYTES_TO_PROCESS</name>
      <anchorfile>namespaceGlomBakery.html</anchorfile>
      <anchor>ac33f0bdb5bd51f7c32463d2e92164790</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GlomBakery::Document</name>
    <filename>classGlomBakery_1_1Document.html</filename>
    <member kind="enumeration">
      <name>LoadFailureCodes</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aee1b6b5a8d4686c9bfc169d9a75bdc53</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LOAD_FAILURE_CODE_NONE</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aee1b6b5a8d4686c9bfc169d9a75bdc53a1cab8645581656f92574a3c98519b653</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LOAD_FAILURE_CODE_NOT_FOUND</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aee1b6b5a8d4686c9bfc169d9a75bdc53abb44f06404dbf86bbccdcb50a679a3be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LOAD_FAILURE_CODE_LAST</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aee1b6b5a8d4686c9bfc169d9a75bdc53ad4109c4886aa5ac52a48e740acb54e5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::signal&lt; void, bool &gt;</type>
      <name>type_signal_modified</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a3338f8ada621546f631e871e9bcae2f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::signal&lt; void &gt;</type>
      <name>type_signal_forget</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a8247a2739645ca2398e35f6037f3dcfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Document</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a7021d383cf7160ac5a393c257bbae2a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Document</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a686862e07913522b19e5baee86bccc9d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>save</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a5d8543c7cbf31acdd6778c8444037e2d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a6bdd515846e4e047a44daa54b38ce9aa</anchor>
      <arglist>(int &amp;failure_code)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_from_data</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>ad639db1aebeb7a2db2d50c9f6ee0a159</anchor>
      <arglist>(const guchar *data, std::size_t length, int &amp;failure_code)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_modified</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a7d0fa388f9dc3011c4e6e806ade550e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_modified</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a766aa11624f6feca1d158f34d3e539c2</anchor>
      <arglist>(bool bVal=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_new</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>af1a8d6f2c8eaf55ba0ee5e7968ba0c9a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_new</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a76c8b9c6ecc0e191e3f85cf7f39a8376</anchor>
      <arglist>(bool bVal)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_contents</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a896bf57ee143517b22cf56308ff8bd4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_contents</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>af988c7c9d3c8dc8aa942d14d5ef3ec5b</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_file_uri_with_extension</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a50e355f3c5e974071cd8bf0223ff1802</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_file_uri</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a5fff07fdeaae76a4ed2dad64579fda59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_file_uri</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aa8a033e6f6f6058716382f20c3060dc6</anchor>
      <arglist>(const Glib::ustring &amp;file_uri, bool bEnforceFileExtension=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>abfa009a6836faac1792142758de4c667</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_read_only</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a69e0b06ad7a5c095b2549d5ea8689f11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_read_only</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>aca92138301a2be9318ec5f3ceb01d5d3</anchor>
      <arglist>(bool bVal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_view</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a5ab97a539e9daccd3dc30eb1af0239c4</anchor>
      <arglist>(ViewBase *pView)</arglist>
    </member>
    <member kind="function">
      <type>ViewBase *</type>
      <name>get_view</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a5cce52a96e87728578b1cfb55f3cd666</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_file_extension</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>ad487e0619d41cb27d757a94f211ba516</anchor>
      <arglist>(const Glib::ustring &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_file_extension</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>adea9e4e177278e9a65245cbcad0c94b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>type_signal_modified &amp;</type>
      <name>signal_modified</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a5d4cb81f8eccea75cca822fbf28f639a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>type_signal_forget &amp;</type>
      <name>signal_forget</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>afb3b630418970ff6effe87d1f33d3b84</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>util_file_uri_get_name</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a0904f206bce062d94dafafc90b970624</anchor>
      <arglist>(const Glib::ustring &amp;file_uri, const Glib::ustring &amp;file_extension)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>load_after</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a4112a39cefd69634701416c3b4211198</anchor>
      <arglist>(int &amp;failure_code)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>save_before</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a51b0a01db186cb0a541f0b13e034c9ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>read_from_disk</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a47de195a88290d2ca8547899ab53432d</anchor>
      <arglist>(int &amp;failure_code)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>write_to_disk</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a613b6457c155ed3678eb5de98c4b3360</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ustring</type>
      <name>m_strContents</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a09071125e90b766828eaa1be07455412</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ustring</type>
      <name>m_file_uri</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a992fbbb6c4bedf0564333234bd5009b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ustring</type>
      <name>m_file_extension</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a03baa3e84f21e9ac4820d78dc28fe076</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ViewBase *</type>
      <name>m_pView</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>adff3979feb69cc4b4d7631322b3b098a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>type_signal_modified</type>
      <name>signal_modified_</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a8c2cb147672f6b9612b8d4d1f5dedeaf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>type_signal_forget</type>
      <name>signal_forget_</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a98b58ec93a7909f7f70bf0037c2f7360</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_bModified</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a490873f3f13b3c0b95c45fb6b8a653dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_bIsNew</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>ab184cb795e5528f3b919b3b138b6f39d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_bReadOnly</name>
      <anchorfile>classGlomBakery_1_1Document.html</anchorfile>
      <anchor>a9e413c2d465c6f8b235ec4cf374c17b6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GlomBakery::Document_XML</name>
    <filename>classGlomBakery_1_1Document__XML.html</filename>
    <base>GlomBakery::Document</base>
    <member kind="function">
      <type></type>
      <name>Document_XML</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a92f6aff28272abe41b6aa14545660243</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Document_XML</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a1e60e696ac8f35be5493957fc5c556ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>load_after</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a729e9316738147dad2ce78f355578a90</anchor>
      <arglist>(int &amp;failure_code)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>save_before</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a83532011a430c0abc35a62e0fd11df0b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dtd_name</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a7cb117b1444954eadc60dcce2e3fd5ef</anchor>
      <arglist>(const std::string &amp;strVal)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_dtd_name</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>af1c479c9f64f2ad904ad4fe171b1e2cf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dtd_root_node_name</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a499c9b565a3054c7e1e57edd922bce2e</anchor>
      <arglist>(const Glib::ustring &amp;strVal, const Glib::ustring &amp;xmlns=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_dtd_root_node_name</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a6ed81009e4168b32867bf992aee16985</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_write_formatted</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>ad451c73b28acce6bb33ed539285f7a42</anchor>
      <arglist>(bool formatted=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_indenting_white_space</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>af8ef363dddab833dd67d8f1893009dbc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_xml</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a9177675711233855590b478c95c3767d</anchor>
      <arglist>(const Glib::ustring &amp;strXML)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_xml</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a8b57b63ee4c42d33fee05397599d6462</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>GlomBakery::Document</type>
      <name>type_base</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>aa3ae223391c3b157f24c09d91ee01bfe</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected">
      <type>const xmlpp::Element *</type>
      <name>get_node_document</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>ae418d0637bbdfd24d1a078f9181aff36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>xmlpp::Element *</type>
      <name>get_node_document</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>aad3b136a0c372603fe2d7f886226427d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>Util_DOM_Write</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>aedadf61425d76ea986d40c282768d0d8</anchor>
      <arglist>(Glib::ustring &amp;refstrXML) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>add_indenting_white_space_to_node</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>af7de2985683f5539cea5d9fa0fe4d75d</anchor>
      <arglist>(xmlpp::Node *node=0, const Glib::ustring &amp;start_indent=Glib::ustring())</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static Glib::ustring</type>
      <name>get_node_attribute_value</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a1c99601f2f6a950801cf80c98835390c</anchor>
      <arglist>(const xmlpp::Element *node, const Glib::ustring &amp;strAttributeName)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>set_node_attribute_value</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>ac7d4387863fcc3f19598a2a48fed64ca</anchor>
      <arglist>(xmlpp::Element *node, const Glib::ustring &amp;strAttributeName, const Glib::ustring &amp;strValue)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static xmlpp::Element *</type>
      <name>get_node_child_named</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a6d9d75daa906ce654bbe2a819a0f7d3f</anchor>
      <arglist>(const xmlpp::Element *node, const Glib::ustring &amp;strName)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static xmlpp::Element *</type>
      <name>get_node_child_named_with_add</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>af9a26c0a772e41217c6e15c0531571cb</anchor>
      <arglist>(xmlpp::Element *node, const Glib::ustring &amp;strName)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>xmlpp::DomParser</type>
      <name>m_DOM_Parser</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a600b6538863c6d22cc6027d0d2dbd20a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>xmlpp::Document *</type>
      <name>m_pDOM_Document</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>aa690187c9bae2055901a3576b4e228ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>m_strDTD_Name</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a690c6dbe1564e23d58b382e78eb82333</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ustring</type>
      <name>m_strRootNodeName</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a48baedb0ab2139019adee963cb0a04e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ustring</type>
      <name>m_root_xmlns</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>ae0796cbd8cf5584a028a418ae324eedb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_write_formatted</name>
      <anchorfile>classGlomBakery_1_1Document__XML.html</anchorfile>
      <anchor>a0de7e441b660c1aeb00a0de754925601</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GlomBakery::View</name>
    <filename>classGlomBakery_1_1View.html</filename>
    <templarg></templarg>
    <base>GlomBakery::ViewBase</base>
    <member kind="typedef">
      <type>View&lt; T_Document &gt;</type>
      <name>type_self</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>ab1b595773be83ad108df574b5d9297df</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>View</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>afed624fec48619fb1b374609c9160a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~View</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>a7feea682734afc980f69fe0507badd7c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual T_Document *</type>
      <name>get_document</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>a2507e30b994c4a49c47119639e195811</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const T_Document *</type>
      <name>get_document</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>aad8d8742b3ca8cb5e0dd000e23bcc84b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_document</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>a8f5a68a501f9af2e7fc6cc18c8c2a6d0</anchor>
      <arglist>(T_Document *pDocument)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_modified</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>ae885ea7e7fdd5fd477f8a0ed974660f0</anchor>
      <arglist>(bool val=true)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>on_document_forget</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>afc7d8dfe849f5358acf1be53fd130c3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>T_Document *</type>
      <name>m_pDocument</name>
      <anchorfile>classGlomBakery_1_1View.html</anchorfile>
      <anchor>a8f82380a65a1f1fb1625913b4a9e2b5e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GlomBakery::View_Composite</name>
    <filename>classGlomBakery_1_1View__Composite.html</filename>
    <templarg></templarg>
    <base>GlomBakery::View</base>
    <member kind="typedef">
      <type>View&lt; T_Document &gt;</type>
      <name>type_view</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>a3c886ba14fb8e9e4471f5328cae5421e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>View_Composite</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>aa4341ec5946d3b8c5b00ddae0fe83b47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~View_Composite</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>af86e0f7d8844e70c100d10401fadbc34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>add_view</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>a266321969053523ba8e1613ede9896a1</anchor>
      <arglist>(type_view *pView)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_view</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>aee997e9bf84fc72e37c01797f9ec0244</anchor>
      <arglist>(type_view *pView)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_document</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>a43be3e59014edafd8f91f632bad8f806</anchor>
      <arglist>(T_Document *pDocument)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>load_from_document</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>ab66293fd7ac7926b158c1d8b9c2b9034</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>save_to_document</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>a0afd143dd3d2384226745fcc2e6e42ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>std::vector&lt; type_view * &gt;</type>
      <name>type_vec_views</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>a6e5a4a09f5716106fbb62c0c412560b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>type_vec_views</type>
      <name>m_vecViews</name>
      <anchorfile>classGlomBakery_1_1View__Composite.html</anchorfile>
      <anchor>ac81060a8eb58e1776d1ecefe96227a2d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GlomBakery::ViewBase</name>
    <filename>classGlomBakery_1_1ViewBase.html</filename>
    <base virtualness="virtual">sigc::trackable</base>
    <member kind="function">
      <type></type>
      <name>ViewBase</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>a7948afa22bc7a7769bb049f23dddc3bc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ViewBase</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>a0e74f356e88e89ef3d915629bcdfa65c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>load_from_document</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>a24fb415bdc962757796168302e0ca227</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>save_to_document</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>ad7c1848c7ae24fbfd574082ed041c792</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clipboard_copy</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>ad35c38b86e3f9b227b1d024ca1f63e34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clipboard_paste</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>a3a0fa189691ae109117c2e98179d41d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clipboard_clear</name>
      <anchorfile>classGlomBakery_1_1ViewBase.html</anchorfile>
      <anchor>a9945a619d0cecfc35d46efa7cc623e16</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Gtk</name>
    <filename>namespaceGtk.html</filename>
  </compound>
</tagfile>
