# Note that this is NOT a relocatable package
%define ver      1.0.52
%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix   /usr

Summary: The core programs for the GNOME GUI desktop environment.
Name: gnome-core
Version: %ver
Release: %rel
Copyright: LGPL
Group: System Environment/Libraries
Source: ftp://ftp.gnome.org/pub/sources/gnome-core/gnome-core-%{ver}.tar.gz
BuildRoot: /var/tmp/gnome-core-root
Obsoletes: gnome

URL: http://www.gnome.org
Prereq: /sbin/install-info
Docdir: %{prefix}/doc

Requires: xscreensaver
Requires: gnome-libs >= 1.0.0
Requires: ORBit >= 0.4.0

%description
GNOME (GNU Network Object Model Environment) is a user-friendly
set of applications and desktop tools to be used in conjunction with a
window manager for the X Window System.  GNOME is similar in purpose and
scope to CDE and KDE, but GNOME is based completely on Open Source
software.  The gnome-core package includes the basic programs and
libraries that are needed to install GNOME.

You should install the gnome-core package if you would like to use the
GNOME desktop environment.  You'll also need to install the gnome-libs
package.  If you would like to develop GNOME applications, you'll also
need to install gnome-libs-devel.  If you want to use linuxconf with a
GNOME front end, you'll also need to install the gnome-linuxconf package.

%package devel
Summary: GNOME core libraries, includes and more.
Group: Development/Libraries
Requires: gnome-core
PreReq: /sbin/install-info

%description devel
Panel libraries and header files for creating GNOME panels.

%changelog

* Sat Nov 21 1998 Pablo Saratxaga <srtxg@chanae.alphanet.ch>

- Cleaned %files section
- added spanish and french translations for rpm

* Wed Sep 23 1998 Michael Fulbright <msf@redhat.com>

- Built 0.30 release

* Fri Mar 13 1998 Marc Ewing <marc@redhat.com>

- Integrate into gnome-core CVS source tree

%prep
%setup

%build
# Needed for snapshot releases.
%ifarch alpha
  MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif
MYCFLAGS="$RPM_OPT_FLAGS"

if [ ! -f configure ]; then
  CFLAGS="$MYCFLAGS" ./autogen.sh $MYARCH_FLAGS --prefix=%prefix --localstatedir=/var/lib --sysconfdir=/etc
else
  CFLAGS="$MYCFLAGS" ./configure $MYARCH_FLAGS --prefix=%prefix --localstatedir=/var/lib --sysconfdir=/etc
fi

if [ "$SMP" != "" ]; then
  make -j$SMP "MAKE=make -j$SMP"
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make sysconfdir=$RPM_BUILD_ROOT/etc prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%{prefix}/bin/*
%{prefix}/lib/lib*.so.*
%{prefix}/share/applets
%{prefix}/share/gnome/help
%{prefix}/share/gnome/apps
%{prefix}/share/idl
%{prefix}/share/mc/templates
%{prefix}/share/locale/*/*/*
%{prefix}/share/pixmaps/*
%{prefix}/share/xmodmap/*
%config /etc/*
%config %{prefix}/share/panelrc
%config %{prefix}/share/gnome/default.session
%config %{prefix}/share/gnome/default.wm
# These are in gnome-core because the shared-library applets need the .so files around
%{prefix}/lib/lib*.so

%files devel
%defattr(-, root, root)

%{prefix}/lib/*.sh
%{prefix}/lib/*a
%{prefix}/include/*
