/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_recordset_h__
#define __gda_recordset_h__ 1

#include <glib.h>
#include <orb/orbit.h>

#include "gda.h"
#include "gda-field.h"

/* Data Structures and Prototypes for the Gnome DB Access Client
 * Library
 */

/* The recordset object. Holds the result from executing a
 * command object. Buffering and updateing data is done thrugh these
 * objects. 
 */


#define GDA_RECORDSET_INVALID_POSITION 0xffffffff

struct _Gda_Command;

typedef struct _Gda_Recordset
{
  struct _Gda_Command*    cmd;
  CORBA_Object            corba_rs;
  CORBA_ORB               orb;
  GList*                  chunks;
  gint                    chunks_length;
  GDA_Row*                current_row;
  gulong                  current_index;
  gint                    bof;
  gint                    eof;
  gint                    maxrows;
  gint                    cachesize;
  gint                    open;
  gint                    readonly;
  gint                    forwardonly;
}Gda_Recordset;


Gda_Recordset*       gda_recordset_new         (void);
void                 gda_recordset_free        (Gda_Recordset* rs);
void                 gda_recordset_close       (Gda_Recordset* rs);
GDA_Field*           gda_recordset_field_name  (Gda_Recordset* rs, gchar* name);
GDA_Field*           gda_recordset_field_idx   (Gda_Recordset* rs, gint   idx);
gint                 gda_recordset_bof         (Gda_Recordset* rs);
gint                 gda_recordset_eof         (Gda_Recordset* rs);
gulong               gda_recordset_move        (Gda_Recordset* rs, gint count, gpointer bookmark);
gulong               gda_recordset_move_first  (Gda_Recordset* rs);
gulong               gda_recordset_move_last   (Gda_Recordset* rs);
gulong               gda_recordset_move_next   (Gda_Recordset* rs);
gulong               gda_recordset_move_prev   (Gda_Recordset* rs);
gint                 gda_recordset_rowsize     (Gda_Recordset* rs);
#endif
