/* GNOME DB
 * Copyright (C) 1998 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GNOMEDBTYPES_H__
#define __GNOMEDBTYPES_H__

#include <glib.h>

typedef enum
{
  GDCN_ACT_UNSPECIFIED,
  GDCN_ACT_CHAOS,
  GDCN_ACT_BROWSE,
  GDCN_ACT_READ_UNCOMMITED,
  GDCN_ACT_READ_COMMITED,
  GDCN_ACT_READ_REPEATED,
  GDCN_ACT_READ_SERIALIZABLE
}GDCN_ISOLATION_LEVEL;
  
typedef enum
{
  GDNC_PERM_UNKNOWN,
  GDCN_PERM_READ,
  GDCN_PERM_WRITE,
  GDCN_PERM_RW,
  GDCN_PERM_DENY_READ,
  GDCN_PERM_DENY_WRITE,
  GDCN_PERM_EXCLUSIVE
}GDCN_PERM;

#define   GDA_ARRAY 0x80000000

typedef enum
{
  GDA_NULL  = 0,
  GDA_BIGINT,
  GDA_BINARY,
  GDA_BOOLEAN,
  GDA_BSTR,
  GDA_CHAR,
  GDA_CURRENCY,
  GDA_DATE,
  GDA_DBDATE,
  GDA_DBTIME,
  GDA_DBTIMESTAMP,
  GDA_DECIMAL,
  GDA_DOUBLE,
  GDA_ERROR,
  GDA_INTEGER,
  GDA_LONGVARBIN,
  GDA_LONGVARCHAR,
  GDA_LONGVARWCHAR,
  GDA_NUMERIC,
  GDA_SINGLE,
  GDA_SMALLINT,
  GDA_TINYINT,
  GDA_UBIGINT,
  GDA_UINT,
  GDA_USINT,
  GDA_VARBIN,
  GDA_VARWCHAR,
  GDA_WCHAR,
  GDA_LAST
} GDA_TYPETAG;

typedef enum
{
  GDC_USE_CLIENT,
  GDC_USE_SERVER
}GDC_CURSOR_LOCATION;

typedef enum
{
  GDC_OPEN_FWDONLY,
  GDC_OPEN_KEYSET,
  GDC_OPEN_DYNAMIC,
  GDC_OPEN_STATIC
}GDC_TYPE;


typedef enum
{
  GDR_OPTION_ADD_NEW,
  GDR_OPTION_APPROX_POS,
  GDR_OPTION_BOOKMARK,
  GDR_OPTION_DELETE,
  GDR_OPTION_HOLD_RECS,
  GDR_OPTION_MOVE_PREV,
  GDR_OPTION_RESYNC,
  GDR_OPTION_UPDATE,
  GDR_OPTION_UPDATE_BATCH
} GDR_OPTION;


typedef enum
{
  GDR_EDIT_NONE,
  GDR_EDITED,
  GDR_EDIT_ADD
}GDR_EDITMODE;



typedef enum
{
  GDC_LOCK_READONLY,
  GDC_LOCK_PESSIMISTIC,
  GDC_LOCK_OPTIMISTIC,
  GDC_LOCK_BATCH
}GDC_LOCKTYPE;
  

typedef enum
{
  GDC_CMD_TEXT,
  GDC_CMD_TABLE,
  GDC_CMD_PROC,
  GC_CMD_UNKNOWN,
}GDC_CMDTYPE;

typedef enum
{
  GDR_OK,
  GDR_NEW,
  GDR_MODIFIED,
  GDR_DELETED,
  GDR_UNMODIFIED,
  GDR_INVALID,
  GDR_MULTIPLE_CHANGES,
  GDR_PENDING_CHANGES,
  GDR_CANCELED,
  GDR_CANT_RELEASE,
  GDR_CONCURRENCY_VIOLATION,
  GDR_INTEGRITY_VIOLATION,
  GDR_MAX_CHANGES_EXCEEDED,
  GDR_OBJECT_OPEN,
  GDR_OOM,
  GDR_EPERM,
  GDR_SCHEMA_VIOLATION,
  GDR_DB_DELTED
} GDR_STATUS;

typedef enum
{
  GDR_AFFECT_CURRENT,
  GDR_AFFECT_GROUP,
  GDR_AFFECT_ALL
} GDR_AFFECT;

typedef enum
{
  GDR_BOOKMARK_CURRENT,
  GDR_BOOKMARK_FIRST,
  GDR_BOOKMARK_LAST
}GDR_BOOKMARK;



typedef enum
{
  GDB_PRAM_IN,
  GDB_PRAM_OUT,
  GDB_PRAM_INOUT,
  GDB_PRAM_RETVAL
}GDA_PRAM_DIRECTION;

#define GDR_MARSHALLING_ALL      0x1
#define GDR_MARSHALLING_MODIFIED 0x2

#define GDA_STMT_SQL     0x1
#define GDA_STMT_TABLE   0x2
#define GDA_STMT_PROC    0x4
#define GDA_STMT_UNKNOWN 0x0

typedef struct _DATE_STRUCT
{
  gshort year;
  gulong month;
  gulong day;
}DATE_STRUCT;

typedef struct _TIME_STRUCT
{
  gushort hour;
  gushort minute;
  gushort second;
} TIME_STRUCT;

typedef struct _TIMESTAMP_STRUCT
{
  gshort  year;
  gushort month;
  gushort day;
  gushort hour;
  gushort minute;
  gushort second;
  gushort fraction;
} TIMESTAMP_STRUCT;




struct _Gda_Connection;
struct _Gda_Command;
struct _Gda_Value;

typedef struct _Gda_Value
{
  gulong              tag;
  union
  {
    gdouble           v_double;
    gfloat            v_float;
    gulong            v_ulong;
    glong             v_long;
    gshort            v_short;
    gushort           v_ushort;
    void*             v_ptr;
    DATE_STRUCT       v_date;
    TIME_STRUCT       v_time;
    TIMESTAMP_STRUCT  v_tstamp;
  }v;
} Gda_Value;

typedef struct _Gda_Recordset
{
  struct _Gda_Command*  cmd;
  gint                  auto_cmd;
  GList*                fields;
  GHashTable*           fields_by_name;
  gint                  at_begin;
  gint                  at_end;
  gulong                pos;
  void*                 bookmark;
  glong                 cache_size;
  GDC_CURSOR_LOCATION   cursor_location;
  GDC_TYPE              cursor_type;
  void*                 filter;
  GDC_LOCKTYPE          locking;
  gint                  marshalling;
  glong                 max_rowcount;
  glong                 rowposition;
  glong                 rowcount;
  gchar*                table;
  gchar*                query;
  gchar*                procedure;
  gint                  open;
}Gda_Recordset;


typedef struct _Gda_Connection
{
  gulong               attributes;
  gulong               cmd_timeout;
  gchar*               cnct_string;
  gulong               cnct_timeout;
  GDC_CURSOR_LOCATION  cursor_location;
  gchar*               default_db;
  GDCN_ISOLATION_LEVEL isolation;
  GDCN_PERM            permission;
  gchar*               provider;
  gint                 open;
  gchar*               version;
  GList*               errors;
  GList*               commands;
  GList*               recsets;
  /*  HSTMT                tables_hstmt;*/
}Gda_Connection;

typedef struct _Gda_Command
{
  struct _Gda_Connection*      cnc;
  gchar*                       cmd;
  gint                         prepare;
  gint                         cmdTimeout;
  gchar*                       name;
  gint                         state;
  GList*                       recsets;
}Gda_Command;


typedef struct _Gda_Parameter
{
  gulong                  attributes;
  GDA_PRAM_DIRECTION      direction;
  gchar*                  name;
  guchar                  numeric_scale;
  guchar                  precission;
  glong                   size;
  Gda_Value               value;
} Gda_Parameter;

typedef struct _Gda_Field
{
  gchar*           name;
  gshort           ll_type;
  gshort           c_type;
  gshort           nullable;
  Gda_Value   	   value;
  guchar           precission;
  gshort           num_scale;
  glong            defined_length;
  glong            actual_length;
  gint             malloced;
} Gda_Field;

typedef struct _Gda_TypeInfo
{
  gchar*         type_name;
  glong          precission;
  gchar*         lit_prefix;
  gchar*         lit_suffix;
  gchar*         create_params;
  gshort         min_scale;
  gshort         max_scale;
  gshort         auto_inc;
  gshort         money;
  gshort         unsig;
  gchar*         local_type;
}Gda_TypeInfo;

typedef struct _Gda_Coldesc
{
  gchar*       name;
  gint         odbc_data_type;
  gchar*       type_name;
  gint         precision;
  gint         length;
  gint         scale;
  gint         radix;
  gint         nullable;
  gchar*       remarks;
}Gda_Coldesc;


typedef struct _Gda_Error
{
  gchar*         description;
  glong          number;
  gchar*         source;
  gchar*         helpfile;
  gchar*         helpctxt;
  gchar*         sqlstate;
  gchar*         native;
}Gda_Error;

#endif
