/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-mysql-types.h"

#include "gda-mysql-error.h"

Gda_MYSQL_Error*
gda_mysql_error_new(void)
{
  Gda_MYSQL_Error* e = g_new0(Gda_MYSQL_Error, 1);
  return e;
}

void
gda_mysql_error_free(Gda_MYSQL_Error* e)
{
  if (e->description)
    g_free(e->description);
  if (e->source)
    g_free(e->source);
  if (e->sqlstate)
    g_free(e->sqlstate);
  if (e->native)
    g_free(e->native);
  g_free(e);
}

      
		    
