#include <orb/orbit.h>
#include "gda-types.h"
#include "gda.h"

PortableServer_ServantBase__epv base_epv = {
  NULL,
  NULL,
  NULL
};

GDA_Connection
gda_ConnectionFactory_create(PortableServer_Servant _obj,CORBA_Environment* ev);

POA_GDA_ConnectionFactory__epv poa_gda_connectionfactory__epv = {
  NULL,
  gda_ConnectionFactory_create,
};

  

POA_GDA_ConnectionFactory__vepv poa_gda_connectionfactory__vepv =
{
  &base_epv,
  &poa_gda_connectionfactory__epv
};


POA_GDA_ConnectionFactory poa_gda_connectionfactory =
{
  NULL,
  &poa_gda_connectionfactory__vepv
};



typedef struct
{
  POA_GDA_ConnectionFactory base;
  PortableServer_POA        poa;
} GDAConnectionFactory_Servant;




CORBA_long    gda_Connection_close        (PortableServer_Servant _obj, CORBA_Environment* env);
CORBA_long    gda_Connection_open         (PortableServer_Servant _obj,
					   const CORBA_char* dsn,
					   const CORBA_char* user,
					   const CORBA_char* passwd,
					   CORBA_Environment* env);
GDA_Recordset gda_Connection_openSchema   (PortableServer_Servant _obj,
					   const GDA_Connection_QType t,
					   const GDA_Connection_ConstraintSeq* constraints,
					   CORBA_Environment * ev);
GDA_Command   gda_Connection_createCommand(PortableServer_Servant _obj, CORBA_Environment* ev);
GDA_Connection_DSNlist* gda_Connection_listSources(PortableServer_Servant _obj, CORBA_Environment* ev);

POA_GDA_Connection__epv poa_gda_connection__epv = {
  NULL,				/* private */
  (gpointer)1,				/* get_flags */
  (gpointer)2,				/* set_flags */
  (gpointer)3,				/* get_cmdTimeout */
  (gpointer)4,				/* set_cmdTimeout */
  (gpointer)5,				/* get_ConnectTimeout */
  (gpointer)6,				/* set_ConnectTimeout */
  (gpointer)7,				/* get_dsn */
  (gpointer)8,				/* get_cursor */
  (gpointer)9,				/* set_cursor */
  (gpointer)10,				/* get_default_dsn */
  (gpointer)11,				/* set_default_dsn */
  (gpointer)12,				/* get_provider */
  (gpointer)13,				/* get_isOpen */
  (gpointer)14,                         /* set_isOpen */
  (gpointer)15,				/* get_version */
  (gpointer)16,				/* get_errors */
  (gpointer)17,				/* set_errors */
  (gpointer)18,				/* begin Transaction */
  (gpointer)19,				/* commit Transaction */
  (gpointer)20,				/* rollback Transaction */
  gda_Connection_close,			/* close */
  (gpointer)22,				/* execute */
  gda_Connection_open,		        /* open */
  gda_Connection_openSchema, 	        /* openSchema */
  gda_Connection_createCommand,         /* createCommand */
  gda_Connection_listSources            /* listSources */
};


POA_GDA_Connection__vepv poa_gda_connection__vepv =
{
  &base_epv,
  &poa_gda_connection__epv
};

POA_GDA_Connection poa_gda_connection =
{
  NULL,
  &poa_gda_connection__vepv
};


typedef struct
{
  POA_GDA_Connection  base;
  PortableServer_POA  poa;
  Gda_ODBC_Connection*     cnc;
} GDAConnection_Servant;


GDA_Recordset     gda_Command_execute (PortableServer_Servant _obj,
				       const CORBA_char* cmd,
				       CORBA_long* affected,
				       const GDA_CmdParameterSeq* params,
				       const CORBA_long options,
				       CORBA_Environment* ev);


POA_GDA_Command__epv poa_gda_command__epv = {
  NULL,				/* private */
  (gpointer)1,			/* get_cmd_timeout */
  (gpointer)2,			/* set_cmd_timeout */
  (gpointer)3,			/* get_prepared */
  (gpointer)4,			/* get_state */
  (gpointer)5,			/* set_state */
  &gda_Command_execute,		/* execute */
};

POA_GDA_Command__vepv poa_gda_command__vepv =
{
  &base_epv,
  &poa_gda_command__epv
};


POA_GDA_Command poa_gda_command =
{
  NULL,
  &poa_gda_command__vepv
};

typedef struct
{
  POA_GDA_Command    base;
  PortableServer_POA poa;
  Gda_ODBC_Command*  cmd;
}GDACommand_Servant;

static GDA_Recordset_Chunk* gda_Recset_fetch(PortableServer_Servant recset, CORBA_long count,  CORBA_Environment* ev);

POA_GDA_Recordset__epv poa_gda_recordset__epv = {
  NULL,				/* void *_private */
  (gpointer)1,				/* get_myConnection */
  (gpointer)2,				/* set_myConnection */
  (gpointer)3,				/* get_bof */
  (gpointer)4,                            /* get_eof */
  (gpointer)5,                            /* get_currentBookmark */
  (gpointer)6,                            /* set_currentBookmark */
  (gpointer)7,                            /* get_cachesize */
  (gpointer)8,				/* set_cachesize */
  (gpointer)9,				/* get_cursorLoc */
  (gpointer)10,				/* set_cursorLoc */
  (gpointer)11,                           /* get_currentCursorType */
  (gpointer)12,                           /* set_currentCursorType */
  (gpointer)13,				/* get_lockingMode */
  (gpointer)14,				/* set_lockingMode */
  (gpointer)15,				/* get_marshalling */
  (gpointer)16,                           /* set_marshalling */
  (gpointer)17,				/* get_maxrecords */
  (gpointer)18,				/* set_maxrecords */
  (gpointer)19,				/* get_pagecount */
  (gpointer)20,				/* get_pagesize */
  (gpointer)21,				/* set_pagesize */
  (gpointer)22,				/* get_recCount */
  (gpointer)23,				/* get_source */
  (gpointer)24,				/* get_isOpen */
  (gpointer)25,				/* get_status */
  (gpointer)27,				/* addNew */
  (gpointer)28,				/* cancelBatch */
  (gpointer)29,				/* cancelUpdate */
  (gpointer)30,				/* close */
  (gpointer)31,				/* deleteCurrent */
  (gpointer)32,				/* move */
  (gpointer)33,				/* moveFirst */
  (gpointer)34,				/* moveLast */
  (gpointer)35,				/* moveNext */
  (gpointer)36,				/* movePrev */
  (gpointer)37,				/* open */
  (gpointer)38,				/* reQuery */
  (gpointer)39,				/* reSync */
  (gpointer)40,				/* supports */
  (gpointer)41,				/* update */
  (gpointer)42,				/* updateBatch */
  (gpointer)43,		                /* itemIdx */
  (gpointer)44,			        /* itemName */
  (gpointer)43,				/* dump */
  gda_Recset_fetch,		        /* fetch */
};

POA_GDA_Recordset__vepv poa_gda_recordset__vepv =
{
  &base_epv,
  &poa_gda_recordset__epv
};

POA_GDA_Recordset poa_gda_recordset =
{
  NULL,
  &poa_gda_recordset__vepv
};

typedef struct
{
  POA_GDA_Recordset     base;
  PortableServer_POA    poa;
  Gda_ODBC_Recordset*   recset;
}GDARecordset_Servant;





POA_GDA_Fieldx__epv poa_gda_fieldx__epv = {
  NULL,
  (gpointer)1,			/* appendChunk */
  (gpointer)2			/* getChunk */
};

POA_GDA_Fieldx__vepv poa_gda_fieldx__vepv =
{
  &base_epv,
  &poa_gda_fieldx__epv
};

POA_GDA_Fieldx poa_gda_fieldx =
{
  NULL,
  &poa_gda_fieldx__vepv
};

typedef struct
{
  POA_GDA_Fieldx      base;
  PortableServer_POA poa;
  Gda_ODBC_Field*    field;
}GDAFieldx_Servant;

