/* GNOME DB
 * Copyright (C) 1998 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GNOMEDBTYPES_H__
#define __GNOMEDBTYPES_H__ 1

#include "odbc.h"
#include "gda.h"

typedef struct _Gda_ODBC_Recordset
{
  struct _Gda_ODBC_Command*  cmd;
  gint                  auto_cmd;
  gint                  at_begin;
  gint                  at_end;
  gulong                pos;
  GList*                fields;
  HSTMT                 hstmt;
}Gda_ODBC_Recordset;


typedef struct _Gda_ODBC_Connection
{
  GList*               recsets;
  GList*               commands;
  gulong               cmd_timeout;
  GList*               errors;
  HENV                 henv;
  HDBC                 hdbc;
}Gda_ODBC_Connection;

typedef struct _Gda_ODBC_Command
{
  struct _Gda_ODBC_Connection* cnc;
  gchar*                       cmd;
  gint                         prepare;
  gint                         cmdTimeout;
  gchar*                       name;
  gint                         state;
  GList*                       recsets;
}Gda_ODBC_Command;


typedef struct _Gda_ODBC_Parameter
{
  gulong                  attributes;
  /*  GDA_PRAM_DIRECTION      direction;*/
  gchar*                  name;
  guchar                  numeric_scale;
  guchar                  precission;
  glong                   size;
  GDA_Value               value;
} Gda_ODBC_Parameter;

typedef struct _Gda_ODBC_Field
{
  gchar*           name;
  gshort           sql_type;
  gshort           c_type;
  gshort           nullable;
  GDA_Value*  	   value;
  guchar           precission;
  gshort           num_scale;
  glong            defined_length;
  glong            actual_length;
  gint             malloced;
} Gda_ODBC_Field;



typedef struct _Gda_ODBC_Error
{
  gchar*         description;
  glong          number;
  gchar*         source;
  gchar*         helpfile;
  gchar*         helpctxt;
  gchar*         sqlstate;
  gchar*         native;
}Gda_ODBC_Error;

#endif
