/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome.h>
#include <gda.h>

#include "gda-field.h"



#define ENUM_TO_STR(e) case (e): strncpy(bfr, #e, length); break
#define min(a,b)       (a) < (b) ? (a) : (b)

/**
 * gda_fieldtype_2_string:
 * @bfr: bufferspace where the printed name of the type of the field
 * is placed into.
 * @length: the size of the buffer
 * @f: a pointer to the field.
 *
 * Returns: a pointer to the buffer.
 */

gchar* 
gda_fieldtype_2_string(gchar* bfr, gint length, GDA_Field* f)
{
  if (!bfr)
    {
      bfr = g_new0(gchar, 20);
      length = 20;
    }
  switch (f->gdaType)
    {
      ENUM_TO_STR(GDA_TypeNull);
      ENUM_TO_STR(GDA_TypeBigint);
      ENUM_TO_STR(GDA_TypeBinary);
      ENUM_TO_STR(GDA_TypeBoolean);
      ENUM_TO_STR(GDA_TypeBstr);
      ENUM_TO_STR(GDA_TypeChar);
      ENUM_TO_STR(GDA_TypeCurrency);
      ENUM_TO_STR(GDA_TypeDate);
      ENUM_TO_STR(GDA_TypeDbDate);
      ENUM_TO_STR(GDA_TypeDbTime);
      ENUM_TO_STR(GDA_TypeDbTimestamp);
      ENUM_TO_STR(GDA_TypeDecimal);
      ENUM_TO_STR(GDA_TypeDouble);
      ENUM_TO_STR(GDA_TypeError);
      ENUM_TO_STR(GDA_TypeInteger);
      ENUM_TO_STR(GDA_TypeLongvarbin);
      ENUM_TO_STR(GDA_TypeLongvarchar);
      ENUM_TO_STR(GDA_TypeLongvarwchar);
      ENUM_TO_STR(GDA_TypeNumeric);
      ENUM_TO_STR(GDA_TypeSingle);
      ENUM_TO_STR(GDA_TypeSmallint);
      ENUM_TO_STR(GDA_TypeTinyint);
      ENUM_TO_STR(GDA_TypeUBigint);
      ENUM_TO_STR(GDA_TypeUSmallint);
      ENUM_TO_STR(GDA_TypeVarchar);
      ENUM_TO_STR(GDA_TypeVarbin);
      ENUM_TO_STR(GDA_TypeVarwchar);
      ENUM_TO_STR(GDA_TypeFixchar);
      ENUM_TO_STR(GDA_TypeFixbin);
      ENUM_TO_STR(GDA_TypeFixwchar);
    }
  return bfr;
}


gchar*
gda_stringify_value(gchar* bfr, gint maxlen, GDA_Field* f)
{
  gchar*     retval = 0;
  
  if (bfr)
    retval = bfr;

  if (GDA_FIELD_ISNULL(f))
    return g_strdup(_("<NULL>"));

  switch (f->gdaType)
    {
    case GDA_TypeNull:
      if (bfr)
	retval = strncpy(bfr, _("<Unknown GDA Type(NULL)>"), maxlen);
      else
	retval = g_strdup(_("<Unknown GDA Type(NULL)>"));
      break;
    case GDA_TypeBigint:
      if (!bfr)
	{
	  retval = g_new0(gchar,20);
	  maxlen = 20;
	}
      g_snprintf(retval, maxlen, "%Ld", GDA_FIELD_BIGINT(f));
      break;
    case GDA_TypeBoolean:
      {
	gchar* retstr;
	if (GDA_FIELD_BOOLEAN(f))
	  retstr = _("TRUE");
	else
	  retstr = _("FALSE");
	if (bfr)
	  retval = strncpy(bfr, retstr, maxlen);
	else
	  retval = g_strdup(retstr);
      }
      break;
    case GDA_TypeLongvarchar:
    case GDA_TypeVarchar:
      if (!bfr)
	{
	  retval = g_strdup(f->realValue._u.v._u.lvc);
	}
      else
	{
	  strncpy(retval, f->realValue._u.v._u.lvc,
		  min(maxlen, strlen(f->realValue._u.v._u.lvc)));
	  retval[min(maxlen, strlen(f->realValue._u.v._u.lvc))] = '\0';
	}
      break;
    case GDA_TypeInteger:
    case GDA_TypeSmallint:
      if (!bfr)
	{
	  retval = g_new0(gchar, 20);
	  maxlen = 20;
	}
      g_snprintf(retval, maxlen, "%d", f->realValue._u.v._u.si);
      break;
    case GDA_TypeChar:
      if (!bfr)
	retval = g_strdup(f->realValue._u.v._u.lvc);
      else
	{
	  strncpy(retval, f->realValue._u.v._u.lvc,
		  min(maxlen, strlen(f->realValue._u.v._u.lvc)));
	  retval[min(maxlen, strlen(f->realValue._u.v._u.lvc))] = '\0';
	}
      break;
    case GDA_TypeBinary:
    case GDA_TypeBstr:
    case GDA_TypeCurrency:
    case GDA_TypeDate:
    case GDA_TypeDbDate:
    case GDA_TypeDbTime:
    case GDA_TypeDbTimestamp:
    case GDA_TypeDecimal:
    case GDA_TypeDouble:
    case GDA_TypeError:
    case GDA_TypeLongvarbin:
    case GDA_TypeLongvarwchar:
    case GDA_TypeNumeric:
    case GDA_TypeSingle:
      
    case GDA_TypeTinyint:
    case GDA_TypeUBigint:
    case GDA_TypeUSmallint:
    case GDA_TypeVarbin:
    case GDA_TypeVarwchar:
    case GDA_TypeFixchar:
    case GDA_TypeFixbin:
    case GDA_TypeFixwchar:
      if (!bfr)
	{
	  retval = g_new0(gchar, 128);
	  maxlen = 128;
	}
      printf("stringify for valuetype [%d]'%s' NYI\n",
	     f->gdaType, gda_fieldtype_2_string(0, 20, f));
      retval[0] = '\0';
      break;
    }
  return retval;
}

      
