/* GNOME DB
 * Copyright (C) 1998 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __GDA_RECSET_H__
#define __GDA_RECSET_H__

#include <glib.h>


#include "gda-types.h"
#include "gda-connection.h"

Gda_ODBC_Recordset*   gda_odbc_recset_new         (void);
void                  gda_odbc_recset_free        (Gda_ODBC_Recordset*);

gint                  gda_odbc_recset_close       (Gda_ODBC_Recordset* rs);
gint                  gda_odbc_recset_move_next   (Gda_ODBC_Recordset* rs);
gint                  gda_odbc_recset_move_prev   (Gda_ODBC_Recordset* rs);
/*
  Development & Debugging
*/
void                  gda_odbc_recset_dump        (Gda_ODBC_Recordset* rs);
						     

/*
 Internal utilities
*/
Gda_ODBC_Recordset*           gda_odbc_init_recset_for_hstmt    (Gda_ODBC_Recordset* rec, Gda_ODBC_Error* e);

#endif
