/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* header files */
#include "gsqlfe.h"

/* global variables */
GnomeClient *glb_SessionClient = NULL;

/* private functions */
static void
load_sql_commands (void)
{
  register gint cnt;
  /* just read from config files and call sql_store_command() */
  for (cnt = 0; cnt < MAX_COMMAND_LIST; cnt++)
    {
      gchar *path = g_strdup_printf("/gnome-sql/SQL/Command%d", cnt + 1);
      gchar *sql_command = gnome_config_get_string(path);
      if (sql_command != NULL)
	sql_store_command((const gchar *) sql_command);
      g_free((gpointer) path);
    }
}

static void
save_sql_commands (void)
{
  register gint cnt = 0;
  extern GList *l_last_commands; /* defined in sql.c */
  GList *node = g_list_first(l_last_commands);
  while (node != NULL)
    {
      gchar *path = g_strdup_printf("/gnome-sql/SQL/Command%d", cnt + 1);
      gnome_config_set_string(path, (gchar *) node->data);
      cnt++;
      node = g_list_next(node);
    }
}

/* application settings */
void
app_load_settings (void)
{
  load_sql_commands();
}

void
app_save_settings (GtkWidget *w, gpointer data)
{
  save_sql_commands();
}

/* Session management stuff */
static gint
die_session_cb (GnomeClient *client, gpointer client_data)
{
  gtk_exit(0);
  return (FALSE);
}

static gint
save_yourself_cb (GnomeClient *client, gint phase, 
	       GnomeRestartStyle restart_style,
	       gint shutdown,
	       GnomeInteractStyle interact_style,
	       gint fast, gpointer client_data)
{
  /* app_save_settings ignore parameters, but be polite */
  app_save_settings(GTK_WIDGET(client), NULL);
  return (TRUE);
}

void
app_init_gnome_session (void)
{
  glb_SessionClient = gnome_master_client();
  gtk_signal_connect(GTK_OBJECT(glb_SessionClient), "save_yourself",
		     GTK_SIGNAL_FUNC(save_yourself_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(glb_SessionClient), "die",
  		     GTK_SIGNAL_FUNC(die_session_cb), NULL);
}





