/* GNOME DB
 * Copyright (C) 1998 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <memory.h>

#include "gda-mysql-field.h"
#include "gda-mysql-command.h"
#include "gda-mysql-recset.h"
#include "gda-mysql-error.h"
#include "gda-mysql-connection.h"

static guint
string_hash (gconstpointer v)
{
  register gchar *c;
  register guint h;
  
  h = 0;
  for (c = (gchar*)v; *c; c++)
    {
      register guint g;
      
      h = (h << 4) + *c;
      g = h & 0xf0000000;
      if (g)
	{
	  h = h ^ (g >> 24);
	  h = h ^ g;
	}
    }
  
  return h;
}

static gint
string_compare(gconstpointer s1, gconstpointer s2)
{
  return !strcmp(s1, s2);
}

Gda_MYSQL_Command*
gda_mysql_cmd_new()
{
  Gda_MYSQL_Command* rc = g_new0(Gda_MYSQL_Command, 1);
  return rc;
}


void
gda_mysql_cmd_free(Gda_MYSQL_Command* cmd)
{
  g_free(cmd);
	
}



Gda_MYSQL_Connection*
gda_mysql_cmd_set_connection(Gda_MYSQL_Command* cmd,
			     Gda_MYSQL_Connection* cnc)
{
  Gda_MYSQL_Connection* old_cnc;

  old_cnc = cmd->cnc;
  cmd->cnc = cnc;
  return old_cnc;
  
}


  
Gda_MYSQL_Recordset*
gda_mysql_cmd_execute(Gda_MYSQL_Command* cmd, gulong options)
{
  gint                 rc;
  Gda_MYSQL_Recordset* recset;
  gint                 fieldidx;
  gint                 max_fieldidx;
  
  fprintf(stderr,"gda_mysql_cmd_execute called\n");
  fprintf(stderr,"gda_mysql_cmd_execute: cmd = '%p'\n", cmd);
  fprintf(stderr,"gda_mysql_cmd_execute: cmd->cmd = '%s'\n", cmd->cmd);
  fprintf(stderr,"gda_mysql_cmd_execute: cmd->cnc = %p\n", cmd->cnc);
  fprintf(stderr,"*** Calling mysql_real_query\n");
  rc = mysql_real_query(cmd->cnc->mysql, cmd->cmd, strlen(cmd->cmd));
  if (rc != 0)
    {
      fprintf(stderr,"gda_cmd_execute: rc = %d\n", rc);
      fprintf(stderr,"                 mysql errno = %d\n",  mysql_errno(cmd->cnc->mysql));
      fprintf(stderr,"                 mysql errmsg = '%s'\n", mysql_error(cmd->cnc->mysql));
      return 0;
    }
  recset = gda_mysql_recset_new();
  recset->mysql = cmd->cnc->mysql;
  recset->mysql_res = mysql_store_result(cmd->cnc->mysql);
  max_fieldidx = mysql_num_fields(recset->mysql_res);
  fprintf(stderr,"gda_cmd_execute: dumping field information\n");
  for (fieldidx = 0; fieldidx < max_fieldidx; fieldidx++)
    {
      MYSQL_FIELD* field;
      Gda_MYSQL_Field* server_field;
      
      field = &mysql_fetch_field_direct(recset->mysql_res, fieldidx);
      fprintf(stderr,"   field %d: name   = '%s'\n", fieldidx, field->name);
      fprintf(stderr,"             table  = '%s'\n", field->table);
      fprintf(stderr,"             def    = '%s'\n", field->def);
      fprintf(stderr,"             type   = %d\n", field->type);
      fprintf(stderr,"             length = %d\n", field->length);
      fprintf(stderr,"             maxlen = %d\n", field->max_length);
      fprintf(stderr,"             flags  = 0x%08x\n", field->flags);
      fprintf(stderr,"             decimls= %d\n", field->decimals);
      server_field = gda_mysql_field_new();
      server_field->name = g_strdup(field->name);
      server_field->def = field->def ? g_strdup(field->def) : 0;
      server_field->native_type = field->type;
      server_field->decimals = field->decimals;
      server_field->flags = field->flags;
      recset->fields = g_list_append(recset->fields, server_field);
    }
  return recset;
}
