#include <gmodule.h>
#include <orb/orbit.h>
#include <libgnorba/gnorba.h>

CORBA_Object connection_factory__create  (PortableServer_POA poa,   gpointer *impl_ptr,  CORBA_Environment *ev);
void         connection_factory__destroy (PortableServer_POA poa,   gpointer impl_ptr,   CORBA_Environment *ev);

static CORBA_Object create_factory (PortableServer_POA poa, const gchar* goad_id, const gchar** params,
				    gpointer* impl_ptr, CORBA_Environment* ev);
static void         destroy_factory(PortableServer_POA poa, const gchar* goad_id, gpointer impl_ptr,
				    CORBA_Environment* ev);


static const gchar* repo_id = "IDL:gda/connection_factory:1.0";



static CORBA_Object create_factory(PortableServer_POA poa, const gchar* goad_id, const gchar** params, gpointer*
				   impl_ptr, CORBA_Environment* ev)
{
  return connection_factory__create(poa, impl_ptr, ev);
}

static void destroy_factory(PortableServer_POA poa, const gchar* goad_id, gpointer impl_ptr, CORBA_Environment* ev)
{
  connection_factory__destroy (poa, impl_ptr, ev);
}


GnomePluginObject gda_odbc_plugin[] = {
  {&repo_id,
   "gda-odbc",
   "object",
   "GDA ODBC Server",
   create_factory,
   destroy_factory},
  {NULL,
   NULL,
   NULL,
   NULL,
   NULL,
   NULL}
};


GnomePlugin GNOME_Plugin_info = {
  &gda_odbc_plugin[0],
  "GDA ODBC Server"};


G_MODULE_EXPORT gchar*
g_module_check_init(GModule* module)
{
  fprintf(stderr,"gda-odbc: g_module_check_init called\n");
  fprintf(stderr,"gda-odbc: Loading iodbc lib.....");
  if (!g_module_open("libiodbc.so", 0))
    {
      fprintf(stderr,"failed with '%s'\n", g_module_error());
    }
  else
    {
      fprintf(stderr,"succeed\n");
    }
  return NULL;
}
