/* GNOME-DB
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_POSTGRES_TYPES_H__
#  define __GDA_POSTGRES_TYPES_H__

#include <glib.h>
#include <libpq-fe.h>
#include "gda-common.h"
#include "gda.h"

typedef struct _Gda_POSTGRES_Connection
{
  gchar  *pq_host;
  gchar  *pq_port;
  gchar  *pq_options;
  gchar  *pq_tty;
  gchar  *pq_db;
  gchar  *pq_login;
  gchar  *pq_pwd;
  PGconn *pq_conn;
  GList  *errors;
} Gda_POSTGRES_Connection;

typedef struct _Gda_POSTGRES_Command
{
  struct _Gda_POSTGRES_Connection* cnc;
  gchar*                           cmd;
  PGresult*                        pq_data;
} Gda_POSTGRES_Command;

typedef struct _Gda_POSTGRES_Recordset
{
  struct _Gda_POSTGRES_Command *cmd;
  gint                          at_begin;
  gint                          at_end;
  gulong                        pos;
  GList*                        fields;
} Gda_POSTGRES_Recordset;

typedef struct _Gda_POSTGRES_Field
{
  gchar*           name;
  gshort           sql_type;
  gshort           c_type;
  gshort           nullable;
  GDA_Value*  	   value;
  guchar           precission;
  gshort           num_scale;
  glong            defined_length;
  glong            actual_length;
  gint             malloced;
} Gda_POSTGRES_Field;

typedef struct _Gda_POSTGRES_Error
{
  gchar*         description;
  glong          number;
  gchar*         source;
  gchar*         helpfile;
  gchar*         helpctxt;
  gchar*         sqlstate;
  gchar*         native;
} Gda_POSTGRES_Error;

#endif
