/* Sample Rolodex Application
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gnome_recset_h__
#define __gnome_recset_h__ 1

#include <gtk/gtk.h>
#include <gda/gda-recordset.h>

#define GNOMERECSET(obj)         GTK_CHECK_CAST(obj, gnome_recset_get_type(), GnomeRecset)
#define GNOMERECSET_CLASS(klass) GTK_CHECK_CLASS_CAST(klass, gnome_recset_get_type(), GnomeRecsetClass)
#define IS_GNOMERECSET(obj)      GTK_CHECK_TYPE(obj, gnome_recset_get_type())

typedef struct _GnomeRecset       GnomeRecset;
typedef struct _GnomeRecsetClass  GnomeRecsetClass;

struct _GnomeRecset
{
  GtkAdjustment  object;
  Gda_Recordset* recset;
  guint          current_pos;
};

struct _GnomeRecsetClass
{
  GtkAdjustmentClass  parent_class;
  void (*eof)         (GnomeRecset* rs);
  void (*bof)         (GnomeRecset* rs);
  void (*first)       (GnomeRecset* first);
  void (*last)        (GnomeRecset* last);
  void (*move)        (GnomeRecset* move, gint count);
};

guint             gnome_recset_get_type (void);
GtkObject*        gnome_recset_new      (Gda_Recordset* rs);
#endif

