/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* header files */
#include "gsqlfe.h"

/* function prototypes */
static void designer_new (GtkWidget *, gpointer );
static void designer_open (GtkWidget *, gpointer );

/* global variables */
extern GList     *l_connections;		/* defined in db.c */
extern gint       l_openconns;			/* defined in db.c */
static gboolean   l_isopen = FALSE;
static GtkWidget *l_tab = NULL;
static GtkWidget *l_toolbar = NULL;
static GtkWidget *l_tree = NULL;
static GtkWidget *l_box = NULL;
static GnomeUIInfo designertoolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("New"), N_("Start with a new database design"),
    designer_new, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Open"), N_("Load a design from disk"),
    designer_open, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close this window"),
    designer_close_window, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};
static struct GSQLFE_DesignerObjectInfo
{
  gchar     *type;
  GtkWidget *subtree;
} l_objects[] =
{
  { "Tables", NULL },
  { NULL, NULL }
};

/* private functions */
static void
designer_new (GtkWidget *w, gpointer data)
{
}

static void
designer_open (GtkWidget *w, gpointer data)
{
}

static void
tree_selection_changed_cb (GtkWidget *tree)
{
  g_print("clicked!!!");
}

/* open the database designer */
GnomeUIInfo treepopupmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Save"), N_("Save design to disk"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_SAVE, 0, 0, NULL },
  GNOMEUIINFO_END
};

void
designer_open_window (GtkWidget *w, gpointer data)
{
  register gint cnt;
  GtkWidget *popup_menu;
  if (!l_isopen)
    {
      l_tab = gtk_table_new(3, 4, FALSE);
      gtk_widget_show(l_tab);
      gtk_notebook_append_page(GTK_NOTEBOOK(ui_get_work_area()), l_tab,
                               gtk_label_new("Database Designer"));
      l_toolbar = ui_new_toolbar_in_table(l_tab, 0, 0, 4, 1);
      gnome_app_fill_toolbar(GTK_TOOLBAR(l_toolbar), designertoolbar, NULL);
      /* create children */
      l_tree = ui_new_tree_in_table(l_tab, 0, 1, 1, 3);
      gtk_signal_connect(GTK_OBJECT(l_tree), "selection_changed",
			 GTK_SIGNAL_FUNC(tree_selection_changed_cb), NULL);
      popup_menu = ui_new_popup_menu(l_tree, &treepopupmenu, NULL);
      /* fill tree widget */
      for (cnt = 0; l_objects[cnt].type != NULL; cnt++)
	{
	  l_objects[cnt].subtree = ui_tree_new_subtree(GTK_TREE(l_tree), 
						       l_objects[cnt].type);
	}
      l_box = gtk_vbox_new(FALSE, 3);
      gtk_table_attach(GTK_TABLE(l_tab), l_box, 1, 4, 1, 3,
		       GTK_FILL | GTK_EXPAND | GTK_SHRINK,
		       GTK_FILL | GTK_EXPAND | GTK_SHRINK,
		       3, 3);
      gtk_widget_show(l_box);
      /* initialize data */
      l_isopen = TRUE;
      l_openconns++;
    }
  /* activate the window */
  ui_set_notebook_page(GTK_NOTEBOOK(ui_get_work_area()), l_tab);
}

/* close the database designer */
void
designer_close_window (GtkWidget *w, gpointer data)
{
  if (l_isopen)
    {
      gint current = gtk_notebook_page_num(GTK_NOTEBOOK(ui_get_work_area()),
					   l_tab);
      gtk_notebook_remove_page(GTK_NOTEBOOK(ui_get_work_area()), current);
      l_openconns--;
      l_isopen = FALSE;
    }
}
