/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_entries_h__
#define __gda_enties_h__ 1

#include "gda-server.h"

typedef struct _Gdamgr_ProviderInfo
{
  Gda_Server* server_info;
  GList*      entries;
  gint        expanded;
  gint        selected;
}Gdamgr_ProviderInfo;

typedef struct _Gdamgr_EntryInfo
{
  gchar*               gda_name;
  gchar*               dsn;
  gchar*               description;
  gchar*               configurator;
  Gdamgr_ProviderInfo* provider;
  gint                 expanded;
  gint                 selected;
}Gdamgr_EntryInfo;

typedef enum {ProviderNode, EntryNode} Gdamgr_Nodetype;

typedef struct _Gdamgr_NodeInfo
{
  Gdamgr_Nodetype ntype;
  gpointer        node;
}Gdamgr_NodeInfo;

void                gdamgr_provider_remove        (Gdamgr_ProviderInfo* provider);

void                gdamgr_entry_free             (Gdamgr_EntryInfo* entry);
void                gdamgr_entry_remove           (Gdamgr_EntryInfo* entry);


gint                gdamgr_build_gda_info          (void);
void                gdamgr_refresh_provider_tree  (GtkWidget* tree);
Gdamgr_NodeInfo*    gdamgr_get_selected_node      (void);
gint                gdamgr_store_gda_info         (void);


void                new_provider_cmd              (void);
void                new_datasource_cmd            (void);
void                save_cmd                      (void);
void                quit_cmd                      (void);
void                delete_cmd                    (void);
void                accept_entry_changes          (GtkWidget* button, gpointer data);
void                accept_provider_changes       (GtkWidget* button, gpointer data);

#endif
