/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_MYSQL_CONNECTION_H__
#define __GDA_MYSQL_CONNECTION_H__ 1

#include "gda-mysql-types.h"

typedef enum
{
  GDCN_SCHEMA_ASSERTS = 0,
  GDCN_SCHEMA_CATALOGS,
  GDCN_SCHEMA_CHARSETS,
  GDCN_SCHEMA_CHECK_CONSTRAINTS,
  GDCN_SCHEMA_COLLATIONS,
  GDCN_SCHEMA_COL_DOM_USAGE,
  GDCN_SCHEMA_COL_PRIVS,
  GDCN_SCHEMA_COLS,
  GDCN_SCHEMA_CONSTR_COL_USAGE,
  GDCN_SCHEMA_CONSTR_TAB_USAGE,
  GDCN_SCHEMA_FOREIGN_KEYS,
  GDCN_SCHEMA_INDEXES,
  GDCN_SCHEMA_KEY_COL_USAGE,
  GDCN_SCHEMA_PRIM_KEYS,
  GDCN_SCHEMA_PROC_COLUMNS,
  GDCN_SCHEMA_PROC_PARAMS,
  GDCN_SCHEMA_PROCS,
  GDCN_SCHEMA_PROV_SPEC,
  GDCN_SCHEMA_PROV_TYPES,
  GDCN_SCHEMA_REF_CONSTRAINTS,
  GDCN_SCHEMA_SQL_LANG,
  GDCN_SCHEMA_STATISTICS,
  GDCN_SCHEMA_TAB_CONSTRAINTS,
  GDCN_SCHEMA_TAB_PRIVS,
  GDCN_SCHEMA_TABLES,
  GDCN_SCHEMA_TRANSLATIONS,
  GDCN_SCHEMA_USAGE_PROVS,
  GDCN_SCHEMA_VIEW_COL_USAGE,
  GDCN_SCHEMA_VIEW_TAB_USAGE,
  GDCN_SCHEMA_VIEWS,
  GDNC_SCHEMA_LAST
}GDA_SCHEMA_QTYPE;


Gda_MYSQL_Connection*       gda_mysql_connection_new(void);
gint                        gda_mysql_connection_open(Gda_MYSQL_Connection* cnc,
						      const gchar* dsn,
						      const gchar* user,
						      const gchar* passwd);
						     
gint                        gda_mysql_connection_close(Gda_MYSQL_Connection* cnc);

Gda_MYSQL_Recordset*        gda_mysql_connection_open_schema(Gda_MYSQL_Connection*      cnc,
							     Gda_MYSQL_Error*           e,
							     GDA_Connection_QType       t,
							     GDA_Connection_Constraint* constraints,
							     gint                       length);
#endif



