/* GNOME-DB
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-postgres-types.h"

Gda_POSTGRES_Error *
gda_postgres_error_new (void)
{
  Gda_POSTGRES_Error *e = g_new0(Gda_POSTGRES_Error, 1);
  return (e);
}

void
gda_postgres_error_free (Gda_POSTGRES_Error *e)
{
  if (e->description)
    g_free(e->description);
  if (e->source)
    g_free(e->source);
  if (e->helpfile)
    g_free(e->helpfile);
  if (e->helpctxt)
    g_free(e->helpctxt);
  if (e->sqlstate)
    g_free(e->sqlstate);
  if (e->native)
    g_free(e->native);
  g_free(e);
}

void
gda_postgres_error_make (Gda_POSTGRES_Error *error, Gda_POSTGRES_Recordset *recset,
                         Gda_POSTGRES_Connection *cnc, gchar *where)
{
  gchar *err_msg = PQerrorMessage(cnc->pq_conn);
  fprintf(stderr, "Error at '%s': ", where);
  error->description = g_strdup(err_msg);
  fprintf(stderr, "error->description = '%s'\n", err_msg);
  error->source      = g_strdup("gda-postgres");
  error->helpfile    = 0;
  error->helpctxt    = 0;
  error->sqlstate    = 0;
  error->native      = 0;
  cnc->errors = g_list_append(cnc->errors, error);
}
