#include <gnome.h>

#include "gda.h"
#include "gda-postgres-types.h"
#include "gda-postgres-connection.h"
#include "gda-postgres-error.h"
#include "gda-postgres-command.h"
#include "gda-postgres-recset.h"

/*** App-specific servant structures ***/

typedef struct {
   POA_GNOME_GenericFactory servant;
   PortableServer_POA poa;

} impl_POA_GNOME_GenericFactory;

typedef struct {
   POA_GDA_Fieldx servant;
   PortableServer_POA poa;

} impl_POA_GDA_Fieldx;

typedef struct {
   POA_GDA_Parameter servant;
   PortableServer_POA poa;

} impl_POA_GDA_Parameter;

typedef struct {
   POA_GDA_Command servant;
   PortableServer_POA poa;
   CORBA_long attr_cmdTimeout;

   CORBA_boolean attr_prepared;

   CORBA_long attr_state;
   Gda_POSTGRES_Command* cmd;
} impl_POA_GDA_Command;

typedef struct {
   POA_GDA_Connection servant;
   PortableServer_POA poa;

   CORBA_long attr_flags;

   CORBA_long attr_cmdTimeout;

   CORBA_long attr_connectTimeout;

   GDA_CursorLocation attr_cursor;

   CORBA_char *attr_version;

   GDA_ErrorSeq attr_errors;
  Gda_POSTGRES_Connection* cnc;
} impl_POA_GDA_Connection;

typedef struct {
   POA_GDA_Recordset servant;
   PortableServer_POA poa;

   CORBA_long attr_currentBookmark;

   CORBA_long attr_cachesize;

   GDA_CursorType attr_currentCursorType;

   GDA_LockType attr_lockingMode;

   CORBA_long attr_maxrecords;

   CORBA_long attr_pagecount;

   CORBA_long attr_pagesize;

   CORBA_long attr_recCount;

   CORBA_char *attr_source;

   CORBA_long attr_status;
  Gda_POSTGRES_Recordset* recset;
} impl_POA_GDA_Recordset;

typedef struct {
   POA_GDA_ConnectionFactory servant;
   PortableServer_POA poa;

} impl_POA_GDA_ConnectionFactory;

/*** Implementation stub prototypes ***/

static void impl_GNOME_GenericFactory__destroy(impl_POA_GNOME_GenericFactory * servant,
					       CORBA_Environment * ev);

CORBA_boolean
impl_GNOME_GenericFactory_supports(impl_POA_GNOME_GenericFactory * servant,
				   CORBA_char * obj_goad_id,
				   CORBA_Environment * ev);

CORBA_Object
impl_GNOME_GenericFactory_create_object(impl_POA_GNOME_GenericFactory * servant,
					CORBA_char * goad_id,
					GNOME_stringlist * params,
					CORBA_Environment * ev);

static void impl_GDA_Fieldx__destroy(impl_POA_GDA_Fieldx * servant,
				     CORBA_Environment * ev);

CORBA_long
impl_GDA_Fieldx_appendChunk(impl_POA_GDA_Fieldx * servant,
			    GDA_VarBinString * data,
			    CORBA_Environment * ev);

GDA_VarBinString *
 impl_GDA_Fieldx_getChunk(impl_POA_GDA_Fieldx * servant,
			  CORBA_long amount,
			  CORBA_Environment * ev);

static void impl_GDA_Parameter__destroy(impl_POA_GDA_Parameter * servant,
					CORBA_Environment * ev);

CORBA_long
impl_GDA_Parameter_appendChunk(impl_POA_GDA_Parameter * servant,
			       GDA_Parameter_VarBinString * data,
			       CORBA_Environment * ev);

static void impl_GDA_Command__destroy(impl_POA_GDA_Command * servant,
				      CORBA_Environment * ev);

CORBA_long
impl_GDA_Command__get_cmdTimeout(impl_POA_GDA_Command * servant,
				 CORBA_Environment * ev);
void
 impl_GDA_Command__set_cmdTimeout(impl_POA_GDA_Command * servant,
				  CORBA_long value,
				  CORBA_Environment * ev);

CORBA_boolean
impl_GDA_Command__get_prepared(impl_POA_GDA_Command * servant,
			       CORBA_Environment * ev);

CORBA_long
impl_GDA_Command__get_state(impl_POA_GDA_Command * servant,
			    CORBA_Environment * ev);
void
 impl_GDA_Command__set_state(impl_POA_GDA_Command * servant,
			     CORBA_long value,
			     CORBA_Environment * ev);

GDA_Recordset
impl_GDA_Command_execute(impl_POA_GDA_Command * servant,
			 CORBA_char * cmd,
			 CORBA_long * affected,
			 GDA_CmdParameterSeq * params,
			 CORBA_long options,
			 CORBA_Environment * ev);

static void impl_GDA_Connection__destroy(impl_POA_GDA_Connection * servant,
					 CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection__get_flags(impl_POA_GDA_Connection * servant,
			       CORBA_Environment * ev);
void
 impl_GDA_Connection__set_flags(impl_POA_GDA_Connection * servant,
				CORBA_long value,
				CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection__get_cmdTimeout(impl_POA_GDA_Connection * servant,
				    CORBA_Environment * ev);
void
 impl_GDA_Connection__set_cmdTimeout(impl_POA_GDA_Connection * servant,
				     CORBA_long value,
				     CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection__get_connectTimeout(impl_POA_GDA_Connection * servant,
					CORBA_Environment * ev);
void
 impl_GDA_Connection__set_connectTimeout(impl_POA_GDA_Connection * servant,
					 CORBA_long value,
					 CORBA_Environment * ev);

GDA_CursorLocation
impl_GDA_Connection__get_cursor(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev);
void
 impl_GDA_Connection__set_cursor(impl_POA_GDA_Connection * servant,
				 GDA_CursorLocation value,
				 CORBA_Environment * ev);

CORBA_char *
 impl_GDA_Connection__get_version(impl_POA_GDA_Connection * servant,
				  CORBA_Environment * ev);

GDA_ErrorSeq *
 impl_GDA_Connection__get_errors(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection_beginTransaction(impl_POA_GDA_Connection * servant,
				     CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection_commitTransaction(impl_POA_GDA_Connection * servant,
				      CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection_rollbackTransaction(impl_POA_GDA_Connection * servant,
					CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection_close(impl_POA_GDA_Connection * servant,
			  CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection_execute(impl_POA_GDA_Connection * servant,
			    CORBA_char * command,
			    CORBA_long rowcount,
			    CORBA_long stmt_type,
			    CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection_open(impl_POA_GDA_Connection * servant,
			 CORBA_char * dsn,
			 CORBA_char * user,
			 CORBA_char * passwd,
			 CORBA_Environment * ev);

GDA_Recordset
impl_GDA_Connection_openSchema(impl_POA_GDA_Connection * servant,
			       GDA_Connection_QType t,
			       GDA_Connection_ConstraintSeq * constraints,
			       CORBA_Environment * ev);

GDA_Command
impl_GDA_Connection_createCommand(impl_POA_GDA_Connection * servant,
				  CORBA_Environment * ev);

GDA_Recordset
impl_GDA_Connection_createRecordset(impl_POA_GDA_Connection * servant,
				    CORBA_Environment * ev);

GDA_Connection_DSNlist *
 impl_GDA_Connection_listSources(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev);

GDA_Recordset
impl_GDA_Connection_openRecordset(impl_POA_GDA_Connection * servant,
				  CORBA_char * command,
				  GDA_LockType lock_type,
				  GDA_CursorType cursor_type,
				  CORBA_unsigned_long options,
				  CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection_startLogging(impl_POA_GDA_Connection * servant,
				 CORBA_char * filename,
				 CORBA_Environment * ev);

CORBA_long
impl_GDA_Connection_stopLogging(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev);

CORBA_char *
 impl_GDA_Connection_createTable(impl_POA_GDA_Connection * servant,
				 CORBA_char * name,
				 GDA_RowAttributes * columns,
				 CORBA_Environment * ev);

static void impl_GDA_Recordset__destroy(impl_POA_GDA_Recordset * servant,
					CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset__get_currentBookmark(impl_POA_GDA_Recordset * servant,
					CORBA_Environment * ev);
void
 impl_GDA_Recordset__set_currentBookmark(impl_POA_GDA_Recordset * servant,
					 CORBA_long value,
					 CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset__get_cachesize(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev);
void
 impl_GDA_Recordset__set_cachesize(impl_POA_GDA_Recordset * servant,
				   CORBA_long value,
				   CORBA_Environment * ev);

GDA_CursorType
impl_GDA_Recordset__get_currentCursorType(impl_POA_GDA_Recordset * servant,
					  CORBA_Environment * ev);
void
 impl_GDA_Recordset__set_currentCursorType(impl_POA_GDA_Recordset * servant,
					   GDA_CursorType value,
					   CORBA_Environment * ev);

GDA_LockType
impl_GDA_Recordset__get_lockingMode(impl_POA_GDA_Recordset * servant,
				    CORBA_Environment * ev);
void
 impl_GDA_Recordset__set_lockingMode(impl_POA_GDA_Recordset * servant,
				     GDA_LockType value,
				     CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset__get_maxrecords(impl_POA_GDA_Recordset * servant,
				   CORBA_Environment * ev);
void
 impl_GDA_Recordset__set_maxrecords(impl_POA_GDA_Recordset * servant,
				    CORBA_long value,
				    CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset__get_pagecount(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset__get_pagesize(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev);
void
 impl_GDA_Recordset__set_pagesize(impl_POA_GDA_Recordset * servant,
				  CORBA_long value,
				  CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset__get_recCount(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev);

CORBA_char *
 impl_GDA_Recordset__get_source(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset__get_status(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_cancelBatch(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_cancelUpdate(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_close(impl_POA_GDA_Recordset * servant,
			 CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_deleteCurrent(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_move(impl_POA_GDA_Recordset * servant,
			CORBA_long count,
			CORBA_long bookmark,
			CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_moveFirst(impl_POA_GDA_Recordset * servant,
			     CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_moveLast(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_open(impl_POA_GDA_Recordset * servant,
			CORBA_char * cmd,
			GDA_Connection cnc,
			GDA_CursorType ct,
			GDA_LockType lt,
			CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_reQuery(impl_POA_GDA_Recordset * servant,
			   CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_reSync(impl_POA_GDA_Recordset * servant,
			  CORBA_Environment * ev);

CORBA_boolean
impl_GDA_Recordset_supports(impl_POA_GDA_Recordset * servant,
			    GDA_Option what,
			    CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_update(impl_POA_GDA_Recordset * servant,
			  CORBA_Environment * ev);

CORBA_long
impl_GDA_Recordset_updateBatch(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev);

GDA_Recordset_Chunk *
 impl_GDA_Recordset_fetch(impl_POA_GDA_Recordset * servant,
			  CORBA_long count,
			  CORBA_Environment * ev);

GDA_RowAttributes *
 impl_GDA_Recordset_describe(impl_POA_GDA_Recordset * servant,
			     CORBA_Environment * ev);

void
impl_GDA_ConnectionFactory__destroy(impl_POA_GDA_ConnectionFactory * servant,
				    CORBA_Environment * ev);

CORBA_Object
impl_GDA_ConnectionFactory_create_connection(impl_POA_GDA_ConnectionFactory * servant,
					     CORBA_char * goad_id,
					     CORBA_Environment * ev);

CORBA_boolean
impl_GDA_ConnectionFactory_supports(impl_POA_GDA_ConnectionFactory * servant,
				    CORBA_char * obj_goad_id,
				    CORBA_Environment * ev);
CORBA_Object
impl_GDA_ConnectionFactory_create_object(impl_POA_GDA_ConnectionFactory * servant,
					 CORBA_char * goad_id,
					 GNOME_stringlist * params,
					 CORBA_Environment * ev);

/*** epv structures ***/

static PortableServer_ServantBase__epv impl_GNOME_GenericFactory_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GNOME_GenericFactory__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GNOME_GenericFactory__epv impl_GNOME_GenericFactory_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GNOME_GenericFactory_supports,

   (gpointer) & impl_GNOME_GenericFactory_create_object,

};

static PortableServer_ServantBase__epv impl_GDA_Fieldx_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_Fieldx__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Fieldx__epv impl_GDA_Fieldx_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_Fieldx_appendChunk,

   (gpointer) & impl_GDA_Fieldx_getChunk,

};

static PortableServer_ServantBase__epv impl_GDA_Parameter_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_Parameter__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Parameter__epv impl_GDA_Parameter_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GDA_Parameter_appendChunk,

};

static PortableServer_ServantBase__epv impl_GDA_Command_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_Command__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Command__epv impl_GDA_Command_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_Command__get_cmdTimeout,
   (gpointer) & impl_GDA_Command__set_cmdTimeout,

   (gpointer) & impl_GDA_Command__get_prepared,

   (gpointer) & impl_GDA_Command__get_state,
   (gpointer) & impl_GDA_Command__set_state,

   (gpointer) & impl_GDA_Command_execute,

};
static PortableServer_ServantBase__epv impl_GDA_Connection_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_Connection__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Connection__epv impl_GDA_Connection_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GDA_Connection__get_flags,
   (gpointer) & impl_GDA_Connection__set_flags,

   (gpointer) & impl_GDA_Connection__get_cmdTimeout,
   (gpointer) & impl_GDA_Connection__set_cmdTimeout,

   (gpointer) & impl_GDA_Connection__get_connectTimeout,
   (gpointer) & impl_GDA_Connection__set_connectTimeout,

   (gpointer) & impl_GDA_Connection__get_cursor,
   (gpointer) & impl_GDA_Connection__set_cursor,

   (gpointer) & impl_GDA_Connection__get_version,

   (gpointer) & impl_GDA_Connection__get_errors,

   (gpointer) & impl_GDA_Connection_beginTransaction,

   (gpointer) & impl_GDA_Connection_commitTransaction,

   (gpointer) & impl_GDA_Connection_rollbackTransaction,

   (gpointer) & impl_GDA_Connection_close,

   (gpointer) & impl_GDA_Connection_execute,

   (gpointer) & impl_GDA_Connection_open,

   (gpointer) & impl_GDA_Connection_openSchema,

   (gpointer) & impl_GDA_Connection_createCommand,

   (gpointer) & impl_GDA_Connection_createRecordset,

   (gpointer) & impl_GDA_Connection_listSources,

   (gpointer) & impl_GDA_Connection_openRecordset,

   (gpointer) & impl_GDA_Connection_startLogging,

   (gpointer) & impl_GDA_Connection_stopLogging,

   (gpointer) & impl_GDA_Connection_createTable,

};

static PortableServer_ServantBase__epv impl_GDA_Recordset_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_Recordset__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Recordset__epv impl_GDA_Recordset_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GDA_Recordset__get_currentBookmark,
   (gpointer) & impl_GDA_Recordset__set_currentBookmark,

   (gpointer) & impl_GDA_Recordset__get_cachesize,
   (gpointer) & impl_GDA_Recordset__set_cachesize,

   (gpointer) & impl_GDA_Recordset__get_currentCursorType,
   (gpointer) & impl_GDA_Recordset__set_currentCursorType,

   (gpointer) & impl_GDA_Recordset__get_lockingMode,
   (gpointer) & impl_GDA_Recordset__set_lockingMode,

   (gpointer) & impl_GDA_Recordset__get_maxrecords,
   (gpointer) & impl_GDA_Recordset__set_maxrecords,

   (gpointer) & impl_GDA_Recordset__get_pagecount,

   (gpointer) & impl_GDA_Recordset__get_pagesize,
   (gpointer) & impl_GDA_Recordset__set_pagesize,

   (gpointer) & impl_GDA_Recordset__get_recCount,

   (gpointer) & impl_GDA_Recordset__get_source,

   (gpointer) & impl_GDA_Recordset__get_status,

   (gpointer) & impl_GDA_Recordset_cancelBatch,

   (gpointer) & impl_GDA_Recordset_cancelUpdate,

   (gpointer) & impl_GDA_Recordset_close,

   (gpointer) & impl_GDA_Recordset_deleteCurrent,

   (gpointer) & impl_GDA_Recordset_move,

   (gpointer) & impl_GDA_Recordset_moveFirst,

   (gpointer) & impl_GDA_Recordset_moveLast,

   (gpointer) & impl_GDA_Recordset_open,

   (gpointer) & impl_GDA_Recordset_reQuery,

   (gpointer) & impl_GDA_Recordset_reSync,

   (gpointer) & impl_GDA_Recordset_supports,

   (gpointer) & impl_GDA_Recordset_update,

   (gpointer) & impl_GDA_Recordset_updateBatch,

   (gpointer) & impl_GDA_Recordset_fetch,

   (gpointer) & impl_GDA_Recordset_describe,

};
static PortableServer_ServantBase__epv impl_GDA_ConnectionFactory_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_GDA_ConnectionFactory__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_ConnectionFactory__epv impl_GDA_ConnectionFactory_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_ConnectionFactory_create_connection,

};
static POA_GNOME_GenericFactory__epv impl_GDA_ConnectionFactory_GNOME_GenericFactory_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_ConnectionFactory_supports,
   (gpointer) & impl_GDA_ConnectionFactory_create_object,
};

/*** vepv structures ***/

static POA_GNOME_GenericFactory__vepv impl_GNOME_GenericFactory_vepv =
{
   &impl_GNOME_GenericFactory_base_epv,
   &impl_GNOME_GenericFactory_epv,
};

static POA_GDA_Fieldx__vepv impl_GDA_Fieldx_vepv =
{
   &impl_GDA_Fieldx_base_epv,
   &impl_GDA_Fieldx_epv,
};

static POA_GDA_Parameter__vepv impl_GDA_Parameter_vepv =
{
   &impl_GDA_Parameter_base_epv,
   &impl_GDA_Parameter_epv,
};

static POA_GDA_Command__vepv impl_GDA_Command_vepv =
{
   &impl_GDA_Command_base_epv,
   &impl_GDA_Command_epv,
};
static POA_GDA_Connection__vepv impl_GDA_Connection_vepv =
{
   &impl_GDA_Connection_base_epv,
   &impl_GDA_Connection_epv,
};

static POA_GDA_Recordset__vepv impl_GDA_Recordset_vepv =
{
   &impl_GDA_Recordset_base_epv,
   &impl_GDA_Recordset_epv,
};
static POA_GDA_ConnectionFactory__vepv impl_GDA_ConnectionFactory_vepv =
{
   &impl_GDA_ConnectionFactory_base_epv,
   &impl_GDA_ConnectionFactory_GNOME_GenericFactory_epv,
   &impl_GDA_ConnectionFactory_epv,
};




/* renamed to Exception_Function since PostgreSQL API has already
   an Exception */
gint
Exception_Function (CORBA_Environment* ev)
{
  switch( ev->_major )
    {
    case CORBA_SYSTEM_EXCEPTION:
      g_log("GDA POSTGRES", G_LOG_LEVEL_DEBUG, "CORBA system exception %s.\n",
	       CORBA_exception_id(ev));
      return -1;
    case CORBA_USER_EXCEPTION:
      g_log("GDA POSTGRES", G_LOG_LEVEL_DEBUG, "CORBA user exception: %s.\n",
	       CORBA_exception_id( ev ) );
      return -1;
    default:
      break;
    }
  return 0;
}
static GDA_Error*
make_errorbuffer(Gda_POSTGRES_Connection* cnc)
{
  gint          idx;
  GList*        ptr;
  GDA_Error*    rc;

  rc  = CORBA_sequence_GDA_Error_allocbuf(g_list_length(cnc->errors));
  idx = 0;
  ptr = cnc->errors;
  
  while(ptr)
    {
      Gda_POSTGRES_Error* e = ptr->data;
      rc[idx].description = CORBA_string_dup(e->description);
      rc[idx].number = e->number;
      rc[idx].source = CORBA_string_dup(e->source);
#if 0
      rc->_buffer[idx].helpfile = CORBA_string_dup(e->helpfile);
      rc->_buffer[idx].helpctxt = CORBA_string_dup(e->helpctxt);
#endif
      rc[idx].sqlstate = CORBA_string_dup(e->sqlstate);
      rc[idx].nativeMsg   = CORBA_string_dup(e->native);
      gda_postgres_error_free(e);
      ptr = g_list_next(ptr);
      idx++;
    }
  g_list_free(cnc->errors);
  cnc->errors = 0;
  return rc;
}      

/*** Stub implementations ***/
static GDA_Recordset 
impl_GDA_Recordset__create(PortableServer_POA poa, Gda_POSTGRES_Recordset* recset, CORBA_Environment * ev);

static GNOME_GenericFactory 
impl_GNOME_GenericFactory__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GNOME_GenericFactory retval;
   impl_POA_GNOME_GenericFactory *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GNOME_GenericFactory, 1);
   newservant->servant.vepv = &impl_GNOME_GenericFactory_vepv;
   newservant->poa = poa;
   POA_GNOME_GenericFactory__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GNOME_GenericFactory__destroy(impl_POA_GNOME_GenericFactory * servant, CORBA_Environment * ev)
{

   POA_GNOME_GenericFactory__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_boolean
impl_GNOME_GenericFactory_supports(impl_POA_GNOME_GenericFactory * servant,
				   CORBA_char * obj_goad_id,
				   CORBA_Environment * ev)
{
  g_error("%s: not implemented\n", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_Object
impl_GNOME_GenericFactory_create_object(impl_POA_GNOME_GenericFactory * servant,
					CORBA_char * goad_id,
					GNOME_stringlist * params,
					CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

static GDA_Fieldx 
impl_GDA_Fieldx__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Fieldx retval;
   impl_POA_GDA_Fieldx *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Fieldx, 1);
   newservant->servant.vepv = &impl_GDA_Fieldx_vepv;
   newservant->poa = poa;
   POA_GDA_Fieldx__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_Fieldx__destroy(impl_POA_GDA_Fieldx * servant, CORBA_Environment * ev)
{

   POA_GDA_Fieldx__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_long
impl_GDA_Fieldx_appendChunk(impl_POA_GDA_Fieldx * servant,
			    GDA_VarBinString * data,
			    CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

GDA_VarBinString *
impl_GDA_Fieldx_getChunk(impl_POA_GDA_Fieldx * servant,
			 CORBA_long amount,
			 CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

static GDA_Parameter 
impl_GDA_Parameter__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Parameter retval;
   impl_POA_GDA_Parameter *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Parameter, 1);
   newservant->servant.vepv = &impl_GDA_Parameter_vepv;
   newservant->poa = poa;
   POA_GDA_Parameter__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_Parameter__destroy(impl_POA_GDA_Parameter * servant, CORBA_Environment * ev)
{

   POA_GDA_Parameter__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_long
impl_GDA_Parameter_appendChunk(impl_POA_GDA_Parameter * servant,
			       GDA_Parameter_VarBinString * data,
			       CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

static GDA_Command 
impl_GDA_Command__create(PortableServer_POA poa, Gda_POSTGRES_Command*  cmd, CORBA_Environment * ev)
{
   GDA_Command retval;
   impl_POA_GDA_Command *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Command, 1);
   newservant->servant.vepv = &impl_GDA_Command_vepv;
   newservant->poa = poa;
   newservant->cmd = cmd;
   POA_GDA_Command__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_Command__destroy(impl_POA_GDA_Command * servant, CORBA_Environment * ev)
{

   POA_GDA_Command__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_long
impl_GDA_Command__get_cmdTimeout(impl_POA_GDA_Command * servant,
				 CORBA_Environment * ev)
{
  return 0;
}

void
impl_GDA_Command__set_cmdTimeout(impl_POA_GDA_Command * servant,
				 CORBA_long value,
				 CORBA_Environment * ev)
{
}

CORBA_boolean
impl_GDA_Command__get_prepared(impl_POA_GDA_Command * servant,
			       CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Command__get_state(impl_POA_GDA_Command * servant,
			    CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

void
impl_GDA_Command__set_state(impl_POA_GDA_Command * servant,
			    CORBA_long value,
			    CORBA_Environment * ev)
{
}

GDA_Recordset
impl_GDA_Command_execute(impl_POA_GDA_Command * servant,
			 CORBA_char * cmd,
			 CORBA_long * affected,
			 GDA_CmdParameterSeq * params,
			 CORBA_long options,
			 CORBA_Environment * ev)
{
  GDA_Recordset                retval;
  Gda_POSTGRES_Recordset*      recset;
  Gda_POSTGRES_Error*          error;
  
  fprintf(stderr,"gda_Command_execute: cmd = '%s'\n", cmd);
  if (servant->cmd->cmd) {
    fprintf(stderr,"WARNING WARNING: command string still existing\n");
    g_free(servant->cmd->cmd);
  }
  servant->cmd->cmd = g_strdup(cmd);
  error = gda_postgres_error_new();
  recset = gda_postgres_cmd_execute(servant->cmd, error, params, 0);
  if (!recset)
    {
      if (error->description)
	{
	  GDA_DriverError* exception = GDA_DriverError__alloc();
	  exception->errors._length = 1;
	  exception->errors._buffer = CORBA_sequence_GDA_Error_allocbuf(1);
	  exception->errors._buffer[0].description = CORBA_string_dup(error->description);
	  exception->errors._buffer[0].number      = error->number;
	  exception->errors._buffer[0].source      = CORBA_string_dup(error->source);
	  exception->errors._buffer[0].sqlstate    = CORBA_string_dup(error->sqlstate);
	  exception->errors._buffer[0].nativeMsg   = CORBA_string_dup(error->native);
	  exception->realcommand = CORBA_string_dup("<Unknown>");
	  CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_DriverError, exception);
	}
      gda_postgres_error_free(error);
      return CORBA_OBJECT_NIL;
    }
  gda_postgres_error_free(error);
  retval = impl_GDA_Recordset__create(servant->poa, recset, ev);
  Exception_Function(ev);
  return retval;
}

static GDA_Connection 
impl_GDA_Connection__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Connection retval;
   impl_POA_GDA_Connection *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Connection, 1);
   newservant->servant.vepv = &impl_GDA_Connection_vepv;
   newservant->poa = poa;
   newservant->cnc = gda_postgres_connection_new();
   
   POA_GDA_Connection__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_Connection__destroy(impl_POA_GDA_Connection * servant, CORBA_Environment * ev)
{

   POA_GDA_Connection__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_long
impl_GDA_Connection__get_flags(impl_POA_GDA_Connection * servant,
			       CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

void
impl_GDA_Connection__set_flags(impl_POA_GDA_Connection * servant,
			       CORBA_long value,
			       CORBA_Environment * ev)
{
}

CORBA_long
impl_GDA_Connection__get_cmdTimeout(impl_POA_GDA_Connection * servant,
				    CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return -1;
}

void
impl_GDA_Connection__set_cmdTimeout(impl_POA_GDA_Connection * servant,
				    CORBA_long value,
				    CORBA_Environment * ev)
{
}

CORBA_long
impl_GDA_Connection__get_connectTimeout(impl_POA_GDA_Connection * servant,
					CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  
  return -1;
}

void
impl_GDA_Connection__set_connectTimeout(impl_POA_GDA_Connection * servant,
					CORBA_long value,
					CORBA_Environment * ev)
{
}

GDA_CursorLocation
impl_GDA_Connection__get_cursor(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

void
impl_GDA_Connection__set_cursor(impl_POA_GDA_Connection * servant,
				GDA_CursorLocation value,
				CORBA_Environment * ev)
{
}

CORBA_char *
impl_GDA_Connection__get_version(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

GDA_ErrorSeq *
impl_GDA_Connection__get_errors(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
  GDA_ErrorSeq*            rc = GDA_ErrorSeq__alloc();

  rc->_length = 0;
  rc->_buffer = 0;
  /* missing function: make_errorbuffer() */
  //  rc->_buffer = make_errorbuffer(cnc);
  return rc;
}

CORBA_long
impl_GDA_Connection_beginTransaction(impl_POA_GDA_Connection * servant,
				     CORBA_Environment * ev)
{
  Gda_POSTGRES_Connection* cnc = servant->cnc;
  GDA_NotSupported*        exception;

  if (gda_postgres_connection_begin_transaction(cnc) != -1)
    return (0);
  exception = GDA_NotSupported__alloc();
  exception->errormsg = CORBA_string_dup("Transactions not Supported");
  CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_NotSupported, exception);
  return -1;

}

CORBA_long
impl_GDA_Connection_commitTransaction(impl_POA_GDA_Connection * servant,
				      CORBA_Environment * ev)
{
  Gda_POSTGRES_Connection* cnc = servant->cnc;
  GDA_NotSupported*        exception;
  
  if (gda_postgres_connection_commit_transaction(cnc) != -1)
    return 0;
  exception = GDA_NotSupported__alloc();
  exception->errormsg = CORBA_string_dup("Transactions not Supported");
  CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_NotSupported, exception);
  return -1;
}

CORBA_long
impl_GDA_Connection_rollbackTransaction(impl_POA_GDA_Connection * servant,
					CORBA_Environment * ev)
{
  Gda_POSTGRES_Connection* cnc = servant->cnc;
  GDA_NotSupported*        exception;

  if (gda_postgres_connection_rollback_transaction(cnc) != -1)
    return (0);
  exception = GDA_NotSupported__alloc();
  exception->errormsg = CORBA_string_dup("Transactions not Supported");
  CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_NotSupported, exception);
  return (-1);

}

CORBA_long
impl_GDA_Connection_close(impl_POA_GDA_Connection * servant,
			  CORBA_Environment * ev)
{
  CORBA_long rc = 0;
  
  if (gda_postgres_connection_close(servant->cnc) < 0)
    rc = -1;
  PortableServer_POA_deactivate_object(servant->poa,
				       PortableServer_POA_servant_to_id(servant->poa, servant, ev),
				       ev);
  if (Exception_Function(ev) < 0)
    return -1;
  return rc;
}

CORBA_long
impl_GDA_Connection_execute(impl_POA_GDA_Connection * servant,
			    CORBA_char * command,
			    CORBA_long rowcount,
			    CORBA_long stmt_type,
			    CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Connection_open(impl_POA_GDA_Connection * servant,
			 CORBA_char * dsn,
			 CORBA_char * user,
			 CORBA_char * passwd,
			 CORBA_Environment * ev)
{
  if (gda_postgres_connection_open(servant->cnc, dsn, user, passwd) < 0)
    return -1;
  return 0;
}

GDA_Recordset
impl_GDA_Connection_openSchema(impl_POA_GDA_Connection * servant,
			       GDA_Connection_QType t,
			       GDA_Connection_ConstraintSeq * constraints,
			       CORBA_Environment * ev)
{
  Gda_POSTGRES_Connection* cnc = servant->cnc;
  GDA_Recordset            new_recset;
  Gda_POSTGRES_Recordset*  recset;
  Gda_POSTGRES_Error       e;
  
  fprintf(stderr,"gda_Connection_openSchema: constraints->_length = %d\n", constraints->_length);
  fprintf(stderr,"gda_Connection_openSchema: constraints->_maximum = %d\n", constraints->_maximum);
  memset(&e, '\0', sizeof(e));
  if ((recset = gda_postgres_connection_open_schema(cnc, &e, t, 
						    constraints->_buffer, 
						    constraints->_length)) == 0)
    return CORBA_OBJECT_NIL;
  new_recset = impl_GDA_Recordset__create(servant->poa, recset, ev);
  Exception_Function(ev);
  return new_recset;
}

GDA_Command
impl_GDA_Connection_createCommand(impl_POA_GDA_Connection * servant,
				  CORBA_Environment * ev)
{
  GDA_Command retval;
  Gda_POSTGRES_Command* cmd = gda_postgres_cmd_new();

  retval = impl_GDA_Command__create(servant->poa, cmd, ev);
  if (Exception_Function(ev))
    return CORBA_OBJECT_NIL;
  gda_postgres_cmd_set_connection(cmd, servant->cnc);
  return retval;
}

GDA_Recordset
impl_GDA_Connection_createRecordset(impl_POA_GDA_Connection * servant,
				    CORBA_Environment * ev)
{
   GDA_Recordset retval;
   retval = 0;
   return retval;
}

GDA_Connection_DSNlist *
impl_GDA_Connection_listSources(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
  gpointer                 postgres_iterator;
  gchar*                   dsn_name;
  gchar*                   section_name;
  GDA_Connection_DSNlist*  retval;
  GList*                   data_sources = 0;
  GList*                   ptr;
  gint                     idx;
  
  retval = GDA_Connection_DSNlist__alloc();
  retval->_length = 0;
  retval->_buffer = 0;
  retval->_maximum = 0;
  
  /* user servers */
  postgres_iterator = gnome_config_init_iterator("gda/POSTGRES Data Sources");
  while ((postgres_iterator = gnome_config_iterator_next(postgres_iterator, &dsn_name, 
							 &section_name)))
    {
      data_sources = g_list_append(data_sources, dsn_name);
      fprintf(stderr, "gda_Connection_listSources: got data source name '%s'\n", dsn_name);
      g_free(section_name);
    }
  retval->_length = g_list_length(data_sources);
  retval->_buffer = CORBA_sequence_CORBA_string_allocbuf(retval->_length);
  ptr = data_sources;
  idx = 0;
  while (ptr)
    {
      retval->_buffer[idx] = CORBA_string_dup(ptr->data);
      g_free(ptr->data);
      ptr = g_list_next(ptr);
      idx++;
    }
  g_list_free(data_sources);
  fprintf(stderr,"gda_Connection_listSources: retval->_length  = %d\n", retval->_length);
  fprintf(stderr,"                            retval->_maximum = %d\n", retval->_maximum);
  fprintf(stderr,"                            retval->_buffer  = %p\n", retval->_buffer);
  return retval;
}

GDA_Recordset
impl_GDA_Connection_openRecordset(impl_POA_GDA_Connection * servant,
				  CORBA_char * command,
				  GDA_LockType lock_type,
				  GDA_CursorType cursor_type,
				  CORBA_unsigned_long options,
				  CORBA_Environment * ev)
{

  /* FIXME: Michael, in this function I've just replaced ODBC stuff with POSTGRES stuff */
  GDA_Recordset            new_recset;
  Gda_POSTGRES_Recordset*  recset;
  Gda_POSTGRES_Command*    cmd;

  cmd = gda_postgres_cmd_new();
  cmd->cmd = g_strdup(command);
  cmd->cnc  = servant->cnc;
  recset = gda_postgres_cmd_execute(cmd, 0, 0, 0);
  if (!recset)
    {
      GDA_DriverError*     exception = GDA_DriverError__alloc();
      Gda_POSTGRES_Connection* pq_cnc = servant->cnc;
      
      exception->errors._length = g_list_length(pq_cnc->errors);
      /* missing function make_errorbuffer() */
      /* exception->errors._buffer = make_errorbuffer(pq_cnc); */
      exception->realcommand = CORBA_string_dup((CORBA_char*)command);
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_DriverError, exception);
      return CORBA_OBJECT_NIL;
    }
  new_recset = impl_GDA_Recordset__create(servant->poa, recset, ev);
  Exception_Function(ev);

  return new_recset;
}

CORBA_long
impl_GDA_Connection_startLogging(impl_POA_GDA_Connection * servant,
				 CORBA_char * filename,
				 CORBA_Environment * ev)
{
  Gda_POSTGRES_Connection *cnc = servant->cnc;

  if (gda_postgres_connection_start_logging(cnc, filename) != -1)
    return (0);
  gda_postgres_error_make(gda_postgres_error_new(), NULL, cnc, 
			  "gda_postgres_connection_start_logging");
  return (-1);
}

CORBA_long
impl_GDA_Connection_stopLogging(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
  Gda_POSTGRES_Connection *cnc = servant->cnc;

  if (gda_postgres_connection_stop_logging(cnc) != -1)
    return (0);
  gda_postgres_error_make(gda_postgres_error_new(), NULL, cnc, 
			  "gda_postgres_connection_stop_logging");
  return (-1);
}

CORBA_char *
impl_GDA_Connection_createTable(impl_POA_GDA_Connection * servant,
				CORBA_char * name,
				GDA_RowAttributes * columns,
				CORBA_Environment * ev)
{
  g_error("%s: not implemented\n", __PRETTY_FUNCTION__);
  return 0;
}

static GDA_Recordset 
impl_GDA_Recordset__create(PortableServer_POA poa, Gda_POSTGRES_Recordset* recset, CORBA_Environment * ev)
{
   GDA_Recordset retval;
   impl_POA_GDA_Recordset *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Recordset, 1);
   newservant->servant.vepv = &impl_GDA_Recordset_vepv;
   newservant->poa = poa;
   newservant->recset = recset;
   POA_GDA_Recordset__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GDA_Recordset__destroy(impl_POA_GDA_Recordset * servant, CORBA_Environment * ev)
{

   POA_GDA_Recordset__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_long
impl_GDA_Recordset__get_currentBookmark(impl_POA_GDA_Recordset * servant,
					CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

void
impl_GDA_Recordset__set_currentBookmark(impl_POA_GDA_Recordset * servant,
					CORBA_long value,
					CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
}

CORBA_long
impl_GDA_Recordset__get_cachesize(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__); 
  return 0;
}

void
impl_GDA_Recordset__set_cachesize(impl_POA_GDA_Recordset * servant,
				  CORBA_long value,
				  CORBA_Environment * ev)
{
}

GDA_CursorType
impl_GDA_Recordset__get_currentCursorType(impl_POA_GDA_Recordset * servant,
					  CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

void
impl_GDA_Recordset__set_currentCursorType(impl_POA_GDA_Recordset * servant,
					  GDA_CursorType value,
					  CORBA_Environment * ev)
{
    g_error("%s: not implemented", __PRETTY_FUNCTION__);

}

GDA_LockType
impl_GDA_Recordset__get_lockingMode(impl_POA_GDA_Recordset * servant,
				    CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

void
impl_GDA_Recordset__set_lockingMode(impl_POA_GDA_Recordset * servant,
				    GDA_LockType value,
				    CORBA_Environment * ev)
{
    g_error("%s: not implemented", __PRETTY_FUNCTION__);

}

CORBA_long
impl_GDA_Recordset__get_maxrecords(impl_POA_GDA_Recordset * servant,
				   CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

void
impl_GDA_Recordset__set_maxrecords(impl_POA_GDA_Recordset * servant,
				   CORBA_long value,
				   CORBA_Environment * ev)
{
    g_error("%s: not implemented", __PRETTY_FUNCTION__);

}

CORBA_long
impl_GDA_Recordset__get_pagecount(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset__get_pagesize(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

void
impl_GDA_Recordset__set_pagesize(impl_POA_GDA_Recordset * servant,
				 CORBA_long value,
				 CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  
}

CORBA_long
impl_GDA_Recordset__get_recCount(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_char *
impl_GDA_Recordset__get_source(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset__get_status(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_cancelBatch(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_cancelUpdate(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_close(impl_POA_GDA_Recordset * servant,
			 CORBA_Environment * ev)
{
  if (gda_postgres_recset_close(servant->recset) < 0)
    {
      fprintf(stderr,"gda_postgres_recset_close: error during close\n");
      return -1;
    }
  PortableServer_POA_deactivate_object(servant->poa,
				       PortableServer_POA_servant_to_id(servant->poa,servant, ev),
				       ev);
  Exception_Function(ev);
  impl_GDA_Recordset__destroy(servant, ev);
  if (Exception_Function(ev) < 0)
    return -1;
  return 0;
}

CORBA_long
impl_GDA_Recordset_deleteCurrent(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_move(impl_POA_GDA_Recordset * servant,
			CORBA_long count,
			CORBA_long bookmark,
			CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_moveFirst(impl_POA_GDA_Recordset * servant,
			     CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_moveLast(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_moveNext(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_movePrev(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_open(impl_POA_GDA_Recordset * servant,
			CORBA_char * cmd,
			GDA_Connection cnc,
			GDA_CursorType ct,
			GDA_LockType lt,
			CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_reQuery(impl_POA_GDA_Recordset * servant,
			   CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_reSync(impl_POA_GDA_Recordset * servant,
			  CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_boolean
impl_GDA_Recordset_supports(impl_POA_GDA_Recordset * servant,
			    GDA_Option what,
			    CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_update(impl_POA_GDA_Recordset * servant,
			  CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

CORBA_long
impl_GDA_Recordset_updateBatch(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}

GDA_Recordset_Chunk *
impl_GDA_Recordset_fetch(impl_POA_GDA_Recordset * servant,
			 CORBA_long count,
			 CORBA_Environment * ev)
{
  Gda_POSTGRES_Recordset* rs = servant->recset;
  GDA_Row*                row;
  GDA_Recordset_Chunk*    chunk;
  GDA_Field*              field;
  Gda_POSTGRES_Field*     server_field;
  GList*                  ptr;
  gint                    rowidx = 0;
  gint                    colidx;
  gint                    rc;
  GList*                  tmp_rows;
  gint                    rowlength;
  
  if (!servant->recset)
    return CORBA_OBJECT_NIL;
  
  tmp_rows = 0;
  rowidx = 0;
  rowlength = g_list_length(rs->fields);
  
  do {
    row = g_new0(GDA_Row, 1);
    row->_buffer = CORBA_sequence_GDA_Field_allocbuf(rowlength);
    row->_length = rowlength;
    ptr = rs->fields;

    colidx = 0;

    while (ptr)
      {
	
	server_field = ptr->data;

	server_field->value = &row->_buffer[colidx].realValue._u.v;
	row->_buffer[colidx].realValue._d = 1;
	row->_buffer[colidx].shadowValue._d = 1;
	row->_buffer[colidx].originalValue._d = 1;
	ptr = g_list_next(ptr);
	colidx++;
      }
    
    rc = gda_postgres_recset_move_next(rs);
      
    if (rc != 0)
      {
	CORBA_free(row->_buffer);
	g_free(row);
	break;
      }
    tmp_rows = g_list_append(tmp_rows, row);

    ptr = rs->fields;
    field = &row->_buffer[0];
    colidx = 0;

    while(ptr)
      {
	server_field = ptr->data;

	field->actualSize = server_field->actual_length;
	field->realValue._d = server_field->actual_length == 0;
	field->shadowValue._d   = 1;
	field->originalValue._d = 1;
	ptr = g_list_next(ptr);
	field = &row->_buffer[++colidx];
      }
    rowidx++;
  }while (rowidx < count);

  printf("gda_Recset_fetch: count = %d, rowidx = %d, fetchresult = %d\n", count, rowidx, rc);

  if (rc < 0)
    {
      GDA_DriverError*     exception = GDA_DriverError__alloc();
      Gda_POSTGRES_Connection* cnc = rs->cmd->cnc;
      
      fprintf(stderr,"Ooops an error ocurred while fetching data\n");
      exception->errors._length = g_list_length(cnc->errors);
      exception->errors._buffer = make_errorbuffer(cnc);
      exception->realcommand = CORBA_string_dup("Fetch");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GDA_DriverError, exception);
      return CORBA_OBJECT_NIL;
    }
  chunk = GDA_Recordset_Chunk__alloc();
  if (rowidx)
    {
      chunk->_buffer = CORBA_sequence_GDA_Row_allocbuf(rowidx);
    }
  else
    {
      chunk->_buffer = 0;
    }
  chunk->_length = rowidx;
  for (ptr = tmp_rows, count = 0; count < rowidx; ptr = g_list_next(ptr), count++)
    {
      row = ptr->data;
      chunk->_buffer[count]._length = row->_length;
      chunk->_buffer[count]._buffer = row->_buffer;
      g_free(row);
    }
  g_list_free(tmp_rows);
  return chunk;
}

GDA_RowAttributes *
impl_GDA_Recordset_describe(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev)
{
  Gda_POSTGRES_Recordset *rs = servant->recset;
  GDA_RowAttributes *rc;
  GList *ptr;
  Gda_POSTGRES_Field *server_field;
  GDA_FieldAttributes *field;
  gint idx;

  rc = GDA_RowAttributes__alloc();
  rc->_length = g_list_length(rs->fields);
  fprintf(stderr,"gda_Recset_describe: length = %d\n", rc->_length);
  rc->_buffer = CORBA_sequence_GDA_FieldAttributes_allocbuf(rc->_length);
  rc->_maximum = 0;

  idx = 0;
  ptr = rs->fields;
  while (ptr)
    {
      field = &rc->_buffer[idx];
      server_field = ptr->data;
      
      field->name        = CORBA_string_dup(server_field->name);
      fprintf(stderr,"gda_Recset_describe: sending field description for '%s'\n", field->name);
      field->definedSize = server_field->defined_length;
      
      field->scale       = server_field->num_scale;
      field->gdaType     = GDA_TypeVarchar;
      field->nativeType  = server_field->sql_type;
      ptr = g_list_next(ptr);
      idx++;
    }
  return rc;
}

GDA_ConnectionFactory 
impl_GDA_ConnectionFactory__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_ConnectionFactory retval;
   impl_POA_GDA_ConnectionFactory *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_ConnectionFactory, 1);
   newservant->servant.vepv = &impl_GDA_ConnectionFactory_vepv;
   newservant->poa = poa;
   POA_GDA_ConnectionFactory__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
void
impl_GDA_ConnectionFactory__destroy(impl_POA_GDA_ConnectionFactory * servant, CORBA_Environment * ev)
{

   POA_GDA_ConnectionFactory__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

CORBA_Object
impl_GDA_ConnectionFactory_create_connection(impl_POA_GDA_ConnectionFactory * servant,
					     CORBA_char * goad_id,
					     CORBA_Environment * ev)
{
  GDA_Connection                new_connection;
  
  fprintf(stderr,"gda_ConnectionFactory_create: called\n");
  new_connection = impl_GDA_Connection__create(servant->poa, ev);
  Exception_Function(ev);
  fprintf(stderr,"gda_ConnectionFactory_create: left\n");
  return new_connection;
}

CORBA_boolean
impl_GDA_ConnectionFactory_supports(impl_POA_GDA_ConnectionFactory * servant,
				    CORBA_char * obj_goad_id,
				    CORBA_Environment * ev)
{
  return !strcmp("gda-postgres", obj_goad_id);
}

CORBA_Object
impl_GDA_ConnectionFactory_create_object(impl_POA_GDA_ConnectionFactory * servant,
					 CORBA_char * goad_id,
					 GNOME_stringlist * params,
					 CORBA_Environment * ev)
{
  g_error("%s: not implemented", __PRETTY_FUNCTION__);
  return 0;
}
