/* Sample Rolodex Application
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>

#include "gdaform.h"
#include <gtk/gtksignal.h>

#include <gtk/gtktable.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkentry.h>

#include <gda/gda-connection.h>
#include <gda/gda-error.h>
#include <gda/gda-field.h>




enum
{
  GDAFORM_DATA_CHANGED,
  LAST_SIGNAL
};

static gint
gdaform_signals[LAST_SIGNAL] = {0 };


static void       gdaform_class_init       (GdaformClass* klass);
static void       gdaform_init             (Gdaform* form);

guint             gdaform_get_type         (void);


static void
gdaform_data_changed(GtkObject* obj, gpointer formw)
{
  gint  idx;
  gchar bfr[128];
  Gdaform* form = GDAFORM(formw);
  
  for (idx = 0; idx < form->entry_fields->len; idx++)
    {
      GtkEntry* entry = form->entry_fields->pdata[idx];
      gtk_entry_set_text(GTK_ENTRY(entry),
			 gda_stringify_value(bfr,
					     sizeof(bfr),
					     gda_recordset_field_idx(form->recset->recset, idx)));
    }
}


guint
gdaform_get_type(void)
{
  static guint gdf_type = 0;

  if (!gdf_type)
    {
      GtkTypeInfo gdf_info =
      {
	"Gdaform",
	sizeof(Gdaform),
	sizeof(GdaformClass),
	(GtkClassInitFunc)gdaform_class_init,
	(GtkObjectInitFunc)gdaform_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL
      };
      gdf_type = gtk_type_unique(gtk_vbox_get_type(), &gdf_info);
    }
  return gdf_type;
}





static void
gdaform_class_init(GdaformClass* klass)
{
  GtkObjectClass* object_class;

  object_class = (GtkObjectClass*) klass;

  gdaform_signals[GDAFORM_DATA_CHANGED] = gtk_signal_new("data_changed",
							 GTK_RUN_LAST,
							 object_class->type,
							 GTK_SIGNAL_OFFSET(GdaformClass, data_changed),
							 gtk_signal_default_marshaller,
							 GTK_TYPE_INT, 0);
  gtk_object_class_add_signals(object_class, gdaform_signals, LAST_SIGNAL);
  klass->data_changed = 0;
}



static void
gdaform_init(Gdaform* form)
{

  form->table = 0;
  form->recset = 0;
  form->entry_fields = g_ptr_array_new();
  form->adjust = gtk_adjustment_new(-1.0,
				    0.0,
				    G_MAXLONG,
				    1.0,
				    1.0,
				    1.0);

}


GtkWidget*
gdaform_new(void)
{
  
  Gdaform* form;

  form = gtk_type_new(gdaform_get_type());
  return GTK_WIDGET(form);
}


GtkWidget*
gdaform_new_from_table(Gda_Connection* cnc, gchar* tablename)
{
  return 0;
}

  
gint
gdaform_set_datasource(Gdaform* form, GnomeRecset* rs)
{
  gint num_of_cols;
  gint idx;
  
  form->recset = rs;
  if (form->table)
    gtk_container_remove(GTK_CONTAINER(form), form->table);
  
  num_of_cols = gda_recordset_rowsize(rs->recset);
  form->table = gtk_table_new(num_of_cols, 3, 0);
  for (idx = 0; idx < num_of_cols; idx++)
    {
      Gda_Field* field = gda_recordset_field_idx(rs->recset, idx);
      GtkWidget* label;
      GtkWidget* entry;
      
      label = gtk_label_new(gda_field_name(field));
      entry = gtk_entry_new();
      gtk_misc_set_alignment(GTK_MISC(label), 1, 1);
      gtk_table_attach_defaults(GTK_TABLE(form->table), label,
				0, 1, idx, idx+1);
      gtk_table_attach_defaults(GTK_TABLE(form->table), entry,
				1, 2, idx, idx+1);
      gtk_widget_show(label);
      gtk_widget_show(entry);
      g_ptr_array_add(form->entry_fields, entry);
    }
  gtk_container_add(GTK_CONTAINER(form), form->table);
  gtk_widget_show(form->table);
  gtk_signal_connect_after(GTK_OBJECT(rs),
		     "value-changed",
		     GTK_SIGNAL_FUNC(gdaform_data_changed),
		     form);
  return 0;
}


