/* GNOME DB Common Library
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gda_config_h__)
#  define __gda_config_h__

#include <glib.h>
#if USING_OAF
#  include <liboaf/liboaf.h>
#else
#  include <libgnorba/gnorba.h>
#endif

#if defined(__cplusplus)
extern "C" {
#endif

/*
 * Providers
 */
typedef struct _Gda_Server
{
  GoadServerType type;
  gchar* name;
  gchar* comment;
  gchar* location;
  gchar* repo_id;
} Gda_Server;

#define GDA_SERVER_GOAD_TYPE(srv) ((srv) ? (srv)->type : 0)
#define GDA_SERVER_NAME(srv)      ((srv) ? (srv)->name : 0)
#define GDA_SERVER_COMMENT(srv)   ((srv) ? (srv)->comment : 0)
#define GDA_SERVER_LOCATION(srv)  ((srv) ? (srv)->location : 0)
#define GDA_SERVER_REPO_ID(srv)   ((srv) ? (srv)->repo_id : 0)

Gda_Server* gda_server_new                    (void);
Gda_Server* gda_server_copy                   (Gda_Server*);
void        gda_server_free                   (Gda_Server*);

GList*      gda_server_list                   (void);
void        gda_server_free_list              (GList* list);
Gda_Server* gda_server_find_by_name           (const gchar* provider);

/*
 * Data sources
 */
GList*      gda_list_datasources              (void);
GList*      gda_list_datasources_for_provider (gchar* provider);

#if !defined(GDA_CONFIG_DIR)
#  define GDA_CONFIG_DIR "/usr/local/etc/gnome-db"
#endif

typedef struct _Gda_Dsn
{
  gchar*   gda_name;
  gchar*   provider;
  gchar*   dsn_str;
  gchar*   description;
  gchar*   username;
  gchar*   config;
  gboolean is_global;
} Gda_Dsn;

#define GDA_DSN_GDA_NAME(dsn)    ((dsn) ? (dsn)->gda_name : 0)
#define GDA_DSN_PROVIDER(dsn)    ((dsn) ? (dsn)->provider : 0)
#define GDA_DSN_DSN(dsn)         ((dsn) ? (dsn)->dsn_str : 0)
#define GDA_DSN_DESCRIPTION(dsn) ((dsn) ? (dsn)->description : 0)
#define GDA_DSN_USERNAME(dsn)    ((dsn) ? (dsn)->username : 0)
#define GDA_DSN_CONFIG(dsn)      ((dsn) ? (dsn)->config : 0)
#define GDA_DSN_IS_GLOBAL(dsn)   ((dsn) ? (dsn)->is_global : FALSE)

#define gda_dsn_new() g_new0(Gda_Dsn, 1)
void    gda_dsn_free            (Gda_Dsn *dsn);

Gda_Dsn* gda_dsn_find_by_name    (const gchar *dsn_name);
void     gda_dsn_set_name        (Gda_Dsn *dsn, const gchar *name);
void     gda_dsn_set_provider    (Gda_Dsn *dsn, const gchar *provider);
void     gda_dsn_set_dsn         (Gda_Dsn *dsn, const gchar *dsn_str);
void     gda_dsn_set_description (Gda_Dsn *dsn, const gchar *description);
void     gda_dsn_set_username    (Gda_Dsn *dsn, const gchar *username);
void     gda_dsn_set_config      (Gda_Dsn *dsn, const gchar *config);
void     gda_dsn_set_global      (Gda_Dsn *dsn, gboolean is_global);

gboolean gda_dsn_save            (Gda_Dsn *dsn);
gboolean gda_dsn_remove          (Gda_Dsn *dsn);

GList*   gda_dsn_list            (void);
void     gda_dsn_free_list       (GList *list);

#if defined(__cplusplus)
}
#endif

#endif
