/* GNOME DB components libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gnome_db_container_h__)
#  define __gnome_db_container_h__

#include <gnome.h>
#include <bonobo.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_CONTAINER            (gnome_db_container_get_type())
#define GNOME_DB_CONTAINER(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_CONTAINER, GnomeDbContainer)
#define GNOME_DB_CONTAINER_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_CONTROL, GnomeDbContainerClass)
#define GNOME_DB_IS_CONTAINER(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_CONTAINER)
#define GNOME_DB_IS_CONTAINER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_CONTAINER))

typedef struct _GnomeDbContainer      GnomeDbContainer;
typedef struct _GnomeDbContainerClass GnomeDbContainerClass;

typedef GtkWidget* (*GnomeDbContainerGetObjectFunc)(GnomeDbContainer *, gchar *);

struct _GnomeDbContainer
{
  BonoboObject                  bonobo_object;
  BonoboContainer*              bonobo_container;
  BonoboPersistFile*            persist_file;
  BonoboUIHandler*              uih;

  /* private */
  GtkWidget*                    toplevel;
  GtkWidget*                    app_bar;
  GList*                        inserted_objects;

  GnomeDbContainerGetObjectFunc get_object_func;
};

struct _GnomeDbContainerClass
{
  BonoboObjectClass parent_class;

  void              (*close)        (GnomeDbContainer *container);
  void              (*insert_object)(GnomeDbContainer *container, GtkWidget *w);
};

GtkType           gnome_db_container_get_type      (void);
GnomeDbContainer* gnome_db_container_new           (const gchar *name,
						    GnomeUIInfo *menus[],
						    GnomeUIInfo *toolbar[],
						    GnomeDbContainerGetObjectFunc func);

GnomeDbContainer* gnome_db_container_new_glade     (GnomeApp *app,
                                                    GtkMenuBar *menubar,
                                                    GtkToolbar *toolbar,
						    GnomeAppBar *app_bar,
                                                    GnomeDbContainerGetObjectFunc func);

GtkWidget*        gnome_db_container_get_toplevel  (GnomeDbContainer *container);
GtkWidget*        gnome_db_container_get_contents  (GnomeDbContainer *container);
void              gnome_db_container_set_contents  (GnomeDbContainer *container,
						    GtkWidget *w);
void              gnome_db_container_set_status    (GnomeDbContainer *container,
						    const gchar *msg,
						    ...);
gfloat            gnome_db_container_get_progress  (GnomeDbContainer *container);
void              gnome_db_container_set_progress  (GnomeDbContainer *container,
						    gfloat percentage);
void              gnome_db_container_show          (GnomeDbContainer *container);
void              gnome_db_container_insert_object (GnomeDbContainer *container,
						    const gchar *id);

#define gnome_db_container_get_widget(ct) (GNOME_DB_IS_CONTAINER(ct) ? GNOME_DB_CONTAINER(ct)->toplevel : NULL)

END_GNOME_DECLS

#endif
