/* GNOME-DB - Development Environment
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include "gda-builder.h"

static GtkWidget* l_LoginDialog = NULL;
static GtkWidget* l_BrowserTab = NULL;

/*
 * Callbacks
 */
static void
error_cb (Gda_Connection* cnc, gpointer data)
{
  GtkWidget *error_dialog;
  error_dialog = gnome_db_errordlg_new(cnc, _("Error Viewer"));
  gnome_db_errordlg_show_errors(GNOME_DB_ERRORDLG(error_dialog)); 
}

static void
login_cb (Gda_Connection *cnc)
{
  g_return_if_fail(cnc != NULL);
  if (cnc->is_open)
    {
      gchar *dsn;
      GnomeDbLogin *login = GNOME_DB_LOGIN(GNOME_DB_LOGINDLG(l_LoginDialog)->login);
      if (login)
        dsn = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(login->gda_dbname)->entry));
      else dsn = NULL;
      
      /* close previous connection, if any */
      if (IS_GDA_CONNECTION(glb_dbconn))
        {
          gda_connection_free(glb_dbconn);
        }
      glb_dbconn = cnc;

      gnome_dialog_close(GNOME_DIALOG(l_LoginDialog));
      l_LoginDialog = NULL;

      gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_Container),
				    _("Connected to %s"), dsn);
    }
}

static void
cancel_cb (GnomeDbLogin* login, gpointer data)
{
  gnome_dialog_close(GNOME_DIALOG(l_LoginDialog));
  l_LoginDialog = 0;
}

/*
 * Public functions
 */
void
builder_database_connect (GtkWidget *w, gpointer data)
{
  Gda_Connection *cnc = gda_connection_new(glb_Orb);
  
  /* check if dialog box is already open */
  if (l_LoginDialog == 0)
    {
      l_LoginDialog = gnome_db_logindlg_new(GNOME_DB_LOGIN(gnome_db_login_new(cnc,
                                                                              0,
                                                                              0)),
				                    _("Open Connection"));
      gtk_signal_connect(GTK_OBJECT(cnc), "error", GTK_SIGNAL_FUNC(error_cb), 0);
      gtk_signal_connect_after(GTK_OBJECT(cnc),
                               "open",
                               GTK_SIGNAL_FUNC(login_cb),
                               0);
      gtk_signal_connect(GTK_OBJECT(l_LoginDialog),
                         "cancel",
                         GTK_SIGNAL_FUNC(cancel_cb),
                         0);
      gnome_dialog_close_hides(GNOME_DIALOG(l_LoginDialog), TRUE);
    }
  while (gtk_events_pending())
    gtk_main_iteration();
  gnome_db_logindlg_popup(GNOME_DB_LOGINDLG(l_LoginDialog));
}

void
builder_database_disconnect (GtkWidget *w, gpointer data)
{
  if (glb_dbconn != 0)
    {
      /* close browser tab */
      if (GNOME_DB_IS_BROWSER(l_BrowserTab))
	{
	  gtk_notebook_remove_page(GTK_NOTEBOOK(glb_Notebook),
				   gtk_notebook_page_num(GTK_NOTEBOOK(glb_Notebook),
							 l_BrowserTab));
	}
      l_BrowserTab = NULL;

      /* close connection */
      if (gda_connection_is_open(glb_dbconn)) gda_connection_close(glb_dbconn);
      gda_connection_free(glb_dbconn);
      glb_dbconn = NULL;
      gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_Container),
				    _("Disconnected from database"));
    }
}

void
builder_database_browse (void)
{
  if (gda_connection_is_open(glb_dbconn))
    {
      /* create the browser tab */
      if (!GTK_IS_WIDGET(l_BrowserTab))
	{
	  l_BrowserTab = gnome_db_browser_new(glb_dbconn);
	  gtk_widget_show(l_BrowserTab);
	  gtk_notebook_append_page(GTK_NOTEBOOK(glb_Notebook),
				   l_BrowserTab,
				   gtk_label_new(_("Database Browser")));
	}
      else gnome_db_browser_set_connection(GNOME_DB_BROWSER(l_BrowserTab), glb_dbconn);

      gtk_notebook_set_page(GTK_NOTEBOOK(glb_Notebook),
			    gtk_notebook_page_num(GTK_NOTEBOOK(glb_Notebook),
						  l_BrowserTab));
    }
  else gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_Container),
				     _("There are no open connections"));
}

void
builder_database_import_objects (GtkWidget *w, gpointer data)
{
  if (gda_connection_is_open(glb_dbconn))
    {
    }
}
