/* GNOME-DB - Development Environment
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include "gda-builder.h"
#if defined(HAVE_GTKHTML)
#  include <gtkhtml/gtkhtml.h>
#else
#  include <gtk-xmhtml/gtk-xmhtml.h>
#endif

static GtkWidget*  l_help_tab = NULL;
static GtkWidget*  l_html_widget = NULL;
static GnomeUIInfo l_help_toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Back"), N_("Go to previous document"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BACK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Forward"), N_("Go to next document"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_FORWARD, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Home"), N_("Go to table of contents"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_HOME, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Private functions
 */
static void
helpwin_init (GtkContainer *frame)
{
  gchar*     help_file;
  GtkWidget* box;

  g_return_if_fail(l_html_widget == NULL);

#if defined(HAVE_GTKHTML)
  l_html_widget = gtk_html_new();
  gtk_widget_show(l_html_widget);
  
  gtk_html_load_empty(GTK_HTML(l_html_widget));
  gtk_html_set_editable(GTK_HTML(l_html_widget), FALSE);
#else
  l_html_widget = gtk_xmhtml_new();
  gtk_xmhtml_set_anchor_underline_type(GTK_XMHTML(l_html_widget), GTK_ANCHOR_SINGLE_LINE);
  gtk_xmhtml_set_anchor_buttons(GTK_XMHTML(l_html_widget), FALSE);
#endif
  gtk_widget_show(l_html_widget);

  box = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(box);
  gtk_box_pack_start(GTK_BOX(box), l_html_widget, 1, 1, 0);
  //gtk_container_add(frame, box);

  help_file = gnome_help_file_find_file("gnome-db", "gnome-db.html");
  if (help_file)
    {
      builder_help_goto((const gchar *) help_file);
      g_free((gpointer) help_file);
    }
}

/*
 * Public functions
 */
void
builder_help_window_open (void)
{
  GtkWidget*      toolbar;
  GtkWidget*      frame;
  static gboolean initialized = FALSE;

  g_return_if_fail(GTK_IS_NOTEBOOK(glb_Notebook));
  g_return_if_fail(initialized == FALSE);

  l_help_tab = gtk_table_new(10, 2, FALSE);
  gtk_widget_show(l_help_tab);

  /* create toolbar */
  toolbar = gda_ui_new_toolbar_widget(GTK_ORIENTATION_HORIZONTAL,
				      GTK_TOOLBAR_ICONS,
				      l_help_toolbar,
				      NULL);
  gtk_table_attach(GTK_TABLE(l_help_tab), toolbar, 0, 2, 0, 1, GTK_FILL, GTK_FILL, 3, 3);

  frame = gda_ui_new_frame_widget(NULL);
  gtk_table_attach(GTK_TABLE(l_help_tab), frame, 0, 2, 1, 10,
		   GTK_SHRINK | GTK_FILL | GTK_EXPAND,
		   GTK_SHRINK | GTK_FILL | GTK_EXPAND,
		   3, 3);

  /* add HTML widget */
  helpwin_init(GTK_CONTAINER(frame));

  gtk_notebook_append_page(GTK_NOTEBOOK(glb_Notebook),
			   l_help_tab,
			   gtk_label_new(_("Help")));

  initialized = TRUE;
}

void
builder_help_goto (const gchar *filename)
{
  FILE*    fp;
  GString* str;

  g_return_if_fail(filename != NULL);

  /* load the file contents */
  if ((fp = fopen(filename, "r")))
    {
      gchar buffer[513];

      str = g_string_new("");
      while (fread(&buffer, sizeof(buffer) - 1, 1, fp))
	{
	  buffer[sizeof(buffer)] = 0;
	  g_string_append(str, buffer);
	}
      fclose(fp);

      /* put the file in the HTML viewer */
#if defined(HAVE_GTKHTML)
#else
      gtk_xmhtml_source(GTK_XMHTML(l_html_widget), str->str);
#endif
      g_string_free(str, TRUE);
    }
  else gda_ui_show_error(_("Could not load file '%s'"), filename);
}


