/* GNOME-DB - Development Environment
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include "gda-builder.h"

static GtkWidget* l_project_window = NULL;
static GtkWidget* l_project_name_entry = NULL;
static GtkWidget* l_project_location_entry = NULL;

GtkWidget *
builder_project_window_open (void)
{
  GtkWidget* frame;
  GtkWidget* table;
  GtkWidget* scroll;
  GtkWidget* label;

  if (!l_project_window)
    {
      frame = gda_ui_new_frame_widget(NULL);

      table = gtk_table_new(4, 2, FALSE);
      gtk_widget_show(table);
      gtk_container_add(GTK_CONTAINER(frame), table);
      
      label = gda_ui_new_label_widget(_("Project"));
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_SHRINK, GTK_SHRINK, 3, 3);
      l_project_name_entry = gda_ui_new_entry_widget(0, FALSE);
      gtk_table_attach(GTK_TABLE(table), l_project_name_entry, 1, 2, 0, 1, GTK_SHRINK, GTK_SHRINK, 3, 3);

      label = gda_ui_new_label_widget(_("Location"));
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, GTK_SHRINK, GTK_SHRINK, 3, 3);
      l_project_location_entry = gda_ui_new_entry_widget(0, FALSE);
      gtk_table_attach(GTK_TABLE(table), l_project_location_entry, 1, 2, 1, 2, GTK_SHRINK, GTK_SHRINK, 3, 3);

      scroll = gda_ui_new_scrolled_window_widget();
      gtk_table_attach(GTK_TABLE(table),
		       scroll,
		       0, 2, 3, 4,
		       GTK_FILL | GTK_SHRINK | GTK_EXPAND,
		       GTK_FILL | GTK_SHRINK | GTK_EXPAND,
		       3, 3);
      l_project_window = gda_ui_new_tree_widget();
      gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll),
					    l_project_window);
    }
  return frame; /* return object to be inserted in containers */
}

void
builder_project_window_hide (void)
{
  g_return_if_fail(GTK_IS_TREE(l_project_window));
  gtk_widget_hide(l_project_window);
}

void
builder_project_window_show (void)
{
  g_return_if_fail(GTK_IS_TREE(l_project_window));
  gtk_widget_show(l_project_window);
}
