/* GNOME DB LDAP Config Component
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-ldap-config.h"

GtkWidget *
ldap_dsn_create_widget_cb (void)
{
  GtkWidget* table;
  GtkWidget* label;
  GtkWidget* entry;

  table = gtk_table_new(2, 3, FALSE);

  label = gtk_label_new(_("Host"));
  gtk_widget_show(label);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 3, 3);

  label = gtk_label_new(_("Port"));
  gtk_widget_show(label);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 3, 3);

  label = gtk_label_new(_("Authentication"));
  gtk_widget_show(label);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 3, 3);

  return table;
}

void
ldap_dsn_new_instance_cb (GnomeDbControl *control,
			  GnomeDbControlInstance *control_instance,
			  gpointer user_data)
{
  g_return_if_fail(GNOME_DB_IS_CONTROL(control));
  g_return_if_fail(control_instance != NULL);

  /* add control properties */
  gnome_db_control_add_property(control_instance,
                                GNOME_DB_CONTROL_PROP_DSN,
                                _("Connection String"),
                                GNOME_DB_CONTROL_ARG_STRING,
                                "");
}
