/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-mgr.h"

void 
manager_about_cb (GtkWidget *w, gpointer data)
{
  gda_ui_show_about_dialog(_("GNOME-DB Manager"));
}

void
manager_activate_dsn_cb (GtkWidget *w, gpointer data)
{
  manager_gda_activate();
}

void
manager_activate_providers_cb (GtkWidget *w, gpointer data)
{
  manager_gda_activate_providers();
}

void
manager_close_tab_cb (GtkWidget *w, gpointer data)
{
  gint       current;
  GtkWidget* current_tab;

  current = gtk_notebook_get_current_page(GTK_NOTEBOOK(glb_Notebook));
  current_tab = gtk_notebook_get_nth_page(GTK_NOTEBOOK(glb_Notebook), current);
  if (current_tab)
    {
      MANAGER_Container* container = gtk_object_get_data(GTK_OBJECT(current_tab),
							 MANAGER_WIDGET_DATA_CONTAINER);
      if (container)
	{
	  /* it's a MANAGER_Container */
	  manager_container_close(container);
	}
    }
}

void
manager_load_component_cb (GtkWidget *w, gpointer data)
{
#if defined(HAVE_BONOBO)
  //const gchar* ids[] = { "IDL:BonoboControl/gnome-db-config:1.0", NULL };
  //gchar*       goadid = gnome_bonobo_select_goad_id(_("Select config component"), ids);
  //if (goadid)
  //  {
  //    manager_container_new(goadid);
  //  }
#endif
}

void 
manager_quit_cb (GtkWidget *w, gpointer data)
{
  manager_container_close_all();
  manager_config_save();
  gtk_main_quit();
}

void
manager_run_app_cb (GtkWidget *w, const gchar *cmd)
{
  gchar* args[1];

  g_return_if_fail(cmd != 0);

  args[0] = cmd;
  if (gnome_execute_async(NULL, 1, args) == -1)
    gda_ui_show_error(_("Unable to execute '%s'"), args[0]);
}
