/* GNOME DB Postgres Config Component
 * Copyright (C) 2000 Rodrigo Moya
 * Copyright (C) 2000 Vivien Malerba
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * 
 * This header describes the interface each component has to show to the
 * gda-postgres-config main() function
 */

#include "gda-postgres-config.h"

/*
 * function called when a component is actually created,
 * called by the gnome-db-control framework
 */
GtkWidget* create_users_ac_widget_cb (void);

/*
 * Function to be called to respond to the creation of a new instance
 */
void users_ac_new_instance_cb(GnomeDbControl *control,
			      GnomeDbControlInstance *control_instance,
			      gpointer data);

/*
 * Function to be called when the "get_property" signal is emitted
 */
void users_ac_get_property_cb(GnomeDbControl *control,
			      GnomeDbControlInstance *control_instance,
			      const gchar *name,
			      gpointer data);


/*
 * Function to be called when the "set_property" signal is emitted
 */
void users_ac_set_property_cb(GnomeDbControl *control,
			      GnomeDbControlInstance *control_instance,
			      const gchar *name,
			      gconstpointer value,
			      gpointer data);
