/* GNOME DB Postgres Config Component
 * Copyright (C) 2000 Rodrigo Moya
 * Copyright (C) 2000 Vivien Malerba
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _GDA_POSTGRES_CONFIG_H_
#define _GDA_POSTGRES_CONFIG_H_

#include <gnome.h>
#include <libgnorba/gnorba.h>
#include <bonobo.h>
#include <gnome-db-control.h>
#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif
#include <libpq-fe.h>
#include <ctype.h>

/* 
 * list of all the properties for all the components
 */
#include <gnome-db-control-defprops.h>


/* 
 * structures to hold the datas associated with each widget 
 */
typedef struct _PostgresGlobalPropsInfo PostgresGlobalPropsInfo;
typedef struct _PostgresUsersPropsInfo PostgresUsersPropsInfo;
typedef struct _PostgresUsersAcPropsInfo PostgresUsersAcPropsInfo;
typedef struct _PostgresDBPropsInfo PostgresDBPropsInfo;
typedef struct _PostgresPropsInfo PostgresPropsInfo;

/* for the global config component */
struct _PostgresGlobalPropsInfo { 
  GtkWidget *users_list;
  GtkWidget *users_ac;
  PostgresPropsInfo *db_info;
};

/* users list component */
struct _PostgresUsersPropsInfo { 
  GtkWidget *clist;
  GtkWidget *name_entry;
  GtkWidget *password_entry;
  GtkWidget *group_clist;
  GtkWidget *createdb_cb; /* check boxes */
  GtkWidget *createusers_cb;
  GtkWidget *date_cb; /* use the date or not? */
  GtkWidget *date;
};

/* users access control component */
struct _PostgresUsersAcPropsInfo { 
  GtkWidget *choice;
  GtkWidget *clist;
  GtkWidget *pub_sel;
  GtkWidget *pub_ins;
  GtkWidget *pub_up;
  GtkWidget *pub_rule;
  GtkWidget *group_choice;
  GtkWidget *group_sel;
  GtkWidget *group_ins;
  GtkWidget *group_up;
  GtkWidget *group_rule;
  GtkWidget *user_choice;
  GtkWidget *user_sel;
  GtkWidget *user_ins;
  GtkWidget *user_up;
  GtkWidget *user_rule;
};

/* DB management  component */
struct _PostgresDBPropsInfo {
  GtkWidget *clist;
};

/* A unique and global structure for all these components, so that we have 
   a pointer to a unique structure whatever the component is. */
struct _PostgresPropsInfo {
  gboolean running;
  gboolean ident;
  gchar *dsn;
  GtkWidget *user_name;
  GtkWidget *user_passwd;
  GtkWidget *ident_widget;
  void (*refresh_component)(PostgresPropsInfo *);
  union {
    PostgresGlobalPropsInfo global;
    PostgresUsersPropsInfo users;
    PostgresUsersAcPropsInfo users_ac;
    PostgresDBPropsInfo db;
  } u;
};

/*
 * Builds a frame where one can enter a username and a password to send
 * commands with that identity. The info struct will be filled at that time.
 */
GtkWidget* create_user_id_config(PostgresPropsInfo *info);


/*
 * Function to be called when a component dies (bind each component to 
 * the "destroy" signal)
 */
void component_widget_destroy_cb(GtkObject *obj, gpointer data);

/*
 * A component should invoke this function wherever something has been 
 * modified which makes that other components should update their display 
 */
void require_components_refresh(PostgresPropsInfo *info);


/*
 *
 * Some utility functions
 *
 */

/* Function used in the parsing of the DSN string */
gchar* get_value(gchar* ptr);
/* opens a connection to the backend with the given info, and returns NULL if 
   an error occurs. */
PGconn *get_setup_conn(PostgresPropsInfo *info);
/* put \ in front of unwanted chars in a string 
   WARNING: str will be freed and new one allocated  */
gchar *escape_chars(gchar *str); 

/* converts a abstime like '2000-05-12 16:43:29+02' to a struct tm */
struct tm *str_to_tmstruct_timestamp(gchar *time) ;
/* Converting YYYY-MM-DD to struct tm */
struct tm *str_to_tmstruct_date2(gchar *date);
/* Converting HH:MM:SS to struct tm */
struct tm *str_to_tmstruct_time(gchar *time);

/* test is a PGresult is valid or not */
gboolean is_pgresult_valid(PGresult *res);


/* 
 * static variable to hold a list of creted components, for refreshment
 * purposes. Every control component SHOULD append its info to it.  
*/
#ifdef _MAIN_CONFIG_
GSList *controls_list;
#else
extern GSList *controls_list;
#endif
#endif
