# Note that this is NOT a relocatable package
# defaults for redhat
%define name	gnome-db
%define ver	0.0.96
%define prefix     /usr
%define sysconfdir /etc

%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

%define	servers	--with-postgres=yes --with-oracle=yes --with-mysql=/usr --with-odbc=/opt/unixodbc

Summary: GNOME DB
Name: 		%name
Version:	%ver
Release: 	%rel
Copyright: 	GPL
Group: 		Applications/Databases
Source:		ftp://ftp.gnome.org/pub/GNOME/sources/%{name}/%{name}-%{ver}.tar.gz
BuildRoot: 	/var/tmp/%{name}-%{ver}-root
URL: 		http://www.gnome.org/gnome-db/
DocDir: 	%{prefix}/doc

%description
Gnome DB is a framework for accessing different database systems
from your GNOME applications using a unique object-oriented
API.

This package contains the core components of GNOME-DB.

%package devel
Summary: GNOME DB Development
Group: 		Applications/Databases
Requires:	%name = %{PACKAGE_VERSION}

%description devel
Gnome DB is a framework for accessing different database systems
from your GNOME applications using a unique object-oriented
API.

This package contains libraries, header files and tools to let
you develop GNOME-DB applications.

# subpackage - ODBC provider
%package odbc
Summary: GNOME DB Development - ODBC provider
Group: 		Applications/Databases
Requires:	%name = %{PACKAGE_VERSION}

%description odbc
Gnome DB is a framework for accessing different database systems
from your GNOME applications using a unique object-oriented
API.

This package contains the ODBC provider.

# subpackage - PostgreSQL provider
%package postgres
Summary: GNOME DB Development - PostgreSQL provider
Group: 		Applications/Databases
Requires:	%name = %{PACKAGE_VERSION}

%description postgres
Gnome DB is a framework for accessing different database systems
from your GNOME applications using a unique object-oriented
API.

This package contains the PostgreSQL provider.

# subpackage - Oracle provider
%package oracle
Summary: GNOME DB Development - Oracle provider
Group:      Applications/Databases
Requires:   %name = %{PACKAGE_VERSION}

%description oracle
Gnome DB is a framework for accessing different database systems
from your GNOME applications using a unique object-oriented
API.

This package contains the Oracle provider.

# subpackage - MySQL provider
%package MySQL
Summary: GNOME DB Development - MySQL provider
Group:      Applications/Databases
Requires:   %name = %{PACKAGE_VERSION}

%description MySQL
Gnome DB is a framework for accessing different database systems
from your GNOME applications using a unique object-oriented
API.

This package contains the MySQL provider.

%changelog
* Fri May 19 2000 Rodrigo Moya <rmoya@chez.com>
- Adapt it to the new bonobo-based distribution
* Sun Feb 6 2000 Rodrigo Moya <rmoya@chez.com>
- Added missing executables and libraries
* Sat Jan 29 2000 Rodrigo Moya <rmoya@chez.com>
- Added Oracle and MySQL servers
* Mon Dec 20 1999 Dan Horak <horakd@volny.cz>
- Initial spec file copied from ggv

%prep
%setup

%build

# libtool workaround for alphalinux
%ifarch alpha
  ARCH_FLAGS="--host=alpha-redhat-linux"
%endif

# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir} %{servers}
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir} %{servers}
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} \
gnome_db_helpdir=$RPM_BUILD_ROOT%{prefix}/share/gnome/help/gnome-db/C \
gnorbadir=$RPM_BUILD_ROOT%{sysconfdir}/CORBA/servers \
Applicationsdir=$RPM_BUILD_ROOT%{prefix}/share/gnome/apps/Applications/GNOME-DB \
Pixmapdir=$RPM_BUILD_ROOT%{prefix}/share/pixmaps \
AppPixmapdir=$RPM_BUILD_ROOT%{prefix}/share/pixmaps/gnome-db \
AppConfigdir=$RPM_BUILD_ROOT%{sysconfdir}/gnome-db \
install

%clean
rm -rf $RPM_BUILD_ROOT

%post
if ! grep %{prefix}/lib /etc/ld.so.conf > /dev/null ; then
  echo "%{prefix}/lib" >> /etc/ld.so.conf
fi
/sbin/ldconfig
							  
%postun
/sbin/ldconfig
							  
%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{prefix}/bin/gda-components
%{prefix}/bin/gda-fe
%{prefix}/bin/gda-mgr
%{prefix}/bin/gda-rolodex
%{prefix}/lib/libgda-common.so*
%{prefix}/lib/libgda-client.so*
%{prefix}/lib/libgda-client-ui.so*
%{prefix}/lib/libgda-server.so*
%{prefix}/lib/libgda-components.so*
%{prefix}/share/gnome/apps/*
%{prefix}/share/pixmaps/*
%config %{sysconfdir}/CORBA/servers/gnome_db.gnorba
%config %{sysconfdir}/CORBA/servers/gnome-db-components.gnorba
%config %{sysconfdir}/gnome-db/gdalib.sample

%files devel
%defattr(-, root, root)

%doc %{prefix}/share/gnome/help/gnome-db/
%{prefix}/bin/gda-builder
%{prefix}/bin/gda-buildclient
%{prefix}/bin/gda-buildserver
%{prefix}/bin/gda-config
%{prefix}/bin/gda-run
%{prefix}/lib/libgda-common.*
%{prefix}/lib/libgda-client.*
%{prefix}/lib/libgda-clientcpp.*
%{prefix}/lib/libgda-client-ui.*
%{prefix}/lib/libgda-server.*
%{prefix}/lib/libgda-components.*
%{prefix}/include/gda/*
%{prefix}/share/idl/*
%{prefix}/share/gnome-db/*

%files odbc
%{prefix}/bin/gda-odbc-srv
%{prefix}/bin/gda-odbc-config
%{prefix}/lib/libgda-odbc.so*
%config %{sysconfdir}/CORBA/servers/gda-odbc-config.gnorba

%files postgres
%{prefix}/bin/gda-postgres-srv
%{prefix}/bin/gda-postgres-config
%{prefix}/lib/libgda-postgres.so*
%config %{sysconfdir}/CORBA/servers/gda-postgres-config.gnorba

%files oracle
%{prefix}/bin/gda-oracle-srv
%{prefix}/lib/libgda-oracle.so*

%files MySQL
%{prefix}/bin/gda-mysql-srv
%{prefix}/bin/gda-mysql-config
%{prefix}/lib/libgda-mysql.so*
%config %{sysconfdir}/CORBA/servers/gda-mysql-config.gnorba
