/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>


#include <libgnorba/gnorba.h>
#include <gda-client.h>

gchar* provider = 0;
gchar* database = 0;
gchar* username = 0;
gchar* password = 0;


struct poptOption options[] = {
  { "provider", 's', POPT_ARG_STRING, &provider, 0, N_("database provider"), N_("PROVIDER")},
  { "database", 'd', POPT_ARG_STRING, &database, 0, N_("database name"), N_("DATABASE")},
  { "user",     'u', POPT_ARG_STRING, &username, 0, N_("user name"), N_("USER-NAME")},
  { "password", 'p', POPT_ARG_STRING, &password, 0, N_("password"), N_("PASSWORD")},
  {0, 0, 0, 0, 0, 0, 0}
};



void Exception( CORBA_Environment *ev )
{
  switch( ev->_major )
    {
    case CORBA_SYSTEM_EXCEPTION:
      fprintf( stderr, "CORBA system exception %s.\n",
	       CORBA_exception_id(ev));
      exit ( 1 );
    case CORBA_USER_EXCEPTION:
      fprintf( stderr, "CORBA user exception: %s.\n",
	       CORBA_exception_id( ev ) );
      exit ( 1 );
    default:
      break;
    }
}

int
main(int argc, char* argv[])
{

  CORBA_ORB orb;
  CORBA_Environment ev;
  Gda_Connection*    cnc;
  GList*             gda_servers;
  GList*             data_sources;
  GList*             provider;
  GList*             data_source;
  
  CORBA_exception_init(&ev);

  orb = gnome_CORBA_init_with_popt_table("gda-client-test1", /* app_id */
					 "0.1",	/* app_version */
					 &argc,
					 argv,
					 options, /* options */
					 0, /* popt_flags */
					 0, /* return_ctx */
					 0, /* gnorba_flags */
					 &ev);

  Exception(&ev);

  cnc = gda_connection_new(orb);

  gda_servers = gda_server_list();
  provider = gda_servers;
  while (provider)
    {
      Gda_Server* server;
      server = provider->data;
      
      fprintf(stderr,"Found a provider: name     =  '%s'\n", server->name);
      fprintf(stderr,"                  comment  =  '%s'\n",
	      server->comment);
      fprintf(stderr,"                  location =  '%s'\n",
	      server->location);
      gda_connection_set_provider(cnc, server->name);

      data_sources = gda_connection_list_datasources(cnc);
      data_source = data_sources;
      while(data_source)
	{
	  
	  fprintf(stderr,"      This provider has a DSN '%s'\n",
		  (char*)data_source->data);
	  data_source = g_list_next(data_source);
	}
      provider = g_list_next(provider);
    }
  return 0;
}

  
