/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

static GtkWidget* login_dialog = NULL;

/*
 * Private functions
 */
static void
login_error_cb (Gda_Connection *cnc, gpointer data)
{
  g_return_if_fail(IS_GDA_CONNECTION(cnc));
  fe_connection_show_errors(cnc);
}

static void
login_login_cb (Gda_Connection *cnc, gpointer data)
{
  g_return_if_fail(IS_GDA_CONNECTION(cnc));

  if (gda_connection_is_open(cnc))
    {
      gchar*             str;
      FE_ConnectionInfo* cnc_info;
      GnomeDbLogin*      login;
      
      login = GNOME_DB_LOGIN(GNOME_DB_LOGINDLG(login_dialog)->login);
      if (login)
        str = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(login->gda_dbname)->entry));
      else str = NULL;

      cnc_info = fe_connection_open(str, cnc);
      if (cnc_info)
        {
          gchar* title;
          
          /* add container to workarea */
        	title = g_strdup_printf("%s@%s", gda_connection_get_user(cnc), str);
          fe_workarea_add_tab((const gchar *) title, cnc_info->container, glb_connection_toolbox);
        	g_free((gpointer) title);
          gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_mainwin),
                                        _("Connected to '%s'"), str);
        }
      gnome_dialog_close(GNOME_DIALOG(login_dialog));
      login_dialog = NULL;
    }
}

static void
login_cancel_cb (GnomeDbLoginDlg *dlg, gpointer data)
{
  gnome_dialog_close(GNOME_DIALOG(login_dialog));
  login_dialog = NULL;

  gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_mainwin), _("Ready"));
}

/*
 * Public functions
 */
void
fe_about_cb (GtkWidget *w, gpointer data)
{
  gnome_db_show_about_dialog(_("GNOME-DB Front End"));
}

void
fe_activate_connection_batch_cb (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo* cnc_info = fe_connection_get_current();
  if (cnc_info) fe_connection_activate_batch(cnc_info);
}

void
fe_activate_connection_browser_cb (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo* cnc_info = fe_connection_get_current();
  if (cnc_info) fe_connection_activate_browser(cnc_info);
}

void
fe_activate_connection_sql_cb (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo* cnc_info = fe_connection_get_current();
  if (cnc_info) fe_connection_activate_sql(cnc_info);
}

void
fe_begin_transaction_cb (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo* cnc_info = fe_connection_get_current();
  if (cnc_info) fe_connection_begin_transaction(cnc_info);
}

void
fe_close_all_connections_cb (GtkWidget *w, gpointer data)
{
  GList* node;
  
  while ((node = fe_connection_get_list()))
    {
      FE_ConnectionInfo* cnc_info = (FE_ConnectionInfo *) node->data;
      if (cnc_info)
        {
          fe_workarea_remove_tab(cnc_info->container);
          fe_connection_close(cnc_info);
        }
    }
}

void
fe_close_connection_cb (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo* cnc_info = fe_connection_get_current();
  
  if (cnc_info)
    {
      fe_workarea_remove_tab(cnc_info->container);
      fe_connection_close(cnc_info);
    }
}

void
fe_commit_transaction_cb (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo* cnc_info = fe_connection_get_current();
  if (cnc_info) fe_connection_commit_transaction(cnc_info);
}

void
fe_open_config_cb (GtkWidget *w, gpointer data)
{
}

void
fe_open_connection_cb (GtkWidget *w, gpointer data)
{
  Gda_Connection* cnc;
  GnomeDbLogin*   login;

  if (!login_dialog)
    {
      cnc = gda_connection_new(gda_corba_get_orb());
      login = gnome_db_login_new(cnc, NULL, NULL);
      login_dialog = gnome_db_logindlg_new(login, _("Open Connection"));

      gtk_signal_connect(GTK_OBJECT(cnc),
                         "error",
                         GTK_SIGNAL_FUNC(login_error_cb),
                         NULL);
      gtk_signal_connect_after(GTK_OBJECT(cnc),
                         "open",
                         GTK_SIGNAL_FUNC(login_login_cb),
                         NULL);
      gtk_signal_connect(GTK_OBJECT(login_dialog),
                         "cancel",
                         GTK_SIGNAL_FUNC(login_cancel_cb),
                         NULL);
      gnome_dialog_close_hides(GNOME_DIALOG(login_dialog), TRUE);
    }

  gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_mainwin), _("Connecting..."));

  /* run the dialog */
  while (gtk_events_pending())
    gtk_main_iteration();
  gnome_db_logindlg_popup(GNOME_DB_LOGINDLG(login_dialog));
}

void
fe_open_connection_config_cb (GtkWidget *w, gpointer data)
{
}

void
fe_open_designer_cb (GtkWidget *w, gpointer data)
{
  FE_DesignerInfo* design_info;
  
  design_info = fe_designer_open();
  if (design_info)
    {
      gint cnt;
      
      for (cnt = 0; glb_designer_toolbox[cnt].type != GNOME_APP_UI_ENDOFINFO; cnt++)
        {
          glb_designer_toolbox[cnt].user_data = (gpointer) design_info;
        }
      fe_workarea_add_tab(_("Designer"), design_info->container, glb_designer_toolbox);
    }
}

void
fe_open_dsnconfig_cb (GtkWidget *w, gpointer data)
{
  fe_config_open_dsn();
}

void
fe_open_log_cb (GtkWidget *w, gpointer data)
{
  FE_LogViewerInfo* log_info;
  
  log_info = fe_log_open();
  if (log_info)
    {
      gint cnt;
      
      for (cnt = 0; glb_log_toolbox[cnt].type != GNOME_APP_UI_ENDOFINFO; cnt++)
        {
          glb_log_toolbox[cnt].user_data = (gpointer) log_info;
        }
      fe_workarea_add_tab(_("Log Viewer"), log_info->container, glb_log_toolbox);
    }
}

void
fe_open_service_manager_cb (GtkWidget *w, gpointer data)
{
  FE_ServiceManagerInfo* service_info;
  
  service_info = fe_service_manager_open();
  if (service_info)
    {
      gint cnt;
      
      for (cnt = 0; glb_servicemgr_toolbox[cnt].type != GNOME_APP_UI_ENDOFINFO; cnt++)
        {
          glb_servicemgr_toolbox[cnt].user_data = (gpointer) service_info;
        }
      fe_workarea_add_tab(_("Service Manager"), service_info->container, glb_servicemgr_toolbox);
    }
}

void
fe_quit_cb (GtkWidget *w, gpointer data)
{
  fe_close_all_connections_cb(w, data);
  fe_config_save();
  gnome_db_main_quit();
}

void
fe_rollback_transaction_cb (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo* cnc_info = fe_connection_get_current();
  if (cnc_info) fe_connection_rollback_transaction(cnc_info);
}

void
fe_run_app_cb (GtkWidget *w, const gchar *cmd)
{
  gchar* args[1];

  g_return_if_fail(cmd != NULL);

  args[0] = cmd;
  if (gnome_execute_async(NULL, 1, args) == -1)
    gnome_db_show_error(_("Unable to execute '%s'"), args[0]);
}

void
fe_save_config_cb (GtkWidget *w, gpointer data)
{
}

void
fe_view_connection_props_cb (GtkWidget *w, gpointer data)
{
}