/* GNOME DB library
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gnome_db_config_h__)

#include <glib.h>
#include <gnome.h>

BEGIN_GNOME_DECLS

typedef struct
{
  gchar* name;
  gchar* location;
  gchar* description;
  gchar* repo_ids;
  gchar* type;
  gchar* icon;
} GnomeDbConfigComponent;

#define gnome_db_config_component_get_name(_com_) ((_com_) != NULL ? (_com_)->name : NULL)
#define gnome_db_config_component_get_location(_com_) ((_com_) != NULL ? (_com_)->location : NULL)
#define gnome_db_config_component_get_description(_com_) ((_com_) != NULL ? (_com_)->description : NULL)
#define gnome_db_config_component_get_repo_ids(_com_) ((_com_) != NULL ? (_com_)->repo_ids : NULL)
#define gnome_db_config_component_get_type(_com_) ((_com_) != NULL ? (_com_)->type : NULL)
#define gnome_db_config_component_get_icon(_com_) ((_com_) != NULL ? (_com_)->icon : NULL)

GnomeDbConfigComponent* gnome_db_config_component_new             (void);
void                    gnome_db_config_component_free            (GnomeDbConfigComponent *component);
void                    gnome_db_config_component_set_name        (GnomeDbConfigComponent *component, const gchar *name);
void                    gnome_db_config_component_set_location    (GnomeDbConfigComponent *component, const gchar *location);
void                    gnome_db_config_component_set_description (GnomeDbConfigComponent *component, const gchar *desc);
void                    gnome_db_config_component_set_repo_ids    (GnomeDbConfigComponent *component, const gchar *repo_ids);
void                    gnome_db_config_component_set_type        (GnomeDbConfigComponent *component, const gchar *type);
void                    gnome_db_config_component_set_icon        (GnomeDbConfigComponent *component, const gchar *icon);

GList*                  gnome_db_config_get_all_components   (void);
GList*                  gnome_db_config_get_shell_components (void);
void                    gnome_db_config_component_free_list  (GList *list);

END_GNOME_DECLS

#endif
