/* GNOME DB library
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_moniker_h__)
#  define __gnome_db_moniker_h__

#include <gnome.h>
#include <bonobo/bonobo-moniker.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_MONIKER_TYPE        (gnome_db_moniker_get_type ())
#define GNOME_DB_MONIKER(o)          (GTK_CHECK_CAST ((o), GNOME_DB_MONIKER_TYPE, GnomeDbMoniker))
#define GNOME_DB_MONIKER_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GNOME_DB_MONIKER_TYPE, GnomeDbMonikerClass))
#define GNOME_DB_IS_MONIKER(o)       (GTK_CHECK_TYPE ((o), GNOME_DB_MONIKER_TYPE))
#define GNOME_DB_IS_MONIKER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GNOME_DB_MONIKER_TYPE))

typedef struct _GnomeDbMoniker        GnomeDbMoniker;
typedef struct _GnomeDbMonikerClass   GnomeDbMonikerClass;

typedef struct _GnomeDbMonikerPrivate GnomeDbMonikerPrivate;

struct _GnomeDbMoniker
{
  BonoboMoniker          moniker;
  GnomeDbMonikerPrivate* priv;
};

struct _GnomeDbMonikerClass
{
  BonoboMonikerClass parent_class;
};

GtkType         gnome_db_moniker_get_type (void);

GnomeDbMoniker* gnome_db_moniker_new      (const gchar *prefix);

END_GNOME_DECLS

#endif

