/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnomedb-mgr.h"

static GnomeDbControl* manager_control = NULL;

int
main (int argc, char *argv[])
{
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);
  
  gnome_db_init("gnomedb-mgr", VERSION, argc, argv);
  
  /* register control */
  manager_control = gnome_db_control_new("OAFIID:control-factory:gnome-db-manager:69c316f9-944f-4a7d-8637-0fa545439138",
                                         manager_control_create_instance_cb);
  if (!GNOME_DB_IS_CONTROL(manager_control))
    {
      g_error(_("Could not initialize manager component"));
    }
                     
  /* run application */
  gnome_db_main(NULL);
  return 0;
}

