/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 4 -*- */

/*
 * Generic gdb stuff.
 *
 * Author : Dave Camp <campd@oit.edu>
 */

#ifndef __GDB_INSTANCE_H__
#define __GDB_INSTANCE_H__

#include <glib.h>
#include "process.h"

#include "gdb-signal.h"

/* An instance of gdb */
struct _GdbInstance {
    ChildProcess *proc;

    GdbSignal *signals;

    GdbCommand *first_command;  /* Command Queue */
    GdbCommand *last_command;
    GdbCommand *running_command;

    GTree *breakpoints;

    GdbDisplay **display_array;  /* Displays */
    gint display_array_size;
    gint num_displays;

    gboolean file_loaded;
    gboolean is_running;    /* Loaded and ready to execute */
    gboolean is_executing;  /* Currently executing */
    gboolean at_prompt;
    gboolean at_query;

    gint listener_id;
    double gdb_ver;
};

GdbInstance *gdb_create_instance (void);
void gdb_destroy_instance (GdbInstance *inst);
void gdb_emit_error (GdbInstance *inst, gchar *error_msg);

#endif
