/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 1999-2000 Dave Camp <campd@oit.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef __GDF_LOCALS_VIEWER_H__
#define __GDF_LOCALS_VIEWER_H__

#include <gnome.h>
#include "gdf-variable-viewer.h"
#include <gdf.h>

BEGIN_GNOME_DECLS

typedef struct _GdfLocalsViewer      GdfLocalsViewer;
typedef struct _GdfLocalsViewerClass GdfLocalsViewerClass;
typedef struct _GdfLocalsViewerPriv  GdfLocalsViewerPriv;

#define GDF_LOCALS_VIEWER_TYPE        (gdf_locals_viewer_get_type ())
#define GDF_LOCALS_VIEWER(o)          (GTK_CHECK_CAST ((o), GDF_LOCALS_VIEWER_TYPE, GdfLocalsViewer))
#define GDF_LOCALS_VIEWER_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GDF_LOCALS_VIEWER_TYPE, GdfLocalsViewerClass))
#define GDF_IS_LOCALS_VIEWER(o)       (GTK_CHECK_TYPE ((o), GDF_LOCALS_VIEWER_TYPE))
#define GDF_IS_LOCALS_VIEWER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GDF_LOCALS_VIEWER_TYPE))

struct _GdfLocalsViewer {
	GdfVariableViewer parent;
};

struct _GdfLocalsViewerClass {
	GdfVariableViewerClass parent_class;
};

GtkType gdf_locals_viewer_get_type ();

GdfLocalsViewer *gdf_locals_viewer_new ();

#endif





