/* chess-scene.c generated by valac 0.11.7, the Vala compiler
 * generated from chess-scene.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
typedef struct _ParamSpecChessModel ParamSpecChessModel;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
#define __g_list_free__chess_model_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__chess_model_unref0_ (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _chess_game_unref0(var) ((var == NULL) ? NULL : (var = (chess_game_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

struct _ParamSpecChessModel {
	GParamSpec parent_instance;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessScenePrivate {
	gboolean _can_move[64];
	GTimer* animation_timer;
	gdouble animation_time;
	ChessGame* _game;
	gint _move_number;
	gboolean _show_numbering;
	gboolean _show_move_hints;
	gchar* _theme_name;
	gboolean _show_3d_smooth;
	gchar* _board_side;
	gchar* _move_format;
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};


static gpointer chess_model_parent_class = NULL;
static gpointer chess_scene_parent_class = NULL;

gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_MODEL_DUMMY_PROPERTY
};
ChessModel* chess_model_new (ChessPiece* piece, gdouble x, gdouble y);
ChessModel* chess_model_construct (GType object_type, ChessPiece* piece, gdouble x, gdouble y);
gboolean chess_model_move_to (ChessModel* self, gdouble x, gdouble y);
gboolean chess_model_animate (ChessModel* self, gdouble timestep);
gboolean chess_model_get_moving (ChessModel* self);
static gdouble chess_model_update_position (ChessModel* self, gdouble timestep, gdouble value, gdouble target);
static void chess_model_finalize (ChessModel* obj);
GType chess_scene_get_type (void) G_GNUC_CONST;
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
#define CHESS_SCENE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_SCENE, ChessScenePrivate))
enum  {
	CHESS_SCENE_DUMMY_PROPERTY,
	CHESS_SCENE_GAME,
	CHESS_SCENE_MOVE_NUMBER,
	CHESS_SCENE_SHOW_NUMBERING,
	CHESS_SCENE_SHOW_MOVE_HINTS,
	CHESS_SCENE_THEME_NAME,
	CHESS_SCENE_SHOW_3D_SMOOTH,
	CHESS_SCENE_BOARD_SIDE,
	CHESS_SCENE_BOARD_ANGLE,
	CHESS_SCENE_MOVE_FORMAT
};
static void _chess_model_unref0_ (gpointer var);
static void _g_list_free__chess_model_unref0_ (GList* self);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
ChessGame* chess_scene_get_game (ChessScene* self);
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
gint chess_scene_get_move_number (ChessScene* self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
ChessPlayer* chess_game_get_current_player (ChessGame* self);
gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply);
static void chess_scene_update_board (ChessScene* self);
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
static void chess_scene_moved_cb (ChessScene* self, ChessGame* game, ChessMove* move);
static void chess_scene_undo_cb (ChessScene* self, ChessGame* game);
static ChessModel* chess_scene_find_model (ChessScene* self, ChessPiece* piece);
void chess_game_add_hold (ChessGame* self);
static gboolean chess_scene_animate_cb (ChessScene* self);
static gboolean _chess_scene_animate_cb_gsource_func (gpointer self);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
void chess_game_remove_hold (ChessGame* self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void _chess_scene_moved_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void _chess_scene_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
void chess_scene_set_move_number (ChessScene* self, gint value);
gboolean chess_scene_get_show_numbering (ChessScene* self);
void chess_scene_set_show_numbering (ChessScene* self, gboolean value);
gboolean chess_scene_get_show_move_hints (ChessScene* self);
void chess_scene_set_show_move_hints (ChessScene* self, gboolean value);
const gchar* chess_scene_get_theme_name (ChessScene* self);
void chess_scene_set_theme_name (ChessScene* self, const gchar* value);
gboolean chess_scene_get_show_3d_smooth (ChessScene* self);
void chess_scene_set_show_3d_smooth (ChessScene* self, gboolean value);
const gchar* chess_scene_get_board_side (ChessScene* self);
void chess_scene_set_board_side (ChessScene* self, const gchar* value);
gdouble chess_scene_get_board_angle (ChessScene* self);
GType color_get_type (void) G_GNUC_CONST;
const gchar* chess_scene_get_move_format (ChessScene* self);
void chess_scene_set_move_format (ChessScene* self, const gchar* value);
static void chess_scene_finalize (GObject* obj);
static void _vala_chess_scene_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_scene_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _chess_piece_ref0 (gpointer self) {
	return self ? chess_piece_ref (self) : NULL;
}


ChessModel* chess_model_construct (GType object_type, ChessPiece* piece, gdouble x, gdouble y) {
	ChessModel* self = NULL;
	ChessPiece* _tmp0_;
	g_return_val_if_fail (piece != NULL, NULL);
	self = (ChessModel*) g_type_create_instance (object_type);
	_tmp0_ = _chess_piece_ref0 (piece);
	_chess_piece_unref0 (self->piece);
	self->piece = _tmp0_;
	self->target_x = x;
	self->x = self->target_x;
	self->target_y = y;
	self->y = self->target_y;
	return self;
}


ChessModel* chess_model_new (ChessPiece* piece, gdouble x, gdouble y) {
	return chess_model_construct (TYPE_CHESS_MODEL, piece, x, y);
}


gboolean chess_model_move_to (ChessModel* self, gdouble x, gdouble y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->target_x == x) {
		_tmp0_ = self->target_y == y;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	self->target_x = x;
	self->target_y = y;
	result = TRUE;
	return result;
}


gboolean chess_model_animate (ChessModel* self, gdouble timestep) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = chess_model_get_moving (self);
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = chess_model_update_position (self, timestep, self->x, self->target_x);
	self->x = _tmp1_;
	_tmp2_ = chess_model_update_position (self, timestep, self->y, self->target_y);
	self->y = _tmp2_;
	result = TRUE;
	return result;
}


static gdouble chess_model_update_position (ChessModel* self, gdouble timestep, gdouble value, gdouble target) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	gdouble distance;
	gdouble step;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = fabs (target - value);
	distance = _tmp0_;
	step = timestep * 4.0;
	if (step > distance) {
		step = distance;
	}
	if (target > value) {
		result = value + step;
		return result;
	} else {
		result = value - step;
		return result;
	}
}


gboolean chess_model_get_moving (ChessModel* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->x != self->target_x) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->y != self->target_y;
	}
	result = _tmp0_;
	return result;
}


static void value_chess_model_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_model_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_model_unref (value->data[0].v_pointer);
	}
}


static void value_chess_model_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_model_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_model_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_model_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessModel* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_model_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_model_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessModel** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_model_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessModel* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_MODEL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_model (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MODEL), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_model (GValue* value, gpointer v_object) {
	ChessModel* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MODEL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MODEL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_model_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_model_unref (old);
	}
}


void value_take_chess_model (GValue* value, gpointer v_object) {
	ChessModel* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MODEL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MODEL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_model_unref (old);
	}
}


static void chess_model_class_init (ChessModelClass * klass) {
	chess_model_parent_class = g_type_class_peek_parent (klass);
	CHESS_MODEL_CLASS (klass)->finalize = chess_model_finalize;
}


static void chess_model_instance_init (ChessModel * self) {
	self->ref_count = 1;
}


static void chess_model_finalize (ChessModel* obj) {
	ChessModel * self;
	self = CHESS_MODEL (obj);
	_chess_piece_unref0 (self->piece);
}


GType chess_model_get_type (void) {
	static volatile gsize chess_model_type_id__volatile = 0;
	if (g_once_init_enter (&chess_model_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_model_init, value_chess_model_free_value, value_chess_model_copy_value, value_chess_model_peek_pointer, "p", value_chess_model_collect_value, "p", value_chess_model_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessModel), 0, (GInstanceInitFunc) chess_model_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_model_type_id;
		chess_model_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessModel", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_model_type_id__volatile, chess_model_type_id);
	}
	return chess_model_type_id__volatile;
}


gpointer chess_model_ref (gpointer instance) {
	ChessModel* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_model_unref (gpointer instance) {
	ChessModel* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_MODEL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _chess_model_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (chess_model_unref (var), NULL));
}


static void _g_list_free__chess_model_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _chess_model_unref0_, NULL);
	g_list_free (self);
}


ChessPiece* chess_scene_get_selected_piece (ChessScene* self) {
	ChessPiece* result = NULL;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gint _tmp3_;
	ChessPiece* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = chess_scene_get_game (self);
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->selected_rank < 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = chess_scene_get_game (self);
	_tmp3_ = chess_scene_get_move_number (self);
	_tmp4_ = chess_game_get_piece (_tmp2_, self->selected_rank, self->selected_file, _tmp3_);
	result = _tmp4_;
	return result;
}


ChessScene* chess_scene_construct (GType object_type) {
	ChessScene * self = NULL;
	GTimer* _tmp0_ = NULL;
	self = (ChessScene*) g_object_new (object_type, NULL);
	_tmp0_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->animation_timer);
	self->priv->animation_timer = _tmp0_;
	return self;
}


ChessScene* chess_scene_new (void) {
	return chess_scene_construct (TYPE_CHESS_SCENE);
}


void chess_scene_select_square (ChessScene* self, gint file, gint rank) {
	ChessGame* _tmp0_ = NULL;
	gint _tmp1_;
	ChessGame* _tmp2_ = NULL;
	gint _tmp3_;
	ChessPiece* _tmp4_ = NULL;
	ChessPiece* piece;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_scene_get_game (self);
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = chess_scene_get_move_number (self);
	if (_tmp1_ != (-1)) {
		return;
	}
	_tmp2_ = chess_scene_get_game (self);
	_tmp3_ = chess_scene_get_move_number (self);
	_tmp4_ = chess_game_get_piece (_tmp2_, rank, file, _tmp3_);
	piece = _tmp4_;
	if (file == self->selected_file) {
		_tmp5_ = rank == self->selected_rank;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		self->selected_file = -1;
		self->selected_rank = self->selected_file;
	} else {
		gboolean _tmp6_ = FALSE;
		if (piece != NULL) {
			ChessGame* _tmp7_ = NULL;
			ChessPlayer* _tmp8_ = NULL;
			_tmp7_ = chess_scene_get_game (self);
			_tmp8_ = chess_game_get_current_player (_tmp7_);
			_tmp6_ = piece->player == _tmp8_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			self->selected_rank = rank;
			self->selected_file = file;
		} else {
			if (self->selected_file != (-1)) {
				ChessGame* _tmp9_ = NULL;
				ChessPlayer* _tmp10_ = NULL;
				gboolean _tmp11_;
				_tmp9_ = chess_scene_get_game (self);
				_tmp10_ = chess_game_get_current_player (_tmp9_);
				_tmp11_ = chess_player_move_with_coords (_tmp10_, self->selected_rank, self->selected_file, rank, file, TRUE);
				if (_tmp11_) {
					self->selected_file = -1;
					self->selected_rank = self->selected_file;
				}
			}
		}
	}
	chess_scene_update_board (self);
	g_signal_emit_by_name (self, "changed");
	_chess_piece_unref0 (piece);
}


static void chess_scene_moved_cb (ChessScene* self, ChessGame* game, ChessMove* move) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	chess_scene_update_board (self);
}


static void chess_scene_undo_cb (ChessScene* self, ChessGame* game) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	chess_scene_update_board (self);
}


static gpointer _chess_model_ref0 (gpointer self) {
	return self ? chess_model_ref (self) : NULL;
}


static ChessModel* chess_scene_find_model (ChessScene* self, ChessPiece* piece) {
	ChessModel* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (piece != NULL, NULL);
	{
		GList* model_collection;
		GList* model_it;
		model_collection = self->pieces;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp0_;
			ChessModel* model;
			_tmp0_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp0_;
			{
				if (model->piece == piece) {
					result = model;
					return result;
				}
				_chess_model_unref0 (model);
			}
		}
	}
	result = NULL;
	return result;
}


static gboolean _chess_scene_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_scene_animate_cb (self);
	return result;
}


static void chess_scene_update_board (ChessScene* self) {
	ChessGame* _tmp0_ = NULL;
	gboolean board_changed;
	gboolean need_animation;
	GList* new_pieces;
	guint _tmp19_;
	guint _tmp20_;
	gboolean _tmp23_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_scene_get_game (self);
	if (_tmp0_ == NULL) {
		return;
	}
	board_changed = FALSE;
	need_animation = FALSE;
	new_pieces = NULL;
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					rank++;
				}
				_tmp1_ = FALSE;
				if (!(rank < 8)) {
					break;
				}
				{
					gint file;
					file = 0;
					{
						gboolean _tmp2_;
						_tmp2_ = TRUE;
						while (TRUE) {
							gboolean can_move;
							gboolean _tmp3_ = FALSE;
							gboolean _tmp4_ = FALSE;
							ChessGame* _tmp9_ = NULL;
							gint _tmp10_;
							ChessPiece* _tmp11_ = NULL;
							ChessPiece* piece;
							ChessModel* _tmp12_ = NULL;
							ChessModel* model;
							gboolean _tmp14_;
							gboolean _tmp15_ = FALSE;
							gboolean _tmp16_ = FALSE;
							gint _tmp17_;
							ChessModel* _tmp18_;
							if (!_tmp2_) {
								file++;
							}
							_tmp2_ = FALSE;
							if (!(file < 8)) {
								break;
							}
							can_move = FALSE;
							if (self->selected_rank >= 0) {
								gint _tmp5_;
								_tmp5_ = chess_scene_get_move_number (self);
								_tmp4_ = _tmp5_ == (-1);
							} else {
								_tmp4_ = FALSE;
							}
							if (_tmp4_) {
								ChessGame* _tmp6_ = NULL;
								ChessPlayer* _tmp7_ = NULL;
								gboolean _tmp8_;
								_tmp6_ = chess_scene_get_game (self);
								_tmp7_ = chess_game_get_current_player (_tmp6_);
								_tmp8_ = chess_player_move_with_coords (_tmp7_, self->selected_rank, self->selected_file, rank, file, FALSE);
								_tmp3_ = _tmp8_;
							} else {
								_tmp3_ = FALSE;
							}
							if (_tmp3_) {
								can_move = TRUE;
							}
							self->priv->_can_move[(rank * 8) + file] = can_move;
							_tmp9_ = chess_scene_get_game (self);
							_tmp10_ = chess_scene_get_move_number (self);
							_tmp11_ = chess_game_get_piece (_tmp9_, rank, file, _tmp10_);
							piece = _tmp11_;
							if (piece == NULL) {
								_chess_piece_unref0 (piece);
								continue;
							}
							_tmp12_ = chess_scene_find_model (self, piece);
							model = _tmp12_;
							if (model == NULL) {
								ChessModel* _tmp13_ = NULL;
								_tmp13_ = chess_model_new (piece, (gdouble) file, (gdouble) rank);
								_chess_model_unref0 (model);
								model = _tmp13_;
								board_changed = TRUE;
							}
							model->under_threat = can_move;
							_tmp14_ = chess_model_move_to (model, (gdouble) file, (gdouble) rank);
							if (_tmp14_) {
								board_changed = TRUE;
								need_animation = TRUE;
							}
							_tmp17_ = chess_scene_get_move_number (self);
							if (_tmp17_ == (-1)) {
								_tmp16_ = rank == self->selected_rank;
							} else {
								_tmp16_ = FALSE;
							}
							if (_tmp16_) {
								_tmp15_ = file == self->selected_file;
							} else {
								_tmp15_ = FALSE;
							}
							if (_tmp15_) {
								model->is_selected = TRUE;
							} else {
								model->is_selected = FALSE;
							}
							_tmp18_ = _chess_model_ref0 (model);
							new_pieces = g_list_append (new_pieces, _tmp18_);
							_chess_model_unref0 (model);
							_chess_piece_unref0 (piece);
						}
					}
				}
			}
		}
	}
	_tmp19_ = g_list_length (new_pieces);
	_tmp20_ = g_list_length (self->pieces);
	if (_tmp19_ != _tmp20_) {
		board_changed = TRUE;
	}
	if (!board_changed) {
		__g_list_free__chess_model_unref0_0 (new_pieces);
		return;
	}
	__g_list_free__chess_model_unref0_0 (self->pieces);
	self->pieces = NULL;
	{
		GList* model_collection;
		GList* model_it;
		model_collection = new_pieces;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp21_;
			ChessModel* model;
			_tmp21_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp21_;
			{
				ChessModel* _tmp22_;
				_tmp22_ = _chess_model_ref0 (model);
				self->pieces = g_list_append (self->pieces, _tmp22_);
				_chess_model_unref0 (model);
			}
		}
	}
	g_signal_emit_by_name (self, "changed");
	if (need_animation) {
		_tmp23_ = !self->animating;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ChessGame* _tmp24_ = NULL;
		self->animating = TRUE;
		g_timer_start (self->priv->animation_timer);
		self->priv->animation_time = (gdouble) 0;
		_tmp24_ = chess_scene_get_game (self);
		chess_game_add_hold (_tmp24_);
		g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, (guint) 10, _chess_scene_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
	}
	__g_list_free__chess_model_unref0_0 (new_pieces);
}


gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_move[(rank * 8) + file];
	return result;
}


static gboolean chess_scene_animate_cb (ChessScene* self) {
	gboolean result = FALSE;
	gdouble old_time;
	gdouble _tmp0_;
	gdouble timestep;
	gint animate_count;
	ChessGame* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	old_time = self->priv->animation_time;
	_tmp0_ = g_timer_elapsed (self->priv->animation_timer, NULL);
	self->priv->animation_time = _tmp0_;
	timestep = self->priv->animation_time - old_time;
	animate_count = 0;
	{
		GList* model_collection;
		GList* model_it;
		model_collection = self->pieces;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp1_;
			ChessModel* model;
			_tmp1_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp1_;
			{
				gboolean _tmp2_;
				_tmp2_ = chess_model_animate (model, timestep);
				if (_tmp2_) {
					animate_count++;
				}
				_chess_model_unref0 (model);
			}
		}
	}
	self->animating = animate_count > 0;
	g_signal_emit_by_name (self, "changed");
	if (self->animating) {
		result = TRUE;
		return result;
	}
	self->animating = FALSE;
	_tmp3_ = chess_scene_get_game (self);
	chess_game_remove_hold (_tmp3_);
	result = FALSE;
	return result;
}


ChessGame* chess_scene_get_game (ChessScene* self) {
	ChessGame* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_game;
	return result;
}


static gpointer _chess_game_ref0 (gpointer self) {
	return self ? chess_game_ref (self) : NULL;
}


static void _chess_scene_moved_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
	chess_scene_moved_cb (self, _sender, move);
}


static void _chess_scene_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
	chess_scene_undo_cb (self, _sender);
}


void chess_scene_set_game (ChessScene* self, ChessGame* value) {
	ChessGame* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _chess_game_ref0 (value);
	_chess_game_unref0 (self->priv->_game);
	self->priv->_game = _tmp0_;
	self->priv->_move_number = -1;
	self->selected_rank = -1;
	self->selected_file = -1;
	g_signal_connect_object (self->priv->_game, "moved", (GCallback) _chess_scene_moved_cb_chess_game_moved, self, 0);
	g_signal_connect_object (self->priv->_game, "undo", (GCallback) _chess_scene_undo_cb_chess_game_undo, self, 0);
	chess_scene_update_board (self);
	g_object_notify ((GObject *) self, "game");
}


gint chess_scene_get_move_number (ChessScene* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_move_number;
	return result;
}


void chess_scene_set_move_number (ChessScene* self, gint value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_move_number == value) {
		return;
	}
	self->priv->_move_number = value;
	chess_scene_update_board (self);
	g_object_notify ((GObject *) self, "move-number");
}


gboolean chess_scene_get_show_numbering (ChessScene* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_numbering;
	return result;
}


void chess_scene_set_show_numbering (ChessScene* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_numbering = value;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "show-numbering");
}


gboolean chess_scene_get_show_move_hints (ChessScene* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_move_hints;
	return result;
}


void chess_scene_set_show_move_hints (ChessScene* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_move_hints = value;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "show-move-hints");
}


const gchar* chess_scene_get_theme_name (ChessScene* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_theme_name;
	return result;
}


void chess_scene_set_theme_name (ChessScene* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_theme_name);
	self->priv->_theme_name = _tmp0_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "theme-name");
}


gboolean chess_scene_get_show_3d_smooth (ChessScene* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_3d_smooth;
	return result;
}


void chess_scene_set_show_3d_smooth (ChessScene* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_3d_smooth = value;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "show-3d-smooth");
}


const gchar* chess_scene_get_board_side (ChessScene* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_board_side;
	return result;
}


void chess_scene_set_board_side (ChessScene* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_board_side);
	self->priv->_board_side = _tmp0_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "board-side");
}


gdouble chess_scene_get_board_angle (ChessScene* self) {
	gdouble result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	static GQuark _tmp2__label2 = 0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = chess_scene_get_board_side (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("black")))) {
		switch (0) {
			default:
			{
				result = 180.0;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				result = 0.0;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("current")))) {
		switch (0) {
			default:
			{
				gdouble _tmp3_ = 0.0;
				ChessGame* _tmp4_ = NULL;
				ChessPlayer* _tmp5_ = NULL;
				_tmp4_ = chess_scene_get_game (self);
				_tmp5_ = chess_game_get_current_player (_tmp4_);
				if (_tmp5_->color == COLOR_WHITE) {
					_tmp3_ = 0.0;
				} else {
					_tmp3_ = 180.0;
				}
				result = _tmp3_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = 0.0;
				return result;
			}
		}
	}
}


const gchar* chess_scene_get_move_format (ChessScene* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_move_format;
	return result;
}


void chess_scene_set_move_format (ChessScene* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_move_format);
	self->priv->_move_format = _tmp0_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "move-format");
}


static void chess_scene_class_init (ChessSceneClass * klass) {
	chess_scene_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessScenePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_scene_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_scene_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_scene_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_GAME, param_spec_chess_game ("game", "game", "game", TYPE_CHESS_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_MOVE_NUMBER, g_param_spec_int ("move-number", "move-number", "move-number", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_NUMBERING, g_param_spec_boolean ("show-numbering", "show-numbering", "show-numbering", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_MOVE_HINTS, g_param_spec_boolean ("show-move-hints", "show-move-hints", "show-move-hints", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_THEME_NAME, g_param_spec_string ("theme-name", "theme-name", "theme-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_3D_SMOOTH, g_param_spec_boolean ("show-3d-smooth", "show-3d-smooth", "show-3d-smooth", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_BOARD_SIDE, g_param_spec_string ("board-side", "board-side", "board-side", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_BOARD_ANGLE, g_param_spec_double ("board-angle", "board-angle", "board-angle", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_MOVE_FORMAT, g_param_spec_string ("move-format", "move-format", "move-format", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("changed", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_scene_instance_init (ChessScene * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = CHESS_SCENE_GET_PRIVATE (self);
	self->pieces = NULL;
	self->animating = FALSE;
	self->selected_rank = -1;
	self->selected_file = -1;
	self->priv->_game = NULL;
	self->priv->_move_number = -1;
	self->priv->_show_numbering = TRUE;
	self->priv->_show_move_hints = TRUE;
	_tmp0_ = g_strdup ("simple");
	self->priv->_theme_name = _tmp0_;
	self->priv->_show_3d_smooth = FALSE;
	_tmp1_ = g_strdup ("human");
	self->priv->_board_side = _tmp1_;
	_tmp2_ = g_strdup ("human");
	self->priv->_move_format = _tmp2_;
}


static void chess_scene_finalize (GObject* obj) {
	ChessScene * self;
	self = CHESS_SCENE (obj);
	__g_list_free__chess_model_unref0_0 (self->pieces);
	_g_timer_destroy0 (self->priv->animation_timer);
	_chess_game_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme_name);
	_g_free0 (self->priv->_board_side);
	_g_free0 (self->priv->_move_format);
	G_OBJECT_CLASS (chess_scene_parent_class)->finalize (obj);
}


GType chess_scene_get_type (void) {
	static volatile gsize chess_scene_type_id__volatile = 0;
	if (g_once_init_enter (&chess_scene_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessSceneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_scene_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessScene), 0, (GInstanceInitFunc) chess_scene_instance_init, NULL };
		GType chess_scene_type_id;
		chess_scene_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessScene", &g_define_type_info, 0);
		g_once_init_leave (&chess_scene_type_id__volatile, chess_scene_type_id);
	}
	return chess_scene_type_id__volatile;
}


static void _vala_chess_scene_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessScene * self;
	self = CHESS_SCENE (object);
	switch (property_id) {
		case CHESS_SCENE_GAME:
		value_set_chess_game (value, chess_scene_get_game (self));
		break;
		case CHESS_SCENE_MOVE_NUMBER:
		g_value_set_int (value, chess_scene_get_move_number (self));
		break;
		case CHESS_SCENE_SHOW_NUMBERING:
		g_value_set_boolean (value, chess_scene_get_show_numbering (self));
		break;
		case CHESS_SCENE_SHOW_MOVE_HINTS:
		g_value_set_boolean (value, chess_scene_get_show_move_hints (self));
		break;
		case CHESS_SCENE_THEME_NAME:
		g_value_set_string (value, chess_scene_get_theme_name (self));
		break;
		case CHESS_SCENE_SHOW_3D_SMOOTH:
		g_value_set_boolean (value, chess_scene_get_show_3d_smooth (self));
		break;
		case CHESS_SCENE_BOARD_SIDE:
		g_value_set_string (value, chess_scene_get_board_side (self));
		break;
		case CHESS_SCENE_BOARD_ANGLE:
		g_value_set_double (value, chess_scene_get_board_angle (self));
		break;
		case CHESS_SCENE_MOVE_FORMAT:
		g_value_set_string (value, chess_scene_get_move_format (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_scene_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessScene * self;
	self = CHESS_SCENE (object);
	switch (property_id) {
		case CHESS_SCENE_GAME:
		chess_scene_set_game (self, value_get_chess_game (value));
		break;
		case CHESS_SCENE_MOVE_NUMBER:
		chess_scene_set_move_number (self, g_value_get_int (value));
		break;
		case CHESS_SCENE_SHOW_NUMBERING:
		chess_scene_set_show_numbering (self, g_value_get_boolean (value));
		break;
		case CHESS_SCENE_SHOW_MOVE_HINTS:
		chess_scene_set_show_move_hints (self, g_value_get_boolean (value));
		break;
		case CHESS_SCENE_THEME_NAME:
		chess_scene_set_theme_name (self, g_value_get_string (value));
		break;
		case CHESS_SCENE_SHOW_3D_SMOOTH:
		chess_scene_set_show_3d_smooth (self, g_value_get_boolean (value));
		break;
		case CHESS_SCENE_BOARD_SIDE:
		chess_scene_set_board_side (self, g_value_get_string (value));
		break;
		case CHESS_SCENE_MOVE_FORMAT:
		chess_scene_set_move_format (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



