/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

#ifndef __AGUTILPALMOS_H__
#define __AGUTILPALMOS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <AGTypes.h>

#ifdef __palmos__

#include <Pilot.h>
#include <sys_socket.h>
#include <sys_types.h>
#include <unix_string.h>
#include <unix_stdio.h>
#include <unix_stdlib.h>

ExportFunc char *AGStrDup(char *str);
#define strdup(str) AGStrDup((str))

#define strncmp(a, b, n) StrNCompare((a), (b), (n))
#define itoa(i, s, radix) StrIToA((s), (i))

ExportFunc void AGFreeFunc(void *ptr);
/* realloc definition in palm\unix_stdlib.h needs to be fixed. */
#ifdef realloc
#   undef realloc
#endif /* realloc */
ExportFunc void *AGRealloc(void *p, int32 s);
#define realloc(p, s) AGRealloc((p), (s))

#ifdef calloc
#   undef calloc
#endif /* calloc */
ExportFunc void *AGCalloc(size_t num, size_t size);
#define calloc(n, s) AGCalloc((n), (s))

#define isascii(c) (((c) >= 0) && ((c) <= 0x7f))
#define isspace(c) ((((c) >= 0x09) && ((c) <= 0x0d)) || ((c) == 0x20))
/*  The memcpy defined by palm would have the side effect of mallocing 
    twice and leaking in this case: bar = memcpy(malloc(5), foo, 5)
*/
#ifdef memcpy
#   undef memcpy
#endif /* memcpy */
#define memcpy(x,y,z) AGMemCopy(x,y,z)
ExportFunc void *AGMemCopy(void *dst, const void *src, size_t len);

#define stricmp(a, b) StrCaselessCompare((a), (b))
#endif /* __palmos__ */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __AGUTILPALMOS_H__ */






