/* $Id: mal-conduit.c,v 1.1.1.1 2000/02/28 04:51:41 eskil Exp $ */

#include <glib.h>
#include <gnome.h>

#include <pi-source.h>
#include <pi-socket.h>
#include <pi-mail.h>
#include <pi-dlp.h>
#include <pi-version.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <utime.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>

#include <gpilotd/gnome-pilot-conduit.h>
#include <gpilotd/gnome-pilot-conduit-standard.h>

#include <AGUtil.h>
#include <AGClientProcessor.h>
#include <AGProtocol.h>
#include <AGBufferReader.h>
#include <AGPalmProtocol.h>
#include <AGUserConfig.h>
#include <AGServerConfig.h>
#include <AGSyncCommon.h>
#include <AGCommandProcessor.h>
#include <AGDesktopInfoPalm.h>
#include <AGTimeoutMessageBox.h>
#include <AGMobileLinkSettings.h>

#include "mal-conduit.h"

#define CONDUIT_VERSION "0.2"

/* This structure is taken from MAL malsync.c. It is used to interact
   with various MAL calls */
typedef struct {
    AGDeviceInfo * deviceInfo;
    AGUserConfig * userConfig;
    AGServerConfig * currentServerConfig;
    AGClientProcessor * clientProcessor;

    AGPlatformCalls * platform;
    AGRecord * record;
    AGDBConfig * currentDb;
    AGCommandProcessor *commandProcessor;
    AGBool quit;
    
    /* Pilot-specific */
    AGBool currentDBIsResourceType;
    int pilot_rHandle;
    int pilot_RecIndex;
    recordid_t id;
    uint8  *pilot_buffer;
    int pilot_buffer_size;
    
    /* Secure Network Library Stuff */
    AGBool          hasseclib;

} PalmSyncInfo;

typedef sword (*netInitFunc)(AGNetCtx *ctx);
typedef sword (*netCloseFunc)(AGNetCtx *ctx);
typedef int32 (*netCtxSizeFunc)(void);
typedef void  (*netPreSyncHook) (AGNetCtx *ctx, 
                                AGServerConfig *sc,
                                AGLocationConfig *lc,
                                AGSyncProcessor *sp,
                                AGBool connectSecure);
typedef void  (*netPostSyncHook) (AGNetCtx *ctx, 
                                 AGServerConfig *sc,
                                 AGLocationConfig *lc,
                                 AGSyncProcessor *sp,
                                 AGBool connectSecure);

extern netInitFunc     secnetinit;
extern netCloseFunc    secnetclose;
extern netCtxSizeFunc  secctxsize;
extern netPreSyncHook  secnetpresync;
extern netPostSyncHook  secnetpostsync;

extern int sd;
static int daemon_mode = 0;
static int verbose = 1;

static gint synchronize( GnomePilotConduit *c, GnomePilotDBInfo *dbi ) 
{
	PalmSyncInfo *pInfo;
	uint32 pilotID;
	AGNetCtx *ctx;

	g_message("MALconduit %s",CONDUIT_VERSION);

	pilotID = dbi->pu->userID;
	sd = dbi->pilot_socket;

	pInfo = syncInfoNew();
	if(loadSecLib()) {
		ctx = calloc(1,(*secctxsize)());
		(*secnetinit)(ctx);
	} else {
		ctx = calloc(1,sizeof(AGNetCtx));
		AGNetInit(ctx);
	}

	if(setupPlatformCalls(pInfo)) {
		return -1;
	}

	pInfo->userConfig = getUserConfig(&pilotID);
	doClientProcessorLoop(pInfo, ctx);
	storeDeviceUserConfig(pInfo->userConfig, pilotID);

        if (secnetclose) {
            (*secnetclose)(ctx);
        } else {
            AGNetClose(ctx);
        }
        
        syncInfoFree(pInfo);
        free(ctx);
	
}


static gint copy_from_pilot( GnomePilotConduit *c, GnomePilotDBInfo *dbi ) {
}

GnomePilotConduit *conduit_get_gpilot_conduit( guint32 pilotId ) 
{
  GtkObject *retval;
/*
  ConduitCfg *cc;
*/

  retval = gnome_pilot_conduit_standard_new("AvantGo",0x4176476f);
  gnome_pilot_conduit_construct(GNOME_PILOT_CONDUIT(retval),"MAL");
  g_assert(retval != NULL);
  gtk_signal_connect(retval, "synchronize", (GtkSignalFunc)synchronize ,NULL);
/*
  load_config(&cc, pilotId );
  gtk_object_set_data(retval,"conduit_config",(gpointer)cc);
*/
  return GNOME_PILOT_CONDUIT(retval); 
}


void conduit_destroy_gpilot_conduit( GnomePilotConduit *c ) 
{
#if 0
  ConduitCfg *cc;
  
  cc = GET_CONFIG(c);
  destroy_configuration( &cc );
#endif
  gtk_object_destroy(GTK_OBJECT(c));
}

