/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>


#define GNOME_SCAN_TYPE_OPTION_HINT (gnome_scan_option_hint_get_type ())

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;
typedef struct _GnomeScanOptionPrivate GnomeScanOptionPrivate;

#define GNOME_SCAN_TYPE_UNIT (gnome_scan_unit_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define GNOME_SCAN_TYPE_OPTION_BOOL (gnome_scan_option_bool_get_type ())
#define GNOME_SCAN_OPTION_BOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBool))
#define GNOME_SCAN_OPTION_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolClass))
#define GNOME_SCAN_IS_OPTION_BOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOOL))
#define GNOME_SCAN_IS_OPTION_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOOL))
#define GNOME_SCAN_OPTION_BOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolClass))

typedef struct _GnomeScanOptionBool GnomeScanOptionBool;
typedef struct _GnomeScanOptionBoolClass GnomeScanOptionBoolClass;
typedef struct _GnomeScanOptionBoolPrivate GnomeScanOptionBoolPrivate;

#define GNOME_SCAN_TYPE_OPTION_NUMBER (gnome_scan_option_number_get_type ())
#define GNOME_SCAN_OPTION_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumber))
#define GNOME_SCAN_OPTION_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumberClass))
#define GNOME_SCAN_IS_OPTION_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER))
#define GNOME_SCAN_IS_OPTION_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_NUMBER))
#define GNOME_SCAN_OPTION_NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumberClass))

typedef struct _GnomeScanOptionNumber GnomeScanOptionNumber;
typedef struct _GnomeScanOptionNumberClass GnomeScanOptionNumberClass;
typedef struct _GnomeScanOptionNumberPrivate GnomeScanOptionNumberPrivate;

#define GNOME_SCAN_TYPE_RANGE (gnome_scan_range_get_type ())
typedef struct _GnomeScanRange GnomeScanRange;

#define GNOME_SCAN_TYPE_OPTION_STRING (gnome_scan_option_string_get_type ())
#define GNOME_SCAN_OPTION_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionString))
#define GNOME_SCAN_OPTION_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringClass))
#define GNOME_SCAN_IS_OPTION_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_STRING))
#define GNOME_SCAN_IS_OPTION_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_STRING))
#define GNOME_SCAN_OPTION_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringClass))

typedef struct _GnomeScanOptionString GnomeScanOptionString;
typedef struct _GnomeScanOptionStringClass GnomeScanOptionStringClass;
typedef struct _GnomeScanOptionStringPrivate GnomeScanOptionStringPrivate;

#define GNOME_SCAN_TYPE_OPTION_ENUM (gnome_scan_option_enum_get_type ())
#define GNOME_SCAN_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnum))
#define GNOME_SCAN_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))
#define GNOME_SCAN_IS_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_IS_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_OPTION_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))

typedef struct _GnomeScanOptionEnum GnomeScanOptionEnum;
typedef struct _GnomeScanOptionEnumClass GnomeScanOptionEnumClass;
typedef struct _GnomeScanOptionEnumPrivate GnomeScanOptionEnumPrivate;

#define GNOME_SCAN_TYPE_ENUM_VALUE (gnome_scan_enum_value_get_type ())
typedef struct _GnomeScanEnumValue GnomeScanEnumValue;

#define GNOME_SCAN_TYPE_OPTION_PAPER_SIZE (gnome_scan_option_paper_size_get_type ())
#define GNOME_SCAN_OPTION_PAPER_SIZE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GnomeScanOptionPaperSize))
#define GNOME_SCAN_OPTION_PAPER_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GnomeScanOptionPaperSizeClass))
#define GNOME_SCAN_IS_OPTION_PAPER_SIZE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE))
#define GNOME_SCAN_IS_OPTION_PAPER_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE))
#define GNOME_SCAN_OPTION_PAPER_SIZE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GnomeScanOptionPaperSizeClass))

typedef struct _GnomeScanOptionPaperSize GnomeScanOptionPaperSize;
typedef struct _GnomeScanOptionPaperSizeClass GnomeScanOptionPaperSizeClass;
typedef struct _GnomeScanOptionPaperSizePrivate GnomeScanOptionPaperSizePrivate;

#define GNOME_SCAN_TYPE_EXTENT (gnome_scan_extent_get_type ())
typedef struct _GnomeScanExtent GnomeScanExtent;

#define GNOME_SCAN_TYPE_OPTION_BOXED (gnome_scan_option_boxed_get_type ())
#define GNOME_SCAN_OPTION_BOXED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxed))
#define GNOME_SCAN_OPTION_BOXED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxedClass))
#define GNOME_SCAN_IS_OPTION_BOXED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOXED))
#define GNOME_SCAN_IS_OPTION_BOXED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOXED))
#define GNOME_SCAN_OPTION_BOXED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxedClass))

typedef struct _GnomeScanOptionBoxed GnomeScanOptionBoxed;
typedef struct _GnomeScanOptionBoxedClass GnomeScanOptionBoxedClass;
typedef struct _GnomeScanOptionBoxedPrivate GnomeScanOptionBoxedPrivate;

#define GNOME_SCAN_TYPE_OPTION_POINTER (gnome_scan_option_pointer_get_type ())
#define GNOME_SCAN_OPTION_POINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointer))
#define GNOME_SCAN_OPTION_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointerClass))
#define GNOME_SCAN_IS_OPTION_POINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_POINTER))
#define GNOME_SCAN_IS_OPTION_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_POINTER))
#define GNOME_SCAN_OPTION_POINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointerClass))

typedef struct _GnomeScanOptionPointer GnomeScanOptionPointer;
typedef struct _GnomeScanOptionPointerClass GnomeScanOptionPointerClass;
typedef struct _GnomeScanOptionPointerPrivate GnomeScanOptionPointerPrivate;

typedef enum  {
	GNOME_SCAN_OPTION_HINT_HIDDEN,
	GNOME_SCAN_OPTION_HINT_PRIMARY,
	GNOME_SCAN_OPTION_HINT_SECONDARY,
	GNOME_SCAN_OPTION_HINT_PREVIEW,
	GNOME_SCAN_OPTION_HINT_REPEAT
} GnomeScanOptionHint;

struct _GnomeScanOption {
	GObject parent_instance;
	GnomeScanOptionPrivate * priv;
};

struct _GnomeScanOptionClass {
	GObjectClass parent_class;
	void (*set_g_value) (GnomeScanOption* self, const GValue* value);
};

typedef enum  {
	GNOME_SCAN_UNIT_NONE = -1,
	GNOME_SCAN_UNIT_PIXEL,
	GNOME_SCAN_UNIT_POINTS,
	GNOME_SCAN_UNIT_INCH,
	GNOME_SCAN_UNIT_MM,
	GNOME_SCAN_UNIT_BIT,
	GNOME_SCAN_UNIT_DPI,
	GNOME_SCAN_UNIT_PERCENT,
	GNOME_SCAN_UNIT_MICROSECOND
} GnomeScanUnit;

struct _GnomeScanOptionPrivate {
	char* _name;
	char* _title;
	char* _desc;
	char* _group;
	char* _domain;
	GnomeScanUnit _unit;
	GnomeScanOptionHint _hint;
	gboolean _active;
};

struct _GnomeScanOptionBool {
	GnomeScanOption parent_instance;
	GnomeScanOptionBoolPrivate * priv;
};

struct _GnomeScanOptionBoolClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionBoolPrivate {
	gboolean _value;
};

struct _GnomeScanOptionNumber {
	GnomeScanOption parent_instance;
	GnomeScanOptionNumberPrivate * priv;
};

struct _GnomeScanOptionNumberClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanRange {
	double min;
	double step;
	double max;
};

struct _GnomeScanOptionNumberPrivate {
	double _value;
	GnomeScanRange _range;
};

struct _GnomeScanOptionString {
	GnomeScanOption parent_instance;
	GnomeScanOptionStringPrivate * priv;
};

struct _GnomeScanOptionStringClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionStringPrivate {
	char* _value;
};

struct _GnomeScanEnumValue {
	GValue value;
	char* label;
	char* domain;
};

struct _GnomeScanOptionEnum {
	GnomeScanOption parent_instance;
	GnomeScanOptionEnumPrivate * priv;
};

struct _GnomeScanOptionEnumClass {
	GnomeScanOptionClass parent_class;
	void (*append) (GnomeScanOptionEnum* self, const GnomeScanEnumValue* value);
};

struct _GnomeScanOptionEnumPrivate {
	GnomeScanEnumValue _value;
	GSList* _values;
};

struct _GnomeScanOptionPaperSize {
	GnomeScanOptionEnum parent_instance;
	GnomeScanOptionPaperSizePrivate * priv;
};

struct _GnomeScanOptionPaperSizeClass {
	GnomeScanOptionEnumClass parent_class;
};

struct _GnomeScanExtent {
	double width;
	double height;
};

struct _GnomeScanOptionPaperSizePrivate {
	GnomeScanExtent _extent;
};

struct _GnomeScanOptionBoxed {
	GnomeScanOption parent_instance;
	GnomeScanOptionBoxedPrivate * priv;
};

struct _GnomeScanOptionBoxedClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionBoxedPrivate {
	GValue _value;
};

struct _GnomeScanOptionPointer {
	GnomeScanOption parent_instance;
	GnomeScanOptionPointerPrivate * priv;
};

struct _GnomeScanOptionPointerClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionPointerPrivate {
	void* _value;
};


static gpointer gnome_scan_option_parent_class = NULL;
static gpointer gnome_scan_option_bool_parent_class = NULL;
static gpointer gnome_scan_option_number_parent_class = NULL;
static gpointer gnome_scan_option_string_parent_class = NULL;
static gpointer gnome_scan_option_enum_parent_class = NULL;
static gpointer gnome_scan_option_paper_size_parent_class = NULL;
static gpointer gnome_scan_option_boxed_parent_class = NULL;
static gpointer gnome_scan_option_pointer_parent_class = NULL;

#define GNOME_SCAN_OPTION_GROUP_SCANNER N_ ("Scan Options")
#define GNOME_SCAN_OPTION_GROUP_SINK N_ ("Output Options")
#define GNOME_SCAN_OPTION_GROUP_FORMAT N_ ("Format")
GType gnome_scan_option_hint_get_type (void);
GType gnome_scan_option_get_type (void);
GType gnome_scan_unit_get_type (void);
#define GNOME_SCAN_OPTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionPrivate))
enum  {
	GNOME_SCAN_OPTION_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_NAME,
	GNOME_SCAN_OPTION_TITLE,
	GNOME_SCAN_OPTION_DESC,
	GNOME_SCAN_OPTION_GROUP,
	GNOME_SCAN_OPTION_DOMAIN,
	GNOME_SCAN_OPTION_UNIT,
	GNOME_SCAN_OPTION_HINT,
	GNOME_SCAN_OPTION_ACTIVE
};
void gnome_scan_option_set_g_value (GnomeScanOption* self, const GValue* value);
static void gnome_scan_option_real_set_g_value (GnomeScanOption* self, const GValue* value);
gboolean gnome_scan_option_copy_or_transform_g_value (GnomeScanOption* self, const GValue* src, GValue* dest);
GnomeScanOption* gnome_scan_option_construct (GType object_type);
const char* gnome_scan_option_get_name (GnomeScanOption* self);
void gnome_scan_option_set_name (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_title (GnomeScanOption* self);
void gnome_scan_option_set_title (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_desc (GnomeScanOption* self);
void gnome_scan_option_set_desc (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_group (GnomeScanOption* self);
void gnome_scan_option_set_group (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_domain (GnomeScanOption* self);
void gnome_scan_option_set_domain (GnomeScanOption* self, const char* value);
GnomeScanUnit gnome_scan_option_get_unit (GnomeScanOption* self);
void gnome_scan_option_set_unit (GnomeScanOption* self, GnomeScanUnit value);
GnomeScanOptionHint gnome_scan_option_get_hint (GnomeScanOption* self);
void gnome_scan_option_set_hint (GnomeScanOption* self, GnomeScanOptionHint value);
gboolean gnome_scan_option_get_active (GnomeScanOption* self);
void gnome_scan_option_set_active (GnomeScanOption* self, gboolean value);
static void gnome_scan_option_finalize (GObject* obj);
static void gnome_scan_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gnome_scan_option_bool_get_type (void);
#define GNOME_SCAN_OPTION_BOOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolPrivate))
enum  {
	GNOME_SCAN_OPTION_BOOL_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_BOOL_VALUE
};
void gnome_scan_option_bool_set_value (GnomeScanOptionBool* self, gboolean value);
GnomeScanOptionBool* gnome_scan_option_bool_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, gboolean value, GnomeScanOptionHint hint);
GnomeScanOptionBool* gnome_scan_option_bool_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, gboolean value, GnomeScanOptionHint hint);
static void gnome_scan_option_bool_real_set_g_value (GnomeScanOption* base, const GValue* value);
gboolean gnome_scan_option_bool_get_value (GnomeScanOptionBool* self);
static void gnome_scan_option_bool_finalize (GObject* obj);
static void gnome_scan_option_bool_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_option_bool_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gnome_scan_option_number_get_type (void);
GType gnome_scan_range_get_type (void);
GnomeScanRange* gnome_scan_range_dup (const GnomeScanRange* self);
void gnome_scan_range_free (GnomeScanRange* self);
#define GNOME_SCAN_OPTION_NUMBER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_NUMBER, GnomeScanOptionNumberPrivate))
enum  {
	GNOME_SCAN_OPTION_NUMBER_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_NUMBER_VALUE,
	GNOME_SCAN_OPTION_NUMBER_RANGE
};
void gnome_scan_option_number_set_range (GnomeScanOptionNumber* self, GnomeScanRange* value);
void gnome_scan_option_number_set_value (GnomeScanOptionNumber* self, double value);
GnomeScanOptionNumber* gnome_scan_option_number_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, double value, const GnomeScanRange* range, GnomeScanUnit unit, GnomeScanOptionHint hint);
GnomeScanOptionNumber* gnome_scan_option_number_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, double value, const GnomeScanRange* range, GnomeScanUnit unit, GnomeScanOptionHint hint);
static void gnome_scan_option_number_real_set_g_value (GnomeScanOption* base, const GValue* value);
double gnome_scan_option_number_get_value (GnomeScanOptionNumber* self);
void gnome_scan_option_number_get_range (GnomeScanOptionNumber* self, GnomeScanRange* result);
static void gnome_scan_option_number_finalize (GObject* obj);
static void gnome_scan_option_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_option_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gnome_scan_option_string_get_type (void);
#define GNOME_SCAN_OPTION_STRING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringPrivate))
enum  {
	GNOME_SCAN_OPTION_STRING_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_STRING_VALUE
};
void gnome_scan_option_string_set_value (GnomeScanOptionString* self, const char* value);
GnomeScanOptionString* gnome_scan_option_string_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const char* value, GnomeScanOptionHint hint);
GnomeScanOptionString* gnome_scan_option_string_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const char* value, GnomeScanOptionHint hint);
const char* gnome_scan_option_string_get_value (GnomeScanOptionString* self);
static void gnome_scan_option_string_finalize (GObject* obj);
static void gnome_scan_option_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_option_string_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gnome_scan_option_enum_get_type (void);
GType gnome_scan_enum_value_get_type (void);
GnomeScanEnumValue* gnome_scan_enum_value_dup (const GnomeScanEnumValue* self);
void gnome_scan_enum_value_free (GnomeScanEnumValue* self);
void gnome_scan_enum_value_copy (const GnomeScanEnumValue* self, GnomeScanEnumValue* dest);
void gnome_scan_enum_value_destroy (GnomeScanEnumValue* self);
#define GNOME_SCAN_OPTION_ENUM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumPrivate))
enum  {
	GNOME_SCAN_OPTION_ENUM_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_ENUM_VALUE,
	GNOME_SCAN_OPTION_ENUM_VALUES
};
void gnome_scan_option_enum_set_values (GnomeScanOptionEnum* self, GSList* value);
void gnome_scan_option_enum_set_value (GnomeScanOptionEnum* self, GnomeScanEnumValue* value);
GnomeScanOptionEnum* gnome_scan_option_enum_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint);
GnomeScanOptionEnum* gnome_scan_option_enum_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint);
GSList* gnome_scan_option_enum_get_values (GnomeScanOptionEnum* self);
void gnome_scan_option_enum_append (GnomeScanOptionEnum* self, const GnomeScanEnumValue* value);
static void gnome_scan_option_enum_real_append (GnomeScanOptionEnum* self, const GnomeScanEnumValue* value);
void gnome_scan_option_enum_get_value (GnomeScanOptionEnum* self, GnomeScanEnumValue* result);
static void gnome_scan_option_enum_finalize (GObject* obj);
static void gnome_scan_option_enum_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_option_enum_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gnome_scan_option_paper_size_get_type (void);
GType gnome_scan_extent_get_type (void);
GnomeScanExtent* gnome_scan_extent_dup (const GnomeScanExtent* self);
void gnome_scan_extent_free (GnomeScanExtent* self);
#define GNOME_SCAN_OPTION_PAPER_SIZE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, GnomeScanOptionPaperSizePrivate))
enum  {
	GNOME_SCAN_OPTION_PAPER_SIZE_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_PAPER_SIZE_EXTENT
};
void gnome_scan_option_paper_size_set_extent (GnomeScanOptionPaperSize* self, GnomeScanExtent* value);
GnomeScanOptionPaperSize* gnome_scan_option_paper_size_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanExtent* extent, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint);
GnomeScanOptionPaperSize* gnome_scan_option_paper_size_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanExtent* extent, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint);
void gnome_scan_option_paper_size_get_extent (GnomeScanOptionPaperSize* self, GnomeScanExtent* result);
static void gnome_scan_option_paper_size_real_append (GnomeScanOptionEnum* base, const GnomeScanEnumValue* value);
static void gnome_scan_option_paper_size_finalize (GObject* obj);
static void gnome_scan_option_paper_size_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_option_paper_size_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gnome_scan_option_boxed_get_type (void);
#define GNOME_SCAN_OPTION_BOXED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxedPrivate))
enum  {
	GNOME_SCAN_OPTION_BOXED_DUMMY_PROPERTY
};
static void gnome_scan_option_boxed_set_value (GnomeScanOptionBoxed* self, GValue* value);
GnomeScanOptionBoxed* gnome_scan_option_boxed_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GValue* value, GnomeScanOptionHint hint);
GnomeScanOptionBoxed* gnome_scan_option_boxed_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GValue* value, GnomeScanOptionHint hint);
static void gnome_scan_option_boxed_get_value (GnomeScanOptionBoxed* self, GValue* result);
static void gnome_scan_option_boxed_finalize (GObject* obj);
static void gnome_scan_option_boxed_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_option_boxed_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gnome_scan_option_pointer_get_type (void);
#define GNOME_SCAN_OPTION_POINTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointerPrivate))
enum  {
	GNOME_SCAN_OPTION_POINTER_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_POINTER_VALUE
};
void gnome_scan_option_pointer_set_value (GnomeScanOptionPointer* self, void* value);
GnomeScanOptionPointer* gnome_scan_option_pointer_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, void* value, GnomeScanOptionHint hint);
GnomeScanOptionPointer* gnome_scan_option_pointer_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, void* value, GnomeScanOptionHint hint);
void* gnome_scan_option_pointer_get_value (GnomeScanOptionPointer* self);
static void gnome_scan_option_pointer_finalize (GObject* obj);
static void gnome_scan_option_pointer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_option_pointer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType gnome_scan_option_hint_get_type (void) {
	static GType gnome_scan_option_hint_type_id = 0;
	if (G_UNLIKELY (gnome_scan_option_hint_type_id == 0)) {
		static const GEnumValue values[] = {{GNOME_SCAN_OPTION_HINT_HIDDEN, "GNOME_SCAN_OPTION_HINT_HIDDEN", "hidden"}, {GNOME_SCAN_OPTION_HINT_PRIMARY, "GNOME_SCAN_OPTION_HINT_PRIMARY", "primary"}, {GNOME_SCAN_OPTION_HINT_SECONDARY, "GNOME_SCAN_OPTION_HINT_SECONDARY", "secondary"}, {GNOME_SCAN_OPTION_HINT_PREVIEW, "GNOME_SCAN_OPTION_HINT_PREVIEW", "preview"}, {GNOME_SCAN_OPTION_HINT_REPEAT, "GNOME_SCAN_OPTION_HINT_REPEAT", "repeat"}, {0, NULL, NULL}};
		gnome_scan_option_hint_type_id = g_enum_register_static ("GnomeScanOptionHint", values);
	}
	return gnome_scan_option_hint_type_id;
}


static void gnome_scan_option_real_set_g_value (GnomeScanOption* self, const GValue* value) {
	g_return_if_fail (self != NULL);
}


void gnome_scan_option_set_g_value (GnomeScanOption* self, const GValue* value) {
	GNOME_SCAN_OPTION_GET_CLASS (self)->set_g_value (self, value);
}


gboolean gnome_scan_option_copy_or_transform_g_value (GnomeScanOption* self, const GValue* src, GValue* dest) {
	gboolean result;
	GType stype;
	GType dtype;
	g_return_val_if_fail (self != NULL, FALSE);
	stype = G_VALUE_TYPE (&(*src));
	dtype = G_VALUE_TYPE (&(*dest));
	if (g_value_type_compatible (stype, dtype)) {
		g_value_copy (&(*src), &(*dest));
		result = TRUE;
		return result;
	} else {
		if (g_value_type_transformable (stype, dtype)) {
			g_value_transform (&(*src), &(*dest));
			result = TRUE;
			return result;
		} else {
			g_warning ("gnome-scan-option.vala:74: Unable to set %s value for %s", g_type_name (stype), g_type_name (dtype));
			result = FALSE;
			return result;
		}
	}
}


GnomeScanOption* gnome_scan_option_construct (GType object_type) {
	GnomeScanOption * self;
	self = (GnomeScanOption*) g_object_new (object_type, NULL);
	return self;
}


const char* gnome_scan_option_get_name (GnomeScanOption* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void gnome_scan_option_set_name (GnomeScanOption* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
	g_object_notify ((GObject *) self, "name");
}


const char* gnome_scan_option_get_title (GnomeScanOption* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_title;
	return result;
}


void gnome_scan_option_set_title (GnomeScanOption* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_title = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_title), _tmp0_);
	g_object_notify ((GObject *) self, "title");
}


const char* gnome_scan_option_get_desc (GnomeScanOption* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_desc;
	return result;
}


void gnome_scan_option_set_desc (GnomeScanOption* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_desc = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_desc), _tmp0_);
	g_object_notify ((GObject *) self, "desc");
}


const char* gnome_scan_option_get_group (GnomeScanOption* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_group;
	return result;
}


void gnome_scan_option_set_group (GnomeScanOption* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_group = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_group), _tmp0_);
	g_object_notify ((GObject *) self, "group");
}


const char* gnome_scan_option_get_domain (GnomeScanOption* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_domain;
	return result;
}


void gnome_scan_option_set_domain (GnomeScanOption* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_domain = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_domain), _tmp0_);
	g_object_notify ((GObject *) self, "domain");
}


GnomeScanUnit gnome_scan_option_get_unit (GnomeScanOption* self) {
	GnomeScanUnit result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_unit;
	return result;
}


void gnome_scan_option_set_unit (GnomeScanOption* self, GnomeScanUnit value) {
	g_return_if_fail (self != NULL);
	self->priv->_unit = value;
	g_object_notify ((GObject *) self, "unit");
}


GnomeScanOptionHint gnome_scan_option_get_hint (GnomeScanOption* self) {
	GnomeScanOptionHint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_hint;
	return result;
}


void gnome_scan_option_set_hint (GnomeScanOption* self, GnomeScanOptionHint value) {
	g_return_if_fail (self != NULL);
	self->priv->_hint = value;
	g_object_notify ((GObject *) self, "hint");
}


gboolean gnome_scan_option_get_active (GnomeScanOption* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void gnome_scan_option_set_active (GnomeScanOption* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


static void gnome_scan_option_class_init (GnomeScanOptionClass * klass) {
	gnome_scan_option_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionPrivate));
	GNOME_SCAN_OPTION_CLASS (klass)->set_g_value = gnome_scan_option_real_set_g_value;
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_DESC, g_param_spec_string ("desc", "desc", "desc", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_GROUP, g_param_spec_string ("group", "group", "group", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_DOMAIN, g_param_spec_string ("domain", "domain", "domain", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_UNIT, g_param_spec_enum ("unit", "unit", "unit", GNOME_SCAN_TYPE_UNIT, GNOME_SCAN_UNIT_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_HINT, g_param_spec_enum ("hint", "hint", "hint", GNOME_SCAN_TYPE_OPTION_HINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_ACTIVE, g_param_spec_boolean ("active", "active", "active", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_instance_init (GnomeScanOption * self) {
	self->priv = GNOME_SCAN_OPTION_GET_PRIVATE (self);
	self->priv->_unit = GNOME_SCAN_UNIT_NONE;
	self->priv->_active = TRUE;
}


static void gnome_scan_option_finalize (GObject* obj) {
	GnomeScanOption * self;
	self = GNOME_SCAN_OPTION (obj);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_desc);
	_g_free0 (self->priv->_group);
	_g_free0 (self->priv->_domain);
	G_OBJECT_CLASS (gnome_scan_option_parent_class)->finalize (obj);
}


GType gnome_scan_option_get_type (void) {
	static GType gnome_scan_option_type_id = 0;
	if (gnome_scan_option_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOption), 0, (GInstanceInitFunc) gnome_scan_option_instance_init, NULL };
		gnome_scan_option_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomeScanOption", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_option_type_id;
}


static void gnome_scan_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOption * self;
	self = GNOME_SCAN_OPTION (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_NAME:
		g_value_set_string (value, gnome_scan_option_get_name (self));
		break;
		case GNOME_SCAN_OPTION_TITLE:
		g_value_set_string (value, gnome_scan_option_get_title (self));
		break;
		case GNOME_SCAN_OPTION_DESC:
		g_value_set_string (value, gnome_scan_option_get_desc (self));
		break;
		case GNOME_SCAN_OPTION_GROUP:
		g_value_set_string (value, gnome_scan_option_get_group (self));
		break;
		case GNOME_SCAN_OPTION_DOMAIN:
		g_value_set_string (value, gnome_scan_option_get_domain (self));
		break;
		case GNOME_SCAN_OPTION_UNIT:
		g_value_set_enum (value, gnome_scan_option_get_unit (self));
		break;
		case GNOME_SCAN_OPTION_HINT:
		g_value_set_enum (value, gnome_scan_option_get_hint (self));
		break;
		case GNOME_SCAN_OPTION_ACTIVE:
		g_value_set_boolean (value, gnome_scan_option_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOption * self;
	self = GNOME_SCAN_OPTION (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_NAME:
		gnome_scan_option_set_name (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_TITLE:
		gnome_scan_option_set_title (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_DESC:
		gnome_scan_option_set_desc (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_GROUP:
		gnome_scan_option_set_group (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_DOMAIN:
		gnome_scan_option_set_domain (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_UNIT:
		gnome_scan_option_set_unit (self, g_value_get_enum (value));
		break;
		case GNOME_SCAN_OPTION_HINT:
		gnome_scan_option_set_hint (self, g_value_get_enum (value));
		break;
		case GNOME_SCAN_OPTION_ACTIVE:
		gnome_scan_option_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GnomeScanOptionBool* gnome_scan_option_bool_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, gboolean value, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionBool * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_bool_set_value (self, value);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionBool* gnome_scan_option_bool_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, gboolean value, GnomeScanOptionHint hint) {
	return gnome_scan_option_bool_construct (GNOME_SCAN_TYPE_OPTION_BOOL, name, title, desc, group, domain, value, hint);
}


static void gnome_scan_option_bool_real_set_g_value (GnomeScanOption* base, const GValue* value) {
	GnomeScanOptionBool * self;
	GValue _tmp0_ = {0};
	GValue oval;
	self = (GnomeScanOptionBool*) base;
	oval = (g_value_init (&_tmp0_, G_TYPE_BOOLEAN), _tmp0_);
	if (gnome_scan_option_copy_or_transform_g_value ((GnomeScanOption*) self, &(*value), &oval)) {
		gnome_scan_option_bool_set_value (self, g_value_get_boolean (&oval));
	}
	G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
}


gboolean gnome_scan_option_bool_get_value (GnomeScanOptionBool* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_value;
	return result;
}


void gnome_scan_option_bool_set_value (GnomeScanOptionBool* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
	g_object_notify ((GObject *) self, "value");
}


static void gnome_scan_option_bool_class_init (GnomeScanOptionBoolClass * klass) {
	gnome_scan_option_bool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionBoolPrivate));
	GNOME_SCAN_OPTION_CLASS (klass)->set_g_value = gnome_scan_option_bool_real_set_g_value;
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_bool_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_bool_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_bool_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_BOOL_VALUE, g_param_spec_boolean ("value", "value", "value", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_bool_instance_init (GnomeScanOptionBool * self) {
	self->priv = GNOME_SCAN_OPTION_BOOL_GET_PRIVATE (self);
}


static void gnome_scan_option_bool_finalize (GObject* obj) {
	GnomeScanOptionBool * self;
	self = GNOME_SCAN_OPTION_BOOL (obj);
	G_OBJECT_CLASS (gnome_scan_option_bool_parent_class)->finalize (obj);
}


GType gnome_scan_option_bool_get_type (void) {
	static GType gnome_scan_option_bool_type_id = 0;
	if (gnome_scan_option_bool_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionBoolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_bool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionBool), 0, (GInstanceInitFunc) gnome_scan_option_bool_instance_init, NULL };
		gnome_scan_option_bool_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionBool", &g_define_type_info, 0);
	}
	return gnome_scan_option_bool_type_id;
}


static void gnome_scan_option_bool_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBool * self;
	self = GNOME_SCAN_OPTION_BOOL (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_BOOL_VALUE:
		g_value_set_boolean (value, gnome_scan_option_bool_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_bool_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBool * self;
	self = GNOME_SCAN_OPTION_BOOL (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_BOOL_VALUE:
		gnome_scan_option_bool_set_value (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GnomeScanOptionNumber* gnome_scan_option_number_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, double value, const GnomeScanRange* range, GnomeScanUnit unit, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionNumber * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	__params = g_new0 (GParameter, 8);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "range";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_RANGE);
	g_value_set_boxed (&__params_it->value, &(*range));
	__params_it++;
	__params_it->name = "unit";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_UNIT);
	g_value_set_enum (&__params_it->value, unit);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_number_set_value (self, value);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionNumber* gnome_scan_option_number_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, double value, const GnomeScanRange* range, GnomeScanUnit unit, GnomeScanOptionHint hint) {
	return gnome_scan_option_number_construct (GNOME_SCAN_TYPE_OPTION_NUMBER, name, title, desc, group, domain, value, range, unit, hint);
}


static void gnome_scan_option_number_real_set_g_value (GnomeScanOption* base, const GValue* value) {
	GnomeScanOptionNumber * self;
	GValue _tmp0_ = {0};
	GValue oval;
	self = (GnomeScanOptionNumber*) base;
	oval = (g_value_init (&_tmp0_, G_TYPE_DOUBLE), _tmp0_);
	if (gnome_scan_option_copy_or_transform_g_value ((GnomeScanOption*) self, &(*value), &oval)) {
		gnome_scan_option_number_set_value (self, g_value_get_double (&oval));
	}
	G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
}


double gnome_scan_option_number_get_value (GnomeScanOptionNumber* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_value;
	return result;
}


void gnome_scan_option_number_set_value (GnomeScanOptionNumber* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
	g_object_notify ((GObject *) self, "value");
}


void gnome_scan_option_number_get_range (GnomeScanOptionNumber* self, GnomeScanRange* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_range;
	return;
}


void gnome_scan_option_number_set_range (GnomeScanOptionNumber* self, GnomeScanRange* value) {
	g_return_if_fail (self != NULL);
	self->priv->_range = (*value);
	g_object_notify ((GObject *) self, "range");
}


static void gnome_scan_option_number_class_init (GnomeScanOptionNumberClass * klass) {
	gnome_scan_option_number_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionNumberPrivate));
	GNOME_SCAN_OPTION_CLASS (klass)->set_g_value = gnome_scan_option_number_real_set_g_value;
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_number_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_number_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_number_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_NUMBER_VALUE, g_param_spec_double ("value", "value", "value", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_NUMBER_RANGE, g_param_spec_boxed ("range", "range", "range", GNOME_SCAN_TYPE_RANGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_option_number_instance_init (GnomeScanOptionNumber * self) {
	self->priv = GNOME_SCAN_OPTION_NUMBER_GET_PRIVATE (self);
}


static void gnome_scan_option_number_finalize (GObject* obj) {
	GnomeScanOptionNumber * self;
	self = GNOME_SCAN_OPTION_NUMBER (obj);
	G_OBJECT_CLASS (gnome_scan_option_number_parent_class)->finalize (obj);
}


GType gnome_scan_option_number_get_type (void) {
	static GType gnome_scan_option_number_type_id = 0;
	if (gnome_scan_option_number_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionNumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionNumber), 0, (GInstanceInitFunc) gnome_scan_option_number_instance_init, NULL };
		gnome_scan_option_number_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionNumber", &g_define_type_info, 0);
	}
	return gnome_scan_option_number_type_id;
}


static void gnome_scan_option_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionNumber * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_NUMBER (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_NUMBER_VALUE:
		g_value_set_double (value, gnome_scan_option_number_get_value (self));
		break;
		case GNOME_SCAN_OPTION_NUMBER_RANGE:
		boxed = g_new0 (GnomeScanRange, 1);
		gnome_scan_option_number_get_range (self, boxed);
		g_value_take_boxed (value, boxed);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionNumber * self;
	self = GNOME_SCAN_OPTION_NUMBER (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_NUMBER_VALUE:
		gnome_scan_option_number_set_value (self, g_value_get_double (value));
		break;
		case GNOME_SCAN_OPTION_NUMBER_RANGE:
		gnome_scan_option_number_set_range (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GnomeScanOptionString* gnome_scan_option_string_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const char* value, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionString * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_string_set_value (self, value);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionString* gnome_scan_option_string_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const char* value, GnomeScanOptionHint hint) {
	return gnome_scan_option_string_construct (GNOME_SCAN_TYPE_OPTION_STRING, name, title, desc, group, domain, value, hint);
}


const char* gnome_scan_option_string_get_value (GnomeScanOptionString* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_value;
	return result;
}


void gnome_scan_option_string_set_value (GnomeScanOptionString* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_value = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_value), _tmp0_);
	g_object_notify ((GObject *) self, "value");
}


static void gnome_scan_option_string_class_init (GnomeScanOptionStringClass * klass) {
	gnome_scan_option_string_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionStringPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_string_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_string_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_string_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_STRING_VALUE, g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_string_instance_init (GnomeScanOptionString * self) {
	self->priv = GNOME_SCAN_OPTION_STRING_GET_PRIVATE (self);
}


static void gnome_scan_option_string_finalize (GObject* obj) {
	GnomeScanOptionString * self;
	self = GNOME_SCAN_OPTION_STRING (obj);
	_g_free0 (self->priv->_value);
	G_OBJECT_CLASS (gnome_scan_option_string_parent_class)->finalize (obj);
}


GType gnome_scan_option_string_get_type (void) {
	static GType gnome_scan_option_string_type_id = 0;
	if (gnome_scan_option_string_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionStringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_string_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionString), 0, (GInstanceInitFunc) gnome_scan_option_string_instance_init, NULL };
		gnome_scan_option_string_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionString", &g_define_type_info, 0);
	}
	return gnome_scan_option_string_type_id;
}


static void gnome_scan_option_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionString * self;
	self = GNOME_SCAN_OPTION_STRING (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_STRING_VALUE:
		g_value_set_string (value, gnome_scan_option_string_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_string_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionString * self;
	self = GNOME_SCAN_OPTION_STRING (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_STRING_VALUE:
		gnome_scan_option_string_set_value (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GnomeScanOptionEnum* gnome_scan_option_enum_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionEnum * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	__params = g_new0 (GParameter, 7);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	__params_it->name = "values";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, values);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_enum_set_value (self, &(*value));
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionEnum* gnome_scan_option_enum_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint) {
	return gnome_scan_option_enum_construct (GNOME_SCAN_TYPE_OPTION_ENUM, name, title, desc, group, domain, value, values, hint);
}


static gpointer _gnome_scan_enum_value_dup0 (gpointer self) {
	return self ? gnome_scan_enum_value_dup (self) : NULL;
}


static void gnome_scan_option_enum_real_append (GnomeScanOptionEnum* self, const GnomeScanEnumValue* value) {
	g_return_if_fail (self != NULL);
	{
		GSList* val_collection;
		GSList* val_it;
		val_collection = self->priv->_values;
		for (val_it = val_collection; val_it != NULL; val_it = val_it->next) {
			GnomeScanEnumValue val;
			val = *((GnomeScanEnumValue*) val_it->data);
			{
				if (_vala_strcmp0 (val.label, (*value).label) == 0) {
					return;
				}
			}
		}
	}
	self->priv->_values = g_slist_append (self->priv->_values, _gnome_scan_enum_value_dup0 (&(*value)));
}


void gnome_scan_option_enum_append (GnomeScanOptionEnum* self, const GnomeScanEnumValue* value) {
	GNOME_SCAN_OPTION_ENUM_GET_CLASS (self)->append (self, value);
}


void gnome_scan_option_enum_get_value (GnomeScanOptionEnum* self, GnomeScanEnumValue* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_value;
	return;
}


void gnome_scan_option_enum_set_value (GnomeScanOptionEnum* self, GnomeScanEnumValue* value) {
	GnomeScanEnumValue _tmp1_;
	GnomeScanEnumValue _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	self->priv->_value = (_tmp1_ = (gnome_scan_enum_value_copy (&(*value), &_tmp0_), _tmp0_), gnome_scan_enum_value_destroy (&self->priv->_value), _tmp1_);
	g_object_notify ((GObject *) self, "value");
}


GSList* gnome_scan_option_enum_get_values (GnomeScanOptionEnum* self) {
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_values;
	return result;
}


void gnome_scan_option_enum_set_values (GnomeScanOptionEnum* self, GSList* value) {
	g_return_if_fail (self != NULL);
	self->priv->_values = value;
	g_object_notify ((GObject *) self, "values");
}


static void gnome_scan_option_enum_class_init (GnomeScanOptionEnumClass * klass) {
	gnome_scan_option_enum_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionEnumPrivate));
	GNOME_SCAN_OPTION_ENUM_CLASS (klass)->append = gnome_scan_option_enum_real_append;
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_enum_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_enum_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_enum_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_ENUM_VALUE, g_param_spec_boxed ("value", "value", "value", GNOME_SCAN_TYPE_ENUM_VALUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_ENUM_VALUES, g_param_spec_pointer ("values", "values", "values", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_option_enum_instance_init (GnomeScanOptionEnum * self) {
	self->priv = GNOME_SCAN_OPTION_ENUM_GET_PRIVATE (self);
}


static void gnome_scan_option_enum_finalize (GObject* obj) {
	GnomeScanOptionEnum * self;
	self = GNOME_SCAN_OPTION_ENUM (obj);
	gnome_scan_enum_value_destroy (&self->priv->_value);
	G_OBJECT_CLASS (gnome_scan_option_enum_parent_class)->finalize (obj);
}


GType gnome_scan_option_enum_get_type (void) {
	static GType gnome_scan_option_enum_type_id = 0;
	if (gnome_scan_option_enum_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionEnumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_enum_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionEnum), 0, (GInstanceInitFunc) gnome_scan_option_enum_instance_init, NULL };
		gnome_scan_option_enum_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionEnum", &g_define_type_info, 0);
	}
	return gnome_scan_option_enum_type_id;
}


static void gnome_scan_option_enum_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionEnum * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_ENUM (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_ENUM_VALUE:
		boxed = g_new0 (GnomeScanEnumValue, 1);
		gnome_scan_option_enum_get_value (self, boxed);
		g_value_take_boxed (value, boxed);
		break;
		case GNOME_SCAN_OPTION_ENUM_VALUES:
		g_value_set_pointer (value, gnome_scan_option_enum_get_values (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_enum_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionEnum * self;
	self = GNOME_SCAN_OPTION_ENUM (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_ENUM_VALUE:
		gnome_scan_option_enum_set_value (self, g_value_get_boxed (value));
		break;
		case GNOME_SCAN_OPTION_ENUM_VALUES:
		gnome_scan_option_enum_set_values (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GnomeScanOptionPaperSize* gnome_scan_option_paper_size_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanExtent* extent, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionPaperSize * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	__params = g_new0 (GParameter, 8);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "extent";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_EXTENT);
	g_value_set_boxed (&__params_it->value, &(*extent));
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	__params_it->name = "values";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, values);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_enum_set_value ((GnomeScanOptionEnum*) self, &(*value));
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionPaperSize* gnome_scan_option_paper_size_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanExtent* extent, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint) {
	return gnome_scan_option_paper_size_construct (GNOME_SCAN_TYPE_OPTION_PAPER_SIZE, name, title, desc, group, domain, extent, value, values, hint);
}


static void gnome_scan_option_paper_size_real_append (GnomeScanOptionEnum* base, const GnomeScanEnumValue* value) {
	GnomeScanOptionPaperSize * self;
	GtkPaperSize* ps;
	gboolean _tmp0_;
	self = (GnomeScanOptionPaperSize*) base;
	ps = (GtkPaperSize*) g_value_get_boxed (&(*value).value);
	g_debug ("gnome-scan-option.vala:191: Adding %s (%.2fx%.2f)", gtk_paper_size_get_display_name (ps), gtk_paper_size_get_width (ps, GTK_UNIT_MM), gtk_paper_size_get_height (ps, GTK_UNIT_MM));
	_tmp0_ = FALSE;
	if (gtk_paper_size_get_width (ps, GTK_UNIT_MM) <= self->priv->_extent.width) {
		_tmp0_ = gtk_paper_size_get_height (ps, GTK_UNIT_MM) <= self->priv->_extent.height;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GNOME_SCAN_OPTION_ENUM_CLASS (gnome_scan_option_paper_size_parent_class)->append (GNOME_SCAN_OPTION_ENUM (self), &(*value));
	}
}


void gnome_scan_option_paper_size_get_extent (GnomeScanOptionPaperSize* self, GnomeScanExtent* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_extent;
	return;
}


void gnome_scan_option_paper_size_set_extent (GnomeScanOptionPaperSize* self, GnomeScanExtent* value) {
	g_return_if_fail (self != NULL);
	self->priv->_extent = (*value);
	g_object_notify ((GObject *) self, "extent");
}


static void gnome_scan_option_paper_size_class_init (GnomeScanOptionPaperSizeClass * klass) {
	gnome_scan_option_paper_size_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionPaperSizePrivate));
	GNOME_SCAN_OPTION_ENUM_CLASS (klass)->append = gnome_scan_option_paper_size_real_append;
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_paper_size_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_paper_size_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_paper_size_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_PAPER_SIZE_EXTENT, g_param_spec_boxed ("extent", "extent", "extent", GNOME_SCAN_TYPE_EXTENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_option_paper_size_instance_init (GnomeScanOptionPaperSize * self) {
	self->priv = GNOME_SCAN_OPTION_PAPER_SIZE_GET_PRIVATE (self);
}


static void gnome_scan_option_paper_size_finalize (GObject* obj) {
	GnomeScanOptionPaperSize * self;
	self = GNOME_SCAN_OPTION_PAPER_SIZE (obj);
	G_OBJECT_CLASS (gnome_scan_option_paper_size_parent_class)->finalize (obj);
}


GType gnome_scan_option_paper_size_get_type (void) {
	static GType gnome_scan_option_paper_size_type_id = 0;
	if (gnome_scan_option_paper_size_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionPaperSizeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_paper_size_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionPaperSize), 0, (GInstanceInitFunc) gnome_scan_option_paper_size_instance_init, NULL };
		gnome_scan_option_paper_size_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_ENUM, "GnomeScanOptionPaperSize", &g_define_type_info, 0);
	}
	return gnome_scan_option_paper_size_type_id;
}


static void gnome_scan_option_paper_size_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionPaperSize * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_PAPER_SIZE (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_PAPER_SIZE_EXTENT:
		boxed = g_new0 (GnomeScanExtent, 1);
		gnome_scan_option_paper_size_get_extent (self, boxed);
		g_value_take_boxed (value, boxed);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_paper_size_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionPaperSize * self;
	self = GNOME_SCAN_OPTION_PAPER_SIZE (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_PAPER_SIZE_EXTENT:
		gnome_scan_option_paper_size_set_extent (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GnomeScanOptionBoxed* gnome_scan_option_boxed_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GValue* value, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionBoxed * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_boxed_set_value (self, &(*value));
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionBoxed* gnome_scan_option_boxed_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GValue* value, GnomeScanOptionHint hint) {
	return gnome_scan_option_boxed_construct (GNOME_SCAN_TYPE_OPTION_BOXED, name, title, desc, group, domain, value, hint);
}


static void gnome_scan_option_boxed_get_value (GnomeScanOptionBoxed* self, GValue* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_value;
	return;
}


static void gnome_scan_option_boxed_set_value (GnomeScanOptionBoxed* self, GValue* value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = (*value);
}


static void gnome_scan_option_boxed_class_init (GnomeScanOptionBoxedClass * klass) {
	gnome_scan_option_boxed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionBoxedPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_boxed_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_boxed_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_boxed_finalize;
}


static void gnome_scan_option_boxed_instance_init (GnomeScanOptionBoxed * self) {
	self->priv = GNOME_SCAN_OPTION_BOXED_GET_PRIVATE (self);
}


static void gnome_scan_option_boxed_finalize (GObject* obj) {
	GnomeScanOptionBoxed * self;
	self = GNOME_SCAN_OPTION_BOXED (obj);
	G_OBJECT_CLASS (gnome_scan_option_boxed_parent_class)->finalize (obj);
}


GType gnome_scan_option_boxed_get_type (void) {
	static GType gnome_scan_option_boxed_type_id = 0;
	if (gnome_scan_option_boxed_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionBoxedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_boxed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionBoxed), 0, (GInstanceInitFunc) gnome_scan_option_boxed_instance_init, NULL };
		gnome_scan_option_boxed_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionBoxed", &g_define_type_info, 0);
	}
	return gnome_scan_option_boxed_type_id;
}


static void gnome_scan_option_boxed_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBoxed * self;
	self = GNOME_SCAN_OPTION_BOXED (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_boxed_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBoxed * self;
	self = GNOME_SCAN_OPTION_BOXED (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GnomeScanOptionPointer* gnome_scan_option_pointer_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, void* value, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionPointer * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gnome_scan_option_pointer_set_value (self, value);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionPointer* gnome_scan_option_pointer_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, void* value, GnomeScanOptionHint hint) {
	return gnome_scan_option_pointer_construct (GNOME_SCAN_TYPE_OPTION_POINTER, name, title, desc, group, domain, value, hint);
}


void* gnome_scan_option_pointer_get_value (GnomeScanOptionPointer* self) {
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_value;
	return result;
}


void gnome_scan_option_pointer_set_value (GnomeScanOptionPointer* self, void* value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
	g_object_notify ((GObject *) self, "value");
}


static void gnome_scan_option_pointer_class_init (GnomeScanOptionPointerClass * klass) {
	gnome_scan_option_pointer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionPointerPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_pointer_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_pointer_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_pointer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_POINTER_VALUE, g_param_spec_pointer ("value", "value", "value", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_pointer_instance_init (GnomeScanOptionPointer * self) {
	self->priv = GNOME_SCAN_OPTION_POINTER_GET_PRIVATE (self);
}


static void gnome_scan_option_pointer_finalize (GObject* obj) {
	GnomeScanOptionPointer * self;
	self = GNOME_SCAN_OPTION_POINTER (obj);
	G_OBJECT_CLASS (gnome_scan_option_pointer_parent_class)->finalize (obj);
}


GType gnome_scan_option_pointer_get_type (void) {
	static GType gnome_scan_option_pointer_type_id = 0;
	if (gnome_scan_option_pointer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionPointerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_pointer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionPointer), 0, (GInstanceInitFunc) gnome_scan_option_pointer_instance_init, NULL };
		gnome_scan_option_pointer_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "GnomeScanOptionPointer", &g_define_type_info, 0);
	}
	return gnome_scan_option_pointer_type_id;
}


static void gnome_scan_option_pointer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionPointer * self;
	self = GNOME_SCAN_OPTION_POINTER (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_POINTER_VALUE:
		g_value_set_pointer (value, gnome_scan_option_pointer_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_pointer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionPointer * self;
	self = GNOME_SCAN_OPTION_POINTER (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_POINTER_VALUE:
		gnome_scan_option_pointer_set_value (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




