/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2009  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define GNOME_SCAN_TYPE_OPTION_WIDGET (gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_SCAN_IS_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_IS_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass GnomeScanOptionWidgetClass;
typedef struct _GnomeScanOptionWidgetPrivate GnomeScanOptionWidgetPrivate;

#define GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET (gnome_scan_page_orientation_widget_get_type ())
#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidget))
#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidgetClass))
#define GNOME_SCAN_IS_PAGE_ORIENTATION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET))
#define GNOME_SCAN_IS_PAGE_ORIENTATION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET))
#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidgetClass))

typedef struct _GnomeScanPageOrientationWidget GnomeScanPageOrientationWidget;
typedef struct _GnomeScanPageOrientationWidgetClass GnomeScanPageOrientationWidgetClass;
typedef struct _GnomeScanPageOrientationWidgetPrivate GnomeScanPageOrientationWidgetPrivate;

#define GNOME_SCAN_TYPE_ENUM_VALUE (gnome_scan_enum_value_get_type ())
typedef struct _GnomeScanEnumValue GnomeScanEnumValue;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;

#define GNOME_SCAN_TYPE_OPTION_ENUM (gnome_scan_option_enum_get_type ())
#define GNOME_SCAN_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnum))
#define GNOME_SCAN_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))
#define GNOME_SCAN_IS_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_IS_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_OPTION_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))

typedef struct _GnomeScanOptionEnum GnomeScanOptionEnum;
typedef struct _GnomeScanOptionEnumClass GnomeScanOptionEnumClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GnomeScanOptionWidget {
	GtkHBox parent_instance;
	GnomeScanOptionWidgetPrivate * priv;
};

struct _GnomeScanOptionWidgetClass {
	GtkHBoxClass parent_class;
};

struct _GnomeScanPageOrientationWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanPageOrientationWidgetPrivate * priv;
};

struct _GnomeScanPageOrientationWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanEnumValue {
	GValue value;
	char* label;
	char* domain;
};

struct _GnomeScanPageOrientationWidgetPrivate {
	GHashTable* radio_map;
};


static gpointer gnome_scan_page_orientation_widget_parent_class = NULL;

GType gnome_scan_option_widget_get_type (void);
GType gnome_scan_page_orientation_widget_get_type (void);
GType gnome_scan_enum_value_get_type (void);
GnomeScanEnumValue* gnome_scan_enum_value_dup (const GnomeScanEnumValue* self);
void gnome_scan_enum_value_free (GnomeScanEnumValue* self);
void gnome_scan_enum_value_copy (const GnomeScanEnumValue* self, GnomeScanEnumValue* dest);
void gnome_scan_enum_value_destroy (GnomeScanEnumValue* self);
#define GNOME_SCAN_PAGE_ORIENTATION_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidgetPrivate))
enum  {
	GNOME_SCAN_PAGE_ORIENTATION_WIDGET_DUMMY_PROPERTY
};
GType gnome_scan_option_get_type (void);
GnomeScanOption* gnome_scan_option_widget_get_option (GnomeScanOptionWidget* self);
GType gnome_scan_option_enum_get_type (void);
void gnome_scan_option_enum_set_value (GnomeScanOptionEnum* self, GnomeScanEnumValue* value);
static void gnome_scan_page_orientation_widget_on_radio_toggled (GnomeScanPageOrientationWidget* self, GtkRadioButton* button);
GnomeScanPageOrientationWidget* gnome_scan_page_orientation_widget_new (void);
GnomeScanPageOrientationWidget* gnome_scan_page_orientation_widget_construct (GType object_type);
void gnome_scan_option_widget_set_no_label (GnomeScanOptionWidget* self, gboolean value);
GSList* gnome_scan_option_enum_get_values (GnomeScanOptionEnum* self);
static void _gnome_scan_page_orientation_widget_on_radio_toggled_gtk_toggle_button_toggled (GtkRadioButton* _sender, gpointer self);
static GObject * gnome_scan_page_orientation_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_page_orientation_widget_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gnome_scan_page_orientation_widget_on_radio_toggled (GnomeScanPageOrientationWidget* self, GtkRadioButton* button) {
	GnomeScanOption* _tmp0_;
	GnomeScanOptionEnum* option;
	GnomeScanEnumValue* value;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (!gtk_toggle_button_get_active ((GtkToggleButton*) button)) {
		return;
	}
	option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_ENUM (_tmp0_) ? ((GnomeScanOptionEnum*) _tmp0_) : NULL));
	value = (GnomeScanEnumValue*) g_hash_table_lookup (self->priv->radio_map, button);
	gnome_scan_option_enum_set_value (option, &(*value));
	_g_object_unref0 (option);
}


GnomeScanPageOrientationWidget* gnome_scan_page_orientation_widget_construct (GType object_type) {
	GnomeScanPageOrientationWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanPageOrientationWidget* gnome_scan_page_orientation_widget_new (void) {
	return gnome_scan_page_orientation_widget_construct (GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET);
}


static void _gnome_scan_page_orientation_widget_on_radio_toggled_gtk_toggle_button_toggled (GtkRadioButton* _sender, gpointer self) {
	gnome_scan_page_orientation_widget_on_radio_toggled (self, _sender);
}


static GObject * gnome_scan_page_orientation_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanPageOrientationWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanPageOrientationWidget * self;
	klass = GNOME_SCAN_PAGE_ORIENTATION_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_PAGE_ORIENTATION_WIDGET (obj);
	{
		GHashTable* _tmp0_;
		GnomeScanOption* _tmp1_;
		GnomeScanOptionEnum* option;
		GtkRadioButton* radio;
		GtkImage* icon;
		GtkLabel* label;
		GtkVBox* parent;
		GtkHBox* box;
		GtkStockItem item = {0};
		GSList* group;
		gnome_scan_option_widget_set_no_label ((GnomeScanOptionWidget*) self, TRUE);
		self->priv->radio_map = (_tmp0_ = g_hash_table_new (g_direct_hash, g_direct_equal), _g_hash_table_unref0 (self->priv->radio_map), _tmp0_);
		option = _g_object_ref0 ((_tmp1_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_ENUM (_tmp1_) ? ((GnomeScanOptionEnum*) _tmp1_) : NULL));
		radio = NULL;
		icon = NULL;
		label = NULL;
		parent = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (TRUE, 0));
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) parent, FALSE, TRUE, (guint) 0);
		box = NULL;
		group = NULL;
		{
			GSList* value_collection;
			GSList* value_it;
			value_collection = gnome_scan_option_enum_get_values (option);
			for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
				GnomeScanEnumValue* value;
				value = (GnomeScanEnumValue*) value_it->data;
				{
					GtkHBox* _tmp2_;
					GtkImage* _tmp3_;
					GtkLabel* _tmp4_;
					GtkRadioButton* _tmp5_;
					box = (_tmp2_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 4)), _g_object_unref0 (box), _tmp2_);
					icon = (_tmp3_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock ((*value).label, GTK_ICON_SIZE_BUTTON)), _g_object_unref0 (icon), _tmp3_);
					gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) icon, FALSE, FALSE, (guint) 0);
					gtk_stock_lookup ((*value).label, &item);
					label = (_tmp4_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (item.label)), _g_object_unref0 (label), _tmp4_);
					gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
					radio = (_tmp5_ = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new (group)), _g_object_unref0 (radio), _tmp5_);
					gtk_container_add ((GtkContainer*) radio, (GtkWidget*) box);
					g_signal_connect_object ((GtkToggleButton*) radio, "toggled", (GCallback) _gnome_scan_page_orientation_widget_on_radio_toggled_gtk_toggle_button_toggled, self, 0);
					group = gtk_radio_button_get_group (radio);
					gtk_box_pack_start ((GtkBox*) parent, (GtkWidget*) radio, FALSE, TRUE, (guint) 0);
					g_hash_table_insert (self->priv->radio_map, _g_object_ref0 (radio), value);
				}
			}
		}
		_g_object_unref0 (option);
		_g_object_unref0 (radio);
		_g_object_unref0 (icon);
		_g_object_unref0 (label);
		_g_object_unref0 (parent);
		_g_object_unref0 (box);
	}
	return obj;
}


static void gnome_scan_page_orientation_widget_class_init (GnomeScanPageOrientationWidgetClass * klass) {
	gnome_scan_page_orientation_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanPageOrientationWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_page_orientation_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_page_orientation_widget_finalize;
}


static void gnome_scan_page_orientation_widget_instance_init (GnomeScanPageOrientationWidget * self) {
	self->priv = GNOME_SCAN_PAGE_ORIENTATION_WIDGET_GET_PRIVATE (self);
}


static void gnome_scan_page_orientation_widget_finalize (GObject* obj) {
	GnomeScanPageOrientationWidget * self;
	self = GNOME_SCAN_PAGE_ORIENTATION_WIDGET (obj);
	_g_hash_table_unref0 (self->priv->radio_map);
	G_OBJECT_CLASS (gnome_scan_page_orientation_widget_parent_class)->finalize (obj);
}


GType gnome_scan_page_orientation_widget_get_type (void) {
	static GType gnome_scan_page_orientation_widget_type_id = 0;
	if (gnome_scan_page_orientation_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanPageOrientationWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_page_orientation_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanPageOrientationWidget), 0, (GInstanceInitFunc) gnome_scan_page_orientation_widget_instance_init, NULL };
		gnome_scan_page_orientation_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "GnomeScanPageOrientationWidget", &g_define_type_info, 0);
	}
	return gnome_scan_page_orientation_widget_type_id;
}




