/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gegl.h>


#define GNOME_SCAN_TYPE_NODE (gnome_scan_node_get_type ())
#define GNOME_SCAN_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNode))
#define GNOME_SCAN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))
#define GNOME_SCAN_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))

typedef struct _GnomeScanNode GnomeScanNode;
typedef struct _GnomeScanNodeClass GnomeScanNodeClass;
typedef struct _GnomeScanNodePrivate GnomeScanNodePrivate;

#define GNOME_SCAN_TYPE_SCANNER (gnome_scan_scanner_get_type ())
#define GNOME_SCAN_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScanner))
#define GNOME_SCAN_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))
#define GNOME_SCAN_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))

typedef struct _GnomeScanScanner GnomeScanScanner;
typedef struct _GnomeScanScannerClass GnomeScanScannerClass;
typedef struct _GnomeScanScannerPrivate GnomeScanScannerPrivate;

#define GNOME_SCAN_TYPE_EXTENT (gnome_scan_extent_get_type ())
typedef struct _GnomeScanExtent GnomeScanExtent;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GnomeScanNode {
	GObject parent_instance;
	GnomeScanNodePrivate * priv;
};

struct _GnomeScanNodeClass {
	GObjectClass parent_class;
	void (*start_scan) (GnomeScanNode* self);
	gboolean (*start_image) (GnomeScanNode* self);
	void (*end_image) (GnomeScanNode* self);
	void (*end_scan) (GnomeScanNode* self);
};

struct _GnomeScanScanner {
	GnomeScanNode parent_instance;
	GnomeScanScannerPrivate * priv;
};

struct _GnomeScanScannerClass {
	GnomeScanNodeClass parent_class;
	gboolean (*work) (GnomeScanScanner* self, double* progress);
};

struct _GnomeScanExtent {
	double width;
	double height;
};

struct _GnomeScanScannerPrivate {
	char* _name;
	char* _blurb;
	char* _icon_name;
	GeglBuffer* _buffer;
	GnomeScanExtent _extent;
};


static gpointer gnome_scan_scanner_parent_class = NULL;

GType gnome_scan_node_get_type (void);
GType gnome_scan_scanner_get_type (void);
GType gnome_scan_extent_get_type (void);
GnomeScanExtent* gnome_scan_extent_dup (const GnomeScanExtent* self);
void gnome_scan_extent_free (GnomeScanExtent* self);
#define GNOME_SCAN_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerPrivate))
enum  {
	GNOME_SCAN_SCANNER_DUMMY_PROPERTY,
	GNOME_SCAN_SCANNER_NAME,
	GNOME_SCAN_SCANNER_BLURB,
	GNOME_SCAN_SCANNER_ICON_NAME,
	GNOME_SCAN_SCANNER_BUFFER,
	GNOME_SCAN_SCANNER_EXTENT
};
gboolean gnome_scan_scanner_work (GnomeScanScanner* self, double* progress);
static gboolean gnome_scan_scanner_real_work (GnomeScanScanner* self, double* progress);
GnomeScanScanner* gnome_scan_scanner_construct (GType object_type);
const char* gnome_scan_scanner_get_name (GnomeScanScanner* self);
void gnome_scan_scanner_set_name (GnomeScanScanner* self, const char* value);
const char* gnome_scan_scanner_get_blurb (GnomeScanScanner* self);
void gnome_scan_scanner_set_blurb (GnomeScanScanner* self, const char* value);
const char* gnome_scan_scanner_get_icon_name (GnomeScanScanner* self);
void gnome_scan_scanner_set_icon_name (GnomeScanScanner* self, const char* value);
GeglBuffer* gnome_scan_scanner_get_buffer (GnomeScanScanner* self);
void gnome_scan_scanner_set_buffer (GnomeScanScanner* self, GeglBuffer* value);
void gnome_scan_scanner_get_extent (GnomeScanScanner* self, GnomeScanExtent* result);
void gnome_scan_scanner_set_extent (GnomeScanScanner* self, GnomeScanExtent* value);
void gnome_scan_extent_init (GnomeScanExtent *self, double width, double height);
static GObject * gnome_scan_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_scanner_finalize (GObject* obj);
static void gnome_scan_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static gboolean gnome_scan_scanner_real_work (GnomeScanScanner* self, double* progress) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	(*progress) = 1.0;
	g_warning ("gnome-scan-scanner.vala:40: Fake processor for %s", g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self)));
	result = FALSE;
	return result;
}


gboolean gnome_scan_scanner_work (GnomeScanScanner* self, double* progress) {
	return GNOME_SCAN_SCANNER_GET_CLASS (self)->work (self, progress);
}


GnomeScanScanner* gnome_scan_scanner_construct (GType object_type) {
	GnomeScanScanner * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


const char* gnome_scan_scanner_get_name (GnomeScanScanner* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void gnome_scan_scanner_set_name (GnomeScanScanner* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
	g_object_notify ((GObject *) self, "name");
}


const char* gnome_scan_scanner_get_blurb (GnomeScanScanner* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_blurb;
	return result;
}


void gnome_scan_scanner_set_blurb (GnomeScanScanner* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_blurb = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_blurb), _tmp0_);
	g_object_notify ((GObject *) self, "blurb");
}


const char* gnome_scan_scanner_get_icon_name (GnomeScanScanner* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon_name;
	return result;
}


void gnome_scan_scanner_set_icon_name (GnomeScanScanner* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_icon_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_name), _tmp0_);
	g_object_notify ((GObject *) self, "icon-name");
}


GeglBuffer* gnome_scan_scanner_get_buffer (GnomeScanScanner* self) {
	GeglBuffer* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_buffer;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gnome_scan_scanner_set_buffer (GnomeScanScanner* self, GeglBuffer* value) {
	GeglBuffer* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_buffer = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_buffer), _tmp0_);
	g_object_notify ((GObject *) self, "buffer");
}


void gnome_scan_scanner_get_extent (GnomeScanScanner* self, GnomeScanExtent* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_extent;
	return;
}


void gnome_scan_scanner_set_extent (GnomeScanScanner* self, GnomeScanExtent* value) {
	g_return_if_fail (self != NULL);
	self->priv->_extent = (*value);
	g_object_notify ((GObject *) self, "extent");
}


static GObject * gnome_scan_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanScannerClass * klass;
	GObjectClass * parent_class;
	GnomeScanScanner * self;
	klass = GNOME_SCAN_SCANNER_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_SCANNER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_SCANNER (obj);
	{
		GnomeScanExtent _tmp0_ = {0};
		GnomeScanExtent _tmp1_;
		gnome_scan_scanner_set_extent (self, (_tmp1_ = (gnome_scan_extent_init (&_tmp0_, 0.0, 0.0), _tmp0_), &_tmp1_));
	}
	return obj;
}


static void gnome_scan_scanner_class_init (GnomeScanScannerClass * klass) {
	gnome_scan_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanScannerPrivate));
	GNOME_SCAN_SCANNER_CLASS (klass)->work = gnome_scan_scanner_real_work;
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_scanner_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_scanner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_BLURB, g_param_spec_string ("blurb", "blurb", "blurb", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_BUFFER, g_param_spec_object ("buffer", "buffer", "buffer", GEGL_TYPE_BUFFER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_EXTENT, g_param_spec_boxed ("extent", "extent", "extent", GNOME_SCAN_TYPE_EXTENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_scanner_instance_init (GnomeScanScanner * self) {
	self->priv = GNOME_SCAN_SCANNER_GET_PRIVATE (self);
}


static void gnome_scan_scanner_finalize (GObject* obj) {
	GnomeScanScanner * self;
	self = GNOME_SCAN_SCANNER (obj);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_blurb);
	_g_free0 (self->priv->_icon_name);
	_g_object_unref0 (self->priv->_buffer);
	G_OBJECT_CLASS (gnome_scan_scanner_parent_class)->finalize (obj);
}


GType gnome_scan_scanner_get_type (void) {
	static GType gnome_scan_scanner_type_id = 0;
	if (gnome_scan_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanScanner), 0, (GInstanceInitFunc) gnome_scan_scanner_instance_init, NULL };
		gnome_scan_scanner_type_id = g_type_register_static (GNOME_SCAN_TYPE_NODE, "GnomeScanScanner", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_scanner_type_id;
}


static void gnome_scan_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanScanner * self;
	gpointer boxed;
	self = GNOME_SCAN_SCANNER (object);
	switch (property_id) {
		case GNOME_SCAN_SCANNER_NAME:
		g_value_set_string (value, gnome_scan_scanner_get_name (self));
		break;
		case GNOME_SCAN_SCANNER_BLURB:
		g_value_set_string (value, gnome_scan_scanner_get_blurb (self));
		break;
		case GNOME_SCAN_SCANNER_ICON_NAME:
		g_value_set_string (value, gnome_scan_scanner_get_icon_name (self));
		break;
		case GNOME_SCAN_SCANNER_BUFFER:
		g_value_set_object (value, gnome_scan_scanner_get_buffer (self));
		break;
		case GNOME_SCAN_SCANNER_EXTENT:
		boxed = g_new0 (GnomeScanExtent, 1);
		gnome_scan_scanner_get_extent (self, boxed);
		g_value_take_boxed (value, boxed);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanScanner * self;
	self = GNOME_SCAN_SCANNER (object);
	switch (property_id) {
		case GNOME_SCAN_SCANNER_NAME:
		gnome_scan_scanner_set_name (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_SCANNER_BLURB:
		gnome_scan_scanner_set_blurb (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_SCANNER_ICON_NAME:
		gnome_scan_scanner_set_icon_name (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_SCANNER_BUFFER:
		gnome_scan_scanner_set_buffer (self, g_value_get_object (value));
		break;
		case GNOME_SCAN_SCANNER_EXTENT:
		gnome_scan_scanner_set_extent (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




