#ifndef GNUMERIC_DEPENDENT_H
#define GNUMERIC_DEPENDENT_H

#include "gnumeric.h"
#include <stdio.h>

struct _Dependent
{
	guint	  flags;
	Sheet	 *sheet;
	ExprTree *expression;
	guint8    generation;
};

typedef struct {
	void (*eval) (Dependent *dep);
	void (*set_expr) (Dependent *dep, ExprTree *expr);
	void (*debug_name) (Dependent const *dep, FILE *out);
} DependentClass;

typedef enum {
	/* Queued for recalc */
	DEPENDENT_QUEUED_FOR_RECALC = 0x00001000,
	/* Linked into the workbook wide expression list */
	DEPENDENT_IN_EXPR_LIST      = 0x00002000,

	/* Types */
	DEPENDENT_CELL 		    = 0x00000001,
	DEPENDENT_TYPE_MASK	    = 0x00000fff,
} DependentFlags;

void dependent_link		(Dependent *dep, CellPos const *pos);
void dependent_unlink		(Dependent *dep, CellPos const *pos);
void dependent_unlink_sheet	(Sheet const *sheet);
void dependent_changed		(Dependent *dep, CellPos const *pos,
				 gboolean queue_recalc);

void dependent_queue_recalc		(Dependent *dep);
void dependent_queue_recalc_list	(GList *list, gboolean freelist);
void dependent_unqueue_recalc		(Dependent *dep);
void dependent_unqueue_recalc_sheet	(Sheet *sheet);

GList *dependent_list_filter	(GList *input, DependentFlags type);

guint32 dependent_type_register (DependentClass const *klass);
void dependent_eval (Dependent *dependent);
void dependent_set_expr (Dependent *dependent, ExprTree *expr);
void dependent_debug_name (Dependent const *dep, FILE *out);

#endif /* GNUMERIC_DEPENDENT_H */
