/*
 *	Googlizer: A demonstration of the value of selections
 *
 *	(c) Copyright 2000 Alan Cox, All Rights Reserved
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

static void got_selection(GtkWidget *widget, GtkSelectionData *data, gpointer val)
{
	GdkAtom *atoms;
	int i;
	char *p, *tp;
	char *bptr;
	
	if(data->length<0)
		exit(1);
	if(data->type!=GDK_SELECTION_TYPE_STRING)
		exit(1);
	bptr=malloc(3*data->length+128);
	if(bptr==NULL)
		exit(1);
	p=data->data;
	tp=bptr+sprintf(bptr, "http://www.google.com/search?q=");
	while(*p)
	{
		if(*p==' ')
		{
			*tp++='+';
			p++;
		}
		else if(*p<' '||*p>'z' || *p=='&' || *p=='%')
		{
			sprintf(tp, "%%%02x", *p);
			tp+=3;
			p++;
		}
		else *tp++=*p++;
	}
	*tp=0;
	gnome_url_show(bptr);
	exit(0);
}

static int get_selection(GtkWidget *w)
{
	static GdkAtom atomos = GDK_NONE;
	if(atomos==GDK_NONE)
		atomos=gdk_atom_intern("STRING", FALSE);
	gtk_selection_convert(w, GDK_SELECTION_PRIMARY, atomos, GDK_CURRENT_TIME);
}

int main(int argc, char *argv[])
{
	GtkWidget *window;
	gnome_init("gnoogle", "0.1", argc, argv);
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_exit), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "selection_received", GTK_SIGNAL_FUNC(got_selection), NULL);
//	gtk_widget_show(window);
	get_selection(window);
	gtk_main();
}
