// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTMM_EVENT_H
#define _GSTMM_EVENT_H


#include <glibmm.h>

#include <gstreamermm/miniobject.h>
#include <gstreamermm/structure.h>
#include <gstreamermm/wrap.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstEvent GstEvent;
typedef struct _GstEventClass GstEventClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Event_Class; } // namespace Gst
namespace Gst
{


class Event : public MiniObject
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Event CppObjectType;
  typedef Event_Class CppClassType;
  typedef GstEvent BaseObjectType;
  typedef GstEventClass BaseClassType;

private:  friend class Event_Class;
  static CppClassType event_class_;

private:
  // noncopyable
  Event(const Event&);
  Event& operator=(const Event&);

protected:
  explicit Event(GstEvent* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Event();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GstMiniObject.
  GstEvent*       gobj()       { return reinterpret_cast<GstEvent*>(gobject_); }

  ///Provides access to the underlying C GstMiniObject.
  const GstEvent* gobj() const { return reinterpret_cast<GstEvent*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstEvent* gobj_copy();

private:


public:
  const Structure& get_structure();

public:
   EventType get_event_type() const;
    ClockTime get_timestamp() const;
    Glib::RefPtr<Gst::Object> get_source() const;
 
  /** Wrap a GstEvent* in a C++ instance, creating an instance of a derived
   * Gst::Event. Gst::wrap() would just create a Gst::Message (rather than a
   * derived one) because the derived Gst::Event classes do not correspond
   * to GType types in the GStreamer API.
   */
  static Glib::RefPtr<Event> wrap(GstEvent* event, bool take_copy=false);

  bool is_downstream() const;
  bool is_upstream() const;
  bool is_serialized() const;

protected:
  Structure structure_;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

class EventBufferSize : public Event
{
public:
  explicit EventBufferSize(GstEvent* event);

  static Glib::RefPtr<Event> create(Format format, gint64 minsize, gint64 maxsize, bool async);
  void parse(Format& format, gint64& minsize, gint64& maxsize, bool& async);
};

class EventCustom : public Event
{
public:
  explicit EventCustom(GstEvent* event);

  static Glib::RefPtr<Event> create(EventType type, Structure& structure);
};

class EventEos : public Event
{
public:
  explicit EventEos(GstEvent* event);

  static Glib::RefPtr<Event> create();
};

class EventFlushStart : public Event
{
public:
  explicit EventFlushStart(GstEvent* event);

  static Glib::RefPtr<Event> create();
};

class EventFlushStop : public Event
{
public:
  explicit EventFlushStop(GstEvent* event);

  static Glib::RefPtr<Event> create();
};

class EventLatency : public Event
{
public:
  explicit EventLatency(GstEvent* event);

  static Glib::RefPtr<Event> create(ClockTime time);
  void parse(ClockTime& latency);
};

class EventNavigation : public Event
{
public:
  explicit EventNavigation(GstEvent* event);

  static Glib::RefPtr<Event> create(Structure& structure);
};

class EventNewSegment : public Event
{
public:
  explicit EventNewSegment(GstEvent* event);

  static Glib::RefPtr<Event> create(bool update, double rate, Format format, gint64 strat, gint64 stop, gint64 position, double applied_rate=1.0);
  void parse(bool& update, double& rate, Format& format, gint64& start, gint64& stop, gint64& position);
  void parse(bool& update, double& rate, Format& format, gint64& start, gint64& stop, gint64& position, double& applied_rate);
};

class EventQos : public Event
{
public:
  explicit EventQos(GstEvent* event);

  static Glib::RefPtr<Event> create(double proportion, ClockTimeDiff diff, ClockTime timestamp);
  void parse(double& proportion, ClockTimeDiff& diff, ClockTime& timestamp);
};

class EventSeek : public Event
{
public:
  explicit EventSeek(GstEvent* event);

  static Glib::RefPtr<Event> create(double rate, Format format, SeekFlags flags, SeekType start_type, gint64 start, SeekType stop_type, gint64 stop);
  void parse(double& rate, Format& format, SeekFlags& flags, SeekType& start_type, gint64& start, SeekType& stop_type, gint64& stop);
};

class EventTag : public Event
{
public:
  explicit EventTag(GstEvent* event);

  //TODO: static Glib::RefPtr<Event> create(TagList& taglist);
  //TODO: void parse(TagList& taglist);
};

}//namespace Gst


namespace Gst
{
  /** @relates Gst::Event
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gst::Event> wrap(GstEvent* object, bool take_copy = false);
}


#endif /* _GSTMM_EVENT_H */

