// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTMM_QUERY_H
#define _GSTMM_QUERY_H


#include <glibmm.h>

#include <gstreamermm/miniobject.h>
#include <gstreamermm/structure.h>
#include <gstreamermm/wrap.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstQuery GstQuery;
typedef struct _GstQueryClass GstQueryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Query_Class; } // namespace Gst
namespace Gst
{

struct QueryTypeDefinition
{
  QueryType             value;
  Glib::ustring         nick;
  Glib::ustring         description;
  Glib::QueryQuark      quark;
};


class Query : public MiniObject
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Query CppObjectType;
  typedef Query_Class CppClassType;
  typedef GstQuery BaseObjectType;
  typedef GstQueryClass BaseClassType;

private:  friend class Query_Class;
  static CppClassType query_class_;

private:
  // noncopyable
  Query(const Query&);
  Query& operator=(const Query&);

protected:
  explicit Query(GstQuery* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Query();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GstMiniObject.
  GstQuery*       gobj()       { return reinterpret_cast<GstQuery*>(gobject_); }

  ///Provides access to the underlying C GstMiniObject.
  const GstQuery* gobj() const { return reinterpret_cast<GstQuery*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstQuery* gobj_copy();

private:


public:
  const Structure& get_structure();

public:
   QueryType get_query_type() const;
 
  /** Wrap a GstQuery* in a C++ instance, creating an instance of a derived
   * Gst::Query. Gst::wrap() would just create a Gst::Query (rather than a
   * derived one) because the derived Gst::Query classes do not correspond
   * to GType types in the GStreamer API.
   */
  static Glib::RefPtr<Query> wrap(GstQuery* query, bool take_copy=false);

  
  static QueryType register_query_type(const Glib::ustring& nick, const Glib::ustring& description);
  
  static QueryType get_query_type(const Glib::ustring& nick);
  //TODO: static bool query_types_contains(const std::vector<const QueryType>& types, QueryType type)

  bool get_details(QueryType type, QueryTypeDefinition& def);

protected:
  Structure structure_;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

class QueryConvert : public Query
{
public:
  explicit QueryConvert(GstQuery* query);

  static Glib::RefPtr<Query> create(Format src_format, gint64 value, Format dest_format);
  void set(Format src_format, gint64 src_value, Format dest_format, gint64 dest_value);
  void parse(Format& dest_format, gint64& dest_value);
  void parse(Format& src_format, gint64& src_value, Format& dest_format, gint64& dest_value);
};

class QueryPosition : public Query
{
public:
  explicit QueryPosition(GstQuery* query);

  static Glib::RefPtr<Query> create(Format format);
  void set(Format format, gint64 position);
  void parse(Format& format, gint64& position);
};

class QueryDuration : public Query
{
public:
  explicit QueryDuration(GstQuery* query);

  static Glib::RefPtr<Query> create(Format format);
  void set(Format format, gint64 duration);
  void parse(Format& format, gint64& duration);
};

class QueryLatency : public Query
{
public:
  explicit QueryLatency(GstQuery* query);

  static Glib::RefPtr<Query> create();
  void set(bool live, ClockTime min_latency, ClockTime max_latency);
  void parse(bool& live, ClockTime& min_latency, ClockTime& max_latency);
};

class QuerySeeking : public Query
{
public:
  explicit QuerySeeking(GstQuery* query);

  static Glib::RefPtr<Query> create(Format format);
  void set(Format format, bool seeakable, gint64 segment_start, gint64 segment_end);
  void parse(Format& format, bool& seekable, gint64& segment_start, gint64& segment_end);
};

class QueryFormats : public Query
{
public:
  explicit QueryFormats(GstQuery* query);

  static Glib::RefPtr<Query> create();
  void set(int n_formats, const va_list& varargs);
  //TODO: set(int n_formats, const std::vector<const Format>& formats);
  void parse(guint& n_formats);
  void parse(guint nth, Format& format);
};

class QuerySegment : public Query
{
public:
  explicit QuerySegment(GstQuery* query);

  static Glib::RefPtr<Query> create(Format format);
  void set(double rate, Format format, gint64 start_value, gint64 stop_value);
  void parse(double& rate, Format& format, gint64& start_value, gint64& stop_value);
};

}//namespace Gst


namespace Gst
{
  /** @relates Gst::Query
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gst::Query> wrap(GstQuery* object, bool take_copy = false);
}


#endif /* _GSTMM_QUERY_H */

