// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_BUFFER_H
#define _GSTREAMERMM_BUFFER_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/miniobject.h>
#include <gstreamermm/wrap.h>
#include <gstreamermm/enums.h>
#include <gstreamermm/caps.h>
#include <gstreamermm/clock.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstBuffer GstBuffer;
typedef struct _GstBufferClass GstBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Buffer_Class; } // namespace Gst
namespace Gst
{


class Buffer : public MiniObject
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Buffer CppObjectType;
  typedef Buffer_Class CppClassType;
  typedef GstBuffer BaseObjectType;
  typedef GstBufferClass BaseClassType;

private:  friend class Buffer_Class;
  static CppClassType buffer_class_;

private:
  // noncopyable
  Buffer(const Buffer&);
  Buffer& operator=(const Buffer&);

protected:
  explicit Buffer(GstBuffer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Buffer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GstMiniObject.
  GstBuffer*       gobj()       { return reinterpret_cast<GstBuffer*>(gobject_); }

  ///Provides access to the underlying C GstMiniObject.
  const GstBuffer* gobj() const { return reinterpret_cast<GstBuffer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBuffer* gobj_copy();

private:


public:
  static Glib::RefPtr<Buffer> create(const guint& size);

  
  guint flags() const;
  
  bool flag_is_set(BufferFlag flag) const;
  
  void flag_set(BufferFlag flag);
  
  void flag_unset(BufferFlag flag);

  
  Glib::RefPtr<Buffer> copy() const;

  
  void copy_metadata(const Glib::RefPtr<Buffer>& source_buffer, BufferCopyFlags flags);

  
  bool is_metadata_writable() const;

  //This is not const because it sometimes returns the same buffer:
  //gtkmmproc error: gst_buffer_make_writable : method defs lookup failed (1)

  //This is const because it always returns a new buffer:
  
  Glib::RefPtr<Buffer> make_metadata_writable() const;

  // TODO: Do we need to hand code this to throw an exception when the C API returns NULL ?
  
  Glib::RefPtr<Caps> get_caps();
  
  Glib::RefPtr<Caps const> get_caps() const;

  
  void set_caps(const Glib::RefPtr<Caps>& caps);

  // TODO: Do we need to hand code this to throw an exception when the C API returns NULL ?
  
  Glib::RefPtr<Buffer> create_sub(const guint& offset, const guint& size);
  
  Glib::RefPtr<Buffer const> create_sub(const guint& offset, const guint& size) const;

  
  bool is_span_fast(const Glib::RefPtr<Buffer>& other_buffer) const;

  //This is const because it always returns a new buffer:
  
  Glib::RefPtr<Buffer> span(const guint32& offset, const Glib::RefPtr<Buffer>& other_buffer, const guint32& len) const;

  
  Glib::RefPtr<Buffer> join(const Glib::RefPtr<Buffer>& other_buffer);

  //This is const because it always returns a new buffer:
  
  Glib::RefPtr<Buffer> join(const Glib::RefPtr<Buffer>& other_buffer) const;

  //This is const because it always returns a new buffer: (TODO: though maybe not: see the documentation. murrayc)
  
  Glib::RefPtr<Buffer> merge(const Glib::RefPtr<Buffer>& other_buffer) const;

   guint8* get_data() const;
    guint get_size() const;
    ClockTime get_timestamp() const;
    ClockTime get_duration() const;
    guint64 get_offset() const;
    guint64 get_offset_end() const;
    guint8* get_malloc_data() const;
 

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

}//namespace Gst


namespace Gst
{
  /** @relates Gst::Buffer
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gst::Buffer> wrap(GstBuffer* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_BUFFER_H */

