// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/bin.h>
#include <gstreamermm/private/bin_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdexcept>
#include <gst/gstbin.h>
#include <gst/gstutils.h>
#include <gstreamermm/pad.h>

namespace Gst
{

Glib::RefPtr<Bin> Bin::create(const Glib::ustring& name)
{
  GstElement* bin = gst_bin_new(name.c_str());
  return Glib::wrap((GstBin*) bin);
}

Glib::RefPtr<Bin> Bin::add(const Glib::RefPtr<Element>& element)
{
  bool result = gst_bin_add(gobj(), element->gobj());

  if(result)
    return Glib::wrap(gobj(), true);
  else
    throw std::runtime_error("Bin '" + get_name() + "' does not want to accept Element '" + element->get_name() + "'");
}

Glib::RefPtr<Bin> Bin::remove(const Glib::RefPtr<Element>& element)
{
  bool result = gst_bin_remove(gobj(), element->gobj());

  if(result)
    return Glib::RefPtr<Bin>(this);
  else
    throw std::runtime_error("Bin '" + get_name() + "' does not want to remove Element '" + element->get_name() + "'");
}

} //namespace Gst

namespace
{


static void Bin_signal_element_added_callback(GstBin* self, GstElement* p0,void* data)
{
  using namespace Gst;
  typedef sigc::slot< void,const Glib::RefPtr<Element>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Bin_signal_element_added_info =
{
  "element-added",
  (GCallback) &Bin_signal_element_added_callback,
  (GCallback) &Bin_signal_element_added_callback
};


static void Bin_signal_element_removed_callback(GstBin* self, GstElement* p0,void* data)
{
  using namespace Gst;
  typedef sigc::slot< void,const Glib::RefPtr<Element>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Bin_signal_element_removed_info =
{
  "element-removed",
  (GCallback) &Bin_signal_element_removed_callback,
  (GCallback) &Bin_signal_element_removed_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gst::Bin> wrap(GstBin* object, bool take_copy)
{
  return Glib::RefPtr<Gst::Bin>( dynamic_cast<Gst::Bin*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Bin_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Bin_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_bin_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  ChildProxy::add_interface(get_type());

  }

  return *this;
}

void Bin_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->element_added = &element_added_callback;
  klass->element_removed = &element_removed_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Bin_Class::element_added_callback(GstBin* self, GstElement* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_element_added(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->element_added)
    (*base->element_added)(self, p0);
}
void Bin_Class::element_removed_callback(GstBin* self, GstElement* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_element_removed(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->element_removed)
    (*base->element_removed)(self, p0);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Bin_Class::wrap_new(GObject* object)
{
  return new Bin((GstBin*)object);
}


/* The implementation: */

GstBin* Bin::gobj_copy()
{
  reference();
  return gobj();
}

Bin::Bin(const Glib::ConstructParams& construct_params)
:
  Element(construct_params)
{

}

Bin::Bin(GstBin* castitem)
:
  Element((GstElement*)(castitem))
{}

Bin::~Bin()
{}


Bin::CppClassType Bin::bin_class_; // initialize static member

GType Bin::get_type()
{
  return bin_class_.init().get_type();
}

GType Bin::get_base_type()
{
  return gst_bin_get_type();
}


Bin::Bin()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Element(Glib::ConstructParams(bin_class_.init()))
{
  

}

Glib::RefPtr<Element> Bin::get_element(const Glib::ustring& name)
{
  return Glib::wrap(gst_bin_get_by_name(gobj(), name.c_str()));
}

Glib::RefPtr<Element> Bin::get_element_recurse_up(const Glib::ustring& name)
{
  return Glib::wrap(gst_bin_get_by_name_recurse_up(gobj(), name.c_str()));
}

Glib::RefPtr<Element> Bin::get_element(GType interface)
{
  return Glib::wrap(gst_bin_get_by_interface(gobj(), interface));
}

Glib::RefPtr<Pad> Bin::find_unconnected_pad(PadDirection dir)
{
  return Glib::wrap(gst_bin_find_unconnected_pad(gobj(), ((GstPadDirection)(dir))));
}


Glib::SignalProxy1< void,const Glib::RefPtr<Element>& > Bin::signal_element_added()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Element>& >(this, &Bin_signal_element_added_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<Element>& > Bin::signal_element_removed()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Element>& >(this, &Bin_signal_element_removed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Bin::property_async_handling() 
{
  return Glib::PropertyProxy<bool>(this, "async-handling");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Bin::property_async_handling() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "async-handling");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gst::Bin::on_element_added(const Glib::RefPtr<Element>& element)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->element_added)
    (*base->element_added)(gobj(),Glib::unwrap(element));
}
void Gst::Bin::on_element_removed(const Glib::RefPtr<Element>& element)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->element_removed)
    (*base->element_removed)(gobj(),Glib::unwrap(element));
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


